/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.devmon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Monitor
implements ActionListener {
    private JFrame frame = null;
    private JButton resetButton = new JButton("Reset");
    private JPanel panel = new JPanel();
    private Font font = new Font("Monospaced", 0, 12);
    private Font fontBig = new Font("Monospaced", 1, 12);
    private Hashtable labels = new Hashtable();
    private int iteration;
    private JLabel jlabel = new JLabel();
    private boolean run = true;
    private static Monitor monitor = null;
    private static Hashtable monitors = new Hashtable();

    private Monitor() {
        this.initialize();
    }

    private Monitor(String string) {
        this.initialize(string);
    }

    public static Monitor getMonitor() {
        if (monitor == null) {
            monitor = new Monitor();
        }
        return monitor;
    }

    public static synchronized Monitor getMonitor(String string) {
        Monitor monitor = (Monitor)monitors.get(string);
        if (monitor == null) {
            monitor = new Monitor(string);
            monitors.put(string, monitor);
        }
        return monitor;
    }

    private void initialize() {
        this.initialize(null);
    }

    private void initialize(String string) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout());
        jPanel.add((Component)jPanel2, "South");
        jPanel.add((Component)this.panel, "Center");
        jPanel2.add(this.resetButton);
        this.resetButton.addActionListener(this);
        this.frame = new JFrame("DynaCache Development Monitor " + (string != null ? string : ""));
        this.frame.setCursor(new Cursor(12));
        this.frame.setBounds(0, 0, 500, 600);
        this.frame.getContentPane().add(jPanel);
        BoxLayout boxLayout = new BoxLayout(this.panel, 1);
        this.panel.setLayout(boxLayout);
        this.frame.show();
        this.panel.setBackground(new Color(238, 238, 255));
        this.panel.add(this.jlabel);
        Thread thread = new Thread(){

            public void run() {
                while (Monitor.this.run) {
                    Monitor.this.jlabel.setText("" + Monitor.this.iteration++);
                    Enumeration enumeration = Monitor.this.labels.keys();
                    while (enumeration.hasMoreElements()) {
                        Element element = (Element)Monitor.this.labels.get(enumeration.nextElement());
                        element.label.setText(element.name + ": " + (element.value != null ? "" + element.value : "" + element.intValue));
                    }
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception exception) {}
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private JLabel addLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(this.font);
        this.panel.add(jLabel);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            Color colorNormal = Color.black;
            Color colorHigh = Color.red;
            Color colorLock = Color.blue;
            boolean lock = false;

            public void mouseEntered(MouseEvent mouseEvent) {
                JLabel jLabel = (JLabel)mouseEvent.getSource();
                jLabel.setFont(Monitor.this.fontBig);
                jLabel.setForeground(this.colorHigh);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JLabel jLabel = (JLabel)mouseEvent.getSource();
                jLabel.setFont(Monitor.this.font);
                if (!this.lock) {
                    jLabel.setForeground(this.colorNormal);
                }
                if (this.lock) {
                    jLabel.setForeground(this.colorLock);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                JLabel jLabel = (JLabel)mouseEvent.getSource();
                if (!this.lock) {
                    jLabel.setForeground(this.colorLock);
                    this.lock = true;
                } else {
                    jLabel.setForeground(this.colorNormal);
                    this.lock = false;
                }
            }
        };
        jLabel.addMouseListener(mouseAdapter);
        return jLabel;
    }

    private void addLabel(String string, Object object) {
        JLabel jLabel = this.addLabel(string);
        this.labels.put(string, new Element(string, object, jLabel));
    }

    private void addLabel(String string, int n) {
        JLabel jLabel = this.addLabel(string);
        this.labels.put(string, new Element(string, n, jLabel));
    }

    public void updateLabel(String string, Object object) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, object);
        } else {
            element.value = object;
            this.labels.put(string, element);
        }
    }

    public void updateLabel(String string, int n) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, n);
        } else {
            element.intValue = n;
            this.labels.put(string, element);
        }
    }

    public void updateLabel(String string, boolean bl) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, "" + bl);
        } else {
            element.value = "" + bl;
            this.labels.put(string, element);
        }
    }

    public void increment(String string) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, 1);
        } else {
            ++element.intValue;
        }
    }

    public void increment(String string, int n) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, 1);
        } else {
            element.intValue += n;
        }
    }

    public void decrement(String string) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, -1);
        } else {
            --element.intValue;
        }
    }

    public void highWaterMark(String string, int n) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, n);
        } else if (n > element.intValue) {
            element.intValue = n;
        }
    }

    public void lowWaterMark(String string, int n) {
        Element element = (Element)this.labels.get(string);
        if (element == null) {
            this.addLabel(string, n);
        } else if (n < element.intValue) {
            element.intValue = n;
        }
    }

    public void dispose() {
        this.run = false;
        this.frame.hide();
        Enumeration enumeration = this.labels.keys();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)this.labels.get(enumeration.nextElement());
            this.panel.remove(element.label);
        }
        this.labels.clear();
        this.frame.dispose();
    }

    public void clear() {
        Enumeration enumeration = this.labels.keys();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)this.labels.get(enumeration.nextElement());
            element.reset();
        }
        this.frame.repaint();
    }

    public void show() {
        this.run = true;
        this.frame.show();
    }

    public boolean isVisible() {
        return this.frame.isShowing();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.resetButton) {
            this.clear();
        }
    }

    public static void main(String[] stringArray) {
        Monitor.getMonitor().updateLabel("Test", 1);
        Monitor.getMonitor().updateLabel("Test 1", 2);
        try {
            Thread.sleep(5250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Monitor.getMonitor().updateLabel("Test", 1);
        Monitor.getMonitor().updateLabel("Test 1", 2);
    }

    static class Element {
        String name;
        Object value;
        int intValue;
        JLabel label;
        int pad = 150;

        Element(String string, JLabel jLabel) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("                                                                                        ");
            stringBuffer.append(string);
            if (this.pad - (this.pad - string.length()) > 0) {
                string = stringBuffer.substring(this.pad - (this.pad - string.length()));
            }
            this.name = string;
            this.label = jLabel;
        }

        Element(String string, Object object, JLabel jLabel) {
            this(string, jLabel);
            this.value = object;
        }

        Element(String string, int n, JLabel jLabel) {
            this(string, jLabel);
            this.intValue = n;
        }

        void reset() {
            this.value = null;
            this.intValue = 0;
        }
    }
}

