/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.command;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetableCommand;
import com.ibm.websphere.command.TargetableCommandImpl;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.command.CommandStoragePolicy;
import java.io.Serializable;
import java.rmi.RemoteException;

public class CommandCache {
    private static TraceComponent tc = Trace.register(CommandCache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private Cache cache = null;
    private RemoteServices remoteServices = null;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private CommandStoragePolicy commandStoragePolicy = null;
    private int defaultPriority = CacheEntry.DEFAULT_PRIORITY;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    public void setRemoteServices(RemoteServices remoteServices) {
        this.remoteServices = remoteServices;
    }

    public CommandStoragePolicy getCommandStoragePolicy() {
        return this.commandStoragePolicy;
    }

    public void setCommandStoragePolicy(CommandStoragePolicy commandStoragePolicy) {
        this.commandStoragePolicy = commandStoragePolicy;
    }

    public void setDefaultPriority(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("defaultPriority must be nonnegative");
        }
        this.defaultPriority = n;
    }

    public void start() {
        if (this.cache == null || this.commandStoragePolicy == null || this.batchUpdateDaemon == null || this.remoteServices == null) {
            throw new IllegalStateException("cache, batchUpdateDaemon, and remoteServices must all be set before start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableCommand getCommandLocally(CacheableCommand cacheableCommand, boolean bl) throws CommandException {
        CacheableCommand cacheableCommand2;
        if (cacheableCommand == null) {
            throw new IllegalArgumentException("inputCommand was null");
        }
        com.ibm.websphere.cache.CacheEntry cacheEntry = null;
        Object object = null;
        try {
            EntryInfo entryInfo = (EntryInfo)cacheableCommand.getEntryInfo();
            cacheEntry = this.cache.getEntry(entryInfo, false);
            if (cacheEntry != null) {
                object = cacheEntry.getValue();
            }
            cacheableCommand2 = this.commandStoragePolicy.prepareForCacheAccess((Serializable)object, this.cache, entryInfo);
        }
        finally {
            if (cacheEntry != null) {
                ((CacheEntry)cacheEntry).finish();
            }
        }
        if (cacheableCommand2 == null && bl) {
            cacheableCommand2 = this.executeAndCacheCommand(cacheableCommand);
        }
        return cacheableCommand2;
    }

    private CacheableCommand executeAndCacheCommand(CacheableCommand cacheableCommand) throws CommandException {
        TargetPolicy targetPolicy = TargetableCommandImpl.getTargetPolicy();
        CommandTarget commandTarget = targetPolicy.getCommandTarget((TargetableCommand)cacheableCommand);
        CacheableCommand cacheableCommand2 = this.executeCommand(cacheableCommand, commandTarget);
        if (cacheableCommand2 == null) {
            throw new IllegalStateException("outputCommand was returned from proxy as null");
        }
        this.setCommand(cacheableCommand2);
        return cacheableCommand2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableCommand getCommand(CacheableCommand cacheableCommand, boolean bl) throws CommandException {
        String string = cacheableCommand.getId();
        com.ibm.websphere.cache.CacheEntry cacheEntry = null;
        Object object = null;
        try {
            CacheableCommand cacheableCommand2;
            int n;
            boolean bl2;
            if (cacheableCommand == null) {
                throw new IllegalArgumentException("inputCommand was null");
            }
            EntryInfo entryInfo = (EntryInfo)cacheableCommand.getEntryInfo();
            cacheEntry = this.cache.getEntry(entryInfo, bl2 = this.remoteServices.shouldPull(n = cacheableCommand.getSharingPolicy(), string));
            if (cacheEntry != null) {
                object = cacheEntry.getValue();
            }
            if ((cacheableCommand2 = this.commandStoragePolicy.prepareForCacheAccess((Serializable)object, this.cache, entryInfo)) == null && bl) {
                cacheableCommand2 = this.executeAndCacheCommand(cacheableCommand);
            }
            CacheableCommand cacheableCommand3 = cacheableCommand2;
            return cacheableCommand3;
        }
        finally {
            if (cacheEntry != null) {
                ((CacheEntry)cacheEntry).finish();
            }
        }
    }

    public void setCommand(CacheableCommand cacheableCommand) {
        if (cacheableCommand == null) {
            throw new IllegalArgumentException("command was null");
        }
        String string = cacheableCommand.getId();
        EntryInfo entryInfo = (EntryInfo)cacheableCommand.getEntryInfo();
        if (entryInfo.isSharedPull()) {
            this.batchUpdateDaemon.invalidateById(string, true, this.cache);
        }
        Serializable serializable = this.commandStoragePolicy.prepareForCache(cacheableCommand);
        this.cache.setValue(entryInfo, serializable, entryInfo.isSharedPush());
    }

    private void setCommandLocal(CacheableCommand cacheableCommand) {
        EntryInfo entryInfo = (EntryInfo)cacheableCommand.getEntryInfo();
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        Serializable serializable = this.commandStoragePolicy.prepareForCache(cacheableCommand);
        this.cache.setValue(entryInfo, serializable, false);
    }

    public CacheableCommand executeCommand(CacheableCommand cacheableCommand, CommandTarget commandTarget) throws CommandException {
        CacheableCommand cacheableCommand2;
        CacheableCommand cacheableCommand3;
        block5: {
            cacheableCommand3 = cacheableCommand;
            boolean bl = cacheableCommand.preExecute();
            if (!bl) break block5;
            CacheableCommand cacheableCommand4 = cacheableCommand;
            Object var7_8 = null;
            EntryInfo entryInfo = (EntryInfo)cacheableCommand3.getEntryInfo();
            entryInfo.addTemplate(cacheableCommand3.getClass().getName());
            return cacheableCommand4;
        }
        try {
            cacheableCommand3 = (CacheableCommand)commandTarget.executeCommand((TargetableCommand)cacheableCommand);
            cacheableCommand3.postExecute();
            cacheableCommand2 = cacheableCommand3;
            Object var7_9 = null;
        }
        catch (RemoteException remoteException) {
            try {
                throw new CommandException((Throwable)remoteException);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                EntryInfo entryInfo = (EntryInfo)cacheableCommand3.getEntryInfo();
                entryInfo.addTemplate(cacheableCommand3.getClass().getName());
                throw throwable;
            }
        }
        EntryInfo entryInfo = (EntryInfo)cacheableCommand3.getEntryInfo();
        entryInfo.addTemplate(cacheableCommand3.getClass().getName());
        return cacheableCommand2;
    }

    public boolean isValid(String string) {
        return this.cache.isValid(string);
    }

    public void invalidateById(String string, boolean bl) {
        this.cache.invalidateById(string, bl);
    }

    public void invalidateById(String string, int n, boolean bl) {
        this.cache.invalidateById(string, n, bl);
    }

    public void invalidateByTemplate(String string, boolean bl) {
        this.cache.invalidateByTemplate(string, bl);
    }
}

