/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class PrimitiveArrayPool {
    private static TraceComponent tc = Trace.register(PrimitiveArrayPool.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static boolean IS_UNIT_TEST = false;
    private HashMap pools = null;
    private PoolConfig poolConfig = null;
    private long lastScanTime = 0L;
    private String cacheName = null;

    public PrimitiveArrayPool(PoolConfig poolConfig, String string) {
        poolConfig.verifyConfig();
        this.poolConfig = poolConfig;
        this.pools = new HashMap(poolConfig.numberOfPools);
        this.cacheName = string;
        this.traceDebug("PrimitiveArrayPool() - CTOR", "cacheName=" + this.cacheName + " " + poolConfig);
    }

    private void releaseUnusedPools() {
        long l = System.currentTimeMillis();
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)iterator2.next();
                if (l - poolEntry.getLastAccess() <= (long)this.poolConfig.poolEntryLife) continue;
                this.traceDebug("releaseUnusedPools()", "cacheName=" + this.cacheName + " unused pool entry released for type=" + this.poolConfig.getType() + " size=" + poolEntry.getLength());
                iterator2.remove();
                poolEntry.release();
                if (arrayList.size() != 0) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolEntry allocate(int n) {
        PoolEntry poolEntry = null;
        Object object = this.pools;
        synchronized (object) {
            if (this.pools.size() > 0) {
                ArrayList arrayList = (ArrayList)this.pools.get("" + n);
                if (arrayList != null && arrayList.size() > 0) {
                    poolEntry = (PoolEntry)arrayList.remove(0);
                } else {
                    this.releaseUnusedPools();
                }
            }
        }
        if (poolEntry == null) {
            switch (this.poolConfig.type) {
                case 2: {
                    poolEntry = new PoolEntry(new long[n]);
                    break;
                }
                case 1: {
                    poolEntry = new PoolEntry(new byte[n]);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.poolConfig.toString());
                }
            }
            this.traceDebug("allocate()", "cacheName=" + this.cacheName + " pool entry created for type=" + this.poolConfig.getType() + " size=" + n);
        } else {
            object = poolEntry.getArray();
            if (object instanceof byte[]) {
                Arrays.fill((byte[])object, (byte)0);
            } else if (object instanceof long[]) {
                Arrays.fill((long[])object, 0L);
            }
        }
        return poolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnToPool(PoolEntry poolEntry) {
        boolean bl = false;
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            long l = System.currentTimeMillis();
            if (l - this.lastScanTime > (long)this.poolConfig.scanFrequency) {
                this.lastScanTime = l;
                this.releaseUnusedPools();
            }
            if (this.pools.size() < this.poolConfig.numberOfPools) {
                ArrayList<PoolEntry> arrayList = (ArrayList<PoolEntry>)this.pools.get("" + poolEntry.getLength());
                if (arrayList == null) {
                    arrayList = new ArrayList<PoolEntry>(this.poolConfig.poolSize);
                    this.pools.put("" + poolEntry.getLength(), arrayList);
                }
                if (arrayList.size() < this.poolConfig.poolSize) {
                    arrayList.add(poolEntry);
                    poolEntry.touch();
                    bl = true;
                } else {
                    this.traceDebug("returnToPool()", "cacheName=" + this.cacheName + " the pool is full for type=" + this.poolConfig.getType() + " size=" + poolEntry.getLength());
                    this.releaseUnusedPools();
                }
            } else {
                this.traceDebug("returnToPool()", "cacheName=" + this.cacheName + " there are no more pool slots");
                this.releaseUnusedPools();
            }
        }
        return bl;
    }

    private void traceDebug(String string, String string2) {
        if (IS_UNIT_TEST) {
            System.out.println(this.getClass().getName() + "." + string + " " + string2);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " " + string2));
        }
    }

    public static class PoolEntry {
        private Object primitiveArray = null;
        private long lastAccess = 0L;
        private int length = 0;

        public PoolEntry(Object object) {
            this.primitiveArray = object;
            if (object instanceof byte[]) {
                this.length = ((byte[])object).length;
            } else if (object instanceof long[]) {
                this.length = ((long[])object).length;
            }
        }

        public Object getArray() {
            this.touch();
            return this.primitiveArray;
        }

        protected void release() {
            this.primitiveArray = null;
        }

        protected long getLastAccess() {
            return this.lastAccess;
        }

        protected int getLength() {
            return this.length;
        }

        protected void touch() {
            this.lastAccess = System.currentTimeMillis();
        }
    }

    static class PoolConfig {
        public static final int TYPE_BYTE = 1;
        public static final int TYPE_LONG = 2;
        public int type = -1;
        public int numberOfPools = 0;
        public int poolSize = 0;
        public int poolEntryLife = 0;
        public int scanFrequency = 0;

        PoolConfig() {
        }

        public String toString() {
            return "PoolConfig@@" + this.hashCode() + " type=" + (this.type == 1 ? "byte[]" : (this.type == 2 ? "long[]" : "unknown")) + " numberOfPools=" + this.numberOfPools + " poolSize=" + this.poolSize + " poolEntryLife=" + this.poolEntryLife + " scanFrequency=" + this.scanFrequency;
        }

        protected void verifyConfig() {
            if (this.numberOfPools < 0 || this.poolSize < 0 || this.poolEntryLife <= 0 || this.scanFrequency < 0 || this.type == -1) {
                throw new IllegalStateException("PoolConfig error " + this.toString());
            }
        }

        protected String getType() {
            String string = "";
            switch (this.type) {
                case 2: {
                    string = "long[]";
                    break;
                }
                case 1: {
                    string = "byte[]";
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
            return string;
        }
    }
}

