/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.NonSyncHashtableEntry;
import com.ibm.ws.cache.NonSyncHashtableEnumerator;
import java.io.Serializable;
import java.util.Enumeration;

public class NonSyncHashtable
implements Serializable {
    private static final long serialVersionUID = 0x50002002L;
    protected NonSyncHashtableEntry[] table;
    protected int count;

    public NonSyncHashtable(int n) {
        this.table = new NonSyncHashtableEntry[n];
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new NonSyncHashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new NonSyncHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        NonSyncHashtableEntry[] nonSyncHashtableEntryArray = this.table;
        int n = nonSyncHashtableEntryArray.length;
        while (n-- > 0) {
            NonSyncHashtableEntry nonSyncHashtableEntry = nonSyncHashtableEntryArray[n];
            while (nonSyncHashtableEntry != null) {
                if (nonSyncHashtableEntry.value.equals(object)) {
                    return true;
                }
                nonSyncHashtableEntry = nonSyncHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        NonSyncHashtableEntry[] nonSyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % nonSyncHashtableEntryArray.length;
        NonSyncHashtableEntry nonSyncHashtableEntry = nonSyncHashtableEntryArray[n2];
        while (nonSyncHashtableEntry != null) {
            if (nonSyncHashtableEntry.hash == n && nonSyncHashtableEntry.key.equals(object)) {
                return true;
            }
            nonSyncHashtableEntry = nonSyncHashtableEntry.next;
        }
        return false;
    }

    public Object get(Object object) {
        NonSyncHashtableEntry[] nonSyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % nonSyncHashtableEntryArray.length;
        NonSyncHashtableEntry nonSyncHashtableEntry = nonSyncHashtableEntryArray[n2];
        while (nonSyncHashtableEntry != null) {
            if (nonSyncHashtableEntry.hash == n && nonSyncHashtableEntry.key.equals(object)) {
                return nonSyncHashtableEntry.value;
            }
            nonSyncHashtableEntry = nonSyncHashtableEntry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        NonSyncHashtableEntry[] nonSyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % nonSyncHashtableEntryArray.length;
        NonSyncHashtableEntry nonSyncHashtableEntry = nonSyncHashtableEntryArray[n2];
        while (nonSyncHashtableEntry != null) {
            if (nonSyncHashtableEntry.hash == n && nonSyncHashtableEntry.key.equals(object)) {
                Object object3 = nonSyncHashtableEntry.value;
                nonSyncHashtableEntry.value = object2;
                return object3;
            }
            nonSyncHashtableEntry = nonSyncHashtableEntry.next;
        }
        nonSyncHashtableEntry = new NonSyncHashtableEntry();
        nonSyncHashtableEntry.hash = n;
        nonSyncHashtableEntry.key = object;
        nonSyncHashtableEntry.value = object2;
        nonSyncHashtableEntry.next = nonSyncHashtableEntryArray[n2];
        nonSyncHashtableEntryArray[n2] = nonSyncHashtableEntry;
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        NonSyncHashtableEntry[] nonSyncHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % nonSyncHashtableEntryArray.length;
        NonSyncHashtableEntry nonSyncHashtableEntry = nonSyncHashtableEntryArray[n2];
        NonSyncHashtableEntry nonSyncHashtableEntry2 = null;
        while (nonSyncHashtableEntry != null) {
            if (nonSyncHashtableEntry.hash == n && nonSyncHashtableEntry.key.equals(object)) {
                if (nonSyncHashtableEntry2 != null) {
                    nonSyncHashtableEntry2.next = nonSyncHashtableEntry.next;
                } else {
                    nonSyncHashtableEntryArray[n2] = nonSyncHashtableEntry.next;
                }
                --this.count;
                return nonSyncHashtableEntry.value;
            }
            nonSyncHashtableEntry2 = nonSyncHashtableEntry;
            nonSyncHashtableEntry = nonSyncHashtableEntry.next;
        }
        return null;
    }

    public void clear() {
        NonSyncHashtableEntry[] nonSyncHashtableEntryArray = this.table;
        int n = nonSyncHashtableEntryArray.length;
        while (--n >= 0) {
            nonSyncHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

