/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.ValueSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class InvalidateByTemplateEvent
implements InvalidationEvent,
Externalizable {
    private static final long serialVersionUID = 0x50002002L;
    private static final long CACHE_COMMAND_NONE = 0L;
    private static final long CACHE_COMMAND_CLEAR = 1L;
    private static final long CACHE_COMMAND_INVALIDATE_BY_TEMPLATE = 2L;
    private static final long CACHE_COMMAND_INVALIDATE_BY_ID = 4L;
    private static final long CACHE_COMMAND_SPARE2 = 8L;
    private long cacheCommand = 0L;
    protected String template = null;
    protected long timeStamp = -1L;
    public int source;
    private ValueSet removedIds;
    private long drsClock = -1L;

    public InvalidateByTemplateEvent(String string, int n) {
        this.template = string;
        this.source = n;
        this.timeStamp = System.currentTimeMillis();
        this.setCacheCommand_InvalidateByTemplate();
    }

    public InvalidateByTemplateEvent(String string, long l, int n) {
        this.template = string;
        this.source = n;
        this.timeStamp = l;
        this.setCacheCommand_InvalidateByTemplate();
    }

    public ValueSet getRemovedIds() {
        return this.removedIds;
    }

    public void addRemovedIds(ValueSet valueSet) {
        if (this.removedIds == null) {
            this.removedIds = new ValueSet(4);
        }
        this.removedIds.union(valueSet);
    }

    public InvalidateByTemplateEvent() {
    }

    void setCacheCommand_Clear() {
        this.cacheCommand |= 1L;
    }

    private void setCacheCommand_InvalidateByTemplate() {
        this.cacheCommand |= 2L;
    }

    public boolean isCacheCommand_Clear() {
        return (this.cacheCommand & 1L) == 1L;
    }

    public boolean isCacheCommand_InvalidateByTemplate() {
        return (this.cacheCommand & 2L) == 2L;
    }

    private void processDrsInbound(long l) {
        if (this.drsClock <= 0L) {
            return;
        }
        if (this.timeStamp <= 0L) {
            return;
        }
        long l2 = l - this.drsClock;
        this.timeStamp += l2;
        this.drsClock = -1L;
    }

    private void processDrsOutbound() {
        if (this.drsClock != -1L) {
            return;
        }
        if (this.timeStamp <= 0L) {
            return;
        }
        this.drsClock = System.currentTimeMillis();
    }

    public String getTemplate() {
        return this.template;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.processDrsOutbound();
        objectOutput.writeObject(this.template);
        objectOutput.writeLong(this.timeStamp);
        objectOutput.writeLong(this.drsClock);
        objectOutput.writeInt(this.source);
        objectOutput.writeLong(this.cacheCommand);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = System.currentTimeMillis();
        this.template = (String)objectInput.readObject();
        this.timeStamp = objectInput.readLong();
        this.drsClock = objectInput.readLong();
        this.source = objectInput.readInt();
        this.cacheCommand = objectInput.readLong();
        this.processDrsInbound(l);
    }
}

