/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.InvalidationEvent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class InvalidateByIdEvent
implements InvalidationEvent,
Externalizable {
    private static final long serialVersionUID = 0x50002002L;
    static final boolean INVOKE_INTERNAL_INVALIDATE_BY_ID = true;
    private static TraceComponent tc = Trace.register(InvalidateByIdEvent.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private Object id = null;
    private byte[] serializedId = null;
    private long timeStamp = -1L;
    private long drsClock = -1L;
    public boolean useServerClassLoader = false;
    public int causeOfInvalidation;
    public int source;
    public transient boolean invokeInternalInvalidateById = true;

    public InvalidateByIdEvent(Object object, int n, int n2, boolean bl) {
        this.id = object;
        this.causeOfInvalidation = n;
        this.source = n2;
        this.timeStamp = System.currentTimeMillis();
        this.invokeInternalInvalidateById = bl;
    }

    public InvalidateByIdEvent(Object object) {
        this.id = object;
        this.timeStamp = System.currentTimeMillis();
    }

    public InvalidateByIdEvent(Object object, long l) {
        this.id = object;
        this.timeStamp = l;
    }

    public InvalidateByIdEvent() {
    }

    public void setClassLoaderType(boolean bl) {
        this.useServerClassLoader = bl;
    }

    private void processDrsInbound(long l) {
        if (this.drsClock <= 0L || this.timeStamp <= 0L) {
            return;
        }
        long l2 = l - this.drsClock;
        this.timeStamp += l2;
        this.drsClock = -1L;
    }

    private void processDrsOutbound() {
        if (this.drsClock != -1L || this.timeStamp <= 0L) {
            return;
        }
        this.drsClock = System.currentTimeMillis();
    }

    public Object getId() {
        return this.id;
    }

    public byte[] getSerializedId() {
        return this.serializedId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean prepareForSerialization() {
        boolean bl = true;
        String string = null;
        if (this.serializedId == null) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.serializedId == null) {
                Tr.error((TraceComponent)tc, (String)"DYNA0052E", (Object)new Object[]{this.id, this.id.getClass().getName(), string});
                bl = false;
            }
        }
        return bl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.processDrsOutbound();
        if (!this.prepareForSerialization()) {
            throw new IOException("Object not serializable: " + this.serializedId == null ? "null object" : this.serializedId.getClass().getName());
        }
        if (this.serializedId != null) {
            objectOutput.writeInt(this.serializedId.length);
            objectOutput.write(this.serializedId);
        } else {
            objectOutput.writeInt(-1);
        }
        objectOutput.writeLong(this.timeStamp);
        objectOutput.writeLong(this.drsClock);
        objectOutput.writeInt(this.causeOfInvalidation);
        objectOutput.writeInt(this.source);
        objectOutput.writeBoolean(this.useServerClassLoader);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = System.currentTimeMillis();
        int n = objectInput.readInt();
        if (n > 0) {
            this.serializedId = new byte[n];
            objectInput.readFully(this.serializedId);
        } else {
            this.serializedId = null;
        }
        this.id = null;
        this.timeStamp = objectInput.readLong();
        this.drsClock = objectInput.readLong();
        this.causeOfInvalidation = objectInput.readInt();
        this.source = objectInput.readInt();
        try {
            this.useServerClassLoader = objectInput.readBoolean();
        }
        catch (Exception exception) {
            this.useServerClassLoader = false;
        }
        if (this.serializedId != null) {
            try {
                this.id = this.useServerClassLoader ? SerializationUtility.deserialize_1(this.serializedId, 0, this.serializedId.length) : SerializationUtility.deserialize(this.serializedId);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.InvalidateByIdEvent.getId", "146", this);
                exception.printStackTrace();
            }
            this.serializedId = null;
        } else {
            this.id = null;
        }
        this.processDrsInbound(l);
    }

    public boolean isInvokeInternalInvalidateById() {
        return this.invokeInternalInvalidateById;
    }
}

