/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.drs.ws390.DynacachePlatformHelper;
import com.ibm.ws.cache.util.SerializationUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class IdObject
implements Externalizable {
    private static final long serialVersionUID = -1537510527687102354L;
    private static TraceComponent tc = Trace.register(IdObject.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    public Object id = null;
    public String idString;
    protected byte[] serializedId = null;
    protected byte[] serializedIdString = null;

    public IdObject() {
    }

    public IdObject(Object object) {
        this.id = object;
        this.idString = object.toString();
    }

    public boolean prepareForSerialization() {
        boolean bl = true;
        String string = null;
        if (this.serializedId == null && bl) {
            try {
                this.serializedId = SerializationUtility.serialize((Serializable)this.id);
                this.serializedIdString = this.idString.getBytes();
            }
            catch (IOException iOException) {
                string = iOException.toString();
            }
            catch (ClassCastException classCastException) {
                string = classCastException.toString();
            }
            if (this.serializedId == null) {
                Tr.error((TraceComponent)tc, (String)"dynacache.error", (Object)new Object[]{"OBJECT_NOT_REPLICATED_OR_SAVED_TO_DISK ID className=" + this.id.getClass().getName() + " exception=" + string});
                bl = false;
            }
        }
        return bl;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.prepareForSerialization();
        if (this.serializedId != null) {
            objectOutput.writeInt(this.serializedId.length);
            objectOutput.write(this.serializedId);
            objectOutput.writeInt(this.serializedIdString.length);
            objectOutput.write(this.serializedIdString);
        } else {
            objectOutput.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        try {
            int n = objectInput.readInt();
            if (n > 0) {
                this.serializedId = new byte[n];
                objectInput.readFully(this.serializedId, 0, n);
                int n2 = objectInput.readInt();
                if (n2 > 0) {
                    this.serializedIdString = new byte[n2];
                    objectInput.readFully(this.serializedIdString, 0, n2);
                }
            } else {
                this.serializedId = null;
                this.serializedIdString = null;
            }
            if (this.serializedId != null) {
                try {
                    if (!DynacachePlatformHelper.isZOS_Controller()) {
                        this.id = SerializationUtility.deserialize(this.serializedId);
                    }
                    this.idString = new String(this.serializedIdString);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.IdObject.readExternal", "366", this);
                    exception.printStackTrace();
                }
            } else {
                this.id = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.IdObject.readExternal", "468", this);
            exception.printStackTrace();
        }
    }

    public Object getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IdObject)) {
            return false;
        }
        IdObject idObject = (IdObject)object;
        if (this.id == null || idObject.id == null) {
            return super.equals(object);
        }
        return this.id.equals(idObject.id);
    }

    public int hashCode() {
        if (this.id == null) {
            return IdObject.class.hashCode();
        }
        return this.id.hashCode();
    }

    public String toString() {
        return this.idString;
    }
}

