/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import java.util.Iterator;

public class HTODInvalidationBuffer {
    private static TraceComponent tc = Trace.register(HTODInvalidationBuffer.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private static final boolean IS_UNIT_TEST = false;
    public static final boolean SCAN = true;
    public static final boolean ALREADY_FIRED = true;
    public static final boolean CHECK_ALIAS = true;
    private CacheOnDisk cod = null;
    private ValueSet noNotificationBuffer = null;
    private ValueSet notificationBuffer = null;
    private ValueSet aliasBuffer = null;
    private boolean backgroundInvalidationInProgress = false;
    private boolean cleanupDiskPending = false;
    private boolean loopOnce = false;
    private int maxInvalidationBufferSize = 0;
    private int maxInvalidationBufferLife = 0;
    private long lastRemoveTime = 0L;
    private long lastWaitTime = 0L;

    private HTODInvalidationBuffer() {
    }

    public HTODInvalidationBuffer(CacheOnDisk cacheOnDisk) {
        this.cod = cacheOnDisk;
        this.maxInvalidationBufferSize = cacheOnDisk.invalidationBufferSize;
        this.maxInvalidationBufferLife = cacheOnDisk.invalidationBufferLife;
        this.noNotificationBuffer = new ValueSet(this.maxInvalidationBufferSize);
        this.notificationBuffer = new ValueSet(this.maxInvalidationBufferSize);
        this.aliasBuffer = new ValueSet(this.maxInvalidationBufferSize / 5);
    }

    protected synchronized void add(Object object, boolean bl) {
        if (object == null) {
            return;
        }
        if (bl) {
            this.noNotificationBuffer.add(object);
            this.notificationBuffer.remove(object);
        } else if (!this.noNotificationBuffer.contains(object)) {
            this.notificationBuffer.add(object);
        }
        if (this.isFull()) {
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized void add(ValueSet valueSet, boolean bl) {
        if (valueSet == null || valueSet.isEmpty()) {
            return;
        }
        int n = valueSet.size();
        if (bl) {
            this.noNotificationBuffer.addAll(valueSet);
            if (!this.notificationBuffer.isEmpty()) {
                this.filter(this.notificationBuffer, valueSet);
            }
        } else {
            if (!this.noNotificationBuffer.isEmpty()) {
                this.filter(valueSet, this.noNotificationBuffer);
            }
            this.notificationBuffer.addAll(valueSet);
        }
        if (n > 50) {
            this.traceDebug("add(ValueSet, boolean)", "cacheName=" + this.cod.cacheName + " idSet=" + n + " idSetFilter=" + valueSet.size() + " EAF=" + bl + " NNB=" + this.noNotificationBuffer.size() + " NB=" + this.notificationBuffer.size());
        }
        if (this.isFull()) {
            this.invokeBackgroundInvalidation(false);
        }
    }

    protected synchronized void addAlias(Object object) {
        if (object == null) {
            return;
        }
        this.aliasBuffer.add(object);
    }

    protected synchronized Object get(boolean bl) {
        Object object = null;
        if (bl) {
            if (!this.noNotificationBuffer.isEmpty()) {
                object = this.noNotificationBuffer.getOne();
            }
        } else if (!this.notificationBuffer.isEmpty()) {
            object = this.notificationBuffer.getOne();
        }
        return object;
    }

    protected synchronized void remove(Object object, boolean bl) {
        if (bl) {
            this.noNotificationBuffer.remove(object);
        } else {
            this.notificationBuffer.remove(object);
        }
    }

    protected synchronized void removeAlias(Object object) {
        if (object == null) {
            return;
        }
        this.aliasBuffer.remove(object);
    }

    protected synchronized void remove(Object object) {
        if (object == null) {
            return;
        }
        this.noNotificationBuffer.remove(object);
        this.notificationBuffer.remove(object);
    }

    protected synchronized ValueSet removeAll(boolean bl) {
        ValueSet valueSet = null;
        if (bl) {
            if (this.noNotificationBuffer.size() == 0) {
                valueSet = new ValueSet(1);
            } else {
                valueSet = this.noNotificationBuffer;
                this.noNotificationBuffer = new ValueSet(this.maxInvalidationBufferSize);
            }
        } else if (this.notificationBuffer.size() == 0) {
            valueSet = new ValueSet(1);
        } else {
            valueSet = this.notificationBuffer;
            this.notificationBuffer = new ValueSet(this.maxInvalidationBufferSize);
        }
        this.traceDebug("removeAll(boolean)", "cacheName=" + this.cod.cacheName + " EAF=" + bl + " bufferSize=" + valueSet.size());
        return valueSet;
    }

    protected synchronized void clear(boolean bl, boolean bl2) {
        if (bl) {
            this.noNotificationBuffer.clear();
        }
        if (bl2) {
            this.notificationBuffer.clear();
        }
        this.aliasBuffer.clear();
        this.traceDebug("clear()", "cacheName=" + this.cod.cacheName + " EAF=" + bl + " ENF=" + bl2);
    }

    protected synchronized void invokeBackgroundInvalidation(boolean bl) {
        if (!this.backgroundInvalidationInProgress) {
            this.backgroundInvalidationInProgress = true;
            this.cod.doCleanUp(bl);
        } else if (bl) {
            this.traceDebug("invokeBackgroundInvalidation()", "cacheName=" + this.cod.cacheName + " set cleanupDiskPending to true");
            this.cleanupDiskPending = true;
        }
    }

    protected synchronized boolean contains(Object object) {
        boolean bl = false;
        if (this.noNotificationBuffer.contains(object) || this.notificationBuffer.contains(object) || this.aliasBuffer.contains(object)) {
            bl = true;
        }
        return bl;
    }

    private boolean isFull() {
        boolean bl = false;
        int n = this.noNotificationBuffer.size() + this.notificationBuffer.size() + this.aliasBuffer.size();
        if (n > this.maxInvalidationBufferSize || System.currentTimeMillis() - this.lastRemoveTime > (long)this.maxInvalidationBufferLife) {
            bl = true;
            this.setlastRemoveTime();
        }
        return bl;
    }

    protected synchronized void filter(ValueSet valueSet, boolean bl) {
        boolean bl2 = this.noNotificationBuffer.isEmpty();
        boolean bl3 = this.notificationBuffer.isEmpty();
        boolean bl4 = this.aliasBuffer.isEmpty();
        if (!(valueSet == null || valueSet.isEmpty() || bl2 && bl3)) {
            Iterator iterator = valueSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!bl2 && this.noNotificationBuffer.contains(e)) {
                    iterator.remove();
                    continue;
                }
                if (!bl3 && this.notificationBuffer.contains(e)) {
                    iterator.remove();
                    continue;
                }
                if (!bl || bl4 || !this.aliasBuffer.contains(e)) continue;
                iterator.remove();
            }
        }
    }

    private void filter(ValueSet valueSet, ValueSet valueSet2) {
        if (valueSet != null && valueSet2 != null && !valueSet.isEmpty() && !valueSet2.isEmpty()) {
            Iterator iterator = valueSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!valueSet2.contains(e)) continue;
                iterator.remove();
            }
        }
    }

    protected synchronized int size(boolean bl) {
        if (bl) {
            return this.noNotificationBuffer.size();
        }
        return this.notificationBuffer.size();
    }

    protected synchronized int size() {
        return this.noNotificationBuffer.size() + this.notificationBuffer.size() + this.aliasBuffer.size();
    }

    protected synchronized boolean isCleanupPending() {
        return this.cleanupDiskPending;
    }

    protected synchronized void resetCleanupPending() {
        this.cleanupDiskPending = false;
        this.traceDebug("resetCleanupPending()", "cacheName=" + this.cod.cacheName);
    }

    protected synchronized boolean isBackgroundInvalidationInProgress() {
        return this.backgroundInvalidationInProgress;
    }

    protected synchronized void resetBackgroundInvalidationInProgress() {
        this.backgroundInvalidationInProgress = false;
    }

    protected synchronized boolean isLoopOnce() {
        return this.loopOnce;
    }

    protected synchronized void setLoopOnce(boolean bl) {
        this.loopOnce = bl;
        this.traceDebug("setLoopOnce()", "cacheName=" + this.cod.cacheName + " loopOnce=" + bl + " NNB=" + this.noNotificationBuffer.size() + " NB=" + this.notificationBuffer.size());
    }

    protected synchronized void setlastRemoveTime() {
        this.lastRemoveTime = System.currentTimeMillis();
    }

    private void traceDebug(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " " + string2));
        }
    }
}

