/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.DMapRequest;
import com.ibm.websphere.cache.DMapResponse;
import com.ibm.websphere.cache.DistributedNioMapObject;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.DMapLockManagerImpl;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.ValidateUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DistributedObjectCacheAdapter
extends DistributedObjectCache {
    protected static final boolean IS_UNIT_TEST = false;
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    private static final boolean INCREMENT_REF_COUNT = true;
    private static final Object[] NULL_ALIASIDs;
    private static final Object[] NULL_DEPIDs;
    protected Cache cache = null;
    protected String cacheName = null;
    protected String myTemplate = null;
    protected int sharingPolicy = 1;
    protected int timeToLive = -1;
    protected int priority = -1;
    protected EntryInfo.EntryInfoPool entryInfoPool = null;
    protected CacheEntry.CacheEntryPool cacheEntryPool = null;
    protected int mapType = -1;
    protected String transactionIdPrefix = null;
    protected boolean useLockManager = false;
    protected static final String LOCK_MANAGER_DISABLED = "Lock Manager is disabled";
    protected static final String INVALID_ARGUMENTS = "Invalid arguments";
    protected DMapLockManagerImpl lockManager = null;
    private CacheConfig cacheConfig = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DistributedObjectCacheAdapter() {
    }

    protected DistributedObjectCacheAdapter(Cache cache, int n) {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cache == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cache.getCacheName() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cache.getCacheName().trim().equals("")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cache.getCacheConfig() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n != 1 && n != 3) {
            throw new AssertionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DistributedObjectCacheAdapter() - CTOR " + cache.getCacheName() + " Cache=" + cache + " CacheConfig=" + cache.getCacheConfig() + " enableReplication=" + cache.getCacheConfig().enableCacheReplication));
        }
        this.cache = cache;
        this.cacheName = cache.getCacheName();
        this.cacheConfig = cache.getCacheConfig();
        this.transactionIdPrefix = this.cacheConfig.serverNodeName + "." + this.cacheConfig.serverServerName + ".";
        this.myTemplate = this.transactionIdPrefix + this.cacheName;
        this.setMapType(n);
        this.setSharingPolicy(this.cacheConfig.defaultShareType);
        this.createMapSpecificObjects();
        if (this.entryInfoPool != null) {
            this.entryInfoPool.setFeatures(this.cacheConfig);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DistributedObjectCacheAdapter() - CTOR Adapter Impl=" + this));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DistributedObjectCacheAdapter() - CTOR MapType:" + n));
        }
    }

    protected void finalize() {
        this.destroyMapSpecificObjects();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("finalize Object destroyed:" + this));
        }
    }

    protected void createMapSpecificObjects() {
        throw new RuntimeException("You must override this method!!");
    }

    protected void destroyMapSpecificObjects() {
        throw new RuntimeException("You must override this method!!");
    }

    public final int getMapType() {
        return this.mapType;
    }

    public final String getTransactionIdPrefix() {
        return this.transactionIdPrefix;
    }

    public final void setSharingPolicy(int n) {
        ValidateUtility.sharingPolicy(n);
        this.sharingPolicy = n;
    }

    public final void setDRSBootstrap(boolean bl) {
        this.cache.setDRSBootstrap(bl);
    }

    public final void setPriority(int n) {
        ValidateUtility.priority(n);
        this.priority = n;
    }

    public final void setTimeToLive(int n) {
        ValidateUtility.timeToLive(n);
        this.timeToLive = n;
    }

    public final int getSharingPolicy() {
        return this.sharingPolicy;
    }

    public final int size() {
        return this.cache.getNumberCacheEntries();
    }

    public int size(boolean bl) {
        if (bl) {
            return this.cache.getNumberCacheEntries() + this.cache.getIdsSizeDisk();
        }
        return this.cache.getNumberCacheEntries();
    }

    public final boolean isEmpty() {
        return this.cache.getNumberCacheEntries() == 0;
    }

    public boolean isEmpty(boolean bl) {
        if (bl) {
            return this.cache.getNumberCacheEntries() + this.cache.getIdsSizeDisk() == 0;
        }
        return this.cache.getNumberCacheEntries() == 0;
    }

    public final boolean containsKey(Object object) {
        ValidateUtility.objectNotNull(object, "key");
        return this.cache.containsKey(object);
    }

    public boolean containsKey(Object object, boolean bl) {
        ValidateUtility.objectNotNull(object, "key");
        boolean bl2 = this.cache.containsKey(object);
        if (bl2) {
            return bl2;
        }
        if (bl) {
            bl2 = this.cache.containsKeyDisk(object);
        }
        return bl2;
    }

    public final boolean containsValue(Object object) {
        ValidateUtility.objectNotNull(object, "value");
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object2 = this.get(e);
            if (object2 != object && (object2 == null || !object2.equals(object))) continue;
            return true;
        }
        return false;
    }

    public final void putAll(Map map) {
        ValidateUtility.objectNotNull(map, "map");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final void clear() {
        boolean bl = true;
        this.cache.clear(bl);
    }

    public Object get(Object object) {
        return this.functionNotAvailable("get(key)");
    }

    protected final Object common_get(Object object) {
        ValidateUtility.objectNotNull(object, "key");
        Object object2 = this.cache.getValue(object, this.cache.shouldPull(this.sharingPolicy, object));
        return object2;
    }

    public com.ibm.websphere.cache.CacheEntry getCacheEntry(Object object) {
        return (com.ibm.websphere.cache.CacheEntry)this.functionNotAvailable("getCacheEntry(key)");
    }

    protected final com.ibm.websphere.cache.CacheEntry common_getCacheEntry(Object object) {
        ValidateUtility.objectNotNull(object, "key");
        EntryInfo entryInfo = this.entryInfoPool.allocate(object, NULL_DEPIDs, NULL_ALIASIDs);
        entryInfo.setSharingPolicy(this.sharingPolicy);
        com.ibm.websphere.cache.CacheEntry cacheEntry = this.cache.getEntry(entryInfo, true);
        entryInfo.returnToPool();
        if (tc.isDebugEnabled() && cacheEntry != null) {
            Tr.debug((TraceComponent)tc, (String)("getCacheEntry(key) " + this.cache.getCacheName() + " id=" + ((CacheEntry)cacheEntry).id + " refcount=" + ((CacheEntry)cacheEntry).refCount));
        }
        return cacheEntry;
    }

    public void put(Object object, Object object2, Object object3, int n, int n2, int n3, Object[] objectArray, Object[] objectArray2) {
        this.functionNotAvailable("put(key,value,userMetaData...)");
    }

    public com.ibm.websphere.cache.CacheEntry putAndGet(Object object, Object object2, Object object3, int n, int n2, int n3, Object[] objectArray, Object[] objectArray2) {
        return (com.ibm.websphere.cache.CacheEntry)this.functionNotAvailable("putAndGet(key,value,userMetaData...)");
    }

    protected final void common_put(Object object, Object object2, Object object3, int n, int n2, int n3, Object[] objectArray, Object[] objectArray2) {
        this.internal_putAndGet(object, object2, object3, n, n2, n3, objectArray, objectArray2, false);
    }

    protected final com.ibm.websphere.cache.CacheEntry common_putAndGet(Object object, Object object2, Object object3, int n, int n2, int n3, Object[] objectArray, Object[] objectArray2) {
        return this.internal_putAndGet(object, object2, object3, n, n2, n3, objectArray, objectArray2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final com.ibm.websphere.cache.CacheEntry internal_putAndGet(Object object, Object object2, Object object3, int n, int n2, int n3, Object[] objectArray, Object[] objectArray2, boolean bl) {
        ValidateUtility.objectNotNull(object, "key", object2, "value");
        if (n3 == 4 || n3 == 3) {
            this.invalidate(object, true);
        }
        EntryInfo entryInfo = this.entryInfoPool.allocate(object, objectArray, objectArray2);
        entryInfo.setUserMetaData(object3);
        entryInfo.setPriority(n);
        entryInfo.setTimeLimit(n2);
        entryInfo.setSharingPolicy(n3);
        CacheEntry cacheEntry = this.cacheEntryPool.allocate();
        cacheEntry.copyMetaData(entryInfo);
        cacheEntry.setValue(object2);
        if (object2 instanceof DistributedNioMapObject) {
            cacheEntry.useByteBuffer = true;
        }
        CacheEntry cacheEntry2 = null;
        if (bl) {
            Cache cache = this.cache;
            synchronized (cache) {
                cacheEntry2 = this.cache.setEntry(cacheEntry, 5, false, true);
                ++cacheEntry2.refCount;
            }
        } else {
            cacheEntry2 = this.cache.setEntry(cacheEntry, 5, false, true);
        }
        entryInfo.returnToPool();
        cacheEntry.serializedValue = null;
        cacheEntry.value = null;
        cacheEntry.returnToPool();
        if (tc.isDebugEnabled() && cacheEntry2 != null) {
            Tr.debug((TraceComponent)tc, (String)("putAndGet(..) " + this.cache.getCacheName() + " id=" + cacheEntry2.id + " refcount=" + cacheEntry2.refCount + "incRefCount=" + bl));
        }
        return cacheEntry2;
    }

    public void addAlias(Object object, Object[] objectArray) {
        this.functionNotAvailable("addAlias(key, aliasArray)");
    }

    protected final void common_addAlias(Object object, Object[] objectArray) {
        ValidateUtility.objectNotNull(object, "key", objectArray, "aliasArray");
        this.cache.addAlias(object, objectArray, this.cache.shouldPull(this.sharingPolicy, object), true);
    }

    public void removeAlias(Object object) {
        this.functionNotAvailable("removeAlias( alias )");
    }

    protected final void common_removeAlias(Object object) {
        ValidateUtility.objectNotNull(object, "alias");
        this.cache.removeAlias(object, this.cache.shouldPull(this.sharingPolicy, object), true);
    }

    public void releaseLruEntries(int n) {
        this.functionNotAvailable("releaseLruEntries(numOfEntries)");
    }

    protected final void common_releaseLruEntries(int n) {
        for (int i = 0; i < n && this.cache.freeLruEntry(); ++i) {
        }
    }

    public Object get(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        return this.functionNotAvailable("get(key, request, response)");
    }

    protected final Object common_get(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        Object object2 = null;
        if (this.isMapEntryReadAllowed(object, dMapRequest, dMapResponse)) {
            object2 = this.getFromCache(object, dMapRequest, dMapResponse);
        }
        return object2;
    }

    public Object getAndLock(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        return this.functionNotAvailable("getAndLock(key, request, response)");
    }

    protected final Object common_getAndLock(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        Object object2 = null;
        if (this.lockMapEntry(object, dMapRequest, dMapResponse)) {
            object2 = this.getFromCache(object, dMapRequest, dMapResponse);
        }
        return object2;
    }

    public Object put(Object object, Object object2) {
        return this.functionNotAvailable("put(key, value)");
    }

    protected final Object common_put(Object object, Object object2) {
        EntryInfo entryInfo = this.entryInfoPool.allocate(object, NULL_DEPIDs, NULL_DEPIDs);
        entryInfo.setTimeLimit(-1);
        entryInfo.setSharingPolicy(this.sharingPolicy);
        Object object3 = this.cache.invalidateAndSet(entryInfo, object2, this.cache.getCacheConfig().enableCacheReplication);
        entryInfo.returnToPool();
        return object3;
    }

    public Object put(Object object, Object object2, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        return this.functionNotAvailable("put(key, value, request, response)");
    }

    protected final Object common_put(Object object, Object object2, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        Object object3 = null;
        if (this.isMapEntryWriteAllowed(object, dMapRequest, dMapResponse)) {
            object3 = this.putToCache(object, object2, dMapRequest, dMapResponse);
        }
        return object3;
    }

    public Object putAndUnlock(Object object, Object object2, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        return this.functionNotAvailable("putAndUnlock(key, value, request, response)");
    }

    protected final Object common_putAndUnlock(Object object, Object object2, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        Object object3 = null;
        if (this.isMapEntryWriteAllowed(object, dMapRequest, dMapResponse)) {
            EntryInfo entryInfo = this.entryInfoPool.allocate(object, dMapRequest.getDependencyIds(), NULL_ALIASIDs);
            entryInfo.setPriority(dMapRequest.getPriority());
            entryInfo.setTimeLimit(dMapRequest.getTimeToLive());
            entryInfo.setSharingPolicy(dMapRequest.getSharingPolicy());
            object3 = this.cache.invalidateAndSet(entryInfo, object2, this.cache.getCacheConfig().enableCacheReplication);
            entryInfo.returnToPool();
            boolean bl = this.unlockMapEntry(object, dMapRequest, dMapResponse);
            if (!bl) {
                // empty if block
            }
        }
        return object3;
    }

    public Object put(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        return this.functionNotAvailable("put(key, value, priority, timeToLive, sharingPolicy, dependencyIds)");
    }

    protected Object common_put(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        EntryInfo entryInfo = this.entryInfoPool.allocate(object, objectArray, NULL_ALIASIDs);
        entryInfo.setPriority(n);
        entryInfo.setTimeLimit(n2);
        entryInfo.setSharingPolicy(n3);
        Object object3 = this.cache.invalidateAndSet(entryInfo, object2, this.cache.getCacheConfig().enableCacheReplication);
        entryInfo.returnToPool();
        return object3;
    }

    public void invalidate(Object object) {
        this.functionNotAvailable("invalidate(key)");
    }

    protected void common_invalidate(Object object) {
        this.cache.invalidateById(object, true);
    }

    public void invalidate(Object object, boolean bl) {
        this.functionNotAvailable("invalidate(key, wait)");
    }

    protected void common_invalidate(Object object, boolean bl) {
        this.cache.invalidateById(object, bl);
    }

    public boolean invalidate(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.functionNotAvailable("invalidate(key, request, response)");
        return false;
    }

    protected final boolean common_invalidate(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        boolean bl = false;
        if (this.isMapEntryWriteAllowed(object, dMapRequest, dMapResponse)) {
            this.cache.invalidateById(object, true);
            bl = true;
        }
        return bl;
    }

    public boolean invalidateAndUnlock(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.functionNotAvailable("invalidateAndUnlock(key, request, response)");
        return false;
    }

    protected final boolean common_invalidateAndUnlock(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        boolean bl = false;
        if (this.invalidate(object, dMapRequest, dMapResponse)) {
            bl = this.unlockMapEntry(object, dMapRequest, dMapResponse);
        }
        return bl;
    }

    public Object remove(Object object) {
        return this.functionNotAvailable("remove(key)");
    }

    protected Object common_remove(Object object) {
        Object object2 = this.get(object);
        this.cache.invalidateById(object, true);
        return object2;
    }

    public boolean lockMapEntry(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.functionNotAvailable("lockMapEntry(key)");
        return false;
    }

    protected final boolean common_lockMapEntry(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        boolean bl = false;
        bl = this.lockManager.lockMapEntry(this.cacheName, object, dMapRequest, dMapResponse);
        return bl;
    }

    public boolean unlockMapEntry(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.functionNotAvailable("unlockMapEntry(key, request, response)");
        return false;
    }

    protected final boolean common_unlockMapEntry(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments(object, dMapRequest, dMapResponse);
        dMapResponse.reset();
        boolean bl = false;
        bl = this.lockManager.unlockMapEntry(this.cacheName, object, dMapRequest, dMapResponse);
        return bl;
    }

    public Set keySet() {
        this.functionNotAvailable("keySet()");
        return null;
    }

    protected Set common_keySet() {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    public Set keySet(boolean bl) {
        this.functionNotAvailable("keySet(boolean)");
        return null;
    }

    protected Set common_keySet(boolean bl) {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        if (bl && this.cache.getIdsSizeDisk() > 0) {
            int n = 0;
            boolean bl2 = true;
            Collection collection = null;
            do {
                if ((collection = this.cache.getIdsByRangeDisk(n, 100)) != null) {
                    hashSet.addAll(collection);
                    if (!collection.contains("DISKCACHE_MORE")) {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
                n = 1;
            } while (bl2);
            hashSet.remove("DISKCACHE_MORE");
        }
        return hashSet;
    }

    public Collection values() {
        this.functionNotAvailable("values()");
        return null;
    }

    protected final Collection common_values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            arrayList.add(this.get(enumeration.nextElement()));
        }
        return arrayList;
    }

    public Set entrySet() {
        this.functionNotAvailable("values()");
        return null;
    }

    protected final Set common_entrySet() {
        HashSet<DMIEntry> hashSet = new HashSet<DMIEntry>();
        Enumeration enumeration = this.cache.getAllIds();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            hashSet.add(new DMIEntry(e, this.get(e)));
        }
        return hashSet;
    }

    public boolean enableListener(boolean bl) {
        this.functionNotAvailable("enableListener(enable)");
        return false;
    }

    protected final boolean common_enableListener(boolean bl) {
        return this.cache.enableListener(bl);
    }

    public boolean addInvalidationListener(InvalidationListener invalidationListener) {
        this.functionNotAvailable("addInvalidationListener(listener)");
        return false;
    }

    protected final boolean common_addInvalidationListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            return this.cache.addInvalidationListener(invalidationListener);
        }
        return false;
    }

    public boolean removeInvalidationListener(InvalidationListener invalidationListener) {
        this.functionNotAvailable("removeInvalidationListener(listener)");
        return false;
    }

    protected final boolean common_removeInvalidationListener(InvalidationListener invalidationListener) {
        if (invalidationListener != null) {
            return this.cache.removeInvalidationListener(invalidationListener);
        }
        return false;
    }

    public boolean addChangeListener(ChangeListener changeListener) {
        this.functionNotAvailable("addChangeListener(listener)");
        return false;
    }

    protected final boolean common_addChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            return this.cache.addChangeListener(changeListener);
        }
        return false;
    }

    public boolean removeChangeListener(ChangeListener changeListener) {
        this.functionNotAvailable("removeChangeListener(listener)");
        return false;
    }

    protected final boolean common_removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null) {
            return this.cache.removeChangeListener(changeListener);
        }
        return false;
    }

    public boolean clearAllMapEntryLocks(DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.functionNotAvailable("clearAllMapEntryLocks(request, response)");
        return false;
    }

    protected final boolean common_clearAllMapEntryLocks(DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments("", dMapRequest, dMapResponse);
        dMapResponse.reset();
        boolean bl = false;
        bl = this.lockManager.clearAllMapEntryLocks(this.cacheName, dMapRequest, dMapResponse);
        return bl;
    }

    public boolean clearMapEntryLocks(DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.functionNotAvailable("clearMapEntryLocks(request, response)");
        return false;
    }

    protected final boolean common_clearMapEntryLocks(DMapRequest dMapRequest, DMapResponse dMapResponse) {
        this.validateArguments("", dMapRequest, dMapResponse);
        dMapResponse.reset();
        boolean bl = false;
        return bl;
    }

    protected final Object getFromCache(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        Object object2 = this.cache.getValue(object, this.cache.shouldPull(dMapRequest.getSharingPolicy(), object));
        return object2;
    }

    protected final Object putToCache(Object object, Object object2, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        EntryInfo entryInfo = this.entryInfoPool.allocate(object, dMapRequest.getDependencyIds(), NULL_ALIASIDs);
        entryInfo.setPriority(dMapRequest.getPriority());
        entryInfo.setTimeLimit(dMapRequest.getTimeToLive());
        entryInfo.setSharingPolicy(dMapRequest.getSharingPolicy());
        Object object3 = this.cache.invalidateAndSet(entryInfo, object2, this.cache.getCacheConfig().enableCacheReplication);
        entryInfo.returnToPool();
        return object3;
    }

    private void validateArguments(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        if (object == null || dMapRequest == null || dMapResponse == null) {
            throw new IllegalStateException(INVALID_ARGUMENTS);
        }
        if (!this.useLockManager) {
            throw new IllegalStateException(LOCK_MANAGER_DISABLED);
        }
    }

    private boolean isMapEntryWriteAllowed(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        boolean bl = false;
        this.lockManager.getLockType(this.cacheName, object, dMapRequest, dMapResponse);
        if (dMapResponse.isLockTypeTransactionExclusive()) {
            bl = true;
        } else if (dMapResponse.isLockTypeTransactionShared() && !dMapResponse.isLockTypeOtherTransactionExclusive() && !dMapResponse.isLockTypeOtherTransactionShared()) {
            bl = this.lockManager.convertToExclusive(this.cacheName, object, dMapRequest, dMapResponse);
        }
        return bl;
    }

    private boolean isMapEntryReadAllowed(Object object, DMapRequest dMapRequest, DMapResponse dMapResponse) {
        boolean bl = false;
        this.lockManager.getLockType(this.cacheName, object, dMapRequest, dMapResponse);
        if (dMapResponse.isLockTypeTransactionExclusive() || dMapResponse.isLockTypeTransactionShared()) {
            bl = true;
        } else {
            dMapResponse.setErrorCurrentlyNotLocked();
        }
        return bl;
    }

    private boolean isMapEntryReadAllowed(Object object) {
        boolean bl = false;
        DMapRequest dMapRequest = new DMapRequest();
        DMapResponse dMapResponse = new DMapResponse();
        dMapRequest.setTransactionId(this.transactionIdPrefix);
        this.lockManager.getLockType(this.cacheName, object, dMapRequest, dMapResponse);
        if (!$assertionsDisabled && (dMapResponse.isLockTypeTransactionExclusive() || dMapResponse.isLockTypeTransactionShared())) {
            throw new AssertionError();
        }
        if ((dMapResponse.isLockTypeNone() || dMapResponse.isLockTypeOtherTransactionShared()) && !dMapResponse.isLockTypeOtherTransactionExclusive()) {
            bl = true;
        }
        return bl;
    }

    private boolean isMapEntryWriteAllowed(Object object) {
        boolean bl = false;
        DMapRequest dMapRequest = new DMapRequest();
        DMapResponse dMapResponse = new DMapResponse();
        dMapRequest.setTransactionId(this.transactionIdPrefix);
        this.lockManager.getLockType(this.cacheName, object, dMapRequest, dMapResponse);
        if (!$assertionsDisabled && (dMapResponse.isLockTypeTransactionExclusive() || dMapResponse.isLockTypeTransactionShared())) {
            throw new AssertionError();
        }
        if (dMapResponse.isLockTypeNone()) {
            bl = true;
        }
        return bl;
    }

    private void setMapType(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMapType " + this.cache.getCacheName() + " MapTypeOld:" + this.mapType + " MapTypeNew:" + n));
        }
        this.mapType = n;
    }

    private Object functionNotAvailable(String string) {
        throw new RuntimeException(string + " not implemented in " + this);
    }

    protected final void verifyAllowRead(Object object) {
        if (this.useLockManager && !this.isMapEntryReadAllowed(object)) {
            throw new IllegalStateException("Error: Map entry is locked");
        }
    }

    protected final void verifyAllowWrite(Object object) {
        if (this.useLockManager && !this.isMapEntryWriteAllowed(object)) {
            throw new IllegalStateException("Error: Map entry is locked");
        }
    }

    protected final void readyLockManager() {
        try {
            this.useLockManager = false;
            this.lockManager = new DMapLockManagerImpl(this.cacheName, this.transactionIdPrefix);
            this.useLockManager = true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.DistribtedObjectCacheAdapter", "1135", this);
            throwable.printStackTrace();
        }
    }

    public Cache getCache() {
        return this.cache;
    }

    static {
        $assertionsDisabled = !DistributedObjectCacheAdapter.class.desiredAssertionStatus();
        tc = Trace.register(DistributedObjectCacheAdapter.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
        NULL_ALIASIDs = null;
        NULL_DEPIDs = null;
    }

    class DMIEntry
    implements Map.Entry {
        Object key;
        Object value;

        DMIEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

