/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.cache.Cache;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivilegedAction;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Properties;

public class CacheOnDisk
implements AlarmListener,
DynacacheOnDisk {
    private static final boolean IS_UNIT_TEST = false;
    private static final long SECONDS_FOR_24_HOURS = 86400L;
    private static final long SECONDS_FOR_23_HOURS = 82800L;
    public static final int PROPERTY_OK = 0;
    public static final int PROPERTY_CREATE = 1;
    public static final int PROPERTY_DELETE_CREATE = 2;
    public static final String HTOD_VERSION = "version";
    public static final String HTOD_VERSION_NUM = "6.0";
    public static final String DISABLE_DEPENDENCY_ID = "disableDependencyId";
    public static final String DISABLE_TEMPLATE_SUPPORT = "disableTemplatesSupport";
    public static final String HTOD_PROPERTIES_FILENAME = "htod.properties";
    public static final String HTOD_LAST_SCAN_FILENAME = "lastscantime";
    public static final String HTOD_INVALIDATION_FILENAME = "invalidations.htod";
    private static TraceComponent tc = Trace.register(CacheOnDisk.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    protected String sep = File.separator;
    protected String swapDirPath = null;
    protected String swapRootDirPath = null;
    protected String cacheName = null;
    protected int swapNumHashDirs = 1024;
    protected long sleepInterval = 1800000L;
    protected int cleanupHour = 0;
    protected long invalInterval = 86400000L;
    protected int cleanupFrequency = 0;
    protected boolean delayOffload;
    protected int delayOffloadEntriesLimit = 1000;
    protected int delayOffloadDepIdBuckets = 1000;
    protected int delayOffloadTemplateBuckets = 100;
    protected int dataHashtableSize;
    protected int depIdHashtableSize;
    protected int templateHashtableSize;
    protected int numberOfPools;
    protected int poolSize;
    protected int poolEntryLife;
    protected int invalidationBufferSize;
    protected int invalidationBufferLife;
    protected boolean disableDependencyId = false;
    protected boolean disableTemplatesSupport = false;
    protected boolean ignoreValueInInvalidationEvent = false;
    protected long sleepTime = 0L;
    protected boolean setAlarm = true;
    protected String lastScanFileName = null;
    protected String htodPropertyFileName = null;
    protected String invalidationFileName = null;
    protected final String HTOD_PREF = "_dynacache";
    protected Cache cache = null;
    protected HTODDynacache htod = null;
    protected long lastScanTime = 0L;
    protected int propertyFileStatus = 0;
    protected ValueSet valueSet = null;
    protected boolean stopping = false;

    public CacheOnDisk(CacheConfig cacheConfig, Cache cache) {
        Object object;
        int n;
        Object object2;
        String string = cacheConfig.diskOffloadLocation;
        this.swapNumHashDirs = cacheConfig.diskHashBuckets;
        this.cleanupHour = cacheConfig.htodCleanupHour;
        this.invalInterval = cacheConfig.htodInvalInterval;
        this.cleanupFrequency = cacheConfig.htodCleanupFrequency;
        this.delayOffload = cacheConfig.htodDelayOffload;
        this.delayOffloadEntriesLimit = cacheConfig.htodDelayOffloadEntriesLimit;
        this.delayOffloadDepIdBuckets = cacheConfig.htodDelayOffloadDepIdBuckets;
        this.delayOffloadTemplateBuckets = cacheConfig.htodDelayOffloadTemplateBuckets;
        this.dataHashtableSize = cacheConfig.htodDataHashtableSize;
        this.depIdHashtableSize = cacheConfig.htodDepIdHashtableSize;
        this.templateHashtableSize = cacheConfig.htodTemplateHashtableSize;
        this.numberOfPools = cacheConfig.htodNumberOfPools;
        this.poolSize = cacheConfig.htodPoolSize;
        this.poolEntryLife = cacheConfig.htodPoolEntryLife;
        this.invalidationBufferSize = cacheConfig.htodInvalidationBufferSize;
        this.invalidationBufferLife = cacheConfig.htodInvalidationBufferLife;
        this.disableDependencyId = cacheConfig.disableDependencyId;
        this.disableTemplatesSupport = cacheConfig.disableTemplatesSupport;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        if (this.delayOffload && this.delayOffloadEntriesLimit < 100) {
            this.delayOffloadEntriesLimit = 100;
        }
        if (this.cleanupFrequency < 0) {
            this.cleanupFrequency = 0;
        }
        this.cache = cache;
        this.cacheName = cache.cacheName;
        this.cacheName = this.cacheName.replace('/', '_');
        this.cacheName = this.cacheName.replace('\\', '_');
        String string2 = "";
        String string3 = "";
        int n2 = string.indexOf("##");
        if (n2 == -1) {
            string3 = string + this.sep + this.cacheName;
        } else {
            string2 = string.substring(0, n2) + this.sep + this.cacheName;
            string3 = string.substring(n2 + 2) + this.sep + this.cacheName;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2.equals("")) {
            bl3 = true;
        } else {
            try {
                object2 = new File(string2);
                if (!((File)object2).exists()) {
                    if (!((File)object2).mkdirs()) {
                        bl = true;
                        bl3 = true;
                    }
                } else if (!((File)object2).isDirectory()) {
                    bl = true;
                    bl3 = true;
                } else if (!((File)object2).canWrite()) {
                    bl = true;
                    bl3 = true;
                }
            }
            catch (Throwable throwable) {
                bl = true;
                bl3 = true;
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.CacheOnDisk", "151", this);
                this.traceDebug("constructor()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
        }
        if (!bl && !bl3) {
            this.swapDirPath = string2;
            Tr.info((TraceComponent)tc, (String)"DYNA0053I", (Object)new Object[]{cache.cacheName, string2});
        } else {
            try {
                object2 = new File(string3);
                if (!((File)object2).exists()) {
                    if (!((File)object2).mkdirs()) {
                        bl2 = true;
                    }
                } else if (!((File)object2).isDirectory()) {
                    bl2 = true;
                } else if (!((File)object2).canWrite()) {
                    bl2 = true;
                }
            }
            catch (Throwable throwable) {
                bl2 = true;
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.CacheOnDisk", "176", this);
                this.traceDebug("constructor()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
            if (!bl && !bl2) {
                this.swapDirPath = string3;
                Tr.info((TraceComponent)tc, (String)"DYNA0053I", (Object)new Object[]{cache.cacheName, string3});
            } else if (!bl2) {
                this.swapDirPath = string3;
                Tr.warning((TraceComponent)tc, (String)"DYNA0054W", (Object)new Object[]{cache.cacheName, string2, string3});
            } else {
                this.swapDirPath = "";
                Tr.error((TraceComponent)tc, (String)"DYNA0055E", (Object)new Object[]{cache.cacheName, string2, string3});
                cache.swapToDisk = false;
                return;
            }
        }
        object2 = "  CleanupHour=" + this.cleanupHour + "  InvalInterval=" + this.invalInterval + "  CleanupFrequency=" + this.cleanupFrequency + "  DelayOffload=" + this.delayOffload + "  DelayOffloadEntriesLimit=" + this.delayOffloadEntriesLimit + " DelayOffloadDepIdBuckets=" + this.delayOffloadDepIdBuckets + " DelayOffloadTemplateBuckets=" + this.delayOffloadTemplateBuckets + " DataHashtableSize=" + this.dataHashtableSize + " DepIdHashtableSize=" + this.depIdHashtableSize + " templateHashtableSize=" + this.templateHashtableSize + " DisableDependencyId=" + this.disableDependencyId + " DisableTemplatesSupport=" + this.disableTemplatesSupport;
        Tr.info((TraceComponent)tc, (String)"DYNA0059I", (Object)new Object[]{cache.cacheName, object2});
        if (cache.cacheName != null) {
            n = cacheConfig.flushToDiskOnStop;
            if (this.cacheName.equals("baseCache") && (object = System.getProperty("com.ibm.ws.cache.flushToDiskOnStop")) != null && ((String)object).equalsIgnoreCase("true")) {
                n = 1;
            }
            if (n != 0) {
                Tr.info((TraceComponent)tc, (String)"DYNA0060I", (Object)new Object[]{cache.cacheName});
            } else {
                Tr.info((TraceComponent)tc, (String)"DYNA0061I", (Object)new Object[]{cache.cacheName});
            }
        }
        n = this.swapDirPath.lastIndexOf(this.sep);
        this.swapRootDirPath = this.swapDirPath.substring(0, n);
        this.lastScanFileName = this.swapDirPath + this.sep + HTOD_LAST_SCAN_FILENAME;
        this.htodPropertyFileName = this.swapDirPath + this.sep + HTOD_PROPERTIES_FILENAME;
        this.invalidationFileName = this.swapDirPath + this.sep + HTOD_INVALIDATION_FILENAME;
        if (this.cacheName.equalsIgnoreCase("baseCache")) {
            object = new File(this.swapRootDirPath + this.sep + "InProgress");
            if (((File)object).exists()) {
                Tr.warning((TraceComponent)tc, (String)"DYNA0056W", null);
                this.deleteAllDiskCacheFiles();
            }
            this.createInProgressFile();
        }
        this.loadAndCheckPropertyFile();
        if (this.propertyFileStatus == 2) {
            Tr.warning((TraceComponent)tc, (String)"DYNA0056W", null);
            this.deleteDiskCacheFiles();
            this.updatePropertyFile();
        } else if (this.propertyFileStatus == 1) {
            this.updatePropertyFile();
        }
        try {
            this.htod = new HTODDynacache(this.swapDirPath, this.swapDirPath + this.sep + "_dynacache", this.cache, this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.CacheOnDisk", "243", this);
            this.traceDebug("constructor()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            Tr.error((TraceComponent)tc, (String)"DYNA0055E", (Object)new Object[]{cache.cacheName, string2, string3});
            cache.swapToDisk = false;
            return;
        }
        if (this.cleanupFrequency != 0) {
            this.sleepTime = this.cleanupFrequency * 60 * 1000;
        }
        this.readLastScanFile();
        this.setAlarm = true;
        long l = System.currentTimeMillis();
        if (this.lastScanTime > 0L) {
            if (this.cleanupFrequency == 0) {
                if (this.lastScanTime + this.invalInterval <= l) {
                    this.clearDiskCache();
                }
            } else if (this.lastScanTime + (long)this.cleanupFrequency <= l) {
                this.htod.invalidationBuffer.invokeBackgroundInvalidation(true);
                this.setAlarm = false;
            }
        } else {
            this.updateLastScanFile();
        }
        if (this.setAlarm) {
            if (this.cleanupFrequency == 0) {
                this.sleepTime = this.calculateSleepTime();
                if (this.sleepTime > 82800000L) {
                    this.htod.invalidationBuffer.invokeBackgroundInvalidation(true);
                    this.setAlarm = false;
                } else {
                    this.traceDebug("constructor()", "cacheName=" + this.cacheName + " sleepTime=" + this.sleepTime);
                }
            }
            if (this.setAlarm) {
                AlarmManager.createNonDeferrable((long)this.sleepTime, (AlarmListener)this, null);
            }
        }
    }

    public void close() {
        this.traceDebug("close()", "cacheName=" + this.cacheName);
        if (this.cacheName.equalsIgnoreCase("baseCache")) {
            this.deleteInProgressFile();
        }
        try {
            this.htod.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.close", "306", this);
            this.traceDebug("close()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
        }
    }

    public void writeAuxiliaryDepTables() {
        this.htod.writeAuxiliaryDepTables();
    }

    private void readLastScanFile() {
        final File file = new File(this.lastScanFileName);
        this.traceDebug("readLastScanFile()", "cacheName=" + this.cacheName);
        if (file.exists()) {
            final CacheOnDisk cacheOnDisk = this;
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public Object run() {
                    block14: {
                        FileInputStream fileInputStream = null;
                        ObjectInputStream objectInputStream = null;
                        fileInputStream = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        cacheOnDisk.lastScanTime = objectInputStream.readLong();
                        Object var5_3 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block14;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.readLastScanFile", "354", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                        break block14;
                        {
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.readLastScanFile", "340", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                                Object var5_4 = null;
                                try {
                                    if (objectInputStream != null) {
                                        objectInputStream.close();
                                    }
                                    if (fileInputStream != null) {
                                        fileInputStream.close();
                                    }
                                    break block14;
                                }
                                catch (Throwable throwable2) {
                                    FFDCFilter.processException(throwable2, "com.ibm.ws.cache.CacheOnDisk.readLastScanFile", "354", cacheOnDisk);
                                    CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable2));
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            try {
                                if (objectInputStream != null) {
                                    objectInputStream.close();
                                }
                                if (fileInputStream != null) {
                                    fileInputStream.close();
                                }
                            }
                            catch (Throwable throwable3) {
                                FFDCFilter.processException(throwable3, "com.ibm.ws.cache.CacheOnDisk.readLastScanFile", "354", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("readLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable3));
                            }
                            throw throwable;
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected void updateLastScanFile() {
        final File file = new File(this.lastScanFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("updateLastScanFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                block14: {
                    FileOutputStream fileOutputStream = null;
                    ObjectOutputStream objectOutputStream = null;
                    fileOutputStream = new FileOutputStream(file);
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeLong(System.currentTimeMillis());
                    Object var5_3 = null;
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", "399", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                    break block14;
                    {
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", "385", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                            Object var5_4 = null;
                            try {
                                if (objectOutputStream != null) {
                                    objectOutputStream.close();
                                }
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                                break block14;
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException(throwable2, "com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", "399", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable2));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        try {
                            if (objectOutputStream != null) {
                                objectOutputStream.close();
                            }
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            FFDCFilter.processException(throwable3, "com.ibm.ws.cache.CacheOnDisk.updateLastScanFile", "399", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("updateLastScanFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable3));
                        }
                        throw throwable;
                    }
                }
                return null;
            }
        });
    }

    private void loadAndCheckPropertyFile() {
        final File file = new File(this.htodPropertyFileName);
        final File file2 = new File(this.swapDirPath);
        final CacheOnDisk cacheOnDisk = this;
        final boolean bl = this.disableDependencyId;
        final boolean bl2 = this.disableTemplatesSupport;
        this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                block18: {
                    block19: {
                        cacheOnDisk.propertyFileStatus = 0;
                        if (!file.exists()) break block19;
                        boolean bl3 = false;
                        boolean bl22 = false;
                        FileInputStream fileInputStream = null;
                        fileInputStream = new FileInputStream(file);
                        Properties properties = new Properties();
                        properties.load(fileInputStream);
                        String string = (String)properties.get(CacheOnDisk.DISABLE_DEPENDENCY_ID);
                        if (string != null) {
                            bl3 = Boolean.valueOf(string);
                        } else {
                            cacheOnDisk.propertyFileStatus = 2;
                        }
                        string = (String)properties.get(CacheOnDisk.DISABLE_TEMPLATE_SUPPORT);
                        if (string != null) {
                            bl22 = Boolean.valueOf(string);
                        } else {
                            cacheOnDisk.propertyFileStatus = 2;
                        }
                        if (bl != bl3 || bl2 != bl22) {
                            cacheOnDisk.propertyFileStatus = 2;
                        }
                        CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " htod.properties exist with status=" + cacheOnDisk.propertyFileStatus);
                        Object var7_8 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block18;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", "464", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                        break block18;
                        {
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", "452", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                                cacheOnDisk.propertyFileStatus = 2;
                                Object var7_9 = null;
                                try {
                                    if (fileInputStream != null) {
                                        fileInputStream.close();
                                    }
                                    break block18;
                                }
                                catch (Throwable throwable2) {
                                    FFDCFilter.processException(throwable2, "com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", "464", cacheOnDisk);
                                    CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable2));
                                }
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            try {
                                if (fileInputStream != null) {
                                    fileInputStream.close();
                                }
                            }
                            catch (Throwable throwable3) {
                                FFDCFilter.processException(throwable3, "com.ibm.ws.cache.CacheOnDisk.loadAndCheckPropertyFile", "464", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable3));
                            }
                            throw throwable;
                        }
                    }
                    String[] stringArray = file2.list();
                    if (stringArray != null && stringArray.length > 0) {
                        CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " htod.properties not exist but other disk cache files exist");
                        cacheOnDisk.propertyFileStatus = 2;
                    } else {
                        CacheOnDisk.this.traceDebug("loadAndCheckPropertyFile()", "cacheName=" + cacheOnDisk.cacheName + " htod.properties not exist");
                        cacheOnDisk.propertyFileStatus = 1;
                    }
                }
                return null;
            }
        });
    }

    protected void updatePropertyFile() {
        final File file = new File(this.htodPropertyFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("updatePropertyFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                block11: {
                    FileOutputStream fileOutputStream = null;
                    Properties properties = new Properties();
                    fileOutputStream = new FileOutputStream(file);
                    properties.put(CacheOnDisk.HTOD_VERSION, CacheOnDisk.HTOD_VERSION_NUM);
                    properties.put(CacheOnDisk.DISABLE_DEPENDENCY_ID, Boolean.toString(CacheOnDisk.this.disableDependencyId));
                    properties.put(CacheOnDisk.DISABLE_TEMPLATE_SUPPORT, Boolean.toString(CacheOnDisk.this.disableTemplatesSupport));
                    properties.store(fileOutputStream, "HTOD properties - Do not modify the properties");
                    Object var5_3 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", "520", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                    break block11;
                    {
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", "509", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                            Object var5_4 = null;
                            try {
                                if (fileOutputStream != null) {
                                    fileOutputStream.close();
                                }
                                break block11;
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException(throwable2, "com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", "520", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable2));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            FFDCFilter.processException(throwable3, "com.ibm.ws.cache.CacheOnDisk.updatePropertyFile", "520", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("updatePropertyFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable3));
                        }
                        throw throwable;
                    }
                }
                return null;
            }
        });
    }

    public void deleteDiskCacheFiles() {
        final File file = new File(this.swapDirPath);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("deleteDiskCacheFiles()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        fileArray[i].delete();
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.deleteDiskCacheFiles", "550", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("deleteDiskCacheFiles()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                }
                return null;
            }
        });
    }

    private void deleteAllDiskCacheFiles() {
        final File file = new File(this.swapRootDirPath);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("deleteAllDiskCacheFiles()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    File[] fileArray2 = fileArray[i].listFiles();
                    for (int j = 0; j < fileArray2.length; ++j) {
                        try {
                            fileArray2[j].delete();
                            continue;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.deleteAllDiskCacheFiles", "583", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("deleteAllDiskCacheFiles()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                    }
                }
                return null;
            }
        });
    }

    private void createInProgressFile() {
        final File file = new File(this.swapRootDirPath + this.sep + "InProgress");
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("createInProgressFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    file.createNewFile();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.createInProgressFile", "612", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("createInProgressFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                return null;
            }
        });
    }

    private void deleteInProgressFile() {
        final File file = new File(this.swapRootDirPath + this.sep + "InProgress");
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("deleteInProgressFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    file.delete();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.close", "638", cacheOnDisk);
                    CacheOnDisk.this.traceDebug("deleteInProgressFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                }
                return null;
            }
        });
    }

    public void stop(boolean bl) {
        this.stopping = true;
        this.htod.stop(bl);
    }

    public void restart() {
        if (this.cacheName.equalsIgnoreCase("baseCache")) {
            this.createInProgressFile();
        }
        this.stopping = false;
        this.htod.restart();
        if (this.cleanupFrequency == 0) {
            this.sleepTime = this.calculateSleepTime();
        }
        AlarmManager.createNonDeferrable((long)this.sleepTime, (AlarmListener)this, null);
    }

    protected void readAndDeleteInvalidationFile() {
        final File file = new File(this.invalidationFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.valueSet = new ValueSet(1);
        if (file.exists()) {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public Object run() {
                    block15: {
                        FileInputStream fileInputStream = null;
                        ObjectInputStream objectInputStream = null;
                        fileInputStream = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        int n = objectInputStream.readInt();
                        cacheOnDisk.valueSet = new ValueSet(n);
                        for (int i = 0; i < n; ++i) {
                            cacheOnDisk.valueSet.add(objectInputStream.readObject());
                        }
                        Object var6_6 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            file.delete();
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "712", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                        }
                        break block15;
                        {
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "697", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                                Object var6_7 = null;
                                try {
                                    if (objectInputStream != null) {
                                        objectInputStream.close();
                                    }
                                    if (fileInputStream != null) {
                                        fileInputStream.close();
                                    }
                                    file.delete();
                                }
                                catch (Throwable throwable2) {
                                    FFDCFilter.processException(throwable2, "com.ibm.ws.cache.CacheOnDisk", "712", cacheOnDisk);
                                    CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable2));
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            try {
                                if (objectInputStream != null) {
                                    objectInputStream.close();
                                }
                                if (fileInputStream != null) {
                                    fileInputStream.close();
                                }
                                file.delete();
                            }
                            catch (Throwable throwable3) {
                                FFDCFilter.processException(throwable3, "com.ibm.ws.cache.CacheOnDisk", "712", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable3));
                            }
                            throw throwable;
                        }
                    }
                    return null;
                }
            });
        }
        this.traceDebug("readAndDeleteInvalidationFile()", "cacheName=" + this.cacheName + " " + this.invalidationFileName + " size=" + this.valueSet.size());
    }

    protected void createInvalidationFile() {
        final File file = new File(this.invalidationFileName);
        final CacheOnDisk cacheOnDisk = this;
        this.traceDebug("createInvalidationFile()", "cacheName=" + this.cacheName);
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object run() {
                block9: {
                    FileOutputStream fileOutputStream = null;
                    ObjectOutputStream objectOutputStream = null;
                    fileOutputStream = new FileOutputStream(file);
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeInt(cacheOnDisk.valueSet.size());
                    Iterator iterator = CacheOnDisk.this.valueSet.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        objectOutputStream.writeObject(e);
                    }
                    Object var6_6 = null;
                    try {
                        objectOutputStream.close();
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "762", cacheOnDisk);
                        CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                    }
                    break block9;
                    {
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk", "752", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
                            Object var6_7 = null;
                            try {
                                objectOutputStream.close();
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException(throwable2, "com.ibm.ws.cache.CacheOnDisk", "762", cacheOnDisk);
                                CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable2));
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        try {
                            objectOutputStream.close();
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable3) {
                            FFDCFilter.processException(throwable3, "com.ibm.ws.cache.CacheOnDisk", "762", cacheOnDisk);
                            CacheOnDisk.this.traceDebug("createInvalidationFile()", "cacheName=" + cacheOnDisk.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable3));
                        }
                        throw throwable;
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        CacheOnDisk cacheOnDisk = this;
        synchronized (cacheOnDisk) {
            if (!this.stopping) {
                this.htod.invalidationBuffer.invokeBackgroundInvalidation(true);
            } else {
                this.traceDebug("alarm()", "cacheName=" + this.cacheName + " abort disk cleanup because of server is stopping.");
            }
        }
    }

    protected void cleanUpHTOD(boolean bl) {
        if (this.htod != null) {
            try {
                this.htod.removeExpiredCache(this.invalInterval, bl);
                if (bl) {
                    this.updateLastScanFile();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.cache.CacheOnDisk.cleanupHTOD", "867", this);
                this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cacheName + "\nException: " + ExceptionUtility.getStackTrace(throwable));
            }
        }
        if (bl && !this.stopping && !this.htod.invalidationBuffer.isCleanupPending()) {
            if (this.cleanupFrequency == 0) {
                this.sleepTime = this.calculateSleepTime();
                this.traceDebug("cleanUpHTOD()", "cacheName=" + this.cacheName + " sleepTime=" + this.sleepTime);
            }
            AlarmManager.createNonDeferrable((long)this.sleepTime, (AlarmListener)this, null);
        }
    }

    protected void doCleanUp(boolean bl) {
        LowPriCleanupThread lowPriCleanupThread = new LowPriCleanupThread(this, bl);
        lowPriCleanupThread.setPriority(1);
        lowPriCleanupThread.start();
    }

    public void clearDiskCache() {
        this.htod.clearDiskCache();
        this.updateLastScanFile();
        this.updatePropertyFile();
    }

    public void writeCacheEntry(CacheEntry cacheEntry) {
        this.htod.writeCacheEntry(cacheEntry);
    }

    public CacheEntry readCacheEntry(Object object) {
        return this.htod.readCacheEntry(object);
    }

    public void delCacheEntry(CacheEntry cacheEntry) {
        this.htod.delCacheEntry(cacheEntry);
    }

    public void delCacheEntry(ValueSet valueSet) {
        this.htod.delCacheEntry(valueSet);
    }

    public ValueSet readDependency(Object object, boolean bl) {
        return this.htod.readDependency(object, bl);
    }

    public ValueSet readTemplate(String string, boolean bl) {
        return this.htod.readTemplate(string, bl);
    }

    public ValueSet readCacheIdsByRange(int n, int n2) {
        return this.htod.readCacheIdsByRange(n, n2);
    }

    public ValueSet readDependencyByRange(int n, int n2) {
        return this.htod.readDependencyByRange(n, n2);
    }

    public ValueSet readTemplatesByRange(int n, int n2) {
        return this.htod.readTemplatesByRange(n, n2);
    }

    public int getCacheIdsSize() {
        int n = this.htod.getCacheIdsSize() - this.htod.invalidationBuffer.size();
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    public int getDepIdsSize() {
        return this.htod.getDepIdsSize();
    }

    public int getTemplatesSize() {
        return this.htod.getTemplatesSize();
    }

    public void delDependencyEntry(Object object, Object object2) {
        this.htod.delDependencyEntry(object, object2);
    }

    public void delTemplateEntry(String string, Object object) {
        this.htod.delTemplateEntry(string, object);
    }

    public void delDependency(Object object) {
        this.htod.delDependency(object);
    }

    public void delTemplate(String string) {
        this.htod.delTemplate(string);
    }

    public void writeDependency(Object object, ValueSet valueSet) {
        this.htod.writeDependency(object, valueSet);
    }

    public void writeTemplate(String string, ValueSet valueSet) {
        this.htod.writeTemplate(string, valueSet);
    }

    public void writeDependencyEntry(Object object, Object object2) {
        this.htod.writeDependencyEntry(object, object2);
    }

    public void writeTemplateEntry(String string, Object object) {
        this.htod.writeTemplateEntry(string, object);
    }

    public boolean containsKey(Object object) {
        return this.htod.containsKey(object);
    }

    private long calculateSleepTime() {
        int n;
        int n2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = gregorianCalendar.get(11);
        long l = 86400L - (long)((n3 * 60 + (n2 = gregorianCalendar.get(12))) * 60 + (n = gregorianCalendar.get(13))) + (long)(this.cleanupHour * 60 * 60);
        if (l > 86400L) {
            l -= 86400L;
        }
        if (l < 10L) {
            l = 10L;
        }
        return l *= 1000L;
    }

    public boolean isCleanupRunning() {
        return this.htod.invalidationBuffer.isBackgroundInvalidationInProgress();
    }

    private void traceDebug(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " " + string2));
        }
    }

    class LowPriCleanupThread
    extends Thread {
        CacheOnDisk cod;
        boolean scan = true;

        LowPriCleanupThread(CacheOnDisk cacheOnDisk2, boolean bl) {
            this.cod = cacheOnDisk2;
            this.scan = bl;
        }

        public void run() {
            this.cod.cleanUpHTOD(this.scan);
            if (this.cod.htod.invalidationBuffer.isCleanupPending()) {
                this.cod.htod.invalidationBuffer.resetCleanupPending();
                this.cod.cleanUpHTOD(true);
            }
            this.cod.htod.invalidationBuffer.setlastRemoveTime();
            this.cod.htod.invalidationBuffer.resetBackgroundInvalidationInProgress();
            if (this.cod.cache.doNotify) {
                this.cod.cache.notify();
            }
        }
    }
}

