/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.util.AssertUtility;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheInstanceInfo {
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    private static CacheServiceImpl cacheService;
    private static long lastPopulate;
    private static long populateInterval;
    private static CacheInstanceInfo cacheInstanceInfo;
    private static CacheInstanceInfo[] currentCacheInstanceInfoOut;
    static ArrayList allFactory;
    static ArrayList allFile;
    static ArrayList allConfigured;
    static ArrayList allActive;
    static ArrayList objectConfigured;
    static ArrayList servletConfigured;
    private String cacheName = null;
    private boolean isFactory = false;
    private boolean isFile = false;
    private boolean isActive = false;
    private boolean isObjectCache = false;
    private boolean isServletCache = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getCacheName() {
        return this.cacheName;
    }

    public boolean isFactory() {
        return this.isFactory;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isObjectCache() {
        return this.isObjectCache;
    }

    public boolean isServletCache() {
        return this.isServletCache;
    }

    private CacheInstanceInfo() {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"CacheInstanceInfo() - CTOR");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("CacheInstanceInfo() - CTOR cacheService=" + cacheService));
        }
    }

    static synchronized CacheInstanceInfo[] getCacheInstanceInfo(CacheServiceImpl cacheServiceImpl) {
        CacheInstanceInfo[] cacheInstanceInfoArray = currentCacheInstanceInfoOut;
        if (System.currentTimeMillis() - lastPopulate > populateInterval) {
            if (cacheServiceImpl != null) {
                if (cacheInstanceInfo == null) {
                    cacheInstanceInfo = new CacheInstanceInfo();
                }
                cacheServiceImpl.populateCacheInstanceInfo(cacheInstanceInfo);
                cacheService = cacheServiceImpl;
                cacheInstanceInfoArray = new CacheInstanceInfo[allConfigured.size()];
                Iterator iterator = allConfigured.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    CacheInstanceInfo cacheInstanceInfo = new CacheInstanceInfo();
                    cacheInstanceInfo.cacheName = string;
                    cacheInstanceInfo.isActive = allActive.contains(string);
                    cacheInstanceInfo.isFactory = allFactory.contains(string);
                    cacheInstanceInfo.isFile = allFile.contains(string);
                    cacheInstanceInfo.isObjectCache = objectConfigured.contains(string);
                    cacheInstanceInfo.isServletCache = servletConfigured.contains(string);
                    cacheInstanceInfoArray[n++] = cacheInstanceInfo;
                }
                currentCacheInstanceInfoOut = cacheInstanceInfoArray;
                allConfigured.clear();
                allActive.clear();
                allFactory.clear();
                allFile.clear();
                objectConfigured.clear();
                servletConfigured.clear();
            }
            lastPopulate = System.currentTimeMillis();
        }
        return cacheInstanceInfoArray;
    }

    static {
        $assertionsDisabled = !CacheInstanceInfo.class.desiredAssertionStatus();
        tc = Trace.register(CacheInstanceInfo.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
        cacheService = null;
        lastPopulate = 0L;
        populateInterval = 3000L;
        cacheInstanceInfo = null;
        currentCacheInstanceInfoOut = null;
        allFactory = new ArrayList();
        allFile = new ArrayList();
        allConfigured = new ArrayList();
        allActive = new ArrayList();
        objectConfigured = new ArrayList();
        servletConfigured = new ArrayList();
    }
}

