/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.ChangeEvent;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.InvalidationEvent;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.CacheStatisticsListener;
import com.ibm.ws.cache.CacheStatisticsListenerImpl;
import com.ibm.ws.cache.DCEventSource;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.DynacacheOnDisk;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.EventSourceIntf;
import com.ibm.ws.cache.FastHashtable;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.NullCachePerfModule;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.devmon.Monitor;
import com.ibm.ws.cache.stat.CacheStatsModule;
import com.ibm.ws.cache.util.AssertUtility;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Cache
implements com.ibm.websphere.cache.Cache {
    private static TraceComponent tc;
    private static boolean assertRanOnce;
    public static final boolean IS_UNIT_TEST = false;
    public Monitor monitor = null;
    public static final boolean FIRE_INVALIDATION_LISTENER = true;
    public static final boolean COORDINATE = true;
    public static final boolean INCREMENT_REFF_COUNT = true;
    public static final boolean IGNORE_COUNTING = true;
    public static final boolean ASK_PERMISSION = true;
    public static final boolean DO_FINISH = true;
    public static final String DEFAULT_CACHE_NAME = "baseCache";
    public static final int DEFAULT_CACHE_SIZE = 2000;
    public static final String DEFAULT_DISTRIBUTED_MAP_NAME = "default";
    public static final String DEFAULT_BASE_JNDI_NAME = "services/cache/basecache";
    public static final String DEFAULT_DMAP_JNDI_NAME = "services/cache/distributedmap";
    private static final ArrayList EMPTY_ARRAY_LIST;
    public static final boolean FROM_DEPID_TEMPLATE_INVALIDATION = true;
    private long lastCachePerf_maxNumberCacheEntries = 0L;
    private long lastCachePerf_entryHashtableSize = 0L;
    protected CachePerf cachePerf = null;
    private CacheStatisticsListener cacheStatisticsListener = null;
    String cacheName;
    String cacheNameNonPrefixed;
    private CacheConfig cacheConfig = null;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private RemoteServices remoteServices = null;
    private TimeLimitDaemon timeLimitDaemon = null;
    private CacheEntry.CacheEntryPool cacheEntryPool = null;
    private DependencyTable dataDependencyTable = null;
    private DependencyTable templateDependencyTable = null;
    private FastHashtable entryHashtable = null;
    private int defaultPriority = CacheEntry.DEFAULT_PRIORITY;
    protected boolean swapToDisk = false;
    protected DynacacheOnDisk diskCache = null;
    private boolean flushToDiskComplete = false;
    CacheEntry.LRUHead[] lruBuckets = null;
    int lruTop = 0;
    protected boolean bEnableListener = false;
    protected EventSourceIntf eventSource = null;
    protected boolean ignoreValueInInvalidationEvent = false;
    private boolean drsDisabled = false;
    protected boolean doNotify = false;
    protected int cePoolCount = 0;
    protected boolean useServerClassLoader = false;
    public boolean cacheInstanceStoreCookies = true;
    private boolean drsBootstrap = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Cache(String string, CacheConfig cacheConfig) {
        if (!$assertionsDisabled && !(assertRanOnce = AssertUtility.assertCheck(assertRanOnce, this))) {
            throw new AssertionError();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Cache() CTOR cacheName:" + string));
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cacheConfig == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !string.equals(cacheConfig.cacheName)) {
            throw new AssertionError((Object)("cacheName:" + string + " cacheConfig.cacheName:" + cacheConfig.cacheName));
        }
        this.cacheName = string;
        this.cacheNameNonPrefixed = cacheConfig.cacheNameNonPrefixed != null ? cacheConfig.cacheNameNonPrefixed : string;
        this.cacheConfig = cacheConfig;
        this.swapToDisk = cacheConfig.enableDiskOffload;
        this.ignoreValueInInvalidationEvent = cacheConfig.ignoreValueInInvalidationEvent;
        this.useServerClassLoader = cacheConfig.useServerClassLoader;
        String string2 = cacheConfig.disableStoreCookies;
        if (string2.equalsIgnoreCase("All")) {
            this.cacheInstanceStoreCookies = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.equals(string) && !string3.equalsIgnoreCase("All")) continue;
                this.cacheInstanceStoreCookies = false;
                break;
            }
        }
        if (!this.cacheInstanceStoreCookies && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" Store_Cookies property disabled for cacheName:" + string));
        }
        int n = Math.min(1000, cacheConfig.cacheSize / 10);
        this.cacheEntryPool = CacheEntry.createCacheEntryPool(this, n);
        this.lruBuckets = new CacheEntry.LRUHead[CacheEntry.MAX_PRIORITY + 1];
        for (int i = 0; i < this.lruBuckets.length; ++i) {
            this.lruBuckets[i] = new CacheEntry.LRUHead();
            this.lruBuckets[i].priority = i;
        }
        this.entryHashtable = new FastHashtable(cacheConfig.cacheSize);
        if (!cacheConfig.disableDependencyId) {
            this.dataDependencyTable = new DependencyTable(1, cacheConfig.cacheSize / 3);
        }
        if (!cacheConfig.disableTemplatesSupport) {
            this.templateDependencyTable = new DependencyTable(1, cacheConfig.cacheSize / 10);
        }
        if (this.swapToDisk) {
            this.diskCache = new CacheOnDisk(cacheConfig, this);
            if (!this.swapToDisk) {
                this.diskCache = null;
            }
        }
        this.createCachePerf();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Cache() CTOR cacheName=" + string + "  cache=" + this));
        }
    }

    public void finalize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("finalize() cacheName=" + this.cacheName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finalize() cache=" + this));
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    protected void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        if (!$assertionsDisabled && this.batchUpdateDaemon != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && batchUpdateDaemon == null) {
            throw new AssertionError();
        }
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    public CacheStatisticsListenerImpl getCacheStatisticsListener() {
        if (!$assertionsDisabled && this.cacheStatisticsListener == null) {
            throw new AssertionError();
        }
        return (CacheStatisticsListenerImpl)this.cacheStatisticsListener;
    }

    protected void setCacheStatisticsListener(CacheStatisticsListener cacheStatisticsListener) {
        if (!$assertionsDisabled && this.cacheStatisticsListener != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cacheStatisticsListener == null) {
            throw new AssertionError();
        }
        this.cacheStatisticsListener = cacheStatisticsListener;
    }

    protected void setTimeLimitDaemon(TimeLimitDaemon timeLimitDaemon) {
        if (!$assertionsDisabled && this.timeLimitDaemon != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && timeLimitDaemon == null) {
            throw new AssertionError();
        }
        this.timeLimitDaemon = timeLimitDaemon;
    }

    protected void setRemoteServices(RemoteServices remoteServices) {
        if (!$assertionsDisabled && this.remoteServices != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && remoteServices == null) {
            throw new AssertionError();
        }
        this.remoteServices = remoteServices;
    }

    protected RemoteServices getRemoteServices() {
        if (!$assertionsDisabled && this.remoteServices == null) {
            throw new AssertionError();
        }
        return this.remoteServices;
    }

    protected void setDefaultPriority(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (n < 0) {
            n = CacheEntry.DEFAULT_PRIORITY;
        }
        this.defaultPriority = n;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    protected void start() {
        if (this.timeLimitDaemon == null || this.batchUpdateDaemon == null || this.cacheStatisticsListener == null || this.remoteServices == null) {
            throw new IllegalStateException("batchUpdateDaemon, cacheStatisticsListener, remoteServices, and timeLimitDaemon must all be set before start()");
        }
        this.flushToDiskComplete = false;
    }

    public CacheEntry setEntry(CacheEntry cacheEntry) {
        return this.setEntry(cacheEntry, 5);
    }

    public CacheEntry setEntry(CacheEntry cacheEntry, int n) {
        return this.setEntry(cacheEntry, n, false, false);
    }

    public CacheEntry setEntry(CacheEntry cacheEntry, int n, boolean bl, boolean bl2) {
        if (!$assertionsDisabled && cacheEntry.cacheEntryPool != null && cacheEntry.cacheEntryPool == this.cacheEntryPool) {
            throw new AssertionError();
        }
        CacheEntry cacheEntry2 = null;
        if (!bl) {
            this.cacheStatisticsListener.setEntry(cacheEntry.id);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setEntry id=" + cacheEntry.id + " sharing policy=" + cacheEntry.sharingPolicy + " timeToLive=" + cacheEntry.timeLimit));
        }
        cacheEntry2 = this._syncSetEntry(cacheEntry, n, bl);
        if (cacheEntry2.timeLimit > 0 || cacheEntry2.inactivity > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry2.id, cacheEntry2.expirationTime, cacheEntry2.inactivity);
        }
        if (cacheEntry2.getSharingPolicy() == 1) {
            cacheEntry2.finish();
            return cacheEntry2;
        }
        if (bl2) {
            this.updatePeerCaches(cacheEntry2);
        } else {
            cacheEntry2.finish();
        }
        return cacheEntry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getCacheEntry(Object object, boolean bl, boolean bl2, String string, boolean bl3) {
        CacheEntry cacheEntry;
        if (bl3) {
            Cache cache = this;
            synchronized (cache) {
                cacheEntry = (CacheEntry)this.entryHashtable.get(object, bl3);
                if (cacheEntry != null && !cacheEntry.invalid && !cacheEntry.removeWhenUnpinned) {
                    this.updateLruLocation(cacheEntry);
                    if (cacheEntry.inactivity > 0) {
                        this.timeLimitDaemon.valueWasAccessed(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
                    }
                }
            }
        } else {
            cacheEntry = (CacheEntry)this.entryHashtable.get(object, bl3);
        }
        if (cacheEntry != null) {
            if (!bl2) {
                this.cacheStatisticsListener.getValueLocalHit(object);
                if (this.cachePerf.isPMIEnabled() && cacheEntry != null && cacheEntry.getValue() != null) {
                    this.cachePerf.onCacheHit(cacheEntry.getTemplate(), 1);
                }
            }
            return cacheEntry;
        }
        if (cacheEntry == null && this.swapToDisk && (cacheEntry = this.diskCache.readCacheEntry(object)) != null) {
            if (bl3) {
                ++cacheEntry.refCount;
            }
            cacheEntry.loadedFromDisk = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" found on disk for id " + object + ", monitor = " + bl2));
            }
            if (!bl2) {
                this.cacheStatisticsListener.getValueLocalHit(object);
            }
            if (this.cachePerf.isPMIEnabled() && !bl2) {
                this.cachePerf.onCacheHit(cacheEntry.getTemplate(), 3);
            }
            cacheEntry = this.setEntry(cacheEntry, 3, bl2, false);
            return cacheEntry;
        }
        if (cacheEntry == null && bl) {
            cacheEntry = this.remoteServices.getEntry(object);
            if (cacheEntry != null) {
                if (bl3) {
                    ++cacheEntry.refCount;
                }
                if (!bl2) {
                    this.cacheStatisticsListener.getValueRemoteHit(object);
                }
                cacheEntry = this.setEntry(cacheEntry, 2, bl2, false);
            } else {
                if (!bl2) {
                    this.cacheStatisticsListener.getValueCacheMiss(object);
                }
                if (this.cachePerf.isPMIEnabled() && !bl2) {
                    this.cachePerf.onCacheMiss(string, 5);
                }
            }
        } else {
            if (!bl2) {
                this.cacheStatisticsListener.getValueCacheMiss(object);
            }
            if (this.cachePerf.isPMIEnabled() && !bl2) {
                this.cachePerf.onCacheMiss(string, 5);
            }
        }
        return cacheEntry;
    }

    private synchronized CacheEntry _syncSetEntry(CacheEntry cacheEntry, int n, boolean bl) {
        Object e;
        Object object;
        int n2 = -1;
        CacheEntry cacheEntry2 = (CacheEntry)this.entryHashtable.get(cacheEntry.id);
        if (!bl && this.cachePerf.isPMIEnabled() && n != 3) {
            if ((cacheEntry.getSharingPolicy() == 3 || cacheEntry.getSharingPolicy() == 4) && n == 2) {
                this.cachePerf.onCacheHit(cacheEntry.getTemplate(), n);
            } else if (cacheEntry.getSharingPolicy() == 2 && n == 2) {
                if (cacheEntry2 == null) {
                    this.cachePerf.onEntryCreation(cacheEntry.getTemplate(), n);
                }
            } else {
                this.cachePerf.onEntryCreation(cacheEntry.getTemplate(), n);
            }
        }
        CacheEntry cacheEntry3 = null;
        if (cacheEntry2 == null) {
            n2 = 2;
            cacheEntry3 = this.getFreeLruEntry();
            this.entryHashtable.put(cacheEntry.id, cacheEntry3);
            if (this.swapToDisk && !cacheEntry.loadedFromDisk && (object = this.diskCache.readCacheEntry(cacheEntry.id)) != null) {
                this.diskCache.delCacheEntry((CacheEntry)object);
                n2 = 1;
            }
        } else {
            n2 = 1;
            if (cacheEntry2.timeStamp > cacheEntry.timeStamp) {
                Tr.debug((TraceComponent)tc, (String)("ERROR: attempting to overwrite cacheEntry with older cacheEntry: " + cacheEntry.id));
            }
            if (this.swapToDisk && cacheEntry2.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry2);
            }
            if (cacheEntry2.refCount == 0) {
                cacheEntry3 = cacheEntry2;
            } else {
                cacheEntry3 = this.getFreeLruEntry();
                this.entryHashtable.put(cacheEntry.id, cacheEntry3);
                cacheEntry2.removeWhenUnpinned = true;
            }
            this.removeInvalidationInfo(cacheEntry2);
            object = cacheEntry2.getAliasList();
            while (object.hasMoreElements()) {
                e = object.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" removing alias from EHT id=" + cacheEntry.id + " alias=" + e));
                }
                this.entryHashtable.remove(e);
            }
        }
        this.updateInvalidationHashtable(cacheEntry);
        cacheEntry3.copy(cacheEntry);
        this.updateLruLocation(cacheEntry3);
        object = cacheEntry3.getAliasList();
        while (object.hasMoreElements()) {
            e = object.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" adding alias to EHT id=" + cacheEntry.id + " alias=" + e));
            }
            this.entryHashtable.put(e, cacheEntry3);
        }
        ++cacheEntry3.refCount;
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0 && n != 3) {
            int n3 = 1;
            if (n == 2) {
                n3 = 2;
            }
            Object object2 = null;
            object2 = cacheEntry3.serializedValue != null ? cacheEntry3.serializedValue : (Object)cacheEntry3.getValue();
            ChangeEvent changeEvent = new ChangeEvent(cacheEntry3.id, object2, n2, n3, this.cacheNameNonPrefixed);
            this.eventSource.cacheEntryChanged(changeEvent);
        }
        return cacheEntry3;
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl) {
        CacheEntry cacheEntry;
        Object object = entryInfo.getIdObject();
        if (object == null) {
            return null;
        }
        boolean bl2 = false;
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if (bl) {
            bl2 = this.shouldPull(entryInfo.getSharingPolicy(), object);
        }
        if ((cacheEntry = this.getCacheEntry(object, bl2, false, entryInfo.getTemplate(), true)) == null) {
            this.cacheStatisticsListener.getEntryMiss(object);
            return null;
        }
        this.cacheStatisticsListener.getEntryHit(object);
        return cacheEntry;
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(com.ibm.websphere.cache.EntryInfo entryInfo) {
        Object object = entryInfo.getIdObject();
        if (object == null) {
            return null;
        }
        return this.getEntry(entryInfo, true);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(String string) {
        return this.getCacheEntry(string, false, true, null, false);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(Object object) {
        return this.getCacheEntry(object, false, true, null, false);
    }

    public com.ibm.websphere.cache.CacheEntry getEntry(Object object, int n, boolean bl) {
        if (object == null) {
            return null;
        }
        CacheEntry cacheEntry = this.getCacheEntry(object, false, bl, null, true);
        if (this.cachePerf.isPMIEnabled() && !bl && cacheEntry != null && n == 2) {
            this.cachePerf.onRequest(cacheEntry.getTemplate(), 2);
        }
        return cacheEntry;
    }

    public synchronized void refreshEntry(CacheEntry cacheEntry) {
        this.updateLruLocation(cacheEntry);
    }

    private final synchronized void updateLruLocation(CacheEntry cacheEntry) {
        if (cacheEntry.lruHead == null) {
            int n = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[n];
            cacheEntry.lruHead.addLast(cacheEntry);
        } else if (cacheEntry.lruHead.priority != cacheEntry.priority || cacheEntry.lruHead.priority == cacheEntry.priority && !cacheEntry.lruHead.isLast(cacheEntry)) {
            cacheEntry.lruHead.remove(cacheEntry);
            int n = (this.lruTop + cacheEntry.priority) % this.lruBuckets.length;
            cacheEntry.lruHead = this.lruBuckets[n];
            cacheEntry.lruHead.addLast(cacheEntry);
        }
    }

    public void setValue(EntryInfo entryInfo, Object object) {
        this.setValue(entryInfo, object, !this.shouldPull(entryInfo.getSharingPolicy(), entryInfo.id));
    }

    public void setValue(EntryInfo entryInfo, Object object, boolean bl) {
        if (entryInfo == null) {
            throw new NullPointerException("input parameter entryInfo is null.");
        }
        if (entryInfo.getIdObject() == null) {
            throw new NullPointerException("entryInfo.getIdObject() is null.");
        }
        this.cacheStatisticsListener.setValue(entryInfo.getIdObject());
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        CacheEntry cacheEntry = this._syncSetValue(entryInfo, object);
        if (cacheEntry.timeLimit > 0 || cacheEntry.inactivity > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry.id, cacheEntry.expirationTime, cacheEntry.inactivity);
        }
        if (entryInfo.isNotShared()) {
            cacheEntry.finish();
            return;
        }
        if (bl) {
            this.updatePeerCaches(cacheEntry);
        } else {
            cacheEntry.finish();
        }
    }

    private synchronized CacheEntry _syncSetValue(EntryInfo entryInfo, Object object) {
        Serializable serializable;
        int n = -1;
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(entryInfo.getIdObject());
        if (cacheEntry == null) {
            n = 2;
            cacheEntry = this.getFreeLruEntry();
            this.entryHashtable.put(entryInfo.getIdObject(), cacheEntry);
            if (this.swapToDisk && (serializable = this.diskCache.readCacheEntry(entryInfo.getIdObject())) != null) {
                this.diskCache.delCacheEntry((CacheEntry)serializable);
                n = 1;
            }
        } else {
            n = 1;
            if (this.swapToDisk && cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry);
            }
            this.removeInvalidationInfo(cacheEntry);
        }
        if (this.cachePerf.isPMIEnabled() && cacheEntry.getValue() == null) {
            this.cachePerf.onEntryCreation(entryInfo.getTemplate(), 5);
        }
        cacheEntry.copyMetaData(entryInfo);
        this.updateInvalidationHashtable(cacheEntry);
        cacheEntry.setValue(object);
        this.updateLruLocation(cacheEntry);
        cacheEntry.timeStamp = System.currentTimeMillis();
        ++cacheEntry.refCount;
        if (this.bEnableListener && this.eventSource.getChangeListenerCount() > 0) {
            serializable = new ChangeEvent(cacheEntry.id, cacheEntry.getValue(), n, 1, this.cacheNameNonPrefixed);
            this.eventSource.cacheEntryChanged((ChangeEvent)serializable);
        }
        return cacheEntry;
    }

    private void updateInvalidationHashtable(CacheEntry cacheEntry) {
        int n;
        Object object = cacheEntry.id;
        for (n = 0; n < cacheEntry._dataIds.length; ++n) {
            this.dataDependencyTable.add(cacheEntry._dataIds[n], object);
        }
        for (n = 0; n < cacheEntry._templates.length; ++n) {
            this.templateDependencyTable.add(cacheEntry._templates[n], object);
        }
    }

    private void removeInvalidationInfo(CacheEntry cacheEntry) {
        int n;
        Object object = cacheEntry.id;
        for (n = 0; n < cacheEntry._dataIds.length; ++n) {
            this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n], object);
        }
        for (n = 0; n < cacheEntry._templates.length; ++n) {
            this.templateDependencyTable.removeEntry(cacheEntry._templates[n], object);
        }
    }

    public boolean isValid(String string) {
        CacheEntry cacheEntry = this.getCacheEntry(string, false, true, null, false);
        if (cacheEntry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cache.isValid 1: cacheEntry == null");
            }
            return false;
        }
        if (cacheEntry.invalid) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cache.isValid 2: cacheEntry.invalid");
            }
            return false;
        }
        return !cacheEntry.removeWhenUnpinned;
    }

    public Object getValue(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl, boolean bl2) {
        CacheEntry cacheEntry;
        if (entryInfo == null) {
            return null;
        }
        Object object = entryInfo.getIdObject();
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if ((cacheEntry = this.getCacheEntry(object, bl, bl2, entryInfo.getTemplate(), true)) != null) {
            Object object2 = cacheEntry.getValue();
            cacheEntry.finish();
            return object2;
        }
        return null;
    }

    public Object invalidateAndSet(EntryInfo entryInfo, Object object, boolean bl) {
        CacheEntry cacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invalidateAndSet() idObject=" + entryInfo.getIdObject() + " coordinate=" + bl));
        }
        Object object2 = null;
        if (entryInfo == null) {
            return null;
        }
        Object object3 = entryInfo.getIdObject();
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(entryInfo.getTemplate(), 5);
        }
        if ((cacheEntry = this.getCacheEntry(object3, false, true, null, true)) != null) {
            object2 = cacheEntry.getValue();
            cacheEntry.finish();
        } else {
            object2 = null;
        }
        if (entryInfo.getSharingPolicy() == 4 || entryInfo.getSharingPolicy() == 3) {
            this.invalidateById(object3, true);
        }
        this.cacheStatisticsListener.setValue(entryInfo.getIdObject());
        if (!entryInfo.wasPrioritySet()) {
            entryInfo.setPriority(this.defaultPriority);
        }
        CacheEntry cacheEntry2 = this._syncSetValue(entryInfo, object);
        if (cacheEntry2.timeLimit > 0 || cacheEntry2.inactivity > 0) {
            this.timeLimitDaemon.valueHasChanged(this, cacheEntry2.id, cacheEntry2.expirationTime, cacheEntry2.inactivity);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invalidateAndSet() ei.isNotShared()=" + entryInfo.isNotShared()));
        }
        if (entryInfo.isNotShared()) {
            cacheEntry2.finish();
            return object2;
        }
        if (bl) {
            this.updatePeerCaches(cacheEntry2);
        } else {
            cacheEntry2.finish();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("invalidateAndSet() id=" + object3));
        }
        return object2;
    }

    public Object getValue(com.ibm.websphere.cache.EntryInfo entryInfo, boolean bl) {
        return this.getValue(entryInfo, bl, false);
    }

    public Object getValue(String string, boolean bl) {
        return this.getValue((Object)string, bl);
    }

    public Object getValue(Object object, boolean bl) {
        CacheEntry cacheEntry;
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onRequest(null, 5);
        }
        Object object2 = null;
        if (object != null && (cacheEntry = this.getCacheEntry(object, bl, false, null, true)) != null) {
            object2 = cacheEntry.getValue();
            cacheEntry.finish();
        }
        return object2;
    }

    public void invalidateById(String string, boolean bl) {
        this.invalidateById(string, 1, bl);
    }

    public void invalidateById(Object object, boolean bl) {
        this.invalidateById(object, 1, bl);
    }

    public void invalidateById(Object object, int n, boolean bl) {
        if (object != null) {
            this.batchUpdateDaemon.invalidateById(object, n, bl, this);
        }
    }

    public void invalidateById(Object object, int n, int n2, boolean bl, boolean bl2) {
        if (object != null) {
            this.batchUpdateDaemon.invalidateById(object, n, n2, bl, bl2, this);
        }
    }

    public void invalidateByTemplate(String string, boolean bl) {
        if (string != null) {
            this.batchUpdateDaemon.invalidateByTemplate(string, bl, this);
        }
    }

    protected void batchUpdate(HashMap hashMap, HashMap hashMap2, ArrayList arrayList) {
        Externalizable externalizable;
        Iterator<Object> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            externalizable = (InvalidateByIdEvent)iterator.next();
            if (!((InvalidateByIdEvent)externalizable).isInvokeInternalInvalidateById()) continue;
            this.internalInvalidateById(((InvalidateByIdEvent)externalizable).getId(), ((InvalidateByIdEvent)externalizable).causeOfInvalidation, ((InvalidateByIdEvent)externalizable).source, true);
        }
        iterator = hashMap2.values().iterator();
        while (iterator.hasNext()) {
            externalizable = (InvalidateByTemplateEvent)iterator.next();
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommand_Clear()) {
                this.clearLocal(((InvalidateByTemplateEvent)externalizable).source);
                continue;
            }
            if (((InvalidateByTemplateEvent)externalizable).isCacheCommand_InvalidateByTemplate()) {
                this.internalInvalidateByTemplate((InvalidateByTemplateEvent)externalizable);
                continue;
            }
            throw new IllegalStateException("Program check - cache command unknown.");
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            externalizable = (CacheEntry)iterator.next();
            this.setEntry((CacheEntry)externalizable, 2);
        }
    }

    public synchronized void internalInvalidateByTemplate(InvalidateByTemplateEvent invalidateByTemplateEvent) {
        long l = System.currentTimeMillis();
        String string = invalidateByTemplateEvent.getTemplate();
        int n = invalidateByTemplateEvent.source;
        if (!this.cacheConfig.disableTemplatesSupport) {
            ValueSet valueSet = this.templateDependencyTable.removeDependency(string);
            ValueSet valueSet2 = null;
            if (this.swapToDisk) {
                valueSet2 = this.diskCache.readTemplate(string, true);
            }
            if (valueSet == null && valueSet2 == null) {
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("internalInvalidateByTemplate: " + string));
            }
            int n2 = 0;
            int n3 = 0;
            if (valueSet != null) {
                n2 = valueSet.size();
                invalidateByTemplateEvent.addRemovedIds(valueSet);
            }
            if (valueSet2 != null) {
                n3 = valueSet2.size();
                invalidateByTemplateEvent.addRemovedIds(valueSet2);
            }
            if (n2 == 0 && n3 == 0) {
                return;
            }
            this.loopRemove(valueSet, 1, n, true);
            if (valueSet != null) {
                valueSet.clear();
                valueSet = null;
            }
            if (this.bEnableListener) {
                this.loopRemove(valueSet2, 1, n, true);
            } else if (valueSet2 != null) {
                int n4 = valueSet2.size();
                if (n4 > 0 && this.cachePerf.isPMIEnabled()) {
                    this.cachePerf.batchOnInvalidate(string, 1, 3, n, n4);
                }
                this.diskCache.delCacheEntry(valueSet2);
            }
            if (valueSet2 != null) {
                valueSet2.clear();
                valueSet2 = null;
            }
            String string2 = "internalInvalidateByTemplate: cacheName=" + this.cacheName + " template=" + string + " numOfMemoryEntries=" + n2 + " numOfDiskEntries=" + n3 + " cause=" + 1 + " source=" + n + " elapsed=" + (System.currentTimeMillis() - l) + " listenerEnabled=" + this.bEnableListener;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)string2);
            }
        }
    }

    protected synchronized void internalInvalidateById(Object object, int n, int n2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("Cache.internalInvalidateById: " + object));
        }
        long l = System.currentTimeMillis();
        this.remove(object, n, n2, bl, false);
        if (!this.cacheConfig.disableDependencyId) {
            ValueSet valueSet = this.dataDependencyTable.removeDependency(object);
            ValueSet valueSet2 = null;
            if (this.swapToDisk) {
                valueSet2 = this.diskCache.readDependency(object, true);
            }
            if (valueSet == null && valueSet2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("Cache.internalInvalidateById: " + object));
                }
                return;
            }
            int n3 = 0;
            int n4 = 0;
            if (valueSet != null) {
                n3 = valueSet.size();
            }
            if (valueSet2 != null) {
                n4 = valueSet2.size();
            }
            if (n3 == 0 && n4 == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("Cache.internalInvalidateById: " + object));
                }
                return;
            }
            this.loopRemove(valueSet, n, n2, bl);
            if (valueSet != null) {
                valueSet.clear();
                valueSet = null;
            }
            if (this.bEnableListener || this.cachePerf.isPMIEnabled()) {
                this.loopRemove(valueSet2, n, n2, bl);
            } else if (valueSet2 != null) {
                this.diskCache.delCacheEntry(valueSet2);
            }
            if (valueSet2 != null) {
                valueSet2.clear();
                valueSet2 = null;
            }
            String string = "internalInvalidateById: cacheName=" + this.cacheName + " dep-id=" + object + " numOfMemoryEntries=" + n3 + " numOfDiskEntries=" + n4 + " cause=" + n + " source=" + n2 + " elapsed=" + (System.currentTimeMillis() - l) + " listenerEnabled=" + this.bEnableListener + " PMIEnabled=" + this.cachePerf.isPMIEnabled();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Cache.internalInvalidateById: " + object));
        }
    }

    private void loopRemove(ValueSet valueSet, int n, int n2, boolean bl) {
        if (valueSet != null && !valueSet.isEmpty()) {
            Iterator iterator = valueSet.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.remove(e, n, n2, bl, true);
            }
        }
    }

    protected final void remove(Object object, int n, int n2) {
        this.remove(object, n, n2, true, false);
    }

    protected final synchronized void remove(Object object, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        if (object == null) {
            throw new NullPointerException("input parameter id is null.");
        }
        boolean bl3 = false;
        CacheEntry cacheEntry = (CacheEntry)this.entryHashtable.get(object);
        boolean bl4 = false;
        if (cacheEntry == null && this.swapToDisk) {
            if (!bl2) {
                cacheEntry = this.diskCache.readCacheEntry(object);
            } else {
                if (this.cachePerf.isPMIEnabled() || this.bEnableListener && bl && this.eventSource.getInvalidationListenerCount() > 0 && !this.ignoreValueInInvalidationEvent) {
                    cacheEntry = this.diskCache.readCacheEntry(object);
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    cacheEntry = this.cacheEntryPool.allocate();
                    cacheEntry.id = object;
                }
            }
            if (cacheEntry != null) {
                bl3 = true;
            }
        }
        if (cacheEntry != null) {
            this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
        }
        if (cacheEntry == null || cacheEntry.invalid || cacheEntry.removeWhenUnpinned) {
            return;
        }
        if (n == 2) {
            this.cacheStatisticsListener.lruRemove(object);
        } else {
            this.cacheStatisticsListener.remove(object);
        }
        if (this.cachePerf.isPMIEnabled() && n != -1) {
            if (bl3) {
                this.cachePerf.onInvalidate(cacheEntry.getTemplate(), n, 3, n2);
            } else {
                this.cachePerf.onInvalidate(cacheEntry.getTemplate(), n, 1, n2);
            }
        }
        cacheEntry.invalid = true;
        Object object2 = null;
        object2 = cacheEntry.serializedValue != null ? cacheEntry.serializedValue : (Object)cacheEntry.getValue();
        if (!bl3) {
            for (n3 = 0; n3 < cacheEntry._dataIds.length; ++n3) {
                this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n3], object);
            }
        }
        if (!bl3) {
            for (n3 = 0; n3 < cacheEntry._templates.length; ++n3) {
                this.templateDependencyTable.removeEntry(cacheEntry._templates[n3], object);
            }
        }
        if (!bl3) {
            this.entryHashtable.remove(cacheEntry.id);
            if (bl2 && n2 != 2 && (cacheEntry.sharingPolicy == 4 || cacheEntry.sharingPolicy == 3)) {
                this.invalidateById(object, n, n2, false, false);
            }
            if (cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry);
            }
            if (cacheEntry.refCount <= 0) {
                for (n3 = 0; n3 < cacheEntry.aliasList.length; ++n3) {
                    this.entryHashtable.remove(cacheEntry.aliasList[n3]);
                }
                cacheEntry.returnToPool();
            } else {
                cacheEntry.removeWhenUnpinned = true;
                cacheEntry.lruHead.remove(cacheEntry);
            }
        } else {
            this.diskCache.delCacheEntry(cacheEntry);
        }
        if (this.bEnableListener && bl && this.eventSource.getInvalidationListenerCount() > 0 && n > 0) {
            n3 = 1;
            if (n2 == 2) {
                n3 = 2;
            }
            if (this.ignoreValueInInvalidationEvent) {
                object2 = null;
            }
            InvalidationEvent invalidationEvent = new InvalidationEvent(object, object2, n, n3, this.cacheNameNonPrefixed);
            this.eventSource.fireEvent(invalidationEvent);
        }
        if (bl4) {
            cacheEntry.returnToPool();
        }
    }

    synchronized void clear(boolean bl) {
        this.batchUpdateDaemon.cacheCommand_Clear(bl, this);
    }

    private synchronized void clearLocal(int n) {
        int n2 = 1;
        if (this.swapToDisk) {
            this.diskCache.clearDiskCache();
        }
        boolean bl = this.swapToDisk;
        this.swapToDisk = false;
        Enumeration enumeration = this.entryHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.internalInvalidateById(e, n2, n, false);
        }
        if (this.bEnableListener) {
            int n3 = 1;
            if (n == 2) {
                n3 = 2;
            }
            InvalidationEvent invalidationEvent = new InvalidationEvent("*", null, 5, n3, this.cacheNameNonPrefixed);
            this.eventSource.fireEvent(invalidationEvent);
        }
        this.swapToDisk = bl;
    }

    public synchronized void clear() {
        boolean bl = true;
        this.clear(bl);
    }

    public synchronized Enumeration getAllIds() {
        return this.entryHashtable.keys();
    }

    public synchronized boolean containsKey(Object object) {
        return this.entryHashtable.contains(object);
    }

    public boolean containsKeyDisk(Object object) {
        if (this.swapToDisk) {
            return this.diskCache.containsKey(object);
        }
        return false;
    }

    public synchronized Collection getAllDependencyIds() {
        ArrayList arrayList = EMPTY_ARRAY_LIST;
        if (!this.cacheConfig.disableDependencyId) {
            Enumeration enumeration = this.dataDependencyTable.getKeys();
            arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return arrayList;
    }

    public synchronized Collection getCacheIdsByDependency(String string) {
        return this.getCacheIdsByDependency((Object)string);
    }

    public synchronized Collection getCacheIdsByDependency(Object object) {
        ValueSet valueSet;
        ArrayList arrayList = null;
        if (!this.cacheConfig.disableDependencyId && (valueSet = this.dataDependencyTable.getEntries(object)) != null) {
            arrayList = new ArrayList();
            arrayList.addAll(valueSet);
        }
        return arrayList;
    }

    public synchronized Collection getCacheIdsByTemplate(String string) {
        ValueSet valueSet;
        ArrayList arrayList = null;
        if (!this.cacheConfig.disableTemplatesSupport && (valueSet = this.templateDependencyTable.getEntries(string)) != null) {
            arrayList = new ArrayList();
            arrayList.addAll(valueSet);
        }
        return arrayList;
    }

    private synchronized CacheEntry getFreeLruEntry() {
        CacheEntry cacheEntry = null;
        if (this.getNumberCacheEntries() < this.cacheConfig.cacheSize) {
            cacheEntry = this.cacheEntryPool.allocate();
            return cacheEntry;
        }
        try {
            if (this.freeLruEntry()) {
                return this.getFreeLruEntry();
            }
            cacheEntry = this.cacheEntryPool.allocate();
            return cacheEntry;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.cache.Cache.getFreeLruEntry", "1181", this);
            throwable.printStackTrace();
            return null;
        }
    }

    protected synchronized void trimCache() {
        int n = this.getNumberCacheEntries() - this.cacheConfig.cacheSize;
        if (n > 0) {
            for (int i = 0; i < n && this.freeLruEntry(); ++i) {
            }
        }
    }

    protected synchronized boolean freeLruEntry() {
        CacheEntry cacheEntry = null;
        int n = (this.lruTop + this.lruBuckets.length - 1) % this.lruBuckets.length;
        while (cacheEntry == null && this.lruTop != n) {
            int n2;
            Object object;
            if (!this.lruBuckets[this.lruTop].isEmpty()) {
                Iterator iterator = this.lruBuckets[this.lruTop].iterator();
                while (iterator.hasNext()) {
                    cacheEntry = (CacheEntry)iterator.next();
                    if (cacheEntry.refCount != 0 || (object = cacheEntry.id) == null) continue;
                    n2 = 0;
                    if (this.swapToDisk && cacheEntry.persistToDisk) {
                        this.lruToDisk(cacheEntry);
                        n2 = 1;
                    }
                    if (n2 == 0) {
                        this.internalInvalidateById(object, 2, 5, true);
                        this.invalidateById(object, 2, 5, false, false);
                    }
                    return true;
                }
            }
            int n3 = (this.lruTop + 1) % this.lruBuckets.length;
            object = this.lruBuckets[this.lruTop];
            while (!((CacheEntry.LRUHead)object).isEmpty()) {
                CacheEntry cacheEntry2 = ((CacheEntry.LRUHead)object).removeFirst();
                cacheEntry2.lruHead = this.lruBuckets[n3];
                this.lruBuckets[n3].addFirst(cacheEntry2);
            }
            this.lruTop = n3;
            for (n2 = 0; n2 < this.lruBuckets.length; ++n2) {
                this.lruBuckets[(this.lruTop + n2) % this.lruBuckets.length].priority = n2;
            }
        }
        return false;
    }

    protected synchronized void lruToDisk(CacheEntry cacheEntry) {
        ValueSet valueSet;
        int n;
        if (cacheEntry.id == null) {
            return;
        }
        if (!cacheEntry.loadedFromDisk && !cacheEntry.prepareForSerialization()) {
            Object object = cacheEntry.id;
            this.internalInvalidateById(object, 2, 5, true);
            this.invalidateById(object, 2, 5, false, false);
            return;
        }
        this.cacheStatisticsListener.lruRemove(cacheEntry.id);
        this.timeLimitDaemon.valueWasRemoved(this, cacheEntry.id);
        if (cacheEntry.loadedFromDisk) {
            this.removeInvalidationInfo(cacheEntry);
        } else {
            this.diskCache.writeCacheEntry(cacheEntry);
            for (n = 0; n < cacheEntry._dataIds.length; ++n) {
                this.diskCache.writeDependencyEntry(cacheEntry._dataIds[n], cacheEntry.id);
                this.dataDependencyTable.removeEntry(cacheEntry._dataIds[n], cacheEntry.id);
            }
            for (n = 0; n < cacheEntry._templates.length; ++n) {
                this.diskCache.writeTemplateEntry(cacheEntry._templates[n], cacheEntry.id);
                this.templateDependencyTable.removeEntry(cacheEntry._templates[n], cacheEntry.id);
            }
        }
        this.entryHashtable.remove(cacheEntry.id);
        for (n = 0; n < cacheEntry.aliasList.length; ++n) {
            this.entryHashtable.remove(cacheEntry.aliasList[n]);
        }
        if (!this.cacheConfig.disableDependencyId && (valueSet = this.dataDependencyTable.removeDependency(cacheEntry.id)) != null && !cacheEntry.loadedFromDisk) {
            this.diskCache.writeDependency(cacheEntry.id, valueSet);
        }
        if (this.cachePerf.isPMIEnabled()) {
            this.cachePerf.onInvalidate(cacheEntry.getTemplate(), 2, 3, 5);
        }
        cacheEntry.returnToPool();
    }

    public synchronized void stop() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" Stopping cache: " + this.cacheName));
        }
        if (this.swapToDisk && !this.flushToDiskComplete) {
            this.flushToDisk();
        }
    }

    public synchronized void stopOnDebug() {
        if (this.swapToDisk) {
            this.flushToDisk();
        }
    }

    private void flushToDisk() {
        boolean bl = this.cacheConfig.flushToDiskOnStop;
        if (this.cacheName != null) {
            Object object;
            if (this.cacheName.equals(DEFAULT_CACHE_NAME) && (object = System.getProperty("com.ibm.ws.cache.flushToDiskOnStop")) != null && ((String)object).equalsIgnoreCase("true")) {
                bl = true;
            }
            if (bl) {
                Tr.info((TraceComponent)tc, (String)"DYNA0060I", (Object)new Object[]{this.cacheName});
                object = this.entryHashtable.elements();
                while (object.hasMoreElements()) {
                    CacheEntry cacheEntry = (CacheEntry)object.nextElement();
                    if (!cacheEntry.persistToDisk) continue;
                    this.lruToDisk(cacheEntry);
                }
                this.swapToDisk = false;
                this.diskCache.stop(false);
                this.diskCache.writeAuxiliaryDepTables();
                if (this.diskCache.isCleanupRunning()) {
                    this.doNotify = true;
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.doNotify = false;
                }
                this.diskCache.close();
            } else {
                Tr.info((TraceComponent)tc, (String)"DYNA0061I", (Object)new Object[]{this.cacheName});
                this.swapToDisk = false;
                this.diskCache.stop(true);
                this.diskCache.close();
                this.diskCache.deleteDiskCacheFiles();
            }
            this.flushToDiskComplete = true;
        }
    }

    public synchronized void restartDisk() {
        this.swapToDisk = true;
        this.diskCache.restart();
    }

    public synchronized int getMaxNumberCacheEntries() {
        return this.cacheConfig.cacheSize;
    }

    public synchronized int getNumberCacheEntries() {
        return this.entryHashtable.size();
    }

    public boolean shouldPull(int n, Object object) {
        return this.remoteServices.shouldPull(n, object);
    }

    public boolean getSwapToDisk() {
        return this.swapToDisk;
    }

    protected CacheEntry getEntryFromMemory(Object object) {
        return (CacheEntry)this.entryHashtable.get(object);
    }

    public void addAlias(Object object, Object[] objectArray, boolean bl, boolean bl2) {
        CacheEntry cacheEntry = this._syncAddAlias(object, objectArray, bl);
        if (cacheEntry == null) {
            throw new IllegalArgumentException("The cache id is not found in the cache's mapping table when adding alias");
        }
        cacheEntry.finish();
        if (cacheEntry.sharingPolicy != 1 && bl2) {
            AliasEntry aliasEntry = new AliasEntry(object, "AddAlias", cacheEntry.sharingPolicy, objectArray);
            if (!cacheEntry.isBatchEnabled()) {
                this.remoteServices.setEntry(aliasEntry);
            } else {
                this.batchUpdateDaemon.pushAliasEntry(aliasEntry, this);
            }
        }
    }

    private synchronized CacheEntry _syncAddAlias(Object object, Object[] objectArray, boolean bl) {
        CacheEntry cacheEntry = this.getCacheEntry(object, bl, true, null, true);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.loadedFromDisk) {
            this.diskCache.delCacheEntry(cacheEntry);
            cacheEntry.loadedFromDisk = false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" Add alias to EHT key=" + object + " alias=" + objectArray[i]));
            }
            cacheEntry.addAlias(objectArray[i]);
            this.entryHashtable.put(objectArray[i], cacheEntry);
        }
        return cacheEntry;
    }

    public void removeAlias(Object object, boolean bl, boolean bl2) {
        CacheEntry cacheEntry = this._syncRemoveAlias(object, bl);
        if (cacheEntry == null) {
            throw new IllegalArgumentException("The alias is not found in the cache's mapping table when removing alias");
        }
        cacheEntry.finish();
        if (cacheEntry.sharingPolicy == 1) {
            return;
        }
        if (cacheEntry != null && bl2) {
            AliasEntry aliasEntry = new AliasEntry(cacheEntry.getIdObject(), "RemoveAlias", cacheEntry.sharingPolicy, CacheEntry.EMPTY_OBJECT_ARRAY);
            aliasEntry.addAlias(object);
            if (!cacheEntry.isBatchEnabled()) {
                this.remoteServices.setEntry(aliasEntry);
            } else {
                this.batchUpdateDaemon.pushAliasEntry(aliasEntry, this);
            }
        }
    }

    private synchronized CacheEntry _syncRemoveAlias(Object object, boolean bl) {
        CacheEntry cacheEntry = this.getCacheEntry(object, bl, true, null, true);
        if (cacheEntry != null) {
            if (cacheEntry.loadedFromDisk) {
                this.diskCache.delCacheEntry(cacheEntry);
                cacheEntry.loadedFromDisk = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" Remove alias from EHT " + object));
            }
            cacheEntry.removeAlias(object);
            this.entryHashtable.remove(object);
        }
        return cacheEntry;
    }

    public synchronized Collection getIdsByRangeDisk(int n, int n2) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readCacheIdsByRange(n, n2);
        }
        return valueSet;
    }

    public synchronized Collection getDepIdsByRangeDisk(int n, int n2) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readDependencyByRange(n, n2);
        }
        return valueSet;
    }

    public synchronized Collection getTemplatesByRangeDisk(int n, int n2) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readTemplatesByRange(n, n2);
        }
        return valueSet;
    }

    public synchronized com.ibm.websphere.cache.CacheEntry getEntryDisk(Object object) {
        CacheEntry cacheEntry = null;
        if (this.swapToDisk) {
            cacheEntry = this.diskCache.readCacheEntry(object);
        }
        return cacheEntry;
    }

    public synchronized Collection getDepIdValueDisk(Object object) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readDependency(object, false);
        }
        return valueSet;
    }

    public synchronized Collection getTemplateValueDisk(String string) {
        ValueSet valueSet = null;
        if (this.swapToDisk) {
            valueSet = this.diskCache.readTemplate(string, false);
        }
        return valueSet;
    }

    public int getIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getCacheIdsSize();
        }
        return 0;
    }

    public int getDepIdsSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getDepIdsSize();
        }
        return 0;
    }

    public int getTemplatesSizeDisk() {
        if (this.swapToDisk) {
            return this.diskCache.getTemplatesSize();
        }
        return 0;
    }

    public synchronized void clearDisk() {
        if (this.swapToDisk) {
            this.diskCache.clearDiskCache();
        }
    }

    public synchronized boolean enableListener(boolean bl) {
        boolean bl2 = true;
        if (bl && this.eventSource == null) {
            bl2 = this.initEventSource();
        }
        this.bEnableListener = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("enableListener() enable=" + bl + " success=" + bl2 + " ignoreValueInInvalidationEvent=" + this.ignoreValueInInvalidationEvent));
        }
        return bl2;
    }

    public int getPushPullTableSize() {
        return this.remoteServices.getPushPullTableSize();
    }

    private boolean initEventSource() {
        boolean bl = true;
        if (this.cacheConfig.useListenerContext) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.cache.DCAsyncEventSource");
                this.eventSource = (EventSourceIntf)clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" Using listener's J2EE context for callback - cacheName= " + this.cacheName));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.cache.Cache.initEventSource", "1969", this);
                exception.printStackTrace();
                bl = false;
            }
            catch (Error error) {
                FFDCFilter.processException((Throwable)error, "com.ibm.ws.cache.Cache.initEventSource", "1973", this);
                error.printStackTrace();
                bl = false;
            }
        }
        if (this.eventSource == null) {
            this.eventSource = new DCEventSource();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using caller thread context for callback - cacheName= " + this.cacheName));
            }
        }
        return bl;
    }

    public synchronized boolean addInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.addListener(invalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removeInvalidationListener(InvalidationListener invalidationListener) {
        if (this.bEnableListener && invalidationListener != null) {
            this.eventSource.removeListener(invalidationListener);
            return true;
        }
        return false;
    }

    public synchronized boolean addChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.addListener(changeListener);
            return true;
        }
        return false;
    }

    public synchronized boolean removeChangeListener(ChangeListener changeListener) {
        if (this.bEnableListener && changeListener != null) {
            this.eventSource.removeListener(changeListener);
            return true;
        }
        return false;
    }

    public void refreshCachePerf() {
        if (this.lastCachePerf_maxNumberCacheEntries != (long)this.cacheConfig.cacheSize || this.lastCachePerf_entryHashtableSize != (long)this.entryHashtable.size()) {
            this.cachePerf.updateCacheSizes((long)this.cacheConfig.cacheSize, (long)this.entryHashtable.size());
            this.lastCachePerf_maxNumberCacheEntries = this.cacheConfig.cacheSize;
            this.lastCachePerf_entryHashtableSize = this.entryHashtable.size();
        }
    }

    private void createCachePerf() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("createCachePerf() cacheName=" + this.cacheName));
            }
            if (!$assertionsDisabled && this.cachePerf != null) {
                throw new AssertionError();
            }
            String string = null;
            string = this.cacheConfig.enableServletSupport ? "cacheModule.servlet" : "cacheModule.object";
            if (StatsFactory.isPMIEnabled()) {
                try {
                    this.cachePerf = new CacheStatsModule(string, this.cacheName);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.cache.Cache", "2116", this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("createCachePerf() Exception while creating PMI cacheModule: " + ExceptionUtility.getStackTrace(throwable)));
                }
            }
        }
        if (this.cachePerf == null) {
            this.cachePerf = NullCachePerfModule.getInstance();
        }
        this.refreshCachePerf();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createCachePerf() " + (this.cacheConfig.enableServletSupport ? "Servlet" : "Object") + " CachePerf for " + this.cacheName + " created. cachePerf=" + this.cachePerf));
        }
    }

    private void updatePeerCaches(CacheEntry cacheEntry) {
        if (!$assertionsDisabled && cacheEntry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cacheEntry.getSharingPolicy() == 1) {
            throw new AssertionError();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatePeerCaches() Entry cacheName=" + this.cacheName + " isBatchEnabled=" + cacheEntry.isBatchEnabled() + " isDRSReady=" + this.remoteServices.isDRSReady() + " id=" + cacheEntry.id + " refCount=" + cacheEntry.refCount));
        }
        if (this.remoteServices.isDRSReady() && !this.isDRSDisabled()) {
            if (!cacheEntry.isBatchEnabled()) {
                this.remoteServices.setEntry(cacheEntry);
                cacheEntry.finish();
            } else {
                this.batchUpdateDaemon.pushCacheEntry(cacheEntry, this);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updatePeerCaches() DRS is not ready!! - CE will be sent during bootstrap CE=" + cacheEntry));
            }
            cacheEntry.finish();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatePeerCaches() Exit cacheName=" + this.cacheName + " id=" + cacheEntry.id + " refCount=" + cacheEntry.refCount));
        }
    }

    public boolean shouldFilterTimeOutInvalidation(int n) {
        boolean bl = false;
        if (n == 3 && this.cacheConfig.filterTimeOutInvalidation) {
            bl = true;
        }
        return bl;
    }

    public void setDRSDisabled(boolean bl) {
        this.drsDisabled = bl;
    }

    public boolean isDRSDisabled() {
        return this.drsDisabled;
    }

    public void setDRSBootstrap(boolean bl) {
        this.drsBootstrap = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDRSBootstrap  drsBootstrap=" + bl));
        }
    }

    public boolean isDRSBootstrapEnabled() {
        return this.drsBootstrap;
    }

    static {
        $assertionsDisabled = !Cache.class.desiredAssertionStatus();
        tc = Trace.register(Cache.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
        assertRanOnce = false;
        EMPTY_ARRAY_LIST = new ArrayList();
    }
}

