/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.ejb.runtime;

import com.ibm.ivj.ejb.runtime.AccessBeanNullValue;
import java.util.Enumeration;
import java.util.Hashtable;

public class AccessBeanHashtable
extends Hashtable {
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999";
    static final long serialVersionUID = 3206093459760846163L;

    public AccessBeanHashtable() {
    }

    public AccessBeanHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public AccessBeanHashtable(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public synchronized Object get(Object aKey) {
        Object aValue = super.get(aKey);
        if (aValue == null) {
            return null;
        }
        if (aValue instanceof AccessBeanNullValue) {
            return null;
        }
        return aValue;
    }

    private String getNewLine() {
        return System.getProperties().getProperty("line.separator");
    }

    public synchronized Object put(Object aKey, Object value) {
        if (value == null) {
            return super.put(aKey, AccessBeanNullValue.singleton());
        }
        return super.put(aKey, value);
    }

    public synchronized String toString() {
        if (this.size() - 1 < 100) {
            return this.toStringForSmallTable();
        }
        return this.toStringForLargeTable();
    }

    private String toStringForLargeTable() {
        String s2;
        String s1;
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= 30) {
            s1 = k.nextElement().toString();
            s2 = e.nextElement().toString();
            buf.append(String.valueOf(s1) + "=" + s2);
            if (i < max) {
                buf.append(this.getNewLine());
            }
            ++i;
        }
        buf.append("......etc......");
        buf.append(this.getNewLine());
        i = max - 30;
        while (i <= max) {
            s1 = k.nextElement().toString();
            s2 = e.nextElement().toString();
            buf.append(String.valueOf(s1) + "=" + s2);
            if (i < max) {
                buf.append(this.getNewLine());
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    private String toStringForSmallTable() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= max) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(String.valueOf(s1) + "=" + s2);
            if (i < max) {
                buf.append(this.getNewLine());
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

