/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.ejb.runtime;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class AbstractAccessBean
implements Serializable {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 3.0(C) Copyright IBM Corp. 1997, 1999 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DEFAULT_NAMESERVICE_TYPE = "com.ibm.websphere.naming.WsnInitialContextFactory";
    public static final String DEFAULT_NAMESERVICE_PROVIDER_URL = "iiop:///";
    private static final String NAMESERVICE_TYPE_PROPERTY = "java.naming.factory.initial";
    private static final String NAMESERVICE_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    private static final String NAMESERVICE_PROVIDER_URL_PROPERTY_SPECIAL = "java.naming.provider.serverside.accessbean.url";
    protected transient EJBObject ejbRef;
    private static transient InitialContext initContext;
    private static transient ClassLoader initCtxLoader;
    private static transient String globalNameServiceURL;
    private static transient String globalNameServiceType;
    private static transient Map globalHome;
    private String init_jndiName;
    private String init_nameServiceURLName;
    private String init_nameServiceTypeName;
    private transient Object myHome;
    private static transient String currentNameServiceURL;
    private static transient String currentNameServiceType;
    private static transient boolean UseNoInitContextPropsAsDefault;
    public static final String DEFAULT_INSTANCENAME = "";
    private static final String INSTANCENAME_PROPERTY = "com.ibm.ivj.ejb.runtime.instancename";
    private String init_InstanceName;
    static final long serialVersionUID = 3206093459760846163L;

    static {
        globalNameServiceURL = null;
        globalNameServiceType = null;
        globalHome = null;
        UseNoInitContextPropsAsDefault = false;
    }

    public AbstractAccessBean() {
        String initNameSvcType = System.getProperty(NAMESERVICE_TYPE_PROPERTY);
        String initNameProviderUrlSpecial = System.getProperty(NAMESERVICE_PROVIDER_URL_PROPERTY_SPECIAL);
        String initNameProviderUrl = System.getProperty(NAMESERVICE_PROVIDER_URL_PROPERTY);
        String initInstanceName = System.getProperty(INSTANCENAME_PROPERTY);
        if (initNameSvcType != null) {
            this.setInit_NameServiceTypeName(initNameSvcType);
        }
        if (initNameProviderUrl != null) {
            this.setInit_NameServiceURLName(initNameProviderUrl);
        }
        if (initNameProviderUrlSpecial != null) {
            this.setInit_NameServiceURLName(initNameProviderUrlSpecial);
        }
        if (initInstanceName != null) {
            this.setInit_InstanceName(initInstanceName);
        }
    }

    public AbstractAccessBean(EJBObject aEJB) {
        this();
        this.ejbRef = aEJB;
    }

    private void _instantiate() throws CreateException, FinderException, RemoteException, NamingException {
        this.instantiateEJB();
    }

    protected abstract String defaultJNDIName();

    protected String defaultNameServiceType() {
        return DEFAULT_NAMESERVICE_TYPE;
    }

    protected String defaultNameServiceURL() {
        return DEFAULT_NAMESERVICE_PROVIDER_URL;
    }

    public EJBObject getEJBRef() throws CreateException, FinderException, RemoteException, NamingException {
        if (this.ejbRef == null) {
            this._instantiate();
        }
        return this.ejbRef;
    }

    public static synchronized Object getGlobalHome(String nameServiceURL, String nameServiceType, String jndiName) throws NamingException {
        if (jndiName == null) {
            return null;
        }
        StringBuffer key = new StringBuffer();
        String initInstanceName = System.getProperty(INSTANCENAME_PROPERTY);
        if (jndiName != null) {
            if (initInstanceName != null) {
                key.append(initInstanceName).append(jndiName);
            } else {
                key.append(jndiName);
            }
        }
        String instanceJndiName = key.toString();
        if (globalHome == null) {
            globalHome = new HashMap();
        }
        key.append(nameServiceURL).append(nameServiceType);
        String globalKey = key.toString();
        ClassLoader currentLoader = AbstractAccessBean.getCurrentClassLoader();
        Object home = AbstractAccessBean.getOrFlushCachedHome(globalKey, currentLoader);
        if (home == null) {
            home = AbstractAccessBean.lookupAndCacheHome(instanceJndiName, nameServiceURL, nameServiceType, globalKey, currentLoader);
        }
        return home;
    }

    private static Object lookupAndCacheHome(String jndiName, String nameServiceURL, String nameServiceType, String globalKey, ClassLoader currentLoader) throws NamingException {
        AbstractAccessBean.getInitContext(nameServiceURL, nameServiceType);
        Object home = null;
        if (initContext != null) {
            home = initContext.lookup(jndiName);
        }
        if (home != null) {
            globalHome.put(globalKey, new Object[]{home, currentLoader});
        }
        return home;
    }

    private static Object getOrFlushCachedHome(String globalKey, ClassLoader currentLoader) {
        if (globalKey == null) {
            return null;
        }
        Object[] cachedInfo = (Object[])globalHome.get(globalKey);
        if (cachedInfo != null) {
            if (!currentLoader.equals(cachedInfo[1])) {
                globalHome.remove(globalKey);
            } else {
                return cachedInfo[0];
            }
        }
        return null;
    }

    public synchronized Object getHome() throws NamingException {
        if (this.myHome == null) {
            Object aHomeObject;
            this.myHome = aHomeObject = AbstractAccessBean.getGlobalHome(this.getInit_NameServiceURLName(), this.getInit_NameServiceTypeName(), this.getInit_JNDIName());
        }
        return this.myHome;
    }

    public static final synchronized String getInit_GlobalNameServiceTypeName() {
        return globalNameServiceType;
    }

    public static final synchronized String getInit_GlobalNameServiceURLName() {
        return globalNameServiceURL;
    }

    public String getInit_JNDIName() {
        if (this.init_jndiName == null) {
            return this.defaultJNDIName();
        }
        return this.init_jndiName;
    }

    public String getInit_NameServiceTypeName() {
        if (this.init_nameServiceTypeName != null) {
            return this.init_nameServiceTypeName;
        }
        if (globalNameServiceType != null) {
            return globalNameServiceType;
        }
        if (UseNoInitContextPropsAsDefault) {
            return null;
        }
        return this.defaultNameServiceType();
    }

    public String getInit_NameServiceURLName() {
        if (this.init_nameServiceURLName != null) {
            return this.init_nameServiceURLName;
        }
        if (globalNameServiceURL != null) {
            return globalNameServiceURL;
        }
        if (UseNoInitContextPropsAsDefault) {
            return null;
        }
        return this.defaultNameServiceURL();
    }

    public static synchronized InitialContext getInitContext() throws NamingException {
        return AbstractAccessBean.getInitContext(DEFAULT_NAMESERVICE_PROVIDER_URL, DEFAULT_NAMESERVICE_TYPE);
    }

    public static synchronized InitialContext getInitContext(String nameServiceURL, String nameServiceType) throws NamingException {
        if (initContext == null || !AbstractAccessBean.compare(nameServiceURL, currentNameServiceURL) || !AbstractAccessBean.compare(nameServiceType, currentNameServiceType) || initCtxLoader != null && !initCtxLoader.equals(AbstractAccessBean.getCurrentClassLoader())) {
            currentNameServiceURL = nameServiceURL;
            currentNameServiceType = nameServiceType;
            Hashtable<String, String> environment = null;
            if (currentNameServiceURL != null && currentNameServiceType != null) {
                environment = new Hashtable<String, String>(2);
                environment.put(NAMESERVICE_PROVIDER_URL_PROPERTY, currentNameServiceURL);
                environment.put(NAMESERVICE_TYPE_PROPERTY, currentNameServiceType);
            }
            initContext = environment == null ? new InitialContext() : new InitialContext(environment);
            initCtxLoader = AbstractAccessBean.getCurrentClassLoader();
        }
        return initContext;
    }

    public static ClassLoader getCurrentClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static boolean compare(String nameServiceURL, String currentNameServiceURL) {
        if (nameServiceURL == null && currentNameServiceURL == null) {
            return true;
        }
        if (nameServiceURL != null) {
            return nameServiceURL.equals(currentNameServiceURL);
        }
        return false;
    }

    protected abstract void instantiateEJB() throws CreateException, FinderException, RemoteException, NamingException;

    public void resetEJBRef() {
        try {
            this.ejbRef = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetHomeCache() {
        globalHome = new Hashtable();
    }

    protected void setEJBRef(EJBObject aRef) {
        try {
            this.ejbRef = aRef;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final synchronized void setInit_GlobalNameServiceTypeName(String name) {
        globalNameServiceType = name;
    }

    public static final synchronized void setInit_GlobalNameServiceURLName(String name) {
        globalNameServiceURL = name;
    }

    public void setInit_JNDIName(String name) {
        this.init_jndiName = name;
    }

    public void setInit_NameServiceTypeName(String name) {
        this.init_nameServiceTypeName = name;
    }

    public void setInit_NameServiceURLName(String name) {
        this.init_nameServiceURLName = name == System.getProperty(NAMESERVICE_PROVIDER_URL_PROPERTY) && globalNameServiceURL != null ? globalNameServiceURL : name;
    }

    protected String defaultInstanceName() {
        return DEFAULT_INSTANCENAME;
    }

    public String getInit_InstanceName() {
        if (this.init_InstanceName != null) {
            return this.init_InstanceName;
        }
        return this.defaultInstanceName();
    }

    public void setInit_InstanceName(String name) {
        this.init_InstanceName = name;
    }

    public static void setUseNoPropertiesForInitialContextAsDefault(boolean aBoolean) {
        UseNoInitContextPropsAsDefault = aBoolean;
    }
}

