/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSConstants;

public class WSIFJMSProperties
extends HashMap {
    private static final long serialVersionUID = 1L;
    public static final String IN = "in";
    public static final String OUT = "out";
    private static final ArrayList allDirections = new ArrayList<Object>(Arrays.asList("in", "out"));
    public static final String CORRELATIONID = "JMSCorrelationID";
    public static final String DELIVERYMODE = "JMSDeliveryMode";
    public static final String DESTINATION = "JMSDestination";
    public static final String EXPIRATION = "JMSExpiration";
    public static final String MESSAGEID = "JMSMessageID";
    public static final String PRIORITY = "JMSPriority";
    public static final String REDELIVERED = "JMSRedelivered";
    public static final String REPLYTO = "JMSReplyTo";
    public static final String TIMESTAMP = "JMSTimestamp";
    public static final String TIMETOLIVE = "JMSTimeToLive";
    public static final String TYPE = "JMSType";
    public static final String QCF_USERID = "JMSUserid";
    public static final String QCF_PASSWORD = "JMSPassword";
    private static final ArrayList predefinedProps = new ArrayList<Object>(Arrays.asList("JMSCorrelationID", "JMSDeliveryMode", "JMSDestination", "JMSExpiration", "JMSPriority", "JMSRedelivered", "JMSReplyTo", "JMSTimestamp", "JMSTimeToLive", "JMSType"));
    private String direction;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public WSIFJMSProperties(String direction) throws WSIFException {
        Trc.entry((Object)this, direction);
        if (!allDirections.contains(direction)) {
            throw new WSIFException("Invalid direction " + direction);
        }
        this.direction = direction;
        Trc.exit(this.deep());
    }

    public WSIFJMSProperties(WSIFJMSProperties props) {
        super(props);
        Trc.entry((Object)this, props);
        this.direction = props.direction;
        Trc.exit(this.deep());
    }

    public boolean set(MessageProducer producer, Message message) throws WSIFException {
        Trc.entry(this, producer, message);
        boolean producerSet = false;
        if (producer != null && this.direction != IN) {
            throw new WSIFException("Only input properties can be set on a MessageProducer");
        }
        if (this.isEmpty()) {
            Trc.exit(false);
            return false;
        }
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            try {
                String prop = (String)it.next();
                Object value = this.get(prop);
                Class<?> type = value.getClass();
                if (predefinedProps.contains(prop)) {
                    try {
                        if (prop.equals(CORRELATIONID)) {
                            message.setJMSCorrelationID((String)value);
                            continue;
                        }
                        if (prop.equals(DELIVERYMODE)) {
                            message.setJMSDeliveryMode(((Integer)value).intValue());
                            if (producer == null) continue;
                            producer.setDeliveryMode(((Integer)value).intValue());
                            producerSet = true;
                            continue;
                        }
                        if (prop.equals(DESTINATION)) {
                            message.setJMSDestination((Destination)value);
                            continue;
                        }
                        if (prop.equals(EXPIRATION)) {
                            message.setJMSExpiration(((Long)value).longValue());
                            continue;
                        }
                        if (prop.equals(PRIORITY)) {
                            message.setJMSPriority(((Integer)value).intValue());
                            if (producer == null) continue;
                            producer.setPriority(((Integer)value).intValue());
                            producerSet = true;
                            continue;
                        }
                        if (prop.equals(REDELIVERED)) {
                            message.setJMSRedelivered(((Boolean)value).booleanValue());
                            continue;
                        }
                        if (prop.equals(REPLYTO)) {
                            message.setJMSReplyTo((Destination)value);
                            continue;
                        }
                        if (prop.equals(TIMESTAMP)) {
                            message.setJMSTimestamp(((Long)value).longValue());
                            continue;
                        }
                        if (prop.equals(TIMETOLIVE)) {
                            if (producer == null) continue;
                            producer.setTimeToLive(((Long)value).longValue());
                            producerSet = true;
                            continue;
                        }
                        if (!prop.equals(TYPE)) continue;
                        message.setJMSType((String)value);
                        continue;
                    }
                    catch (ClassCastException ce) {
                        Trc.exception(ce);
                        throw new WSIFException("Unexpected type " + type + " for JMS property " + prop + ".");
                    }
                }
                if (type.equals(class$java$lang$String == null ? WSIFJMSProperties.class$("java.lang.String") : class$java$lang$String)) {
                    message.setStringProperty(prop, value.toString());
                    continue;
                }
                if (type.equals(class$java$lang$Integer == null ? WSIFJMSProperties.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    message.setIntProperty(prop, ((Integer)value).intValue());
                    continue;
                }
                if (type.equals(class$java$lang$Boolean == null ? WSIFJMSProperties.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    message.setBooleanProperty(prop, ((Boolean)value).booleanValue());
                    continue;
                }
                if (type.equals(class$java$lang$Byte == null ? WSIFJMSProperties.class$("java.lang.Byte") : class$java$lang$Byte)) {
                    message.setByteProperty(prop, ((Byte)value).byteValue());
                    continue;
                }
                if (type.equals(class$java$lang$Double == null ? WSIFJMSProperties.class$("java.lang.Double") : class$java$lang$Double)) {
                    message.setDoubleProperty(prop, ((Double)value).doubleValue());
                    continue;
                }
                if (type.equals(class$java$lang$Float == null ? WSIFJMSProperties.class$("java.lang.Float") : class$java$lang$Float)) {
                    message.setFloatProperty(prop, ((Float)value).floatValue());
                    continue;
                }
                if (type.equals(class$java$lang$Long == null ? WSIFJMSProperties.class$("java.lang.Long") : class$java$lang$Long)) {
                    message.setLongProperty(prop, ((Long)value).longValue());
                    continue;
                }
                if (type.equals(class$java$lang$Short == null ? WSIFJMSProperties.class$("java.lang.Short") : class$java$lang$Short)) {
                    message.setShortProperty(prop, ((Short)value).shortValue());
                    continue;
                }
                message.setObjectProperty(prop, value);
            }
            catch (JMSException je) {
                Trc.exception(je);
                throw WSIFJMSConstants.ToWsifException(je);
            }
        }
        Trc.exit(producerSet);
        return producerSet;
    }

    public void getPropertiesFromMessage(Message message) throws WSIFException {
        Trc.entry((Object)this, message);
        if (this.direction != OUT) {
            throw new WSIFException("Only output properties can be got from a message");
        }
        this.clear();
        try {
            this.put(CORRELATIONID, message.getJMSCorrelationID());
            this.put(DELIVERYMODE, new Integer(message.getJMSDeliveryMode()));
            this.put(DESTINATION, message.getJMSDestination());
            this.put(EXPIRATION, new Long(message.getJMSExpiration()));
            this.put(MESSAGEID, message.getJMSMessageID());
            this.put(PRIORITY, new Integer(message.getJMSPriority()));
            this.put(REDELIVERED, new Boolean(message.getJMSRedelivered()));
            this.put(REPLYTO, message.getJMSReplyTo());
            this.put(TIMESTAMP, new Long(message.getJMSTimestamp()));
            this.put(TYPE, message.getJMSType());
            Enumeration enumeration = message.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                this.put(name, message.getObjectProperty(name));
            }
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public void clear() {
        Trc.entry(this);
        super.clear();
        Trc.exit();
    }

    public Object get(Object o1) {
        Trc.entry((Object)this, o1);
        Object o2 = super.get(o1);
        Trc.exit(o2);
        return o2;
    }

    public Object put(Object o1, Object o2) {
        Trc.entry(this, o1, o2);
        Object o3 = super.put(o1, o2);
        Trc.exit(o3);
        return o3;
    }

    public void putAll(HashMap hm) {
        Trc.entry((Object)this, hm);
        super.putAll(hm);
        Trc.exit();
    }

    public String toString() {
        return "WSIFJMSProperties(" + this.size() + "," + this.hashCode() + ")";
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(super.toString() + "\n");
            buff = buff + "direction:" + (this.direction.equals(IN) ? IN : (this.direction.equals(OUT) ? OUT : "unknown"));
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
        return buff;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

