/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.jms.WSIFPort_Jms;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.wsdl.extensions.jms.JMSBinding;
import org.apache.wsif.wsdl.extensions.jms.JMSExtensionRegistry;

public class WSIFDynamicProvider_Jms
implements WSIFProvider {
    private static final String jms = "http://schemas.xmlsoap.org/wsdl/jms/";
    private static String[] bindings = new String[0];
    private static String[] addresses = new String[0];
    private static boolean setUpBindings = false;
    private static boolean setUpAddresses = false;

    public WSIFDynamicProvider_Jms() {
        Trc.entry(this);
        if (!setUpBindings) {
            this.setUpBindingNamespaceURIs();
        }
        if (!setUpAddresses) {
            this.setUpAddressNamespaceURIs();
        }
        WSIFServiceImpl.addExtensionRegistry(new JMSExtensionRegistry());
        Trc.exit();
    }

    public WSIFPort createDynamicWSIFPort(Definition def, Service service, Port port, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(this, def, service, port, typeMap);
        Binding binding = port.getBinding();
        List exs = binding.getExtensibilityElements();
        Iterator i = exs.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof JMSBinding)) continue;
            WSIFPort_Jms wp = new WSIFPort_Jms(def, port, typeMap);
            Trc.exit(wp);
            return wp;
        }
        Trc.exit();
        return null;
    }

    public String[] getBindingNamespaceURIs() {
        Trc.entry(this);
        Trc.exit(bindings);
        return bindings;
    }

    public String[] getAddressNamespaceURIs() {
        Trc.entry(this);
        Trc.exit(addresses);
        return addresses;
    }

    private void setUpBindingNamespaceURIs() {
        Class cls = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName("javax.jms.Queue", true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable ignored) {
                    Trc.ignoredException(ignored);
                    return null;
                }
            }
        });
        if (cls != null) {
            bindings = new String[]{jms};
        }
        setUpBindings = true;
    }

    private void setUpAddressNamespaceURIs() {
        Class cls = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName("javax.jms.Queue", true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable ignored) {
                    Trc.ignoredException(ignored);
                    return null;
                }
            }
        });
        if (cls != null) {
            addresses = new String[]{jms};
        }
        setUpAddresses = true;
    }
}

