/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Trc {
    public static final int LOG_LEVEL_TRACE = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_INFO = 2;
    public static final int LOG_LEVEL_WARN = 3;
    public static final int LOG_LEVEL_ERROR = 4;
    public static final int LOG_LEVEL_FATAL = 5;
    private static final String wsifPackageName = "org.apache.wsif";
    private static Log log = LogFactory.getLog((String)"org.apache.wsif.*");
    public static boolean ON = log.isDebugEnabled();
    private static int currentLogLevel = log.isTraceEnabled() ? 0 : (log.isDebugEnabled() ? 1 : (log.isInfoEnabled() ? 2 : (log.isWarnEnabled() ? 3 : (log.isErrorEnabled() ? 4 : 5))));
    private static Log traceLog = LogFactory.getLog((String)"org.apache.wsif.logging.*");
    private static boolean traceTrace = false;
    private static final String ENTRY = "ENTRY";
    private static final String EXIT = "EXIT ";
    private static final String EXCEPTION = "EXCEPTION";
    private static final String EVENT = "EVENT";

    private Trc() {
    }

    public static boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public static void entry(Object that) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, null);
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10, Object p11, Object p12, Object p13, Object p14, Object p15) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entryExpandWsdl(Object that, Object[] parms) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, ENTRY, true, parms);
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void entry(Object that, boolean b) {
        if (ON) {
            Trc.entry(that, new Boolean(b));
        }
    }

    public static void entry(Object that, int i) {
        if (ON) {
            Trc.entry(that, new Integer(i));
        }
    }

    public static void exit() {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EXIT, false, null);
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void exit(Object returnValue) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EXIT, false, new Object[]{returnValue});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void exit(boolean b) {
        if (ON) {
            Trc.exit(new Boolean(b));
        }
    }

    public static void exit(int i) {
        if (ON) {
            Trc.exit(new Integer(i));
        }
    }

    public static void exitExpandWsdl(Object returnValue) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EXIT, true, new Object[]{returnValue});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void exception(Throwable exception) {
        try {
            if (!ON) {
                return;
            }
            log.debug((Object)EXCEPTION, exception);
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void ignoredException(Throwable exception) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(null, EVENT, false, new Object[]{"Caught and handled throwable: " + exception.toString()});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void exceptionInTrace(Exception exception) {
        try {
            log.debug((Object)"****** Exception in WSIF trace statement ******", (Throwable)exception);
        }
        catch (Exception ignored) {}
    }

    public static void event(Object that, Object p1) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3, Object p4) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3, p4});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3, Object p4, Object p5) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3, p4, p5});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3, p4, p5, p6});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3, p4, p5, p6, p7});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static void event(Object that, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9, Object p10) {
        try {
            if (!ON) {
                return;
            }
            Trc.traceIt(that, EVENT, false, new Object[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10});
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
    }

    public static String brief(Definition d) {
        return !ON ? "" : Trc.brief(1, d);
    }

    public static String brief(int outputLevel, Definition d) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (d == null) {
                return "null";
            }
            if (d.getQName() == null) {
                return "UNNAMED," + Integer.toHexString(d.hashCode());
            }
            return d.getQName() + "," + Integer.toHexString(d.hashCode());
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(PortType pt) {
        return !ON ? "" : Trc.brief(1, pt);
    }

    public static String brief(int outputLevel, PortType pt) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (pt == null) {
                return "null";
            }
            if (pt.getQName() == null) {
                return "UNNAMED," + Integer.toHexString(pt.hashCode());
            }
            return pt.getQName() + "," + Integer.toHexString(pt.hashCode());
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(Service s) {
        return !ON ? "" : Trc.brief(1, s);
    }

    public static String brief(int outputLevel, Service s) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (s == null) {
                return "null";
            }
            if (s.getQName() == null) {
                return "UNNAMED," + Integer.toHexString(s.hashCode());
            }
            return s.getQName() + "," + Integer.toHexString(s.hashCode());
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(Port p) {
        return !ON ? "" : Trc.brief(1, p);
    }

    public static String brief(int outputLevel, Port p) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (p == null) {
                return "null";
            }
            if (p.getName() == null) {
                return "UNNAMED," + Integer.toHexString(p.hashCode());
            }
            return p.getName() + "," + Integer.toHexString(p.hashCode());
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(BindingOperation bo) {
        return !ON ? "" : Trc.brief(1, bo);
    }

    public static String brief(int outputLevel, BindingOperation bo) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (bo == null) {
                return "null";
            }
            if (bo.getName() == null) {
                return "UNNAMED," + Integer.toHexString(bo.hashCode());
            }
            return bo.getName() + "," + Integer.toHexString(bo.hashCode());
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(Operation o) {
        return !ON ? "" : Trc.brief(1, o);
    }

    public static String brief(int outputLevel, Operation o) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (o == null) {
                return "null";
            }
            if (o.getName() == null) {
                return "UNNAMED," + Integer.toHexString(o.hashCode());
            }
            return o.getName() + "," + Integer.toHexString(o.hashCode());
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(String name, Collection coll) {
        return !ON ? "" : Trc.brief(1, name, coll);
    }

    public static String brief(int outputLevel, String name, Collection coll) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (coll == null) {
                return name + ":null";
            }
            if (coll.size() == 0) {
                return name + ":size(0)";
            }
            return Trc.brief(outputLevel, name, coll.toArray());
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(String name, Object[] objs) {
        return !ON ? "" : Trc.brief(1, name, objs);
    }

    public static String brief(int outputLevel, String name, Object[] objs) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (objs == null) {
                return name + ":null";
            }
            if (objs.length == 0) {
                return name + ":size(0)";
            }
            StringBuffer buff = new StringBuffer("");
            int i = 0;
            while (i < objs.length) {
                String s = objs[i] == null ? "null" : objs[i].toString();
                buff.append(" ");
                buff.append(name);
                buff.append("[");
                buff.append(i);
                buff.append("]:");
                buff.append(s);
                ++i;
            }
            return buff.toString();
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    public static String brief(Map map) {
        return !ON ? "" : Trc.brief(1, map);
    }

    public static String brief(int outputLevel, Map map) {
        try {
            if (currentLogLevel > outputLevel) {
                return "";
            }
            if (map == null) {
                return "<null>";
            }
            if (map.isEmpty()) {
                return "size(0)";
            }
            StringBuffer result = new StringBuffer("{");
            boolean first = true;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String n = (String)it.next();
                Object value = map.get(n);
                if (value == null) {
                    value = "<null>";
                }
                Object v2 = Trc.checkWsdl(value);
                if (!first) {
                    result.append(", ");
                }
                first = false;
                result.append(n);
                result.append("=");
                result.append(v2.toString());
            }
            result.append("}");
            return result.toString();
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
            return "";
        }
    }

    private static void checkWsdl(Object[] parms) {
        if (parms == null) {
            return;
        }
        int i = 0;
        while (i < parms.length) {
            parms[i] = Trc.checkWsdl(parms[i]);
            ++i;
        }
    }

    private static Object checkWsdl(Object o) {
        String str = null;
        boolean found = false;
        if (o instanceof Definition) {
            found = true;
            Definition d = (Definition)o;
            str = d == null ? "definition(NULL)" : (d.getQName() == null ? "definition(UNNAMED" : "definition(" + d.getQName());
        } else if (o instanceof Service) {
            found = true;
            Service s = (Service)o;
            str = s == null ? "service(NULL)" : (s.getQName() == null ? "service(UNNAMED" : "service(" + s.getQName());
        } else if (o instanceof Port) {
            found = true;
            Port p = (Port)o;
            str = p == null ? "port(NULL)" : (p.getName() == null ? "port(UNNAMED" : "port(" + p.getName());
        } else if (o instanceof PortType) {
            found = true;
            PortType pt = (PortType)o;
            str = pt == null ? "portType(NULL)" : (pt.getQName() == null ? "portType(UNNAMED" : "portType(" + pt.getQName());
        } else if (o instanceof Operation) {
            found = true;
            Operation op = (Operation)o;
            str = op == null ? "operation(NULL)" : (op.getName() == null ? "operation(UNNAMED" : "operation(" + op.getName());
        } else if (o instanceof Binding) {
            found = true;
            Binding b = (Binding)o;
            str = b == null ? "binding(NULL)" : (b.getQName() == null ? "binding(UNNAMED" : "binding(" + b.getQName());
        } else if (o instanceof BindingOperation) {
            found = true;
            BindingOperation bo = (BindingOperation)o;
            str = bo == null ? "bindingOperation(NULL)" : (bo.getName() == null ? "bindingOperation(UNNAMED" : "bindingOperation(" + bo.getName());
        } else if (o instanceof BindingInput) {
            found = true;
            BindingInput bi = (BindingInput)o;
            str = bi == null ? "bindingInput(NULL)" : (bi.getName() == null ? "bindingInput(UNNAMED" : "bindingInput(" + bi.getName());
        } else if (o instanceof BindingOutput) {
            found = true;
            BindingOutput bo = (BindingOutput)o;
            str = bo == null ? "bindingOutput(NULL)" : (bo.getName() == null ? "bindingOutput(UNNAMED" : "bindingOutput(" + bo.getName());
        } else if (o instanceof Map) {
            Map map = (Map)o;
            HashMap newMap = null;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object alt;
                Object value;
                Object key = it.next();
                if (key == null || (value = map.get(key)) == null || value.equals(alt = Trc.checkWsdl(value))) continue;
                if (newMap == null) {
                    newMap = new HashMap(map);
                }
                newMap.put(key, alt);
            }
            if (newMap != null) {
                return newMap;
            }
            return map;
        }
        if (!found) {
            return o;
        }
        if (o != null) {
            str = str + "," + Integer.toHexString(o.hashCode()) + ")";
        }
        return str;
    }

    private static void appendMethodName(StringBuffer buff) {
        Exception e = new Exception();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stack = sw.getBuffer().toString();
        if (traceTrace) {
            traceLog.debug((Object)("TRACE stack=" + stack));
        }
        String lineSeparator = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator", "\n");
            }
        });
        StringTokenizer st1 = new StringTokenizer(stack, lineSeparator);
        boolean foundWsifLogging = false;
        String tok1 = null;
        while (st1.hasMoreTokens()) {
            tok1 = st1.nextToken();
            if (tok1.indexOf("org.apache.wsif.logging") != -1) {
                foundWsifLogging = true;
                continue;
            }
            if (foundWsifLogging) break;
        }
        if (traceTrace) {
            traceLog.debug((Object)("TRACE token=" + tok1));
        }
        StringTokenizer st2 = new StringTokenizer(tok1);
        String tok2 = null;
        while (st2.hasMoreTokens()) {
            tok2 = st2.nextToken();
            if (tok2.indexOf("(") != -1) break;
        }
        if (tok2.indexOf("(") == -1) {
            tok2 = tok1;
        }
        buff.append(" ");
        while (st1.hasMoreTokens()) {
            if (st1.nextToken().indexOf(wsifPackageName) == -1) continue;
            buff.append(" ");
        }
        int idx = tok2.indexOf("(");
        if (idx != -1) {
            tok2 = tok2.substring(0, idx);
        }
        if (traceTrace) {
            traceLog.debug((Object)("TRACE token=" + tok2));
        }
        String result = null;
        if (tok2.startsWith(wsifPackageName)) {
            StringTokenizer st3 = new StringTokenizer(tok2, ".");
            String previous = null;
            while (st3.hasMoreTokens()) {
                previous = result;
                result = st3.nextToken();
            }
            if (previous != null) {
                result = previous + "." + result;
            }
        } else {
            result = tok2;
        }
        if (traceTrace) {
            traceLog.debug((Object)("TRACE appending result=" + result));
        }
        buff.append(result);
    }

    private static void traceIt(Object that, String type, boolean expandWsdl, Object[] parms) {
        boolean isEvent = false;
        if (EVENT.equals(type)) {
            isEvent = true;
        }
        if (!expandWsdl) {
            Trc.checkWsdl(parms);
        }
        StringBuffer sb = new StringBuffer(type);
        if (isEvent) {
            sb.append(" ");
        }
        Trc.appendMethodName(sb);
        if (that != null) {
            sb.append("<");
            sb.append(Integer.toHexString(that.hashCode()));
            sb.append(">");
        }
        if (isEvent) {
            sb.append(" ");
        } else {
            sb.append("(");
        }
        if (parms != null) {
            int i = 0;
            while (i < parms.length) {
                if (i != 0 && !isEvent) {
                    sb.append(", ");
                }
                sb.append(parms[i] == null ? "<null>" : parms[i].toString());
                ++i;
            }
        }
        if (!isEvent) {
            sb.append(")");
        }
        log.debug((Object)sb);
    }
}

