/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wsif.logging.Trc;

public class MessageLogger {
    private static Log log = LogFactory.getLog((String)"wsif");
    private static ResourceBundle messages = null;

    private MessageLogger() {
        Trc.entry(this);
        Trc.exit();
    }

    public static boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    public static boolean isWarnEnabled() {
        return log.isWarnEnabled();
    }

    public static boolean isErrorEnabled() {
        return log.isErrorEnabled();
    }

    public static boolean isFatalEnabled() {
        return log.isFatalEnabled();
    }

    public static void log(String key) {
        Trc.entry(null, key);
        try {
            MessageLogger.logIt(key.charAt(key.length() - 1), MessageLogger.getMessage(key));
        }
        catch (MissingResourceException mre) {
            Trc.exception(mre);
            MessageLogger.handleMissingResourceException(mre, key, null);
        }
        Trc.exit();
    }

    public static void log(String key, Object var) {
        Trc.entry(null, key, var);
        Object[] args = new String[]{var == null ? "<null>" : var.toString()};
        try {
            MessageLogger.logIt(key.charAt(key.length() - 1), MessageFormat.format(MessageLogger.getMessage(key), args));
        }
        catch (MissingResourceException mre) {
            Trc.exception(mre);
            MessageLogger.handleMissingResourceException(mre, key, (String[])args);
        }
        Trc.exit();
    }

    public static void log(String key, Object var1, Object var2) {
        Trc.entry(null, key, var1, var2);
        Object[] args = new String[]{var1 == null ? "<null>" : var1.toString(), var2 == null ? "<null>" : var2.toString()};
        try {
            MessageLogger.logIt(key.charAt(key.length() - 1), MessageFormat.format(MessageLogger.getMessage(key), args));
        }
        catch (MissingResourceException mre) {
            Trc.exception(mre);
            MessageLogger.handleMissingResourceException(mre, key, (String[])args);
        }
        Trc.exit();
    }

    public static void log(String key, Object[] vars) {
        Object[] args;
        Trc.entry(null, key, vars);
        if (vars == null) {
            args = new String[]{"<null>"};
        } else {
            args = new String[vars.length];
            int i = 0;
            while (i < vars.length) {
                args[i] = vars[i] == null ? "<null>" : vars[i].toString();
                ++i;
            }
        }
        try {
            MessageLogger.logIt(key.charAt(key.length() - 1), MessageFormat.format(MessageLogger.getMessage(key), args));
        }
        catch (MissingResourceException mre) {
            Trc.exception(mre);
            MessageLogger.handleMissingResourceException(mre, key, (String[])args);
        }
        Trc.exit();
    }

    private static String getMessage(String key) {
        if (messages == null) {
            messages = ResourceBundle.getBundle("org.apache.wsif.catalog.Messages");
        }
        return messages.getString(key);
    }

    private static void logIt(char severity, String text) {
        if (severity == 'I') {
            if (MessageLogger.isInfoEnabled()) {
                log.info((Object)text);
            }
        } else if (severity == 'W') {
            if (MessageLogger.isWarnEnabled()) {
                log.warn((Object)text);
            }
        } else if (severity == 'F') {
            if (MessageLogger.isFatalEnabled()) {
                log.fatal((Object)text);
            }
        } else if (MessageLogger.isErrorEnabled()) {
            log.error((Object)text);
        }
    }

    private static void handleMissingResourceException(MissingResourceException mre, String key, String[] args) {
        StringBuffer sb = new StringBuffer("WSIF: Unable to display message ");
        sb.append(key);
        if (args != null && args.length > 0) {
            sb.append(" with arguments ");
            int i = 0;
            while (i < args.length) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(args[i]);
                ++i;
            }
        }
        sb.append(" because WSIF MessageLogger caught ");
        sb.append(mre.toString());
        log.error((Object)sb.toString());
    }
}

