/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.schema.tools;

import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.File;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.tools.javac.Main;

public class Conventions {
    private static Hashtable postfixTable = Conventions.init();
    private static boolean verbose = true;

    private static Hashtable init() {
        Hashtable<String, String> postfixTable = new Hashtable<String, String>(11);
        postfixTable.put("simpleType", "");
        postfixTable.put("complexType", "");
        postfixTable.put("group", "_Group");
        postfixTable.put("attributeGroup", "_AttrGp");
        postfixTable.put("element", "");
        postfixTable.put("attribute", "_Attr");
        return postfixTable;
    }

    public static String namespaceURI2JavaPath(String namespaceURI) throws IllegalArgumentException {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Argument to 'namespaceURI2JavaPath' cannot be null.");
        }
        if (namespaceURI.startsWith("http://")) {
            namespaceURI = namespaceURI.substring(7);
        }
        if (namespaceURI.compareTo("") == 0) {
            return namespaceURI;
        }
        if (namespaceURI.endsWith("/")) {
            namespaceURI = namespaceURI.substring(0, namespaceURI.lastIndexOf("/"));
        }
        StringTokenizer tokens = new StringTokenizer(namespaceURI, "/", false);
        String javaPath = tokens.nextToken();
        while (tokens.hasMoreTokens()) {
            javaPath = tokens.nextToken() + "." + javaPath;
        }
        tokens = new StringTokenizer(javaPath, ".", false);
        javaPath = tokens.nextToken();
        while (tokens.hasMoreTokens()) {
            javaPath = tokens.nextToken() + "." + javaPath;
        }
        javaPath = javaPath.replace(':', '_');
        javaPath = javaPath.replace('-', '_');
        return javaPath;
    }

    public static String schema2JavaName(String schemaType, String schemaName, boolean isClass) throws IllegalArgumentException {
        if (schemaType == null) {
            throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
        }
        if (schemaType.compareTo("any") == 0) {
            return "any";
        }
        if (schemaType.compareTo("simpleType") == 0) {
            if (schemaName == null) {
                throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
            }
            schemaName = schemaName.replace('-', '_');
            return schemaName;
        }
        if (schemaType.compareTo("attribute") == 0) {
            if (schemaName == null) {
                throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
            }
            schemaName = schemaName.replace('-', '_');
            return schemaName + postfixTable.get("attribute");
        }
        if (schemaType.compareTo("anyAttribute") == 0) {
            return "anyAttribute";
        }
        if (schemaType.compareTo("all") == 0) {
            schemaName = "all";
        } else if (schemaType.compareTo("choice") == 0) {
            schemaName = "choice";
        } else if (schemaType.compareTo("sequence") == 0) {
            schemaName = "sequence";
        }
        if (schemaName == null) {
            throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
        }
        schemaName = schemaName.replace('-', '_');
        String postfix = (String)postfixTable.get(schemaType);
        if (postfix == null) {
            postfix = "";
        }
        String javaName = schemaName;
        if (isClass) {
            javaName = Character.toUpperCase(schemaName.charAt(0)) + schemaName.substring(1);
        }
        return javaName + postfix;
    }

    public static String schema2JavaName(Node node, String targetURI) {
        if (node == null || targetURI == null) {
            throw new IllegalArgumentException("Illegal arguments to 'schema2JavaName'.");
        }
        String targetNSPrefix = Conventions.namespaceURI2JavaPath(targetURI) + ".";
        String name = DOMUtils.getAttribute((Element)((Element)node), (String)"name");
        String type = node.getLocalName();
        if (name == null || type == null) {
            return null;
        }
        name = Conventions.schema2JavaName(type, name, true);
        return targetNSPrefix + name;
    }

    public static String schema2JavaName(NodeList nl, NodeList targetURI) {
        if (nl.getLength() == 0) {
            throw new IllegalArgumentException("No type name found for serializer class.");
        }
        Node node = nl.item(0);
        if (targetURI.getLength() == 0) {
            throw new IllegalArgumentException("No type name found for serializer class.");
        }
        Node tnode = targetURI.item(0);
        String targetNS = tnode.getNodeValue();
        return Conventions.schema2JavaName(node, targetNS);
    }

    public static String schema2NonQualifiedJavaName(NodeList nl, NodeList targetURI) {
        String fullname = Conventions.schema2JavaName(nl, targetURI);
        StringTokenizer st = new StringTokenizer(fullname, ".");
        String name = null;
        while (st.hasMoreTokens()) {
            name = st.nextToken();
        }
        return name;
    }

    public static String getJavaPathName(String targetDirectoryName, String packageName) {
        if (packageName != null && !packageName.equals("")) {
            targetDirectoryName = targetDirectoryName + File.separatorChar + packageName.replace('.', File.separatorChar);
        }
        return targetDirectoryName;
    }

    public static String getJavaFileName(NodeList nl, NodeList targetURI, String javaFileSuffix) {
        String javaFileName = Conventions.schema2NonQualifiedJavaName(nl, targetURI) + javaFileSuffix + ".java";
        return javaFileName;
    }

    public static boolean JDKcompile(String fileName, String workingDirectory) throws IllegalArgumentException {
        String classPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.class.path");
            }
        });
        if (workingDirectory != null && !workingDirectory.equals("")) {
            String pathSeparator = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("path.separator");
                }
            });
            classPath = classPath + pathSeparator + workingDirectory;
        }
        String[] args = new String[]{"-classpath", classPath, fileName};
        try {
            return new Main((OutputStream)System.err, "javac").compile(args);
        }
        catch (Throwable th) {
            System.err.println("Unable to load JDK compiler.");
            return false;
        }
    }

    public static void setVerbose(boolean ver) {
        verbose = ver;
    }

    public static boolean getVerbose() {
        return verbose;
    }
}

