/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

class WSIFObjectInputStream
extends ObjectInputStream {
    WSIFObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        super(in);
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(v.getName(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException xcpt) {
            String className = v.getName();
            if (className.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (className.equals("char")) {
                return Character.TYPE;
            }
            if (className.equals("byte")) {
                return Byte.TYPE;
            }
            if (className.equals("short")) {
                return Short.TYPE;
            }
            if (className.equals("int")) {
                return Integer.TYPE;
            }
            if (className.equals("long")) {
                return Long.TYPE;
            }
            if (className.equals("float")) {
                return Float.TYPE;
            }
            if (className.equals("double")) {
                return Double.TYPE;
            }
            throw xcpt;
        }
    }
}

