/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.WSIFUtils;

public class WSIFClientProxy
implements InvocationHandler {
    protected Class iface = null;
    protected Definition def = null;
    protected String serviceNS = null;
    protected String serviceName = null;
    protected String portTypeNS = null;
    protected String portTypeName = null;
    protected WSIFDynamicTypeMap typeMap = null;
    protected Map simpleTypeReg = null;
    protected PortType portType = null;
    protected WSIFPort wsifport = null;
    protected Object proxy = null;
    private Map wsdlOperationTable = null;
    static /* synthetic */ Class class$javax$activation$DataHandler;

    public static WSIFClientProxy newInstance(Class iface, Definition def, String serviceNS, String serviceName, String portTypeNS, String portTypeName, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(null, iface, def, serviceNS, serviceName, portTypeNS, portTypeName, typeMap);
        if (!iface.isInterface()) {
            throw new WSIFException("Cannot get a stub for " + iface + " because it is not an interface");
        }
        WSIFClientProxy clientProxy = new WSIFClientProxy(iface, def, serviceNS, serviceName, portTypeNS, portTypeName, typeMap);
        final Class ifaceFin = iface;
        ClassLoader ifaceClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ifaceFin.getClassLoader();
            }
        });
        Object proxy = Proxy.newProxyInstance(ifaceClassLoader, new Class[]{iface}, (InvocationHandler)clientProxy);
        clientProxy.setProxy(proxy);
        if (Trc.ON) {
            Trc.exit(clientProxy.deep());
        }
        return clientProxy;
    }

    private WSIFClientProxy(Class iface, Definition def, String serviceNS, String serviceName, String portTypeNS, String portTypeName, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(this, iface, def, serviceNS, serviceName, portTypeNS, portTypeName, typeMap);
        this.iface = iface;
        this.def = def;
        this.serviceNS = serviceNS;
        this.serviceName = serviceName;
        this.portTypeNS = portTypeNS;
        this.portTypeName = portTypeName;
        this.typeMap = typeMap;
        this.portType = WSIFUtils.selectPortType(def, portTypeNS, portTypeName);
        this.simpleTypeReg = WSIFUtils.getSimpleTypesMap();
        this.wsdlOperationTable = new HashMap();
        Trc.exit();
    }

    private void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void setPort(WSIFPort wsifport) {
        Trc.entry((Object)this, wsifport);
        this.wsifport = wsifport;
        Trc.exit();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List outputParts;
        List inputParts;
        Message m;
        Message m2;
        Trc.entry(this, method, args);
        Operation operation = this.findMatchingOperation(method, args);
        Input input = operation.getInput();
        Output output = operation.getOutput();
        String inputName = input == null ? null : input.getName();
        String outputName = output == null ? null : output.getName();
        Message inputMessage = input == null ? null : input.getMessage();
        Message outputMessage = output == null ? null : output.getMessage();
        WSIFOperation wsifOperation = this.wsifport.createOperation(method.getName(), inputName, outputName);
        String inputMsgName = "";
        if (input != null && (m2 = input.getMessage()) != null) {
            QName qn = m2.getQName();
            inputMsgName = qn == null ? "" : qn.getLocalPart();
        }
        String outputMsgName = "";
        if (output != null && (m = output.getMessage()) != null) {
            QName qn = m.getQName();
            outputMsgName = qn == null ? "" : qn.getLocalPart();
        }
        WSIFMessage wsifInputMessage = wsifOperation.createInputMessage(inputMsgName);
        WSIFMessage wsifOutputMessage = null;
        WSIFMessage wsifFaultMessage = null;
        if (output != null) {
            wsifOutputMessage = wsifOperation.createOutputMessage(inputMsgName);
            wsifFaultMessage = wsifOperation.createFaultMessage(inputMsgName);
        }
        boolean usingwrapped = false;
        List list = inputParts = inputMessage == null ? new ArrayList() : inputMessage.getOrderedParts(null);
        if (args != null) {
            usingwrapped = this.unWrapIfRequired(operation.getName(), inputParts, args);
            Iterator partIt = inputParts.iterator();
            int argIndex = 0;
            while (partIt.hasNext()) {
                Part part = (Part)partIt.next();
                String partName = part.getName();
                wsifInputMessage.setObjectPart(partName, args[argIndex]);
                ++argIndex;
            }
        }
        if (output == null) {
            wsifOperation.executeInputOnlyOperation(wsifInputMessage);
        } else {
            boolean success = wsifOperation.executeRequestResponseOperation(wsifInputMessage, wsifOutputMessage, wsifFaultMessage);
            if (!success) {
                Iterator it = wsifFaultMessage.getParts();
                if (it.hasNext()) {
                    Object fault = it.next();
                    if (fault instanceof Throwable) {
                        Class<?>[] exs = method.getExceptionTypes();
                        int e = 0;
                        while (e < exs.length) {
                            if (exs[e].isAssignableFrom(fault.getClass())) {
                                throw (Throwable)fault;
                            }
                            ++e;
                        }
                        throw new WSIFException("Operation failed, fault message contains a non-declared throwable", (Throwable)fault);
                    }
                    throw new WSIFException("Operation failed and a non-throwable fault message part was returned: " + fault);
                }
                throw new WSIFException("Operation failed but returned fault message contained no part");
            }
        }
        Object result = null;
        if (outputMessage != null && (outputParts = outputMessage.getOrderedParts(null)) != null && outputParts.size() > 0) {
            if (usingwrapped || this.isWrappedInContext()) {
                this.unwrap(operation.getName() + "Response", outputParts);
            }
            Iterator outPartIt = outputParts.iterator();
            Part returnPart = (Part)outPartIt.next();
            result = wsifOutputMessage.getObjectPart(returnPart.getName());
            if (outPartIt.hasNext()) {
                Object[] inPartArr = inputMessage.getOrderedParts(null).toArray();
                Part nextOutPart = (Part)outPartIt.next();
                int argIndex = 0;
                while (argIndex < args.length) {
                    if (((Part)inPartArr[argIndex]).getName().equals(nextOutPart.getName())) {
                        args[argIndex] = wsifOutputMessage.getObjectPart(nextOutPart.getName());
                        if (!outPartIt.hasNext()) break;
                        nextOutPart = (Part)outPartIt.next();
                    }
                    ++argIndex;
                }
            }
        }
        Trc.exit(result);
        return result;
    }

    private Operation findMatchingOperation(Method method, Object[] args) throws WSIFException {
        String key = this.createWSDLOperationKey(method, args);
        Operation previousOp = (Operation)this.wsdlOperationTable.get(key);
        if (previousOp != null) {
            return previousOp;
        }
        final Class ifaceFin = this.iface;
        Method[] allMethods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ifaceFin.getMethods();
            }
        });
        int i = 0;
        while (i < allMethods.length) {
            if (allMethods[i].equals(method)) break;
            ++i;
        }
        if (i >= allMethods.length || !method.equals(allMethods[i])) {
            throw new WSIFException("Method " + method.getName() + " is not in interface " + this.iface.getName());
        }
        String methodName = method.getName();
        Class<?>[] types = method.getParameterTypes();
        List opList = this.portType.getOperations();
        Iterator opIt = opList.iterator();
        Operation matchingOperation = null;
        while (opIt.hasNext()) {
            Operation operation = (Operation)opIt.next();
            if (!methodName.equalsIgnoreCase(operation.getName())) continue;
            Input input = operation.getInput();
            Message inputMessage = input == null ? null : input.getMessage();
            List inputParts = inputMessage == null ? new ArrayList() : inputMessage.getOrderedParts(null);
            int numInputParts = inputParts.size();
            if (numInputParts == 0 && types.length == 0) {
                this.wsdlOperationTable.put(key, operation);
                return operation;
            }
            if (this.isWrappedInContext() || types != null && numInputParts != types.length) {
                if (!ProviderUtils.isUnwrapable(operation)) continue;
                this.unWrapIfRequired(operation.getName(), inputParts, args);
                numInputParts = inputParts.size();
                if (numInputParts != types.length) continue;
            }
            Iterator partIt = inputParts.iterator();
            boolean foundAllArgs = true;
            boolean exactMatchAllArgs = true;
            int argIndex = 0;
            while (partIt.hasNext() && foundAllArgs) {
                Part part = (Part)partIt.next();
                QName partTypeName = part.getTypeName();
                if (partTypeName == null) {
                    partTypeName = part.getElementName();
                }
                QName partTypeNameWrapped = new QName(partTypeName.getNamespaceURI(), ">" + partTypeName.getLocalPart());
                boolean foundThisArg = false;
                boolean exactMatchThisArg = false;
                Iterator mapIt = this.typeMap.iterator();
                while (mapIt.hasNext() && !foundThisArg) {
                    WSIFDynamicTypeMapping mapping = (WSIFDynamicTypeMapping)mapIt.next();
                    if (!mapping.getXmlType().equals(partTypeName) && !mapping.getXmlType().equals(partTypeNameWrapped) || !mapping.getJavaType().isAssignableFrom(types[argIndex]) && (args[argIndex] == null || !mapping.getJavaType().isAssignableFrom(args[argIndex].getClass()))) continue;
                    foundThisArg = true;
                    if (!mapping.getJavaType().equals(types[argIndex]) && (args[argIndex] == null || !mapping.getJavaType().equals(args[argIndex].getClass()))) continue;
                    exactMatchThisArg = true;
                }
                String simpleType = (String)this.simpleTypeReg.get(partTypeName);
                if (!foundThisArg) {
                    if (simpleType != null) {
                        if (types[argIndex].toString().equals(simpleType)) {
                            foundThisArg = true;
                            exactMatchThisArg = true;
                        } else {
                            try {
                                Class<?> simpleClass = Class.forName(simpleType, true, Thread.currentThread().getContextClassLoader());
                                if (simpleClass.isAssignableFrom(types[argIndex])) {
                                    foundThisArg = true;
                                    if (simpleClass.equals(types[argIndex])) {
                                        exactMatchThisArg = true;
                                    }
                                }
                            }
                            catch (ClassNotFoundException ignored) {
                                Trc.ignoredException(ignored);
                            }
                        }
                    } else if (types[argIndex].equals(class$javax$activation$DataHandler == null ? WSIFClientProxy.class$("javax.activation.DataHandler") : class$javax$activation$DataHandler)) {
                        foundThisArg = true;
                    }
                }
                if (!foundThisArg) {
                    foundAllArgs = false;
                }
                if (!exactMatchThisArg) {
                    exactMatchAllArgs = false;
                }
                ++argIndex;
            }
            if (!foundAllArgs) continue;
            if (exactMatchAllArgs) {
                this.wsdlOperationTable.put(key, operation);
                return operation;
            }
            matchingOperation = operation;
        }
        if (matchingOperation != null) {
            this.wsdlOperationTable.put(key, matchingOperation);
            return matchingOperation;
        }
        String argString = new String();
        if (types != null) {
            i = 0;
            while (i < types.length) {
                if (i != 0) {
                    argString = argString + ", ";
                }
                argString = argString + types[i];
                ++i;
            }
        }
        throw new WSIFException("Method " + methodName + "(" + argString + ") was not found in portType " + this.portType.getQName());
    }

    private String createWSDLOperationKey(Method method, Object[] args) {
        Trc.entry(this, method, args);
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName()).append(":");
        Class<?>[] types = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            sb.append(types[i].getName()).append(":");
            ++i;
        }
        if (args != null) {
            int i2 = 0;
            while (i2 < args.length) {
                if (args[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(args[i2].getClass().getName());
                }
                sb.append(":");
                ++i2;
            }
        }
        Trc.exit(sb.toString());
        return sb.toString();
    }

    private String createWSIFOperationKey(String operationName, String inputName, String outputName) {
        Trc.entry(this, operationName, inputName, outputName);
        StringBuffer sb = new StringBuffer();
        sb.append(operationName).append(inputName).append(outputName);
        Trc.exit(sb.toString());
        return sb.toString();
    }

    protected boolean isUnwrapRequired() {
        boolean unwrapRequired = false;
        try {
            WSIFMessage ctx = this.wsifport.getContext();
            String style = (String)ctx.getObjectPart("org.apache.wsif.axis.operationStyle");
            unwrapRequired = "wrapped".equals(style);
        }
        catch (WSIFException e) {
            Trc.ignoredException(e);
        }
        return unwrapRequired;
    }

    private boolean unWrapIfRequired(String name, List parts, Object[] args) throws WSIFException {
        boolean unwrapped = false;
        boolean unwrap = this.isWrappedInContext();
        if (!unwrap) {
            boolean bl = unwrap = args.length != parts.size();
        }
        if (unwrap) {
            unwrapped = this.unwrap(name, parts);
        }
        return unwrapped;
    }

    private boolean unwrap(String name, List parts) throws WSIFException {
        boolean unwrapped = false;
        Part p = ProviderUtils.getWrapperPart(parts, name);
        if (p != null) {
            List unWrappedParts = ProviderUtils.unWrapPart(p, this.def, this.wsifport.getContext());
            parts.remove(p);
            parts.addAll(unWrappedParts);
            unwrapped = true;
        }
        return unwrapped;
    }

    private boolean isWrappedInContext() throws WSIFException {
        WSIFMessage context = this.wsifport.getContext();
        String style = null;
        try {
            style = (String)context.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException e) {
            Trc.ignoredException(e);
        }
        boolean wrappedInContext = "wrapped".equals(style);
        return wrappedInContext;
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(this.toString() + "\n");
            buff = buff + "iface: " + this.iface;
            buff = buff + " def: " + Trc.brief(this.def);
            buff = buff + " serviceNS: " + this.serviceNS;
            buff = buff + " serviceName: " + this.serviceName;
            buff = buff + " portTypeNS: " + this.portTypeNS;
            buff = buff + " portTypeName: " + this.portTypeName;
            buff = buff + " typeMap: " + this.typeMap;
            buff = buff + "\nsimpleTypeReg: " + this.simpleTypeReg;
            buff = buff + "\nportType: " + Trc.brief(this.portType);
            buff = buff + " wsifport: " + this.wsifport;
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
        return buff;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

