/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap.jrom;

import com.ibm.jrom.JROMComplexValue;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import com.ibm.jrom.convertors.JROM2XML;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.ConvertorUtils;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import com.ibm.ws.webservices.engine.encoding.ser.ComponentDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.DeserializerTarget;
import com.ibm.ws.webservices.engine.encoding.utils.Target;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wsif.logging.Trc;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JROMDeserializer
extends ComponentDeserializer {
    protected static Log log = LogFactory.getLog((String)(class$com$ibm$ws$webservices$wsif$providers$soap$jrom$JROMDeserializer == null ? (class$com$ibm$ws$webservices$wsif$providers$soap$jrom$JROMDeserializer = JROMDeserializer.class$("com.ibm.ws.webservices.wsif.providers.soap.jrom.JROMDeserializer")) : class$com$ibm$ws$webservices$wsif$providers$soap$jrom$JROMDeserializer).getName());
    private JROMFactory jromFactory;
    private SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
    private JROMType jType;
    private Deserializer simpleDeser;
    private TypeMapping simpleTypeSMR;
    private JROMComplexValue parent = null;
    private Map jrom2SchemaMap = JROM2XML.createDefaultTypeMap();
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsif$providers$soap$jrom$JROMDeserializer;
    static /* synthetic */ Class class$java$util$Calendar;

    private JROMDeserializer(JROMFactory factory, JROMComplexValue parent, Class javaType, QName xmlType) {
        super(javaType, xmlType);
        Trc.entry((Object)this, factory, parent, javaType, xmlType);
        if (factory == null) {
            try {
                this.jromFactory = (JROMFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws JROMException {
                        return JROMFactory.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                JROMException e = (JROMException)ex.getException();
                Trc.exception((Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage());
            }
        } else {
            this.jromFactory = factory;
        }
        this.parent = parent;
        Trc.exit();
    }

    public JROMDeserializer(JROMFactory factory, Class javaType, QName xmlType) {
        this(factory, null, javaType, xmlType);
    }

    public JROMDeserializer(Class javaType, QName xmlType) {
        this(null, javaType, xmlType);
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        Trc.entry((Object)this, namespace, localName, prefix, attributes, mappingScope, context);
        super.startElement(namespace, localName, prefix, attributes, mappingScope, context);
        if (AttributeUtils.isNil((Attributes)attributes)) {
            this.value = null;
            QName elementType = this.getElementDetails(namespace, localName, attributes, mappingScope, context);
            String namespaceType = elementType.getNamespaceURI();
            String localPartType = elementType.getLocalPart();
            if (this.jType == null) {
                this.jType = namespaceType.equals("http://www.w3.org/1999/XMLSchema") || namespaceType.equals("http://www.w3.org/2000/10/XMLSchema") || namespaceType.equals("http://www.w3.org/2001/XMLSchema") && localPartType.equals("duration") ? JROMType.JROM_DURATION_VALUE : JROMType.JROM_COMPLEX_VALUE;
            }
        }
        Trc.exit();
    }

    public void onStartElement(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        Trc.entry((Object)this, namespace, localPart, prefixedName, attributes, mappingScope, context);
        QName elementType = this.getElementDetails(namespace, localPart, attributes, mappingScope, context);
        String namespaceType = elementType.getNamespaceURI();
        String localPartType = elementType.getLocalPart();
        String arrayTypeString = Constants.getValue((Attributes)attributes, (String[])Constants.URIS_SOAP_ENC, (String)"arrayType");
        if (arrayTypeString != null) {
            QName defaultItemType = null;
            QName arrayTypeValue = null;
            if (arrayTypeString != null) {
                arrayTypeValue = QNameTable.createQName((String)arrayTypeString, (MappingScope)mappingScope);
            }
            if (arrayTypeValue != null) {
                String arrayTypeValueNamespaceURI = arrayTypeValue.getNamespaceURI();
                String arrayTypeValueLocalPart = arrayTypeValue.getLocalPart();
                int leftBracketIndex = arrayTypeValueLocalPart.lastIndexOf(91);
                int rightBracketIndex = arrayTypeValueLocalPart.lastIndexOf(93);
                if (leftBracketIndex == -1 || rightBracketIndex == -1 || rightBracketIndex < leftBracketIndex) {
                    throw new IllegalArgumentException("JROMDeserializer: Error: Malformed arrayType value '" + arrayTypeValue + "'");
                }
                defaultItemType = (arrayTypeValueLocalPart = arrayTypeValueLocalPart.substring(0, leftBracketIndex)).endsWith("]") ? Constants.SOAP_ARRAY : QNameTable.createQName((String)arrayTypeValueNamespaceURI, (String)arrayTypeValueLocalPart);
            }
            if (defaultItemType == null) {
                defaultItemType = Constants.XSD_ANYTYPE;
            }
            this.defaultType = defaultItemType;
        } else {
            this.defaultType = null;
        }
        if (this.jType != null && !this.jType.equals(JROMType.JROM_COMPLEX_VALUE)) {
            if (AttributeUtils.isNil((Attributes)attributes)) {
                return;
            }
            DeserializerFactory deserFac = (DeserializerFactory)this.simpleTypeSMR.getDeserializer(elementType);
            this.simpleDeser = (Deserializer)deserFac.getDeserializerAs("WebServices SAX Mechanism");
            this.simpleDeser.onStartElement(namespace, localPart, prefixedName, attributes, mappingScope, context);
        } else if (namespaceType.equals("http://www.w3.org/1999/XMLSchema") || namespaceType.equals("http://www.w3.org/2000/10/XMLSchema") || namespaceType.equals("http://www.w3.org/2001/XMLSchema") && localPartType.equals("duration")) {
            this.jType = JROMType.JROM_DURATION_VALUE;
        } else {
            this.jType = JROMType.JROM_COMPLEX_VALUE;
            this.value = this.jromFactory.newJROMComplexValue(namespaceType, localPartType, this.parent);
            ((JROMValue)this.value).setNameNamespace(namespace);
            ((JROMValue)this.value).setNameLocalPart(localPart);
            this.simpleDeser = null;
        }
        Trc.exit();
    }

    public void characters(String text) throws SAXException {
        Trc.entry((Object)this, text);
        if (this.simpleDeser == null) {
            if (this.jType.equals(JROMType.JROM_DURATION_VALUE)) {
                this.value = ConvertorUtils.stringToDuration((String)text);
            } else if (text.trim().length() > 0) {
                throw new SAXException("Cannot deserialize '" + this.value + "' into a JROM value");
            }
        } else {
            this.simpleDeser.characters(text);
        }
        Trc.exit();
    }

    public void onEndElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        Trc.entry((Object)this, namespace, localName, context);
        if (!this.jType.equals(JROMType.JROM_COMPLEX_VALUE)) {
            Object internalVal = null;
            if (this.simpleDeser != null) {
                this.simpleDeser.onEndElement(namespace, localName, context);
                internalVal = this.simpleDeser.getValue();
                if (internalVal != null) {
                    if (this.jType.equals(JROMType.JROM_DATE_VALUE)) {
                        Date time = null;
                        if (internalVal instanceof Date) {
                            time = (Date)internalVal;
                        } else if (internalVal instanceof Calendar) {
                            time = ((Calendar)internalVal).getTime();
                        }
                        if (time != null) {
                            internalVal = new GregorianCalendar();
                            ((GregorianCalendar)internalVal).setTime(time);
                        }
                    } else if (internalVal instanceof Calendar && this.jType.equals(JROMType.JROM_TIME_VALUE)) {
                        internalVal = ((Calendar)internalVal).getTime();
                    }
                    if (this.jType.equals(JROMType.JROM_DURATION_VALUE)) {
                        internalVal = this.value;
                    }
                }
                if (this.isFaultElement(namespace, localName)) {
                    this.value = internalVal;
                } else {
                    try {
                        this.value = ConvertorUtils.createSimpleJrom((JROMFactory)this.jromFactory, (JROMType)this.jType, (Object)internalVal, null, null, (JROMComplexValue)this.parent);
                    }
                    catch (Exception e) {
                        Trc.exception(e);
                        throw new SAXException(e);
                    }
                }
                this.jType = null;
                this.simpleDeser = null;
                this.parent = null;
            }
        } else {
            super.onEndElement(namespace, localName, context);
        }
        Trc.exit();
    }

    public DEventProcessor onStartChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        Trc.entry((Object)this, namespace, localPart, prefixedName, attributes, mappingScope, context);
        QName name = new QName(namespace, localPart);
        if (AttributeUtils.isNil((Attributes)attributes)) {
            JROMComplexValue val = null;
            JROMType bkpJType = this.jType;
            QName elementType = this.getElementDetails(namespace, localPart, attributes, mappingScope, context);
            if (!this.jType.equals(JROMType.JROM_COMPLEX_VALUE)) {
                val = ConvertorUtils.createSimpleJrom((JROMFactory)this.jromFactory, (JROMType)this.jType, null, (String)namespace, (String)localPart, (JROMComplexValue)this.parent);
            } else {
                val = this.jromFactory.newJROMComplexValue(elementType.getNamespaceURI(), elementType.getLocalPart(), this.parent);
                val.setNameNamespace(namespace);
                val.setNameLocalPart(localPart);
            }
            this.jType = bkpJType;
            this.setChildValue(val, name);
            NOOPProcessor p = new NOOPProcessor();
            Trc.exit(p);
            return p;
        }
        JROMDeserializer childDeser = new JROMDeserializer(this.jromFactory, (JROMComplexValue)this.value, this.javaType, this.xmlType);
        childDeser.registerValueTarget((Target)new DeserializerTarget((Deserializer)this, (Object)name));
        childDeser.setDefaultType(this.defaultType);
        Trc.exit((Object)childDeser);
        return childDeser;
    }

    public void setValue(Object internalValue, Object hint) {
        Trc.entry((Object)this, internalValue, hint);
        this.setChildValue(internalValue, hint);
        Trc.exit();
    }

    public void setChildValue(Object internalValue, Object hint) {
        Trc.entry((Object)this, internalValue, hint);
        if (internalValue != null) {
            JROMValue jv = (JROMValue)internalValue;
            jv.setNameNamespace(((QName)hint).getNamespaceURI());
            jv.setNameLocalPart(((QName)hint).getLocalPart());
            ((JROMComplexValue)this.value).addElementValue((JROMValue)internalValue);
        }
        Trc.exit();
    }

    private QName getElementDetails(String namespace, String localPart, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        Trc.entry((Object)this, namespace, localPart, attributes, mappingScope, context);
        Class javaClass = null;
        QName elementType = AttributeUtils.getTypeFromAttributes((String)namespace, (String)localPart, (Attributes)attributes, (MappingScope)mappingScope);
        QName guessElementType = null;
        if (elementType == null) {
            if (this.isFaultElement(namespace, localPart)) {
                elementType = localPart.equals("faultcode") ? new QName("http://www.w3.org/2001/XMLSchema", "QName") : new QName("http://www.w3.org/2001/XMLSchema", "string");
            } else if (this.defaultType != null) {
                elementType = this.defaultType;
            } else {
                guessElementType = new QName(namespace, localPart);
                javaClass = context.getTypeMapping().getClassForQName(guessElementType);
                if (javaClass == null) {
                    throw new SAXException("JROMSerializer: Cannot deserialize an element that does not have a type attributeand is not registered in type mappings");
                }
            }
        }
        if (this.simpleTypeSMR == null) {
            this.simpleTypeSMR = ((TypeMappingBase)context.getTypeMapping()).getDelegate();
        }
        if (elementType != null) {
            javaClass = this.simpleTypeSMR.getClassForQName(elementType);
        }
        if (javaClass != null) {
            this.jType = ConvertorUtils.getJROMType((Class)javaClass);
            if (this.jType.equals(JROMType.JROM_TIME_VALUE)) {
                this.jType = JROMType.JROM_DATE_VALUE;
            }
            if (javaClass == (class$java$util$Calendar == null ? (class$java$util$Calendar = JROMDeserializer.class$("java.util.Calendar")) : class$java$util$Calendar)) {
                this.jType = JROMType.JROM_TIME_VALUE;
            }
        }
        if (elementType == null) {
            elementType = this.jType != JROMType.JROM_COMPLEX_VALUE ? (QName)this.jrom2SchemaMap.get(this.jType) : guessElementType;
        }
        QName q = new QName(elementType.getNamespaceURI(), elementType.getLocalPart());
        Trc.exit(q);
        return q;
    }

    public boolean isFaultElement(String namespace, String localName) {
        Trc.entry((Object)this, namespace, localName);
        if (localName.equals("faultcode") || localName.equals("faultstring") || localName.equals("faultactor")) {
            Trc.exit(true);
            return true;
        }
        Trc.exit(false);
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

