/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.Transport;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSDestination;

public class WSIFJmsTransport
extends Transport {
    private WSIFJMSDestination destination = null;
    private String asyncOperation = "false";
    private WSIFOperation wsifOperation = null;
    private Long syncTimeout = null;
    private Long asyncTimeout = null;
    public static final String DESTINATION = "destination";
    public static final String ASYNCOPERATION = "asyncOperation";
    public static final String WSIFOPERATION = "wsifOperation";
    public static final String SYNC_TIMEOUT = "syncTimeout";
    public static final String ASYNC_TIMEOUT = "asyncTimeout";
    public static final String WSIF_TRANSPORT_NAME = "wsifjms";

    public WSIFJmsTransport(WSIFJMSDestination destination) throws WSIFException {
        if (destination == null) {
            throw new WSIFException("destination is null");
        }
        this.destination = destination;
    }

    public void setDestination(WSIFJMSDestination destination) {
        Trc.entry((Object)this, destination);
        this.destination = destination;
        Trc.exit();
    }

    public void setAsyncOperation(String asyncOperation) {
        Trc.entry((Object)this, asyncOperation);
        this.asyncOperation = asyncOperation;
        Trc.exit();
    }

    public void setWsifOperation(WSIFOperation wsifOperation) {
        Trc.entry((Object)this, wsifOperation);
        this.wsifOperation = wsifOperation;
        Trc.exit();
    }

    public void setSyncTimeout(Long syncTimeout) {
        Trc.entry((Object)this, syncTimeout);
        this.syncTimeout = syncTimeout;
        Trc.exit();
    }

    public void setAsyncTimeout(Long asyncTimeout) {
        Trc.entry((Object)this, asyncTimeout);
        this.asyncTimeout = asyncTimeout;
        Trc.exit();
    }

    public WSIFJMSDestination getDestination() {
        Trc.entry((Object)this);
        Trc.exit(this.destination);
        return this.destination;
    }

    public String getAsyncOperation() {
        Trc.entry((Object)this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public WSIFOperation getWsifOperation() {
        Trc.entry((Object)this);
        Trc.exit(this.wsifOperation);
        return this.wsifOperation;
    }

    public Long getSyncTimeout() {
        Trc.entry((Object)this);
        Trc.exit(this.syncTimeout);
        return this.syncTimeout;
    }

    public Long getAsyncTimeout() {
        Trc.entry((Object)this);
        Trc.exit(this.asyncTimeout);
        return this.asyncTimeout;
    }

    public synchronized void setupMessageContextImpl(MessageContext context, WebServicesEngine engine) throws WebServicesFault {
        Trc.entry((Object)this, context, engine);
        context.setTransportName(WSIF_TRANSPORT_NAME);
        if (this.destination != null) {
            context.setProperty(DESTINATION, (Object)this.destination);
        }
        context.setProperty(ASYNCOPERATION, (Object)new Boolean(this.asyncOperation));
        if (this.wsifOperation != null) {
            context.setProperty(WSIFOPERATION, (Object)this.wsifOperation);
        }
        if (this.syncTimeout != null) {
            context.setProperty(SYNC_TIMEOUT, (Object)this.syncTimeout);
        }
        if (this.asyncTimeout != null) {
            context.setProperty(ASYNC_TIMEOUT, (Object)this.asyncTimeout);
        }
        Trc.exit();
    }

    public WSIFJmsTransport copy() throws WSIFException {
        Trc.entry((Object)this);
        WSIFJmsTransport t = new WSIFJmsTransport(this.destination);
        t.setAsyncOperation(this.asyncOperation);
        t.setWsifOperation(this.wsifOperation);
        t.setSyncTimeout(this.syncTimeout);
        t.setAsyncTimeout(this.asyncTimeout);
        if (Trc.ON) {
            Trc.exit(t.deep());
        }
        return t;
    }

    public void close() throws WSIFException {
        Trc.entry((Object)this);
        if (this.destination == null) {
            throw new WSIFException("already closed");
        }
        this.destination.close();
        this.destination = null;
        Trc.exit();
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(super.toString() + ":\n");
            buff = buff + "destination:" + this.destination;
            buff = buff + "asyncOperation:" + this.asyncOperation;
            buff = buff + "wsifOperation:" + this.wsifOperation;
            buff = buff + "syncTimeout:" + this.syncTimeout;
            buff = buff + "asyncTimeout:" + this.asyncTimeout;
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
        return buff;
    }
}

