/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.cobol;

import com.ibm.ivj.eab.record.cobol.CobolRecordException;
import com.ibm.ivj.eab.record.cobol.CobolRecordResource;
import com.ibm.ivj.eab.record.cobol.CobolType;
import com.ibm.ivj.eab.record.cobol.CodePageConversionException;
import com.ibm.ivj.eab.record.cobol.DBCSConversionException;
import com.ibm.ivj.eab.record.cobol.DataAlignmentException;
import com.ibm.ivj.eab.record.cobol.NumericConversionException;
import com.ibm.ivj.eab.record.cobol.TypeConversionException;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.RecordConversionFailureException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CobolRecordAttributes
implements Serializable,
IRecordAttributes {
    private static String copyrights = "Licensed Material - Property of IBM IBM(R) VisualAge(TM) for Java(TM) Version 3.0 (C) Copyright IBM Corp. 1998, 1999 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = 1181483818730948754L;
    public static final int BIGENDIAN = 0;
    public static final int LITTLEENDIAN = 1;
    public static final int IBMFLOATINGPOINTFORMAT = 0;
    public static final int IEEEFLOATINGPOINTFORMAT = 1;
    public static final int MVS = 0;
    public static final int OS2 = 1;
    public static final int NT = 2;
    public static final int AIX = 3;
    public static final int MVSCUSTOM = 4;
    public static final int VACOBOL = 0;
    public static final int MFCOBOL = 1;
    public static final int VSCOBOL2 = 2;
    public static final int COMP = 0;
    public static final int COMP1 = 1;
    public static final int COMP2 = 2;
    public static final int COMP3 = 3;
    public static final int SIGN_LEADING = 4;
    public static final int SIGN_TRAILING = 5;
    public static final int SIGN_LEADING_SEPARATE = 6;
    public static final int SIGN_TRAILING_SEPARATE = 7;
    public static final int DISPLAY_NUMERIC = 8;
    public static final int DISPLAY_NONNUMERIC = 9;
    public static final int DISPLAY = 10;
    protected static final int JAVA_CHAR = 0;
    protected static final int JAVA_BOOLEAN = 1;
    protected static final int JAVA_BYTE = 2;
    protected static final int JAVA_SHORT = 3;
    protected static final int JAVA_INT = 4;
    protected static final int JAVA_LONG = 5;
    protected static final int JAVA_FLOAT = 6;
    protected static final int JAVA_DOUBLE = 7;
    protected static final int JAVA_STRING = 8;
    protected static final int JAVA_BIGDECIMAL = 9;
    private int remoteCobolEndian_;
    private int cobolMachine_;
    private int cobolCompiler_;
    private int remoteIntEndian_;
    private String codePage_;
    private int floatingPointFormat_;
    private byte POSOR;
    private byte NEGOR;
    private byte POSOR_MVSCUSTOM;
    private byte NEGOR_MVSCUSTOM;
    private byte PACKED_POSOR;
    private byte PACKED_NEGOR;
    private byte PACKED_NOSIGN;
    private byte ZERO_PAD;
    private byte ZERO_PAD_STR;
    private byte PLUS_SIGN_STR;
    private byte NEGATIVE_SIGN_STR;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG1 = false;
    private boolean insideDBCS = false;
    private byte fillByte = 0;
    private static final char DBCS_SPACE_CHAR = '\u3000';
    private int cobolDataType;
    private boolean sign;
    private boolean decimal;
    private boolean numeric;
    private int numberOfNines;
    private int decimalPosition;
    private int scale;
    private String expandedPicField;
    protected int picFieldLength;
    private StringBuffer comment;
    private boolean align;
    private boolean isTruncBin = true;
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_MANTISSA_MSB_MASK = 0x10000000000000L;
    private static final long DOUBLE_BIAS = 1022L;
    private static final int S390_DOUBLE_BIAS = 64;
    private static final long S390_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long S390_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int FLOAT_BIAS = 126;
    private static final int S390_FLOAT_BIAS = 64;
    private static final int S390_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int S390_FLOAT_MANTISSA_MASK = 0xFFFFFF;

    public CobolRecordAttributes() {
        this.scale = 0;
        this.numberOfNines = 0;
        this.numeric = true;
        this.decimal = false;
        this.decimalPosition = 0;
        this.expandedPicField = new String();
        this.picFieldLength = 0;
        this.comment = new StringBuffer();
        this.sign = false;
        this.cobolMachine_ = 2;
        this.cobolCompiler_ = 2;
        this.remoteCobolEndian_ = 1;
        this.remoteIntEndian_ = 1;
        this.floatingPointFormat_ = 1;
        this.NEGOR = (byte)112;
        this.POSOR = (byte)48;
        this.PACKED_NEGOR = (byte)13;
        this.PACKED_POSOR = (byte)12;
        this.PACKED_NOSIGN = (byte)15;
        this.ZERO_PAD = (byte)48;
        this.NEGATIVE_SIGN_STR = (byte)45;
        this.PLUS_SIGN_STR = (byte)43;
        this.ZERO_PAD_STR = (byte)48;
        this.codePage_ = new String("8859_1");
        try {
            String tmp = "-";
            this.NEGATIVE_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "+";
            this.PLUS_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "0";
            this.ZERO_PAD_STR = tmp.getBytes(this.codePage_)[0];
            tmp = " ";
            this.fillByte = tmp.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
    }

    public CobolRecordAttributes(String aCodePage, int aRemoteIntEndian) {
        if (aRemoteIntEndian != 0 && aRemoteIntEndian != 1) {
            throw new IllegalArgumentException();
        }
        try {
            byte[] byteArray = new byte[]{12, 34};
            new String(byteArray, aCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(CobolRecordResource.instance().getString("IVJC0224E", aCodePage));
        }
        this.floatingPointFormat_ = 0;
        this.scale = 0;
        this.numberOfNines = 0;
        this.numeric = true;
        this.decimal = false;
        this.decimalPosition = 0;
        this.expandedPicField = new String();
        this.picFieldLength = 0;
        this.comment = new StringBuffer();
        this.sign = false;
        this.remoteCobolEndian_ = 0;
        this.remoteIntEndian_ = aRemoteIntEndian;
        this.cobolMachine_ = 0;
        this.cobolCompiler_ = 2;
        if (this.cobolMachine_ == 1) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 0) {
            this.NEGOR = (byte)-48;
            this.POSOR = (byte)-64;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)-16;
        } else if (this.cobolMachine_ == 2) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        }
        this.codePage_ = aCodePage;
        try {
            String tmp = "-";
            this.NEGATIVE_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "+";
            this.PLUS_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "0";
            this.ZERO_PAD_STR = tmp.getBytes(this.codePage_)[0];
            tmp = " ";
            this.fillByte = tmp.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
    }

    public CobolRecordAttributes(String aCodePage, int aRemoteIntEndian, int aEndian, int aFloatingPointFormat, int aMachine, int aCompiler) {
        if (aRemoteIntEndian != 0 && aRemoteIntEndian != 1) {
            throw new IllegalArgumentException();
        }
        if (aEndian != 0 && aEndian != 1) {
            throw new IllegalArgumentException();
        }
        if (aFloatingPointFormat != 0 && aFloatingPointFormat != 1) {
            throw new IllegalArgumentException();
        }
        if (aMachine != 0 && aMachine != 1 && aMachine != 2 && aMachine != 3 && aMachine != 4) {
            throw new IllegalArgumentException();
        }
        try {
            byte[] byteArray = new byte[]{12, 34};
            new String(byteArray, aCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(CobolRecordResource.instance().getString("IVJC0224E", aCodePage));
        }
        this.scale = 0;
        this.numberOfNines = 0;
        this.numeric = true;
        this.decimal = false;
        this.decimalPosition = 0;
        this.expandedPicField = new String();
        this.picFieldLength = 0;
        this.comment = new StringBuffer();
        this.sign = false;
        this.remoteCobolEndian_ = aEndian;
        this.remoteIntEndian_ = aRemoteIntEndian;
        this.cobolMachine_ = aMachine;
        this.cobolCompiler_ = aCompiler;
        this.floatingPointFormat_ = aFloatingPointFormat;
        if (this.cobolMachine_ == 1) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 0) {
            this.NEGOR = (byte)-48;
            this.POSOR = (byte)-64;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)-16;
        } else if (this.cobolMachine_ == 2) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 4) {
            this.NEGOR = (byte)125;
            this.POSOR = (byte)123;
            this.NEGOR_MVSCUSTOM = (byte)73;
            this.POSOR_MVSCUSTOM = (byte)64;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        }
        this.codePage_ = aCodePage;
        try {
            String tmp = "-";
            this.NEGATIVE_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "+";
            this.PLUS_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "0";
            this.ZERO_PAD_STR = tmp.getBytes(this.codePage_)[0];
            tmp = " ";
            this.fillByte = tmp.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
    }

    private static int check_hyper(byte[] sb, int number_of_nines, boolean aSign) {
        char[] temp = new char[number_of_nines + 2];
        int rc = CobolRecordAttributes.xtr_int_2c_to_int_nts(sb, temp);
        if (rc != 0 || !aSign && temp[0] == '-') {
            return -1;
        }
        return 0;
    }

    public Object clone() {
        try {
            CobolRecordAttributes newAttr = (CobolRecordAttributes)super.clone();
            newAttr.codePage_ = new String(this.codePage_);
            newAttr.expandedPicField = new String(this.expandedPicField);
            newAttr.comment = new StringBuffer(this.comment.toString());
            return newAttr;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    protected final byte[] convertCobolToJava(int javaType, byte[] info) {
        byte[] javaBuffer;
        byte[] cobolBuffer;
        int cobolSize = this.sizeOfCobol();
        if (info.length == cobolSize) {
            cobolBuffer = info;
        } else {
            cobolBuffer = new byte[cobolSize];
            System.arraycopy(info, 0, cobolBuffer, 0, cobolSize);
        }
        int javaSize = CobolRecordAttributes.sizeOfJava(javaType, cobolSize, this.insideDBCS);
        switch (this.cobolDataType) {
            case 0: {
                double doubleVar;
                if (!this.decimal) {
                    if (this.remoteCobolEndian_ == 1 || this.remoteIntEndian_ == 1 && this.numberOfNines < 10) {
                        CobolRecordAttributes.endianSwapForce(cobolBuffer);
                    }
                    javaBuffer = new byte[javaSize];
                    if (this.sign) {
                        CobolRecordAttributes.xtr_int_2c_to_int_2c(cobolBuffer, javaBuffer);
                        break;
                    }
                    CobolRecordAttributes.convertToBinary(cobolBuffer, javaBuffer);
                    break;
                }
                if (this.remoteCobolEndian_ == 1 || this.remoteIntEndian_ == 1 && this.numberOfNines < 10) {
                    CobolRecordAttributes.endianswap(cobolBuffer, this.remoteCobolEndian_);
                }
                if (this.sign) {
                    doubleVar = CobolRecordAttributes.xtr_int_2c_to_real_double(cobolBuffer);
                } else {
                    byte[] tmp = new byte[8];
                    CobolRecordAttributes.convertToBinary(cobolBuffer, tmp);
                    BigInteger bi = new BigInteger(tmp);
                    doubleVar = bi.doubleValue();
                }
                javaBuffer = CobolRecordAttributes.convertToByte(Double.doubleToLongBits(doubleVar *= Math.pow(10.0, this.scale + this.decimalPosition)));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                char[] temp = new char[this.numberOfNines + 1];
                switch (this.cobolDataType) {
                    case 4: {
                        this.signLeadingToIntNts(cobolBuffer, temp);
                        break;
                    }
                    case 6: {
                        CobolRecordAttributes.signLeadingSeparateToIntNts(cobolBuffer, temp, this.PLUS_SIGN_STR);
                        break;
                    }
                    case 7: {
                        CobolRecordAttributes.signTrailingSeparateToIntNts(cobolBuffer, temp, this.PLUS_SIGN_STR);
                        break;
                    }
                    case 5: 
                    case 8: {
                        this.signTrailingToIntNts(cobolBuffer, temp);
                    }
                }
                if (!this.decimal) {
                    javaBuffer = new byte[javaSize];
                    CobolRecordAttributes.xtr_int_nts_to_int_2c(temp, javaBuffer);
                    break;
                }
                double d = 0.0;
                d = CobolRecordAttributes.xtr_int_nts_to_real_double(temp);
                javaBuffer = CobolRecordAttributes.convertToByte(Double.doubleToLongBits(d *= Math.pow(10.0, this.scale + this.decimalPosition)));
                break;
            }
            default: {
                return null;
            }
        }
        return javaBuffer;
    }

    protected final String convertFromByteArrayToString(byte[] recordBuffer) {
        int cobolSize = this.sizeOfCobol();
        byte[] cobolBuffer = new byte[cobolSize];
        System.arraycopy(recordBuffer, 0, cobolBuffer, 0, cobolSize);
        String javaString = null;
        try {
            if (this.insideDBCS) {
                String dbcsSpaceString = "\u3000";
                byte[] dbcsSpaceBytes = dbcsSpaceString.getBytes(this.codePage_);
                cobolBuffer = CobolRecordAttributes.fixInDBCS(cobolBuffer, cobolSize, this.fillByte, dbcsSpaceBytes);
            }
            javaString = new String(cobolBuffer, this.codePage_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
        if (this.insideDBCS) {
            char[] charArray = javaString.toCharArray();
            byte[] tb = new byte[CobolRecordAttributes.stringSize(charArray.length)];
            int j = 0;
            int i = 0;
            while (i < charArray.length) {
                tb[j] = (byte)(((short)charArray[i] & 0xFF00) >>> 8);
                tb[++j] = (byte)((short)charArray[i] & 0xFF);
                ++j;
                ++i;
            }
            j = 0;
            charArray = new char[tb.length / CobolRecordAttributes.stringSize(1)];
            i = 0;
            while (i < tb.length) {
                charArray[j] = (char)((char)tb[i] << 8 & 0xFF00 | (char)tb[++i] & 0xFF);
                if (charArray[j] == '\u0000') break;
                ++j;
                ++i;
            }
            javaString = new String(charArray, 0, j);
        }
        return javaString;
    }

    protected static char convertFromByteToChar(byte[] sb) {
        return (char)CobolRecordAttributes.convertFromByteToShort(sb);
    }

    protected final double convertFromByteToDouble(byte[] sb) {
        double d;
        if (1 == this.floatingPointFormat_) {
            CobolRecordAttributes.endianswap(sb, this.remoteCobolEndian_);
        }
        long doubleLongBits = CobolRecordAttributes.convertFromByteToLong(sb);
        if (this.floatingPointFormat_ == 0) {
            try {
                d = CobolRecordAttributes.longS390BitsToDouble(doubleLongBits);
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            d = Double.longBitsToDouble(doubleLongBits);
        }
        return d;
    }

    protected final float convertFromByteToFloat(byte[] sb) {
        float f;
        if (1 == this.floatingPointFormat_) {
            CobolRecordAttributes.endianswap(sb, this.remoteCobolEndian_);
        }
        int floatIntBits = CobolRecordAttributes.convertFromByteToInt(sb);
        if (this.floatingPointFormat_ == 0) {
            try {
                f = CobolRecordAttributes.intS390BitsToFloat(CobolRecordAttributes.convertFromByteToInt(sb));
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            f = Float.intBitsToFloat(floatIntBits);
        }
        return f;
    }

    protected static int convertFromByteToInt(byte[] sb) {
        int i = sb[0] << 24 >>> 0 | sb[1] << 24 >>> 8 | sb[2] << 24 >>> 16 | sb[3] << 24 >>> 24;
        return i;
    }

    protected static long convertFromByteToLong(byte[] sb) {
        long l = (long)sb[0] << 56 & 0xFF00000000000000L | (long)sb[1] << 48 & 0xFF000000000000L | (long)sb[2] << 40 & 0xFF0000000000L | (long)sb[3] << 32 & 0xFF00000000L | (long)sb[4] << 24 & 0xFF000000L | (long)sb[5] << 16 & 0xFF0000L | (long)sb[6] << 8 & 0xFF00L | (long)sb[7] & 0xFFL;
        return l;
    }

    protected static short convertFromByteToShort(byte[] sb) {
        int i = sb[0] << 24 >>> 16 | sb[1] << 24 >>> 24;
        return (short)i;
    }

    protected static String convertFromByteToString(byte[] sb, boolean isDBCS) {
        int j = 0;
        char[] charArray = new char[sb.length / CobolRecordAttributes.stringSize(1)];
        if (isDBCS) {
            int i = 0;
            while (i < sb.length) {
                charArray[j] = (char)((char)sb[i] << 8 & 0xFF00 | (char)sb[++i] & 0xFF);
                if (charArray[j] == '\u0000') break;
                ++j;
                ++i;
            }
            return new String(charArray, 0, j);
        }
        int i = 0;
        while (i < sb.length) {
            charArray[j] = (char)((char)sb[i] << 8 & 0xFF00 | (char)sb[++i] & 0xFF);
            ++j;
            ++i;
        }
        return new String(charArray);
    }

    protected final BigDecimal convertFromCobol(byte[] value) {
        BigDecimal bd;
        int javaType = CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal);
        switch (javaType) {
            case 7: {
                double d = this.convertFromByteToDouble(value);
                bd = new BigDecimal(d);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                byte[] buf = this.convertCobolToJava(5, value);
                long l = CobolRecordAttributes.convertFromByteToLong(buf);
                bd = new BigDecimal(Long.toString(l));
                break;
            }
            case 6: {
                float f = this.convertFromByteToFloat(value);
                bd = new BigDecimal(new Double(Float.toString(f)));
                break;
            }
            case 8: {
                bd = new BigDecimal(this.convertFromByteArrayToString(value).trim());
                break;
            }
            case 9: {
                if (this.cobolDataType == 0) {
                    if (this.remoteCobolEndian_ == 1 || this.remoteIntEndian_ == 1 && this.numberOfNines < 10) {
                        CobolRecordAttributes.endianswap(value, this.remoteCobolEndian_);
                    }
                    if (this.sign) {
                        double doubleVar = CobolRecordAttributes.xtr_int_2c_to_real_double(value);
                        bd = new BigDecimal(doubleVar);
                    } else {
                        byte[] tmp = new byte[8];
                        CobolRecordAttributes.convertToBinary(value, tmp);
                        BigInteger bi = new BigInteger(tmp);
                        bd = new BigDecimal(bi.toString());
                    }
                    bd = bd.movePointRight(this.scale + this.decimalPosition);
                    break;
                }
                char[] ctmp = new char[this.numberOfNines + 1];
                switch (this.cobolDataType) {
                    case 3: {
                        CobolRecordAttributes.packedDecimalToIntNts(value, ctmp, this.PACKED_NEGOR);
                        break;
                    }
                    case 4: {
                        this.signLeadingToIntNts(value, ctmp);
                        break;
                    }
                    case 6: {
                        CobolRecordAttributes.signLeadingSeparateToIntNts(value, ctmp, this.PLUS_SIGN_STR);
                        break;
                    }
                    case 7: {
                        CobolRecordAttributes.signTrailingSeparateToIntNts(value, ctmp, this.PLUS_SIGN_STR);
                        break;
                    }
                    case 5: 
                    case 8: {
                        this.signTrailingToIntNts(value, ctmp);
                    }
                }
                String tmp = new String(ctmp);
                if (tmp.startsWith("+")) {
                    tmp = tmp.substring(1);
                }
                bd = new BigDecimal(tmp);
                if (!this.decimal) break;
                bd = bd.movePointRight(this.scale + this.decimalPosition);
                break;
            }
            default: {
                bd = new BigDecimal("0");
            }
        }
        return bd;
    }

    protected final byte[] convertFromStringToByteArray(String str) {
        int paddingRequired;
        byte[] dbcsSpaceBytes;
        byte[] cobolBuffer;
        int cobolSize = this.sizeOfCobol();
        if (this.insideDBCS) {
            char[] charArray = str.toCharArray();
            byte[] tb = new byte[CobolRecordAttributes.stringSize(str.length())];
            int j = 0;
            int i = 0;
            while (i < charArray.length) {
                tb[j] = (byte)(((short)charArray[i] & 0xFF00) >>> 8);
                tb[++j] = (byte)((short)charArray[i] & 0xFF);
                ++j;
                ++i;
            }
            j = 0;
            charArray = new char[tb.length / CobolRecordAttributes.stringSize(1)];
            i = 0;
            while (i < tb.length) {
                charArray[j] = (char)((char)tb[i] << 8 & 0xFF00 | (char)tb[++i] & 0xFF);
                if (charArray[j] == '\u0000') break;
                ++j;
                ++i;
            }
            str = new String(charArray, 0, j);
        }
        String dbcsSpaceString = "\u3000";
        try {
            if (this.insideDBCS && (str = str.replace(' ', '\u3000')).length() < this.picFieldLength / 2) {
                int appendsize = this.picFieldLength / 2 - str.length();
                StringBuffer strbuf = new StringBuffer(str);
                int x = 0;
                while (x < appendsize) {
                    strbuf.append('\u3000');
                    ++x;
                }
                str = strbuf.toString();
            }
            cobolBuffer = str.getBytes(this.codePage_);
            dbcsSpaceBytes = dbcsSpaceString.getBytes(this.codePage_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
        }
        if (!this.insideDBCS && (paddingRequired = this.picFieldLength - cobolBuffer.length) > 0) {
            int span = 1;
            int offset = cobolBuffer.length;
            byte[] target = new byte[this.picFieldLength];
            System.arraycopy(cobolBuffer, 0, target, 0, offset);
            target[offset] = this.fillByte;
            while (span * 2 <= paddingRequired) {
                System.arraycopy(target, offset, target, offset + span, span);
                span *= 2;
            }
            System.arraycopy(target, offset, target, offset + span, paddingRequired - span);
            cobolBuffer = target;
        }
        if (cobolBuffer.length > this.picFieldLength && !this.insideDBCS) {
            throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0216E", str, this.expandedPicField));
        }
        if (this.insideDBCS && (cobolBuffer = CobolRecordAttributes.fixOutDBCS(cobolBuffer, cobolSize, this.fillByte, dbcsSpaceBytes)).length > this.picFieldLength) {
            throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0216E", str, this.expandedPicField));
        }
        return cobolBuffer;
    }

    protected final byte[] convertJavaToCobol(int javaType, byte[] javaBuffer, long value) {
        int cobolSize = this.sizeOfCobol();
        byte[] cobolBuffer = new byte[cobolSize];
        int javaSize = CobolRecordAttributes.sizeOfJava(javaType, this.picFieldLength, this.insideDBCS);
        block1 : switch (this.cobolDataType) {
            case 0: {
                if (!this.decimal) {
                    if (this.isTruncBin ? !CobolRecordAttributes.isValidBinaryDecimal(this.decimal, this.expandedPicField, this.numberOfNines, this.sign, this.decimalPosition, new BigDecimal(Long.toString(value))) : CobolRecordAttributes.check_hyper(javaBuffer, this.numberOfNines, this.sign) != 0) {
                        throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                    }
                    if (this.sign) {
                        CobolRecordAttributes.xtr_int_2c_to_int_2c(javaBuffer, cobolBuffer);
                    } else {
                        CobolRecordAttributes.convertToBinary(javaBuffer, cobolBuffer);
                    }
                    if (this.remoteCobolEndian_ != 1 && (this.remoteIntEndian_ != 1 || this.numberOfNines >= 10)) break;
                    CobolRecordAttributes.endianSwapForce(cobolBuffer);
                    break;
                }
                double doubleVar = 0.0;
                byte[] doubleByte = null;
                doubleVar = this.convertFromByteToDouble(javaBuffer);
                if (this.isTruncBin && !CobolRecordAttributes.isValidBinaryDecimal(this.decimal, this.expandedPicField, this.numberOfNines, this.sign, this.decimalPosition, new BigDecimal(doubleVar))) {
                    throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                }
                doubleByte = CobolRecordAttributes.convertToByte(Double.doubleToLongBits(doubleVar /= Math.pow(10.0, this.scale + this.decimalPosition)));
                int rc = 0;
                if (this.sign) {
                    rc = this.xtr_real_fp_to_int_2c(doubleByte, cobolBuffer);
                } else if (rc != 0) {
                    throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                }
                if (!this.isTruncBin) {
                    rc = CobolRecordAttributes.check_hyper(cobolBuffer, this.numberOfNines, this.sign);
                }
                if (rc != 0) {
                    throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                }
                if (this.remoteCobolEndian_ != 1 && (this.remoteIntEndian_ != 1 || this.numberOfNines >= 10)) break;
                CobolRecordAttributes.endianswap(cobolBuffer, this.remoteCobolEndian_);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                char[] charBuf = new char[this.numberOfNines + 1];
                if (!this.decimal) {
                    int rc = CobolRecordAttributes.xtr_int_2c_to_int_nts(javaBuffer, charBuf);
                    if (rc != 0) {
                        String error = javaSize == 2 ? CobolRecordResource.instance().getString("IVJC0213E", Short.toString(CobolRecordAttributes.convertFromByteToShort(javaBuffer))) : (javaSize == 4 ? CobolRecordResource.instance().getString("IVJC0213E", Integer.toString(CobolRecordAttributes.convertFromByteToInt(javaBuffer))) : CobolRecordResource.instance().getString("IVJC0213E", Long.toString(CobolRecordAttributes.convertFromByteToLong(javaBuffer))));
                        throw new NumericConversionException(error);
                    }
                } else {
                    double doubleVar = 0.0;
                    byte[] doubleByte = new byte[8];
                    CobolRecordAttributes.xtr_real_fp_to_real_fp(javaBuffer, doubleByte);
                    doubleVar = this.convertFromByteToDouble(doubleByte);
                    int rc = CobolRecordAttributes.xtr_real_fp_to_int_nts(doubleVar /= Math.pow(10.0, this.scale + this.decimalPosition), charBuf);
                    if (rc != 0) {
                        throw new NumericConversionException(CobolRecordResource.instance().getString("IVJC0214E", Double.toString(doubleVar)));
                    }
                }
                if (charBuf[0] == '-' && !this.sign) {
                    throw new NumericConversionException(CobolRecordResource.instance().getString("IVJC0215E"));
                }
                switch (this.cobolDataType) {
                    case 4: {
                        this.intNtsToSignLeading(charBuf, cobolBuffer, this.sign);
                        break block1;
                    }
                    case 5: 
                    case 8: {
                        this.intNtsToSignTrailing(charBuf, cobolBuffer, this.sign);
                        break block1;
                    }
                    case 6: {
                        this.intNtsToSignLeadingSeparate(charBuf, cobolBuffer);
                        break block1;
                    }
                    case 7: {
                        this.intNtsToSignTrailingSeparate(charBuf, cobolBuffer);
                    }
                }
            }
        }
        if (this.insideDBCS) {
            try {
                String dbcsSpaceString = "\u3000";
                byte[] dbcsSpaceBytes = dbcsSpaceString.getBytes(this.codePage_);
                cobolBuffer = CobolRecordAttributes.fixOutDBCS(cobolBuffer, cobolSize, this.fillByte, dbcsSpaceBytes);
                if (cobolBuffer.length > this.picFieldLength) {
                    throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0216E", CobolRecordAttributes.convertFromByteToString(javaBuffer, this.insideDBCS), this.expandedPicField));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
            }
        }
        return cobolBuffer;
    }

    private static void convertToBinary(byte[] sb, byte[] tb) {
        byte filler = 0;
        int i = tb.length - 1;
        while (i >= 0 && sb.length - (tb.length - i) >= 0) {
            tb[i] = sb[sb.length - (tb.length - i)];
            --i;
        }
        if (i >= 0) {
            while (i >= 0) {
                tb[i--] = filler;
            }
        }
    }

    protected static byte[] convertToByte(char sb) {
        byte[] tb = new byte[]{(byte)(((short)sb & 0xFF00) >>> 8), (byte)((short)sb & 0xFF)};
        return tb;
    }

    protected final byte[] convertToByte(double sb) {
        byte[] tb;
        if (this.floatingPointFormat_ == 0) {
            try {
                long doubleLongBits = CobolRecordAttributes.doubleToS390LongBits(sb);
                tb = CobolRecordAttributes.convertToByte(doubleLongBits);
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            long doubleLongBits = Double.doubleToLongBits(sb);
            tb = CobolRecordAttributes.convertToByte(doubleLongBits);
            CobolRecordAttributes.endianswap(tb, this.remoteCobolEndian_);
        }
        return tb;
    }

    protected final byte[] convertToByte(float sb) {
        byte[] tb;
        if (this.floatingPointFormat_ == 0) {
            try {
                int floatIntBits = CobolRecordAttributes.floatToS390IntBits(sb);
                tb = CobolRecordAttributes.convertToByte(floatIntBits);
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            int floatIntBits = Float.floatToIntBits(sb);
            tb = CobolRecordAttributes.convertToByte(floatIntBits);
            CobolRecordAttributes.endianswap(tb, this.remoteCobolEndian_);
        }
        return tb;
    }

    protected static byte[] convertToByte(int sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF000000) >>> 24), (byte)((sb & 0xFF0000) >>> 16), (byte)((sb & 0xFF00) >>> 8), (byte)(sb & 0xFF)};
        return tb;
    }

    protected static byte[] convertToByte(long sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00000000000000L) >>> 56), (byte)((sb & 0xFF000000000000L) >>> 48), (byte)((sb & 0xFF0000000000L) >>> 40), (byte)((sb & 0xFF00000000L) >>> 32), (byte)((sb & 0xFF000000L) >>> 24), (byte)((sb & 0xFF0000L) >>> 16), (byte)((sb & 0xFF00L) >>> 8), (byte)(sb & 0xFFL)};
        return tb;
    }

    protected static byte[] convertToByte(String sb) {
        char[] charArray = sb.toCharArray();
        byte[] tb = new byte[CobolRecordAttributes.stringSize(sb.length())];
        int j = 0;
        int i = 0;
        while (i < charArray.length) {
            tb[j] = (byte)(((short)sb.charAt(i) & 0xFF00) >>> 8);
            tb[++j] = (byte)((short)sb.charAt(i) & 0xFF);
            ++j;
            ++i;
        }
        return tb;
    }

    protected static byte[] convertToByte(short sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00) >>> 8), (byte)(sb & 0xFF)};
        return tb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final byte[] convertToCobol(BigDecimal value) {
        int javaType = CobolType.getJavaEquivalentCobolType(this.cobolDataType, this.numberOfNines, this.decimal);
        byte[] tb = new byte[1];
        byte[] buf = new byte[1];
        switch (javaType) {
            case 7: {
                double d = value.doubleValue();
                return this.convertToByte(d);
            }
            case 6: {
                float f = value.floatValue();
                return this.convertToByte(f);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (new BigDecimal("10").compareTo(value.movePointLeft(this.numberOfNines - 1).abs()) != 1) {
                    throw new TypeConversionException(CobolRecordResource.instance().getString("IVJC0226E", value.toString()));
                }
                long l = value.longValue();
                tb = CobolRecordAttributes.convertToByte(l);
                return this.convertJavaToCobol(5, tb, l);
            }
            case 9: {
                StringBuffer strBuf;
                if (this.decimal) {
                    if (this.cobolDataType == 0 && this.isTruncBin && !CobolRecordAttributes.isValidBinaryDecimal(this.decimal, this.expandedPicField, this.numberOfNines, this.sign, this.decimalPosition, value)) {
                        throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                    }
                    value = value.movePointLeft(this.scale + this.decimalPosition);
                }
                if (!(this.cobolDataType == 0 && this.isTruncBin || new BigDecimal("10").compareTo(value.movePointLeft(this.numberOfNines - 1).abs()) == 1)) {
                    throw new TypeConversionException(CobolRecordResource.instance().getString("IVJC0226E", value.movePointRight(this.scale + this.decimalPosition).toString()));
                }
                value = value.divide(new BigDecimal("1"), 0, 4);
                int cobolSize = this.sizeOfCobol();
                buf = new byte[cobolSize];
                String tmp = value.toString();
                if (!tmp.startsWith("+") && !tmp.startsWith("-")) {
                    strBuf = new StringBuffer(tmp);
                    strBuf.insert(0, "+");
                    tmp = strBuf.toString();
                }
                if (tmp.charAt(0) == '-' && !this.sign) {
                    throw new NumericConversionException(CobolRecordResource.instance().getString("IVJC0215E"));
                }
                int pos = tmp.length();
                int index = tmp.indexOf(".");
                if (index != -1) {
                    pos = index;
                }
                if (this.cobolDataType != 0 || !this.isTruncBin) {
                    if (this.numberOfNines + 1 >= pos) {
                        tmp = tmp.substring(0, pos);
                        strBuf = new StringBuffer(tmp);
                        int i = 0;
                        while (i < this.numberOfNines - pos + 1) {
                            strBuf.insert(1, "0");
                            ++i;
                        }
                        tmp = strBuf.toString();
                    } else {
                        tmp = String.valueOf(tmp.substring(0, 1)) + tmp.substring(pos - this.numberOfNines, pos);
                    }
                }
                switch (this.cobolDataType) {
                    case 0: {
                        int rc = 0;
                        if (this.sign) {
                            rc = CobolRecordAttributes.xtr_int_nts_to_int_2c(tmp.toCharArray(), buf);
                        } else if (tmp.charAt(0) == '+') {
                            CobolRecordAttributes.convertToBinary(new BigInteger(tmp.substring(1)).toByteArray(), buf);
                        } else {
                            CobolRecordAttributes.convertToBinary(new BigInteger(tmp).toByteArray(), buf);
                        }
                        if (rc != 0) {
                            throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                        }
                        if (this.remoteCobolEndian_ != 1 && (this.remoteIntEndian_ != 1 || this.numberOfNines >= 10)) break;
                        CobolRecordAttributes.endianswap(buf, this.remoteCobolEndian_);
                        break;
                    }
                    case 3: {
                        this.intNtsToPackedDecimal(tmp.toCharArray(), buf, this.sign);
                        break;
                    }
                    case 4: {
                        this.intNtsToSignLeading(tmp.toCharArray(), buf, this.sign);
                        break;
                    }
                    case 5: 
                    case 8: {
                        this.intNtsToSignTrailing(tmp.toCharArray(), buf, this.sign);
                        break;
                    }
                    case 6: {
                        this.intNtsToSignLeadingSeparate(tmp.toCharArray(), buf);
                        break;
                    }
                    case 7: {
                        this.intNtsToSignTrailingSeparate(tmp.toCharArray(), buf);
                    }
                }
                if (!this.insideDBCS) return buf;
                try {
                    String dbcsSpaceString = "\u3000";
                    byte[] dbcsSpaceBytes = dbcsSpaceString.getBytes(this.codePage_);
                    buf = CobolRecordAttributes.fixOutDBCS(buf, cobolSize, this.fillByte, dbcsSpaceBytes);
                    if (buf.length <= this.picFieldLength) return buf;
                    throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0216E", CobolRecordAttributes.convertFromByteToString(tb, this.insideDBCS), this.expandedPicField));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
                }
            }
            case 8: {
                String str = value.toString();
                if (!this.insideDBCS && str.length() > this.picFieldLength) {
                    throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(this.picFieldLength)));
                }
                if (!this.insideDBCS) return this.convertFromStringToByteArray(str);
                if (str.length() <= this.picFieldLength / 2) return this.convertFromStringToByteArray(str);
                throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0249E", Integer.toString(this.picFieldLength / 2)));
            }
        }
        return buf;
    }

    private static long doubleToS390LongBits(double ieeeDouble) throws IOException {
        long quotient;
        boolean positive;
        long ieeeLongBits = Double.doubleToLongBits(ieeeDouble);
        boolean bl = positive = (ieeeLongBits & Long.MIN_VALUE) == 0L;
        if ((ieeeLongBits & Long.MAX_VALUE) == 0L) {
            return ieeeLongBits;
        }
        long exponent = ieeeLongBits & 0x7FF0000000000000L;
        exponent >>>= 52;
        long mantissa = ieeeLongBits & 0xFFFFFFFFFFFFFL;
        long remainder = Math.abs(exponent -= 1022L) % 4L;
        long s390Exponent = quotient = Math.abs(exponent) / 4L;
        if (exponent > 0L && remainder != 0L) {
            ++s390Exponent;
        }
        if (exponent < 0L) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64L;
        long s390Mantissa = mantissa;
        s390Mantissa = exponent > -1022L ? (s390Mantissa |= 0x10000000000000L) : (s390Mantissa <<= 1);
        s390Mantissa <<= 3;
        if (remainder > 0L) {
            if (exponent > 0L) {
                int shift_places = (int)(4L - remainder);
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -1022L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                s390Mantissa >>>= (int)remainder;
            }
        }
        if (exponent == -1022L) {
            while (s390Mantissa != 0L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        if (s390Exponent > 127L) {
            throw new IOException("Number outside of range for double precision S/390 Float");
        }
        if (s390Exponent < 0L) {
            return 0L;
        }
        long s390Double = 0L;
        long s390ExponentBits = s390Exponent & 0x7FL;
        s390Double = s390ExponentBits << 56;
        if (!positive) {
            s390Double |= Long.MIN_VALUE;
        }
        return s390Double |= s390Mantissa;
    }

    private static void endianswap(byte[] buffer, int endian) {
        if (endian == 1) {
            int leftSide = 0;
            int rightSide = buffer.length - 1;
            while (leftSide < rightSide) {
                byte b = buffer[leftSide];
                buffer[leftSide] = buffer[rightSide];
                buffer[rightSide] = b;
                ++leftSide;
                --rightSide;
            }
        }
    }

    private static void endianSwapForce(byte[] buffer) {
        int leftSide = 0;
        int rightSide = buffer.length - 1;
        while (leftSide < rightSide) {
            byte b = buffer[leftSide];
            buffer[leftSide] = buffer[rightSide];
            buffer[rightSide] = b;
            ++leftSide;
            --rightSide;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CobolRecordAttributes)) {
            return false;
        }
        CobolRecordAttributes tmpCRA = (CobolRecordAttributes)obj;
        if (this.remoteCobolEndian_ != tmpCRA.remoteCobolEndian_ || this.remoteIntEndian_ != tmpCRA.remoteIntEndian_ || this.cobolMachine_ != tmpCRA.cobolMachine_ || this.cobolCompiler_ != tmpCRA.cobolCompiler_ || this.floatingPointFormat_ != tmpCRA.floatingPointFormat_ || !this.codePage_.equals(tmpCRA.codePage_)) {
            return false;
        }
        return this.insideDBCS == tmpCRA.insideDBCS && this.fillByte == tmpCRA.fillByte && this.cobolDataType == tmpCRA.cobolDataType && this.sign == tmpCRA.sign && this.decimal == tmpCRA.decimal && this.numeric == tmpCRA.numeric && this.numberOfNines == tmpCRA.numberOfNines && this.decimalPosition == tmpCRA.decimalPosition && this.scale == tmpCRA.scale && this.expandedPicField.equals(tmpCRA.expandedPicField) && this.picFieldLength == tmpCRA.picFieldLength && this.align == tmpCRA.align;
    }

    public final byte[] fillBytes(String fillChar) throws ArrayIndexOutOfBoundsException, CodePageConversionException {
        byte tmpFillByte;
        try {
            tmpFillByte = fillChar.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
        int span = 1;
        byte[] cobolBuffer = new byte[this.picFieldLength];
        cobolBuffer[0] = tmpFillByte;
        while (span * 2 <= this.picFieldLength) {
            System.arraycopy(cobolBuffer, 0, cobolBuffer, span, span);
            span *= 2;
        }
        System.arraycopy(cobolBuffer, 0, cobolBuffer, span, this.picFieldLength - span);
        return cobolBuffer;
    }

    private static byte[] fixInDBCS(byte[] cobolBuffer, int cobolSize, byte spaceChar, byte[] dbcsSpace) {
        byte[] returnCobol;
        if (spaceChar == 64) {
            returnCobol = new byte[cobolSize + 2];
            returnCobol[0] = 14;
            System.arraycopy(cobolBuffer, 0, returnCobol, 1, cobolSize);
            returnCobol[cobolSize + 1] = 15;
        } else {
            returnCobol = new byte[cobolBuffer.length];
            byte b1 = dbcsSpace[0];
            byte b2 = dbcsSpace[1];
            int i = 0;
            while (i < cobolBuffer.length) {
                if (cobolBuffer[i] == spaceChar && cobolBuffer[i + 1] == spaceChar) {
                    returnCobol[i] = b1;
                    returnCobol[i + 1] = b2;
                } else {
                    returnCobol[i] = cobolBuffer[i];
                    returnCobol[i + 1] = cobolBuffer[i + 1];
                }
                i += 2;
            }
        }
        return returnCobol;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] fixOutDBCS(byte[] cobolBuffer, int properCobolSize, byte spaceChar, byte[] dbcsSpace) {
        void var4_5;
        byte[] newCobolBuffer;
        int inputCobolSize = cobolBuffer.length;
        if (cobolBuffer[0] == 14) {
            if (inputCobolSize != properCobolSize + 2) {
                throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
            }
            newCobolBuffer = new byte[properCobolSize];
            System.arraycopy(cobolBuffer, 1, newCobolBuffer, 0, properCobolSize);
        } else if (properCobolSize == inputCobolSize) {
            newCobolBuffer = new byte[cobolBuffer.length];
            byte b1 = dbcsSpace[0];
            byte b2 = dbcsSpace[1];
            int i = 0;
            while (i < cobolBuffer.length) {
                if (cobolBuffer[i] == b1 && cobolBuffer[i + 1] == b2) {
                    newCobolBuffer[i] = spaceChar;
                    newCobolBuffer[i + 1] = spaceChar;
                } else {
                    newCobolBuffer[i] = cobolBuffer[i];
                    newCobolBuffer[i + 1] = cobolBuffer[i + 1];
                }
                i += 2;
            }
        } else {
            throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
        }
        return var4_5;
    }

    private static int floatToS390IntBits(float ieeeFloat) throws IOException {
        int quotient;
        boolean positive;
        int ieeeIntBits = Float.floatToIntBits(ieeeFloat);
        boolean bl = positive = (ieeeIntBits & Integer.MIN_VALUE) == 0;
        if ((ieeeIntBits & Integer.MAX_VALUE) == 0) {
            return ieeeIntBits;
        }
        int exponent = ieeeIntBits & 0x7F800000;
        exponent >>>= 23;
        int mantissa = ieeeIntBits & 0x7FFFFF;
        if ((exponent -= 126) > -126) {
            mantissa |= 0x800000;
        }
        int remainder = Math.abs(exponent) % 4;
        int s390Exponent = quotient = Math.abs(exponent) / 4;
        if (exponent > 0 && remainder != 0) {
            ++s390Exponent;
        }
        if (exponent < 0) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64;
        int s390Mantissa = mantissa;
        if (remainder > 0) {
            int shift_places;
            if (exponent > 0) {
                shift_places = 4 - remainder;
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -126 && (s390Mantissa & 0xF00000) == 0) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                shift_places = remainder;
                s390Mantissa >>>= shift_places;
            }
        }
        if (exponent == -126) {
            s390Mantissa <<= 1;
            while (s390Mantissa != 0 && (s390Mantissa & 0xF00000) == 0) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        int s390Float = 0;
        int s390ExponentBits = s390Exponent & 0x7F;
        s390Float = s390ExponentBits << 24;
        if (!positive) {
            s390Float |= Integer.MIN_VALUE;
        }
        return s390Float |= s390Mantissa;
    }

    public final String getCodePage() {
        return this.codePage_;
    }

    public final int getCompiler() {
        return this.cobolCompiler_;
    }

    public final int getEndian() {
        return this.remoteCobolEndian_;
    }

    public final int getFloatingPointFormat() {
        return this.floatingPointFormat_;
    }

    public final int getMachine() {
        return this.cobolMachine_;
    }

    public final int getRemoteIntEndian() {
        return this.remoteIntEndian_;
    }

    private void intNtsToPackedDecimal(char[] sb, byte[] tb, boolean aSign) {
        int si = sb.length - 1;
        tb[tb.length - 1] = (byte)(Character.digit(sb[si], 16) << 4);
        tb[tb.length - 1] = aSign ? (sb[0] == '-' ? (byte)(tb[tb.length - 1] | this.PACKED_NEGOR) : (byte)(tb[tb.length - 1] | this.PACKED_POSOR)) : (byte)(tb[tb.length - 1] | this.PACKED_NOSIGN);
        --si;
        int i = tb.length - 2;
        while (i >= 0) {
            tb[i] = (byte)Character.digit(sb[si], 16);
            if (sb[--si] != '-' && sb[si] != '+') {
                tb[i] = (byte)(tb[i] | Character.digit(sb[si], 16) << 4);
                --si;
            }
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void intNtsToSignLeading(char[] sb, byte[] tb, boolean hasSign) {
        block4: {
            if (this.cobolMachine_ == 4) {
                value = Character.digit(sb[1], 16);
                tb[0] = sb[0] == '-' ? (value == 0 ? this.NEGOR : (byte)(this.NEGOR_MVSCUSTOM + value)) : (value == 0 ? this.POSOR : (byte)(this.POSOR_MVSCUSTOM | value));
            } else {
                tb[0] = sb[0] == '-' ? (byte)(this.NEGOR | (byte)Character.digit(sb[1], 16)) : (byte)(this.POSOR | (byte)Character.digit(sb[1], 16));
            }
            si = sb.length - 1;
            ti = tb.length - 1;
            if (!hasSign) ** GOTO lbl18
            while (si > 1 && ti > 0) {
                tb[ti] = (byte)(this.ZERO_PAD | (byte)Character.digit(sb[si], 16));
                --si;
                --ti;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                tb[ti] = (byte)(this.ZERO_PAD_STR | (byte)Character.digit(sb[si], 16));
                --si;
                --ti;
lbl18:
                // 2 sources

                ** while (si > 1 && ti > 0)
            }
        }
    }

    private void intNtsToSignLeadingSeparate(char[] sb, byte[] tb) {
        tb[0] = sb[0] == '+' ? this.PLUS_SIGN_STR : this.NEGATIVE_SIGN_STR;
        int si = sb.length - 1;
        int ti = tb.length - 1;
        while (ti > 0 && si > 0) {
            tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD_STR);
            --si;
            --ti;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void intNtsToSignTrailing(char[] sb, byte[] tb, boolean hasSign) {
        block2: {
            ti = tb.length - 1;
            si = sb.length - 1;
            value = Character.digit(sb[si], 16);
            tb[ti] = hasSign ? (this.cobolMachine_ == 4 ? (sb[0] == '-' ? (value == 0 ? this.NEGOR : this.NEGOR_MVSCUSTOM) : (value == 0 ? this.POSOR : this.POSOR_MVSCUSTOM)) : (sb[0] == '+' ? this.POSOR : this.NEGOR)) : this.ZERO_PAD_STR;
            tb[ti] = (byte)(tb[ti] + value);
            --si;
            --ti;
            if (!hasSign) ** GOTO lbl18
            while (ti >= 0) {
                tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD);
                --ti;
                --si;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD_STR);
                --ti;
                --si;
lbl18:
                // 2 sources

                ** while (ti >= 0)
            }
        }
    }

    private void intNtsToSignTrailingSeparate(char[] sb, byte[] tb) {
        tb[tb.length - 1] = sb[0] == '+' ? this.PLUS_SIGN_STR : this.NEGATIVE_SIGN_STR;
        int si = sb.length - 1;
        int ti = tb.length - 2;
        while (ti >= 0) {
            tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD_STR);
            --si;
            --ti;
        }
        while (ti >= 0) {
            tb[ti] = this.ZERO_PAD_STR;
            --ti;
        }
    }

    private static float intS390BitsToFloat(int floatBits) throws IOException {
        boolean positive;
        boolean bl = positive = (floatBits & Integer.MIN_VALUE) == 0;
        if ((floatBits & Integer.MAX_VALUE) == 0) {
            if (positive) {
                return 0.0f;
            }
            return -0.0f;
        }
        int mantissa = floatBits & 0xFFFFFF;
        int exponent = floatBits & 0x7F000000;
        exponent >>= 24;
        int ieeeExponent = (exponent -= 64) * 4;
        int ieeeMantissa = mantissa;
        if (ieeeExponent <= -126) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -126) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0 && (ieeeMantissa & 0x800000) == 0 && ieeeExponent > -126) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -149) {
            return 0.0f;
        }
        if (ieeeExponent > 128) {
            if (positive) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        int ieeeBits = 0;
        if (!positive) {
            ieeeBits |= Integer.MIN_VALUE;
        }
        ieeeExponent += 126;
        ieeeBits |= (ieeeExponent <<= 23);
        return Float.intBitsToFloat(ieeeBits |= (ieeeMantissa &= 0x7FFFFF));
    }

    private static boolean isNumericEdited(String pic) {
        int picLength = pic.length();
        int i = 0;
        while (i < picLength) {
            char c = pic.charAt(i);
            if (c != 'B' && c != 'P' && c != 'V' && c != 'Z' && c != '9' && c != '0' && c != '/' && c != ',' && c != '.' && c != '+' && c != '-' && c != '*' && c != '$' && c != 'C' && c != 'R' && c != 'D') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isValidBinaryDecimal(boolean isDecimal, String expandedPicField, int numberOfNines, boolean sign, int decimalPosition, BigDecimal value) {
        BigDecimal maxValue;
        boolean isValid = true;
        int numPs = 0;
        BigDecimal minValue = new BigDecimal("0");
        if (!isDecimal) {
            if (numberOfNines < 5) {
                if (sign) {
                    minValue = new BigDecimal("-32768");
                    maxValue = new BigDecimal("32767");
                } else {
                    maxValue = new BigDecimal("65535");
                }
            } else if (numberOfNines < 10) {
                if (sign) {
                    minValue = new BigDecimal("-2147483648");
                    maxValue = new BigDecimal("2147483647");
                } else {
                    maxValue = new BigDecimal("4294967295");
                }
            } else if (sign) {
                minValue = new BigDecimal("-9223372036854775808");
                maxValue = new BigDecimal("9223372036854775807");
            } else {
                maxValue = new BigDecimal("18446744073709551615");
            }
        } else {
            numPs = CobolRecordAttributes.numberOfPs(expandedPicField);
            if (numPs == 0) {
                if (numberOfNines < 5) {
                    if (sign) {
                        minValue = new BigDecimal("-32768").movePointRight(decimalPosition);
                        maxValue = new BigDecimal("32767").movePointRight(decimalPosition);
                    } else {
                        maxValue = new BigDecimal("65535").movePointRight(decimalPosition);
                    }
                } else if (numberOfNines < 10) {
                    if (sign) {
                        minValue = new BigDecimal("-2147483648").movePointRight(decimalPosition);
                        maxValue = new BigDecimal("2147483647").movePointRight(decimalPosition);
                    } else {
                        maxValue = new BigDecimal("4294967295").movePointRight(decimalPosition);
                    }
                } else if (sign) {
                    minValue = new BigDecimal("-9223372036854775808").movePointRight(decimalPosition);
                    maxValue = new BigDecimal("9223372036854775807").movePointRight(decimalPosition);
                } else {
                    maxValue = new BigDecimal("18446744073709551615").movePointRight(decimalPosition);
                }
            } else if (numPs > 0) {
                if (numberOfNines < 5) {
                    if (sign) {
                        minValue = new BigDecimal("-32768").movePointRight(numPs);
                        maxValue = new BigDecimal("32767").movePointRight(numPs);
                    } else {
                        maxValue = new BigDecimal("65535").movePointRight(numPs);
                    }
                } else if (numberOfNines < 10) {
                    if (sign) {
                        minValue = new BigDecimal("-2147483648").movePointRight(numPs);
                        maxValue = new BigDecimal("2147483647").movePointRight(numPs);
                    } else {
                        maxValue = new BigDecimal("4294967295").movePointRight(numPs);
                    }
                } else if (sign) {
                    minValue = new BigDecimal("-9223372036854775808").movePointRight(numPs);
                    maxValue = new BigDecimal("9223372036854775807").movePointRight(numPs);
                } else {
                    maxValue = new BigDecimal("1.8446744073709551615").movePointRight(numPs);
                }
            } else {
                numPs *= -1;
                if (numberOfNines < 5) {
                    if (sign) {
                        minValue = new BigDecimal("-32768").movePointLeft(numPs + numberOfNines);
                        maxValue = new BigDecimal("32767").movePointLeft(numPs + numberOfNines);
                    } else {
                        maxValue = new BigDecimal("65535").movePointLeft(numPs + numberOfNines);
                    }
                } else if (numberOfNines < 10) {
                    if (sign) {
                        minValue = new BigDecimal("-2147483648").movePointLeft(numPs + numberOfNines);
                        maxValue = new BigDecimal("2147483647").movePointLeft(numPs + numberOfNines);
                    } else {
                        maxValue = new BigDecimal("4294967295").movePointLeft(numPs + numberOfNines);
                    }
                } else if (sign) {
                    minValue = new BigDecimal("-9223372036854775808").movePointLeft(numPs + numberOfNines);
                    maxValue = new BigDecimal("9223372036854775807").movePointLeft(numPs + numberOfNines);
                } else {
                    maxValue = new BigDecimal("18446744073709551615").movePointLeft(numPs + numberOfNines);
                }
            }
        }
        if (sign) {
            if (minValue.compareTo(value) > 0 || value.compareTo(maxValue) > 0) {
                isValid = false;
            }
        } else if (minValue.compareTo(value) > 0 || value.compareTo(maxValue) > 0) {
            isValid = false;
        }
        return isValid;
    }

    private static double longS390BitsToDouble(long doubleBits) throws IOException {
        boolean positive;
        boolean bl = positive = (doubleBits & Long.MIN_VALUE) == 0L;
        if ((doubleBits & Long.MAX_VALUE) == 0L) {
            if (positive) {
                return 0.0;
            }
            return -0.0;
        }
        long mantissa = doubleBits & 0xFFFFFFFFFFFFFFL;
        long exponent = doubleBits & 0x7F00000000000000L;
        exponent >>= 56;
        long ieeeExponent = (exponent -= 64L) * 4L;
        long ieeeMantissa = mantissa;
        ieeeMantissa >>= 3;
        if (ieeeExponent <= -1022L) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -1022L) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0L && (ieeeMantissa & 0x10000000000000L) == 0L && ieeeExponent > -1022L) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -1045L) {
            return 0.0;
        }
        if (ieeeExponent > 1024L) {
            if (positive) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        long ieeeBits = 0L;
        if (!positive) {
            ieeeBits |= Long.MIN_VALUE;
        }
        ieeeExponent += 1022L;
        ieeeBits |= (ieeeExponent <<= 52);
        return Double.longBitsToDouble(ieeeBits |= (ieeeMantissa &= 0xFFFFFFFFFFFFFL));
    }

    private static int numberOfPs(String expandedPicField) {
        char[] charArray = expandedPicField.toCharArray();
        int numberOfPs = 0;
        boolean isPositive = true;
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (c == 'P') {
                ++numberOfPs;
            }
            if (c == '9' && numberOfPs != 0) {
                isPositive = false;
            }
            ++i;
        }
        if (!isPositive) {
            numberOfPs *= -1;
        }
        return numberOfPs;
    }

    private static void packedDecimalToIntNts(byte[] sb, char[] tb, byte PackedNegor) {
        int ti = tb.length - 1;
        int si = sb.length - 1;
        tb[ti] = Character.forDigit(sb[si] >> 4 & 0xF, 16);
        --ti;
        --si;
        while (si >= 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            tb[--ti] = Character.forDigit(sb[si] >> 4 & 0xF, 16);
            --ti;
            --si;
        }
        tb[0] = (sb[sb.length - 1] & 0xF) == PackedNegor ? 45 : 43;
        while (ti > 0) {
            tb[ti] = Character.forDigit(0, 16);
            --ti;
        }
    }

    private static void printBuffer(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int j = (buffer[i] & 0xF0) >> 4;
            int k = buffer[i] & 0xF;
            System.out.print(Integer.toString(j, 16));
            System.out.print(Integer.toString(k, 16));
            System.out.print(" ");
            ++i;
        }
        System.out.println();
    }

    private static void printByte(byte b) {
        int j = (b & 0xF0) >> 4;
        int k = b & 0xF;
        System.out.print(Integer.toString(j, 16));
        System.out.print(Integer.toString(k, 16));
    }

    private static void printDebug(String s) {
        System.out.println(s);
    }

    private void printDescriptor() {
        System.out.println("cobolDataType :" + this.cobolDataType);
        System.out.println("sign :" + this.sign);
        System.out.println("decimal :" + this.decimal);
        System.out.println("numeric :" + this.numeric);
        System.out.println("numof9s :" + this.numberOfNines);
        System.out.println("decimalPos:" + this.decimalPosition);
        System.out.println("scale:" + this.scale);
        System.out.println("expandedPicField:" + this.expandedPicField);
        System.out.println("picFieldLength:" + this.picFieldLength);
        System.out.println("comment:" + this.comment);
        System.out.println("align:" + this.align);
    }

    private static int rpc_hyper_2c_to_int_nts(byte[] sb, char[] tb) {
        byte[] temp = new byte[8];
        int i = 0;
        i = sb.length - 1;
        while (i >= 0) {
            temp[8 - (sb.length - i)] = sb[i];
            --i;
        }
        if ((sb[0] & 0xFFFFFF80) != 0) {
            i = 0;
            while (i < 8 - sb.length) {
                temp[i] = -1;
                ++i;
            }
            CobolRecordAttributes.rpc_hyper_negate8(temp);
        }
        i = tb.length - 1;
        while (i > 0) {
            tb[i] = Character.forDigit(CobolRecordAttributes.rpc_hyper_mod10(temp), 16);
            CobolRecordAttributes.rpc_hyper_div10(temp);
            --i;
        }
        i = 0;
        while (i < 8) {
            if (temp[i] != 0) {
                return -1;
            }
            ++i;
        }
        tb[0] = (sb[0] & 0x80) != 0 ? 45 : 43;
        return 0;
    }

    private static void rpc_hyper_add(byte[] buffer, char value) {
        byte[] temp = new byte[8];
        temp[7] = (byte)(Character.digit(value, 16) & 0xFF);
        CobolRecordAttributes.rpc_hyper_add8(buffer, temp);
    }

    private static void rpc_hyper_add8(byte[] tb, byte[] sb) {
        int carry = 0;
        int i = 7;
        while (i >= 0) {
            int temp = (tb[i] & 0xFF) + (sb[i] & 0xFF) + carry;
            tb[i] = (byte)(temp % 256 & 0xFF);
            carry = temp / 256;
            --i;
        }
    }

    private static void rpc_hyper_div10(byte[] buffer) {
        CobolRecordAttributes.rpc_hyper_div8(buffer, buffer, 10);
    }

    private static void rpc_hyper_div8(byte[] tb, byte[] sb, int value) {
        int oldCarry = 0;
        int newCarry = 0;
        int i = 0;
        while (i < 8) {
            int temp = (sb[i] & 0xFF) + oldCarry;
            int div = temp / value;
            int mod = temp % value;
            newCarry = mod * 256;
            tb[i] = (byte)div;
            oldCarry = newCarry;
            byte cfr_ignored_0 = (byte)((newCarry & 0xFF00) >> 8);
            byte cfr_ignored_1 = (byte)(newCarry & 0xFF);
            ++i;
        }
    }

    private static int rpc_hyper_mod10(byte[] buffer) {
        byte[] temp = new byte[8];
        CobolRecordAttributes.rpc_hyper_div8(temp, buffer, 10);
        CobolRecordAttributes.rpc_hyper_mult10(temp);
        CobolRecordAttributes.rpc_hyper_negate8(temp);
        CobolRecordAttributes.rpc_hyper_add8(temp, buffer);
        return temp[7];
    }

    private static void rpc_hyper_mult10(byte[] buffer) {
        byte[] temp = new byte[8];
        CobolRecordAttributes.rpc_hyper_shl8(temp, buffer, 1);
        CobolRecordAttributes.rpc_hyper_shl8(buffer, buffer, 3);
        CobolRecordAttributes.rpc_hyper_add8(buffer, temp);
    }

    private static void rpc_hyper_negate8(byte[] buffer) {
        int i = 0;
        while (i < 8) {
            buffer[i] = (byte)(255 - buffer[i]);
            ++i;
        }
        CobolRecordAttributes.rpc_hyper_add(buffer, Character.forDigit(1, 16));
    }

    private static void rpc_hyper_shl8(byte[] tb, byte[] sb, int value) {
        int oldCarry = 0;
        int newCarry = 0;
        int i = 7;
        while (i >= 0) {
            newCarry = (sb[i] & 0xFF) >> 8 - value;
            int temp = ((sb[i] & 0xFF) << value) + oldCarry;
            byte[] tempByte = CobolRecordAttributes.convertToByte(temp);
            tb[i] = tempByte[3];
            oldCarry = newCarry;
            --i;
        }
    }

    private static int rpc_int_nts_to_hyper_2c(char[] sb, byte[] tb) {
        int i = 0;
        byte[] temp = new byte[8];
        if (sb[0] == '-' || sb[0] == '+') {
            ++i;
        }
        CobolRecordAttributes.rpc_hyper_add(temp, sb[i]);
        ++i;
        while (i < sb.length) {
            CobolRecordAttributes.rpc_hyper_mult10(temp);
            CobolRecordAttributes.rpc_hyper_add(temp, sb[i]);
            ++i;
        }
        if (sb[0] == '-') {
            CobolRecordAttributes.rpc_hyper_negate8(temp);
        }
        i = tb.length - 1;
        while (i >= 0) {
            tb[i] = temp[8 - (tb.length - i)];
            --i;
        }
        i = 0;
        while (i < 8 - tb.length) {
            if (sb[0] == '-' ? temp[i] != -1 : temp[i] != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public final void setCodePage(String aCodePage) {
        if (this.codePage_.equals(aCodePage)) {
            return;
        }
        this.codePage_ = aCodePage;
        try {
            String tmp = new String("-");
            this.NEGATIVE_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "+";
            this.PLUS_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "0";
            this.ZERO_PAD_STR = tmp.getBytes(this.codePage_)[0];
            tmp = " ";
            this.fillByte = tmp.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
    }

    public final void setCompiler(int aCompiler) {
        this.cobolCompiler_ = aCompiler;
    }

    public final void setEndian(int aEndian) {
        this.remoteCobolEndian_ = aEndian;
    }

    public final void setFloatingPointFormat(int aFpRep) {
        this.floatingPointFormat_ = aFpRep;
    }

    public final void setMachine(int aMachine) {
        if (this.cobolMachine_ == aMachine) {
            return;
        }
        this.cobolMachine_ = aMachine;
        if (this.cobolMachine_ == 1) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 0) {
            this.NEGOR = (byte)-48;
            this.POSOR = (byte)-64;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)-16;
        } else if (this.cobolMachine_ == 2) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 4) {
            this.NEGOR = (byte)125;
            this.POSOR = (byte)123;
            this.NEGOR_MVSCUSTOM = (byte)73;
            this.POSOR_MVSCUSTOM = (byte)64;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        }
    }

    public final void setRemoteIntEndian(int aRemoteIntEndian) {
        this.remoteIntEndian_ = aRemoteIntEndian;
    }

    private static void signLeadingSeparateToIntNts(byte[] sb, char[] tb, byte PlusSignStr) {
        tb[0] = sb[0] == PlusSignStr ? 43 : 45;
        int ti = tb.length - 1;
        int si = sb.length - 1;
        while (si > 0 && ti > 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            --si;
            --ti;
        }
        while (ti > 0) {
            tb[ti] = 48;
            --ti;
        }
    }

    private void signLeadingToIntNts(byte[] sb, char[] tb) {
        int ti = tb.length - 1;
        int si = sb.length - 1;
        if (this.cobolMachine_ == 4) {
            byte sign = (byte)(sb[0] & 0xF0);
            if (sb[0] == this.POSOR) {
                tb[0] = 43;
                tb[ti - si] = 48;
            } else if (sb[0] == this.NEGOR) {
                tb[0] = 45;
                tb[ti - si] = 48;
            } else if (sign == this.POSOR_MVSCUSTOM && (sb[0] & 0xF) > 0 && (sb[0] & 0xF) < 10) {
                tb[0] = 43;
                tb[ti - si] = Character.forDigit(sb[0] & 0xF, 16);
            } else if (sb[0] == 74 || sb[0] == 75 || sb[0] == 76 || sb[0] == 77 || sb[0] == 78 || sb[0] == 79 || sb[0] == 80 || sb[0] == 81 || sb[0] == 82) {
                tb[0] = 45;
                tb[ti - si] = Character.forDigit(sb[0] - this.NEGOR_MVSCUSTOM, 16);
            } else {
                tb[0] = 43;
                tb[ti - si] = tb[ti] = Character.forDigit(sb[0] & 0xF, 16);
            }
            while (si > 0) {
                tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
                --ti;
                --si;
            }
            --si;
            --ti;
        } else {
            tb[0] = (byte)(sb[0] & 0xF0) == this.NEGOR ? 45 : 43;
            while (si >= 0) {
                tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
                --ti;
                --si;
            }
        }
        while (ti > 0) {
            tb[ti] = 48;
            --ti;
        }
    }

    private static void signTrailingSeparateToIntNts(byte[] sb, char[] tb, byte PlusSignStr) {
        int si = sb.length - 1;
        int ti = tb.length - 1;
        tb[0] = sb[si] == PlusSignStr ? 43 : 45;
        --si;
        while (ti > 0 && si >= 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            --si;
            --ti;
        }
        while (ti > 0) {
            tb[ti] = 48;
            --ti;
        }
    }

    private void signTrailingToIntNts(byte[] sb, char[] tb) {
        int si = sb.length - 1;
        int ti = tb.length - 1;
        if (this.cobolMachine_ == 4) {
            byte sign = (byte)(sb[sb.length - 1] & 0xF0);
            if (sb[si] == this.POSOR) {
                tb[0] = 43;
                tb[ti] = 48;
            } else if (sb[si] == this.NEGOR) {
                tb[0] = 45;
                tb[ti] = 48;
            } else if (sign == this.POSOR_MVSCUSTOM && (sb[si] & 0xF) > 0 && (sb[si] & 0xF) < 10) {
                tb[0] = 43;
                tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            } else if (sb[si] == 74 || sb[si] == 75 || sb[si] == 76 || sb[si] == 77 || sb[si] == 78 || sb[si] == 79 || sb[si] == 80 || sb[si] == 81 || sb[si] == 82) {
                tb[0] = 45;
                tb[ti] = Character.forDigit(sb[si] - this.NEGOR_MVSCUSTOM, 16);
            } else {
                tb[0] = 43;
                tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            }
            --si;
            --ti;
            while (si >= 0) {
                tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
                --ti;
                --si;
            }
        } else {
            tb[0] = (byte)(sb[sb.length - 1] & 0xF0) == this.NEGOR ? 45 : 43;
            while (si >= 0) {
                tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
                --ti;
                --si;
            }
        }
        while (ti > 0) {
            tb[ti] = 48;
            --ti;
        }
    }

    protected final int sizeOfCobol() {
        int length;
        switch (this.cobolDataType) {
            case 4: 
            case 5: 
            case 8: {
                length = this.numberOfNines;
                break;
            }
            case 6: 
            case 7: {
                if (this.sign) {
                    length = this.numberOfNines + 1;
                    break;
                }
                length = this.numberOfNines;
                break;
            }
            case 0: {
                if (this.numberOfNines > 9) {
                    length = 8;
                    break;
                }
                if (this.numberOfNines > 4) {
                    length = 4;
                    break;
                }
                length = 2;
                break;
            }
            case 1: {
                length = 4;
                break;
            }
            case 2: {
                length = 8;
                break;
            }
            case 3: {
                length = this.numberOfNines / 2 + 1;
                break;
            }
            case 9: {
                length = this.picFieldLength;
                break;
            }
            default: {
                length = -1;
            }
        }
        return length;
    }

    private static int sizeOfJava(int javaType, int cobolLength, boolean isDBCS) {
        int size;
        switch (javaType) {
            case 0: 
            case 3: {
                size = 2;
                break;
            }
            case 2: {
                size = 1;
                break;
            }
            case 4: {
                size = 4;
                break;
            }
            case 5: {
                size = 8;
                break;
            }
            case 6: {
                size = 4;
                break;
            }
            case 7: {
                size = 8;
                break;
            }
            case 8: {
                if (isDBCS) {
                    size = cobolLength;
                    break;
                }
                size = CobolRecordAttributes.stringSize(cobolLength);
                break;
            }
            default: {
                size = 0;
            }
        }
        return size;
    }

    private static int stringSize(int stringLength) {
        return 2 * stringLength;
    }

    protected final void updateCicsDataDescriptor(int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInsideDBCS) {
        this.cobolDataType = aCobolDataType;
        this.numberOfNines = aNumberNines;
        this.picFieldLength = aPicFieldLength;
        this.sign = aSign;
        this.decimal = aDecimal;
        this.numeric = aNumeric;
        this.decimalPosition = aDecPos;
        this.scale = aScale;
        this.expandedPicField = aExpandedPicField;
        this.comment = new StringBuffer();
        this.insideDBCS = aInsideDBCS;
    }

    private static void xtr_int_2c_to_int_2c(byte[] sb, byte[] tb) {
        int filler = 0;
        int i = tb.length - 1;
        while (i >= 0 && sb.length - (tb.length - i) >= 0) {
            tb[i] = sb[sb.length - (tb.length - i)];
            --i;
        }
        if (i >= 0) {
            if ((sb[0] & 0x80) != 0) {
                filler = -1;
            }
            while (i >= 0) {
                tb[i--] = filler;
            }
        }
    }

    private static int xtr_int_2c_to_int_nts(byte[] sb, char[] tb) {
        return CobolRecordAttributes.rpc_hyper_2c_to_int_nts(sb, tb);
    }

    private static double xtr_int_2c_to_real_double(byte[] sb) {
        double temp = 0.0;
        byte[] tmp = new byte[2];
        tmp[0] = 0;
        int i = 0;
        while (i < sb.length) {
            tmp[1] = sb[i];
            short tmp2 = CobolRecordAttributes.convertFromByteToShort(tmp);
            temp = (byte)(sb[0] & 0x80) != 0 ? temp * 256.0 + (double)(255 - tmp2) : temp * 256.0 + (double)tmp2;
            ++i;
        }
        if ((byte)(sb[0] & 0x80) != 0) {
            temp = (temp + 1.0) * -1.0;
        }
        return temp;
    }

    private static int xtr_int_nts_to_int_2c(char[] sb, byte[] tb) {
        return CobolRecordAttributes.rpc_int_nts_to_hyper_2c(sb, tb);
    }

    private static double xtr_int_nts_to_real_double(char[] sb) {
        int i = 0;
        double tdouble = 0.0;
        if (sb[0] == '+' || sb[0] == '-') {
            ++i;
        }
        while (i < sb.length) {
            tdouble = tdouble * 10.0 + (double)Character.digit(sb[i], 16);
            ++i;
        }
        if (sb[0] == '-') {
            tdouble *= -1.0;
        }
        return tdouble;
    }

    private int xtr_real_fp_to_int_2c(byte[] sb, byte[] tb) {
        char[] temp = new char[20];
        double f = this.convertFromByteToDouble(sb);
        int rc = CobolRecordAttributes.xtr_real_fp_to_int_nts(f, temp);
        if (rc != 0) {
            return rc;
        }
        rc = CobolRecordAttributes.xtr_int_nts_to_int_2c(temp, tb);
        return rc;
    }

    private static int xtr_real_fp_to_int_nts(double sdouble, char[] tb) {
        if (sdouble < 0.0) {
            tb[0] = 45;
            sdouble *= -1.0;
        } else {
            tb[0] = 43;
        }
        sdouble += 0.5;
        int i = 1;
        while (i < tb.length) {
            int t = (int)(sdouble / Math.pow(10.0, tb.length - i - 1));
            if (t > 9) {
                return -1;
            }
            tb[i] = Character.forDigit(t, 16);
            sdouble -= (double)t * Math.pow(10.0, tb.length - i - 1);
            ++i;
        }
        return 0;
    }

    private static void xtr_real_fp_to_real_fp(byte[] sb, byte[] tb) {
        if (tb.length != sb.length) {
            return;
        }
        System.arraycopy(sb, 0, tb, 0, sb.length);
    }
}

