/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.command;

import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.ivj.eab.command.Command;
import com.ibm.ivj.eab.command.CommunicationCommand;
import com.ibm.ivj.eab.util.BeanDumper;
import com.ibm.ivj.eab.util.Set;
import com.ibm.record.IByteBuffer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.resource.cci.Record;
import javax.resource.cci.Streamable;

public class SelectorRecord
implements IByteBuffer,
Serializable,
Record,
Streamable {
    private static ResourceBundle resCommandResourceBundle = ResourceBundle.getBundle("com.ibm.ivj.eab.command.CommandResourceBundle");
    static final String copyright = "(c) Copyright IBM Corporation 1998, 2000.";
    static final long serialVersionUID = 1934055327148602524L;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private Object fieldObject = null;
    private Set selectableRecords = new Set(10);
    private Vector invalidOutput = new Vector();
    private Command fieldParentCommand = new CommunicationCommand();
    private static String name = "SelectorRecord";
    private static String descr = "Runtime Record used in EAB Commands to support multiple outputs";
    private PrintWriter logWriter;

    public SelectorRecord() {
        this.setObject(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.addPropertyChangeListener(arg1);
    }

    public void addSelectableRecord(IByteBuffer record) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".addSelectableRecord(IByteBuffer)]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (record != null) {
            this.selectableRecords.add(record);
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".addSelectableRecord(IByteBuffer)]");
        }
    }

    public boolean checkBytes(byte[] theBytes) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".checkBytes(byte[])]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        Enumeration elements = this.selectableRecords.elements();
        IByteBuffer record = null;
        boolean result1 = false;
        while (elements.hasMoreElements()) {
            record = (IByteBuffer)elements.nextElement();
            boolean result2 = record.checkBytes(theBytes);
            if (!result2) continue;
            if (result1) {
                return true;
            }
            result1 = result2;
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".checkBytes(byte[])]");
        }
        return result1;
    }

    public Object clone() {
        return null;
    }

    private String dumpBytes(byte[] theBytes) {
        StringBuffer stream = new StringBuffer();
        int bufSize = 0;
        if (theBytes != null) {
            bufSize = theBytes.length;
        }
        int size = bufSize;
        char[] buf = new char[16];
        while (size % 16 != 0) {
            ++size;
        }
        if (theBytes == null) {
            return null;
        }
        int j = 0;
        int i = 1;
        while (i <= size) {
            int k;
            if (i > bufSize) {
                stream.append(Integer.toHexString(0));
                stream.append(Integer.toHexString(0));
                buf[j] = '\u0000';
            } else {
                k = (theBytes[i - 1] & 0xF0) >> 4;
                int l = theBytes[i - 1] & 0xF;
                stream.append(Integer.toHexString(k));
                stream.append(Integer.toHexString(l));
                buf[j] = (char)theBytes[i - 1];
            }
            if (i % 4 == 0) {
                stream.append(" ");
            }
            if (i % 16 == 0) {
                stream.append(" |");
                k = 0;
                while (k < 16) {
                    if (Character.isIdentifierIgnorable(buf[k])) {
                        stream.append(".");
                    } else {
                        stream.append(buf[k]);
                    }
                    ++k;
                }
                stream.append("|");
                stream.append("\n");
                j = 0;
            } else {
                ++j;
            }
            ++i;
        }
        stream.append("\n");
        return stream.toString();
    }

    public void firePropertyChange(String arg1, Object arg2, Object arg3) {
        this.propertyChange.firePropertyChange(arg1, arg2, arg3);
    }

    public byte[] getBytes() {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".getBytes()]");
        }
        if (currentTrace >= 3) {
            this.logTraceInfo(this.toString());
        }
        Enumeration elements = this.selectableRecords.elements();
        IByteBuffer record = null;
        byte[] result1 = new byte[1];
        while (elements.hasMoreElements()) {
            record = (IByteBuffer)elements.nextElement();
            byte[] result2 = record.getBytes();
            if (result1.length >= result2.length) continue;
            result1 = result2;
        }
        if (currentTrace >= 3) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".getBytes()]");
        }
        return result1;
    }

    public int getCurrentTraceLevel() {
        if (this.fieldParentCommand.isCcf2Command()) {
            return this.fieldParentCommand.getCurrentTraceLevel();
        }
        return RuntimeContext.getCurrent().getRASService().getTraceLevel();
    }

    protected Vector getInvalidOutput() {
        return this.invalidOutput;
    }

    protected PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public Object getObject() {
        return this.fieldObject;
    }

    public String getRecordName() {
        return name;
    }

    public String getRecordShortDescription() {
        return descr;
    }

    private void logError(String msg) {
        if (this.fieldParentCommand.isCcf2Command()) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logError(msg);
        }
    }

    private void logTraceInfo(String msg) {
        if (this.fieldParentCommand.isCcf2Command()) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(msg);
        }
    }

    public void read(InputStream istream) throws IOException {
        byte[] bytes = new byte[istream.available()];
        istream.read(bytes);
        this.setBytes(bytes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.removePropertyChangeListener(arg1);
    }

    public void setBytes(byte[] theBytes) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".setBytes(byte[])]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        Enumeration elements = this.selectableRecords.elements();
        IByteBuffer record = null;
        IByteBuffer resultRecord = null;
        boolean result1 = false;
        boolean operationFailed = false;
        while (elements.hasMoreElements()) {
            record = (IByteBuffer)elements.nextElement();
            boolean result2 = record.checkBytes(theBytes);
            if (!result2) continue;
            if (operationFailed) {
                this.setInvalidOutput(record);
                continue;
            }
            if (result1) {
                this.setInvalidOutput(theBytes);
                this.setInvalidOutput(resultRecord);
                this.setInvalidOutput(record);
                operationFailed = true;
                continue;
            }
            result1 = result2;
            resultRecord = record;
        }
        if (operationFailed) {
            this.logError(resCommandResourceBundle.getString("IVJC0866__SelectorRecord.s"));
            if (currentTrace >= 1) {
                this.logTraceInfo("    [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".setBytes(byte[]) error: more then one candidate matches.]");
            }
            this.logTraceInfo("    Returned byte array:");
            this.logTraceInfo(this.dumpBytes(theBytes));
            this.logTraceInfo("    Matching outputs:");
            this.logTraceInfo(this.invalidOutput.elementAt(1).toString());
            this.logTraceInfo(this.invalidOutput.elementAt(2).toString());
            this.setObject(this);
        }
        if (resultRecord != null) {
            resultRecord.setBytes(theBytes);
            this.setObject(resultRecord);
        } else {
            this.setObject(this);
            this.setInvalidOutput(theBytes);
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.SelectorRecord@" + this.hashCode() + ".setBytes(byte[])]");
        }
    }

    private void setInvalidOutput(Object newValue) {
        this.invalidOutput.addElement(newValue);
    }

    protected void setLogWriter(PrintWriter newLogWriter) {
        this.logWriter = newLogWriter;
    }

    public void setObject(Object object) {
        Object oldValue = this.fieldObject;
        this.fieldObject = object;
        this.firePropertyChange("object", oldValue, object);
    }

    public void setRecordName(String aName) {
        name = aName;
    }

    public void setRecordShortDescription(String aDescr) {
        descr = aDescr;
    }

    public String toString() {
        String dumpString = "";
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("[com.ibm.ivj.eab.command.SelectorRecord]");
            pwrtr.println("  fieldObject: ");
            if (this.fieldObject != this) {
                pwrtr.println("    [" + BeanDumper.toString(this.fieldObject) + "    ]");
            } else {
                pwrtr.println("[    com.ibm.ivj.eab.command.SelectorRecord" + this.hashCode() + "    ]");
            }
            pwrtr.println("  selectableRecords: ");
            if (this.selectableRecords != null) {
                pwrtr.println("    [" + this.selectableRecords.toString() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            pwrtr.println("  invalidOutput: ");
            if (this.invalidOutput != null) {
                pwrtr.println("    [" + this.invalidOutput.toString() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }

    public String toStringShort() {
        String dumpString = "";
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("[com.ibm.ivj.eab.command.SelectorRecord]");
            pwrtr.println("  fieldObject: ");
            if (this.fieldObject != this) {
                pwrtr.println("    [" + this.fieldObject.getClass().getName() + "@" + this.fieldObject.hashCode() + "    ]");
            } else {
                pwrtr.println("[    com.ibm.ivj.eab.command.SelectorRecord" + this.hashCode() + "    ]");
            }
            pwrtr.println("  selectableRecords: ");
            if (this.selectableRecords != null) {
                Enumeration elements = this.selectableRecords.elements();
                pwrtr.println("     [");
                while (elements.hasMoreElements()) {
                    Object e = elements.nextElement();
                    pwrtr.println("     " + e.getClass().getName() + "@" + e.hashCode());
                }
                pwrtr.println("     ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            pwrtr.println("  invalidOutput: ");
            if (this.invalidOutput != null) {
                pwrtr.println("    [" + this.invalidOutput.toString() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }

    public void write(OutputStream ostream) throws IOException {
        ostream.write(this.getBytes());
    }
}

