/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.command;

import com.ibm.connector.Communication;
import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.ConnectorException;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.ivj.eab.command.AfterInternalExecutionListener;
import com.ibm.ivj.eab.command.BeforeInternalExecutionListener;
import com.ibm.ivj.eab.command.Command;
import com.ibm.ivj.eab.command.CommandCommunicationPrimitive;
import com.ibm.ivj.eab.command.CommandEvent;
import com.ibm.ivj.eab.command.CommandMappingPrimitive;
import com.ibm.ivj.eab.command.CommandObjectTransferPrimitive;
import com.ibm.ivj.eab.command.ExecutionException;
import com.ibm.ivj.eab.command.IConnectionFactoryConfiguration;
import com.ibm.ivj.eab.command.InvalidInputStateException;
import com.ibm.ivj.eab.command.InvalidOutputStateException;
import com.ibm.ivj.eab.command.Navigator;
import com.ibm.ivj.eab.util.BeanDumper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.resource.cci.Interaction;

public class CommunicationNavigator
extends Navigator
implements AfterInternalExecutionListener,
BeforeInternalExecutionListener,
PropertyChangeListener,
Serializable {
    static final String copyright = "(c) Copyright IBM Corporation 1998, 2000.";
    static final long serialVersionUID = 6308403512639445291L;
    private CommandCommunicationPrimitive ivjcommunicationHelper = null;
    private boolean ivjConnPtoP1Aligning = false;
    private boolean ivjConnPtoP2Aligning = false;
    private boolean ivjConnPtoP3Aligning = false;
    private boolean ivjConnPtoP4Aligning = false;
    private CommandMappingPrimitive ivjmappingHelper = null;
    private CommandObjectTransferPrimitive ivjobjectTransferHelper = null;
    private PrintWriter logWriter;

    public CommunicationNavigator() {
        this.initialize();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.addPropertyChangeListener(arg1);
    }

    public void afterInternalExecution(CommandEvent event) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".afterInternalExecution(CommandEvent)]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (event.getSource() == this) {
            this.connEtoM4(event);
            this.connEtoM5(event);
            this.connEtoM6(event);
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".afterInternalExecution(CommandEvent)]\n\n\n");
        }
    }

    public void beforeInternalExecution(CommandEvent event) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".beforeInternalExecution(CommandEvent)]\n\n\n");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (event.getSource() == this) {
            this.connEtoM1(event);
            this.connEtoM2(event);
            this.connEtoM3(event);
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".beforeInternalExecution(CommandEvent)]");
        }
    }

    public void checkInputState() throws InvalidInputStateException {
    }

    private void connEtoC1(PropertyChangeEvent arg1) {
        try {
            this.firePropertyChange("mappingMappedObjects", arg1.getOldValue(), arg1.getNewValue());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(PropertyChangeEvent arg1) {
        try {
            this.firePropertyChange("communicationCommunication", arg1.getOldValue(), arg1.getNewValue());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(PropertyChangeEvent arg1) {
        try {
            this.firePropertyChange("communicationConnectionSpec", arg1.getOldValue(), arg1.getNewValue());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(PropertyChangeEvent arg1) {
        try {
            this.firePropertyChange("communicationInteractionSpec", arg1.getOldValue(), arg1.getNewValue());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(PropertyChangeEvent arg1) {
        try {
            this.firePropertyChange("communicationDisconnectCommunication", arg1.getOldValue(), arg1.getNewValue());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(CommandEvent arg1) {
        try {
            this.getobjectTransferHelper().beforeExecute(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(CommandEvent arg1) {
        try {
            this.getmappingHelper().beforeExecute(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3(CommandEvent arg1) {
        try {
            this.getcommunicationHelper().beforeExecute(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM4(CommandEvent arg1) {
        try {
            this.getobjectTransferHelper().afterExecute(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM5(CommandEvent arg1) {
        try {
            this.getmappingHelper().afterExecute(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM6(CommandEvent arg1) {
        try {
            this.getcommunicationHelper().afterExecute(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetSource() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                this.setInput(this.getobjectTransferHelper().getInput());
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            if (!this.ivjConnPtoP1Aligning) {
                this.ivjConnPtoP1Aligning = true;
                this.getobjectTransferHelper().setInput(this.getInput());
                this.ivjConnPtoP1Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP1Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetSource() {
        try {
            if (!this.ivjConnPtoP2Aligning) {
                this.ivjConnPtoP2Aligning = true;
                this.getobjectTransferHelper().setOutput(this.getOutput());
                this.ivjConnPtoP2Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP2Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            if (!this.ivjConnPtoP2Aligning) {
                this.ivjConnPtoP2Aligning = true;
                this.setOutput(this.getobjectTransferHelper().getOutput());
                this.ivjConnPtoP2Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP2Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetSource() {
        try {
            if (!this.ivjConnPtoP3Aligning) {
                this.ivjConnPtoP3Aligning = true;
                this.setInput(this.getmappingHelper().getInput());
                this.ivjConnPtoP3Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP3Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP3SetTarget() {
        try {
            if (!this.ivjConnPtoP3Aligning) {
                this.ivjConnPtoP3Aligning = true;
                this.getmappingHelper().setInput(this.getInput());
                this.ivjConnPtoP3Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP3Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP4SetSource() {
        try {
            if (!this.ivjConnPtoP4Aligning) {
                this.ivjConnPtoP4Aligning = true;
                this.setOutput(this.getmappingHelper().getOutput());
                this.ivjConnPtoP4Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP4Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP4SetTarget() {
        try {
            if (!this.ivjConnPtoP4Aligning) {
                this.ivjConnPtoP4Aligning = true;
                this.getmappingHelper().setOutput(this.getOutput());
                this.ivjConnPtoP4Aligning = false;
            }
        }
        catch (Throwable ivjExc) {
            this.ivjConnPtoP4Aligning = false;
            this.handleException(ivjExc);
        }
    }

    private void connPtoP5SetTarget() {
        try {
            this.getmappingHelper().setParentCommand(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP6SetTarget() {
        try {
            this.getobjectTransferHelper().setParentCommand(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP7SetTarget() {
        try {
            this.getcommunicationHelper().setParentCommand(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void execute() throws ConnectorException, InvalidInputStateException, ExecutionException, InvalidOutputStateException {
        if (this.getcommunicationHelper() != null) {
            if (this.getcommunicationHelper().getConnectionFactoryConfiguration() != null) {
                this.ccf2Command = true;
            } else if (this.getcommunicationHelper().getInteraction() != null) {
                this.ccf2Command = true;
            }
        }
        super.execute();
    }

    public void firePropertyChange(String arg1, Object arg2, Object arg3) {
        this.propertyChange.firePropertyChange(arg1, arg2, arg3);
    }

    public Communication getCommunication() {
        return this.getcommunicationHelper().getCommunication();
    }

    private CommandCommunicationPrimitive getcommunicationHelper() {
        if (this.ivjcommunicationHelper == null) {
            try {
                this.ivjcommunicationHelper = new CommandCommunicationPrimitive();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjcommunicationHelper;
    }

    public IConnectionFactoryConfiguration getConnectionFactoryConfiguration() {
        return this.getcommunicationHelper().getConnectionFactoryConfiguration();
    }

    public ConnectionSpec getConnectionSpec() {
        return this.getcommunicationHelper().getConnectionSpec();
    }

    public int getCurrentTraceLevel() {
        if (this.ccf2Command) {
            return Command.CCF2TRACELEVEL;
        }
        return RuntimeContext.getCurrent().getRASService().getTraceLevel();
    }

    public boolean getDisconnectCommunication() {
        return this.getcommunicationHelper().getDisconnectCommunication();
    }

    public Interaction getInteraction() {
        return this.getcommunicationHelper().getInteraction();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public Enumeration getMappedObjects() {
        return this.getmappingHelper().getMappedObjects();
    }

    public CommandMappingPrimitive getMapping() {
        return this.getmappingHelper();
    }

    private CommandMappingPrimitive getmappingHelper() {
        if (this.ivjmappingHelper == null) {
            try {
                this.ivjmappingHelper = new CommandMappingPrimitive();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjmappingHelper;
    }

    private CommandObjectTransferPrimitive getobjectTransferHelper() {
        if (this.ivjobjectTransferHelper == null) {
            try {
                this.ivjobjectTransferHelper = new CommandObjectTransferPrimitive();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjobjectTransferHelper;
    }

    private void handleException(Throwable exception) {
        this.internalExceptionHandler(exception);
    }

    private void initConnections() {
        this.addBeforeInternalExecutionListener(this);
        this.addAfterInternalExecutionListener(this);
        this.getmappingHelper().addPropertyChangeListener(this);
        this.getcommunicationHelper().addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
        this.getobjectTransferHelper().addPropertyChangeListener(this);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
        this.connPtoP3SetTarget();
        this.connPtoP4SetTarget();
        this.connPtoP5SetTarget();
        this.connPtoP6SetTarget();
        this.connPtoP7SetTarget();
    }

    private void initialize() {
        this.initConnections();
    }

    public final void internalExecute() throws ExecutionException {
        CommandEvent commandEvent = new CommandEvent(this);
        this.getobjectTransferHelper().setInternalBeforeAfter(true);
        this.getcommunicationHelper().setInternalBeforeAfter(true);
        this.fireAfterInternalExecution(commandEvent);
        try {
            this.fireInternalExecutionStarting(commandEvent);
        }
        catch (RuntimeException e) {
            this.getobjectTransferHelper().setInternalBeforeAfter(false);
            this.getcommunicationHelper().setInternalBeforeAfter(false);
            throw e;
        }
    }

    public boolean isDisconnectInteraction() {
        return this.getcommunicationHelper().isDisconnectInteraction();
    }

    protected void logError(String msg) {
        if (this.ccf2Command) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logError(msg);
        }
    }

    protected void logTraceInfo(String msg) {
        if (this.ccf2Command) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(msg);
        }
    }

    public static void main(String[] args) {
        try {
            new CommunicationNavigator();
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.ibm.ivj.eab.command.Navigator");
            exception.printStackTrace(System.out);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (source == this.getcommunicationHelper()) {
            if (propertyName == "communication") {
                this.connEtoC2(evt);
            } else if (propertyName == "connectionSpec") {
                this.connEtoC3(evt);
            } else if (propertyName == "interactionSpec") {
                this.connEtoC4(evt);
            } else if (propertyName == "disconnectCommunication") {
                this.connEtoC5(evt);
            }
        } else if (source == this.getobjectTransferHelper()) {
            if (propertyName == "input") {
                this.connPtoP1SetSource();
            } else if (propertyName == "output") {
                this.connPtoP2SetTarget();
            }
        } else if (source == this) {
            if (propertyName == "output") {
                this.connPtoP4SetTarget();
                this.connPtoP2SetSource();
            } else if (propertyName == "input") {
                this.connPtoP3SetTarget();
                this.connPtoP1SetTarget();
            }
        } else if (source == this.getmappingHelper()) {
            if (propertyName == "input") {
                this.connPtoP3SetSource();
            } else if (propertyName == "output") {
                this.connPtoP4SetSource();
            } else if (propertyName == "mappedObjects") {
                this.connEtoC1(evt);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.removePropertyChangeListener(arg1);
    }

    public final void returnExecutionSuccessful(CommandEvent event) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".returnExecutionSuccessful(CommandEvent)]");
        }
        CommandEvent commandEvent = new CommandEvent(this);
        commandEvent.setPropertyTable(event.getPropertyTable());
        this.fireBeforeInternalExecution(commandEvent);
        this.getobjectTransferHelper().setInternalBeforeAfter(false);
        this.getcommunicationHelper().setInternalBeforeAfter(false);
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".returnExecutionSuccessful(CommandEvent)]");
        }
    }

    public final void returnExecutionUnsuccessful(CommandEvent event) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".returnExecutionUnsuccessful(CommandEvent)]");
        }
        CommandEvent commandEvent = new CommandEvent(this);
        commandEvent.setPropertyTable(event.getPropertyTable());
        this.fireBeforeInternalExecution(commandEvent);
        this.getobjectTransferHelper().setInternalBeforeAfter(false);
        this.getcommunicationHelper().setInternalBeforeAfter(false);
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommunicationNavigator@" + this.hashCode() + ".returnExecutionUnsuccessful(CommandEvent)]");
        }
    }

    public void setCommunication(Communication arg1) {
        this.getcommunicationHelper().setCommunication(arg1);
    }

    public void setConnectionFactoryConfiguration(IConnectionFactoryConfiguration arg1) {
        this.getcommunicationHelper().setConnectionFactoryConfiguration(arg1);
    }

    public void setConnectionSpec(ConnectionSpec arg1) {
        this.getcommunicationHelper().setConnectionSpec(arg1);
    }

    public void setDisconnectCommunication(boolean arg1) {
        this.getcommunicationHelper().setDisconnectCommunication(arg1);
    }

    public void setDisconnectInteraction(boolean arg1) {
        this.getcommunicationHelper().setDisconnectInteraction(arg1);
    }

    public void setInteraction(Interaction arg1) {
        this.getcommunicationHelper().setInteraction(arg1);
    }

    public void setLogWriter(PrintWriter newLogWriter) {
        this.logWriter = newLogWriter;
        this.getmappingHelper().setLogWriter(newLogWriter);
        this.getobjectTransferHelper().setLogWriter(newLogWriter);
        this.getcommunicationHelper().setLogWriter(newLogWriter);
    }

    public void setMappedObjects(Enumeration arg1) {
        this.getmappingHelper().setMappedObjects(arg1);
    }

    public String toString() {
        String dumpString = "";
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("[com.ibm.ivj.eab.command.CommunicationNavigator]");
            pwrtr.println("  fieldInput: ");
            if (this.getInput() != null) {
                pwrtr.println("    [" + BeanDumper.toString(this.getInput()) + "    ]");
            } else {
                pwrtr.println("    [null]");
            }
            pwrtr.println("  fieldOutput: ");
            if (this.getOutput() != null) {
                pwrtr.println("    [" + BeanDumper.toString(this.getOutput()) + "    ]");
            } else {
                pwrtr.println("    [null]");
            }
            pwrtr.println("  fieldExpectedTriggerClass: ");
            if (this.getExpectedTriggerClass() != null) {
                pwrtr.println("    [" + BeanDumper.toString(this.getExpectedTriggerClass()) + "    ]");
            } else {
                pwrtr.println("    [null]");
            }
            pwrtr.println("  ivjcommunicationHelper: ");
            if (this.ivjcommunicationHelper != null) {
                pwrtr.println("    [" + this.ivjcommunicationHelper.toString() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            pwrtr.println("  ivjmappingHelper: ");
            if (this.ivjmappingHelper != null) {
                pwrtr.println("    [" + this.ivjmappingHelper.toString() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            pwrtr.println("  ivjobjectTransferHelper: ");
            if (this.ivjobjectTransferHelper != null) {
                pwrtr.println("    [" + this.ivjobjectTransferHelper.toString() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }

    public String toStringShort() {
        String dumpString = "";
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("[com.ibm.ivj.eab.command.CommunicationNavigator]");
            pwrtr.println("  fieldInput: ");
            if (this.getInput() != null) {
                pwrtr.println("    [" + this.getInput().getClass().getName() + "@" + this.getInput().hashCode() + "    ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            pwrtr.println("  fieldOutput: ");
            if (this.getOutput() != null) {
                pwrtr.println("    [" + this.getOutput().getClass().getName() + "@" + this.getOutput().hashCode() + "    ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            pwrtr.println("  fieldExpectedTriggerClass: ");
            if (this.getExpectedTriggerClass() != null) {
                pwrtr.println("    [" + this.getExpectedTriggerClass().getClass().getName() + "@" + this.getExpectedTriggerClass().hashCode() + "    ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            pwrtr.println("  ivjcommunicationHelper: ");
            if (this.ivjcommunicationHelper != null) {
                pwrtr.println("    [" + this.ivjcommunicationHelper.toStringShort() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            pwrtr.println("  ivjmappingHelper: ");
            if (this.ivjmappingHelper != null) {
                pwrtr.println("    [" + this.ivjmappingHelper.toStringShort() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            pwrtr.println("  ivjobjectTransferHelper: ");
            if (this.ivjobjectTransferHelper != null) {
                pwrtr.println("    [" + this.ivjobjectTransferHelper.toString() + "    ]");
            } else {
                pwrtr.println("    [null    ]");
            }
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }
}

