/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.command;

import com.ibm.connector.AlreadyConnectedException;
import com.ibm.connector.Communication;
import com.ibm.connector.CommunicationException;
import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.ConnectorException;
import com.ibm.connector.LogonException;
import com.ibm.connector.NoConnectionAvailableException;
import com.ibm.connector.NotConnectedException;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.ivj.eab.command.Command;
import com.ibm.ivj.eab.command.CommandEvent;
import com.ibm.ivj.eab.command.CommandException;
import com.ibm.ivj.eab.command.ExecutionException;
import com.ibm.ivj.eab.command.ICommandPrimitive;
import com.ibm.ivj.eab.command.IConnectionFactoryConfiguration;
import com.ibm.ivj.eab.command.SelectorRecord;
import com.ibm.ivj.eab.util.BeanDumper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.spi.ManagedConnectionFactory;

public class CommandCommunicationPrimitive
implements ICommandPrimitive,
Serializable {
    private static ResourceBundle resCommandResourceBundle = ResourceBundle.getBundle("com.ibm.ivj.eab.command.CommandResourceBundle");
    static final String copyright = "(c) Copyright IBM Corporation 1998, 2000";
    private static final String lookupPrefix = "java:comp/env/";
    private static final String emptyString = "";
    static final long serialVersionUID = -2368169609505891179L;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private com.ibm.connector.InteractionSpec fieldInteractionSpec = null;
    private InteractionSpec fieldNewInteractionSpec = null;
    private Object fieldInput = null;
    private Object fieldOutput = null;
    private boolean fieldInternalBeforeAfter = false;
    private Command fieldParentCommand = null;
    private ConnectionFactory fieldConnectionFactory = null;
    private Connection fieldConnection = null;
    private Interaction fieldInteraction = null;
    private boolean isExternalInteraction = false;
    private boolean disconnectInteraction = true;
    private Communication fieldCommunication = null;
    private boolean fieldDisconnectCommunication = true;
    private boolean fieldIsExternalCommunication = false;
    private ConnectionSpec fieldConnectionSpec = null;
    private IConnectionFactoryConfiguration fieldConnectionFactoryConfiguration = null;
    private PrintWriter logWriter = null;

    public synchronized void addPropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.addPropertyChangeListener(arg1);
    }

    public void afterExecute(CommandEvent commandEvent) {
        if (this.fieldParentCommand.isCcf2Command()) {
            this.newAfterExecute(commandEvent);
        } else {
            this.oldAfterExecute(commandEvent);
        }
    }

    public void beforeExecute(CommandEvent commandEvent) {
        if (this.fieldParentCommand.isCcf2Command()) {
            this.newBeforeExecute(commandEvent);
        } else {
            if (this.getConnectionFactoryConfiguration() != null) {
                this.fieldParentCommand.ccf2Command = true;
                this.newBeforeExecute(commandEvent);
                return;
            }
            if (this.getInteraction() != null) {
                this.fieldParentCommand.ccf2Command = true;
                this.newBeforeExecute(commandEvent);
                return;
            }
            this.oldBeforeExecute(commandEvent);
        }
    }

    public void execute() {
        if (this.fieldParentCommand.isCcf2Command()) {
            this.newExecute();
        } else {
            this.oldExecute();
        }
    }

    public void firePropertyChange(String arg1, Object arg2, Object arg3) {
        this.propertyChange.firePropertyChange(arg1, arg2, arg3);
    }

    public Communication getCommunication() {
        return this.fieldCommunication;
    }

    public IConnectionFactoryConfiguration getConnectionFactoryConfiguration() {
        return this.fieldConnectionFactoryConfiguration;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.fieldConnectionSpec;
    }

    public int getCurrentTraceLevel() {
        if (this.fieldParentCommand.isCcf2Command()) {
            return this.fieldParentCommand.getCurrentTraceLevel();
        }
        return RuntimeContext.getCurrent().getRASService().getTraceLevel();
    }

    public boolean getDisconnectCommunication() {
        return this.fieldDisconnectCommunication;
    }

    public Object getInput() {
        return this.fieldInput;
    }

    public Interaction getInteraction() {
        return this.fieldInteraction;
    }

    public com.ibm.connector.InteractionSpec getInteractionSpec() {
        return this.fieldInteractionSpec;
    }

    public boolean getInternalBeforeAfter() {
        return this.fieldInternalBeforeAfter;
    }

    protected PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public InteractionSpec getNewInteractionSpec() {
        return this.fieldNewInteractionSpec;
    }

    public Object getOutput() {
        return this.fieldOutput;
    }

    public Command getParentCommand() {
        return this.fieldParentCommand;
    }

    public boolean isDisconnectInteraction() {
        return this.disconnectInteraction;
    }

    private void logError(String msg) {
        if (this.fieldParentCommand.isCcf2Command()) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logError(msg);
        }
    }

    private void logTraceInfo(String msg) {
        if (this.fieldParentCommand.isCcf2Command()) {
            if (this.logWriter != null) {
                this.logWriter.println(msg);
                this.logWriter.flush();
            }
        } else {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(msg);
        }
    }

    private void newAfterExecute(CommandEvent commandEvent) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent)]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (commandEvent.getPropertyNamed("__ComIbmIvjEabCommand_Exception") != null) {
            if (this.getInteraction() != null && !this.isExternalInteraction) {
                try {
                    this.getInteraction().close();
                    this.fieldConnection.close();
                }
                catch (Throwable throwable) {}
                this.fieldInteraction = null;
            }
            return;
        }
        Interaction interaction = null;
        if (!this.getInternalBeforeAfter()) {
            if (!this.isExternalInteraction && this.isDisconnectInteraction() && this.getInteraction() != null) {
                try {
                    this.getInteraction().close();
                    this.fieldInteraction = null;
                    this.fieldConnection.close();
                }
                catch (ResourceException resourceException) {
                    if (currentTrace >= 1) {
                        this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent) error: Unable to stop communication.]");
                    }
                    throw new CommandException(resCommandResourceBundle.getString("IVJC0866"));
                }
            }
            if ((interaction = this.getInteraction()) != null) {
                if (this.isExternalInteraction) {
                    commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Interaction", interaction);
                } else if (!this.isDisconnectInteraction()) {
                    commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Interaction", interaction);
                }
            }
        } else if (this.getInteraction() != null) {
            commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Interaction", this.getInteraction());
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent)]");
        }
    }

    private void newBeforeExecute(CommandEvent commandEvent) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent)]");
        }
        if (currentTrace >= 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        Interaction interaction = (Interaction)commandEvent.getPropertyNamed("__ComIbmIvjEabCommand_Interaction");
        if (!this.getInternalBeforeAfter()) {
            if (interaction != null) {
                this.fieldInteraction = interaction;
                this.isExternalInteraction = true;
            }
            if (this.getInteraction() == null && this.fieldConnectionFactoryConfiguration != null) {
                String res_ref_name = this.fieldConnectionFactoryConfiguration.getRes_ref_name();
                String res_type = this.fieldConnectionFactoryConfiguration.getRes_type();
                if (res_ref_name != null && !res_ref_name.equals(emptyString)) {
                    if (res_type == null || res_type.equals(emptyString)) {
                        this.logError(resCommandResourceBundle.getString("IVJC0873"));
                        throw new CommandException(resCommandResourceBundle.getString("IVJC0873"));
                    }
                    try {
                        block41: {
                            Hashtable<String, String> env = null;
                            InitialContext ctx = null;
                            String contextFactoryName = this.fieldConnectionFactoryConfiguration.getContextFactoryName();
                            if (contextFactoryName != null && !contextFactoryName.equals(emptyString)) {
                                env = new Hashtable<String, String>(11);
                                env.put("java.naming.factory.initial", contextFactoryName);
                            }
                            try {
                                ctx = env != null ? new InitialContext(env) : new InitialContext();
                                if (ctx == null) {
                                    this.logTraceInfo("Cannot create InitialContext");
                                    throw new NamingException();
                                }
                                this.fieldConnectionFactory = (ConnectionFactory)ctx.lookup(lookupPrefix + res_ref_name);
                                if (this.fieldConnectionFactory == null) {
                                    this.logTraceInfo("Lookup of the ConnectionFactory failed");
                                    throw new NamingException();
                                }
                                try {
                                    if (!Class.forName(res_type).isInstance(this.fieldConnectionFactory)) {
                                        this.logError(resCommandResourceBundle.getString("IVJC0867"));
                                        throw new CommandException(resCommandResourceBundle.getString("IVJC0867"));
                                    }
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    this.logError(resCommandResourceBundle.getString("IVJC0867"));
                                    throw new CommandException(resCommandResourceBundle.getString("IVJC0867"));
                                }
                                if (currentTrace >= 3) {
                                    this.logTraceInfo("JNDI lookup successfull: " + this.fieldConnectionFactory);
                                }
                                ctx.close();
                            }
                            catch (NamingException namingException) {
                                try {
                                    if (ctx == null) {
                                        throw new NamingException();
                                    }
                                    this.fieldConnectionFactory = (ConnectionFactory)ctx.lookup(res_ref_name);
                                    if (this.fieldConnectionFactory == null) {
                                        this.logTraceInfo("Lookup of the ConnectionFactory failed");
                                        throw new NamingException();
                                    }
                                    try {
                                        if (!Class.forName(res_type).isInstance(this.fieldConnectionFactory)) {
                                            this.logError(resCommandResourceBundle.getString("IVJC0867"));
                                            throw new CommandException(resCommandResourceBundle.getString("IVJC0867"));
                                        }
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        this.logError(resCommandResourceBundle.getString("IVJC0867"));
                                        throw new CommandException(resCommandResourceBundle.getString("IVJC0867"));
                                    }
                                    if (currentTrace >= 3) {
                                        this.logTraceInfo("JNDI lookup successfull: " + this.fieldConnectionFactory);
                                    }
                                    ctx.close();
                                }
                                catch (NamingException namingException2) {
                                    if (currentTrace >= 1) {
                                        this.logTraceInfo("Naming exception during ConnectionFactory lookup");
                                    }
                                    ManagedConnectionFactory mcf = null;
                                    try {
                                        mcf = this.fieldConnectionFactoryConfiguration.getManagedConnectionFactory();
                                    }
                                    catch (ResourceException rexn1) {
                                        this.logError(resCommandResourceBundle.getString("IVJC0870"));
                                        throw new CommandException(String.valueOf(resCommandResourceBundle.getString("IVJC0870")) + " " + rexn1.getLocalizedMessage());
                                    }
                                    if (mcf != null) {
                                        try {
                                            this.fieldConnectionFactory = (ConnectionFactory)mcf.createConnectionFactory();
                                            break block41;
                                        }
                                        catch (ResourceException resourceException) {
                                            this.logError(resCommandResourceBundle.getString("IVJC0869"));
                                            throw new CommandException(resCommandResourceBundle.getString("IVJC0869"));
                                        }
                                    }
                                    this.logError(resCommandResourceBundle.getString("IVJC0869"));
                                    throw new CommandException(resCommandResourceBundle.getString("IVJC0869"));
                                }
                            }
                        }
                        javax.resource.cci.ConnectionSpec userConnectionSpec = this.fieldConnectionFactoryConfiguration.getConnectionSpec();
                        this.fieldConnection = userConnectionSpec != null ? this.fieldConnectionFactory.getConnection(userConnectionSpec) : this.fieldConnectionFactory.getConnection();
                        this.fieldInteraction = this.fieldConnection.createInteraction();
                    }
                    catch (ResourceException resourceException) {
                        this.logError(resCommandResourceBundle.getString("IVJC0870"));
                        throw new CommandException(resCommandResourceBundle.getString("IVJC0870"));
                    }
                }
                ManagedConnectionFactory mcf = null;
                try {
                    mcf = this.fieldConnectionFactoryConfiguration.getManagedConnectionFactory();
                }
                catch (ResourceException rexn1) {
                    this.logError(resCommandResourceBundle.getString("IVJC0870"));
                    throw new CommandException(String.valueOf(resCommandResourceBundle.getString("IVJC0870")) + " " + rexn1.getLocalizedMessage());
                }
                if (mcf != null) {
                    try {
                        this.fieldConnectionFactory = (ConnectionFactory)mcf.createConnectionFactory();
                        javax.resource.cci.ConnectionSpec userConnectionSpec = this.fieldConnectionFactoryConfiguration.getConnectionSpec();
                        this.fieldConnection = userConnectionSpec != null ? this.fieldConnectionFactory.getConnection(userConnectionSpec) : this.fieldConnectionFactory.getConnection();
                        this.fieldInteraction = this.fieldConnection.createInteraction();
                    }
                    catch (ResourceException ex1) {
                        this.logError(resCommandResourceBundle.getString("IVJC0870"));
                        throw new CommandException(String.valueOf(resCommandResourceBundle.getString("IVJC0870")) + " " + ex1.getLocalizedMessage());
                    }
                }
            }
        } else if (interaction != null) {
            this.fieldInteraction = interaction;
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent)]");
        }
    }

    private void newExecute() {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute()]");
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (this.getInteraction() == null) {
            this.logError(resCommandResourceBundle.getString("IVJC0871"));
            throw new CommandException(resCommandResourceBundle.getString("IVJC0871"));
        }
        if (this.getNewInteractionSpec() == null) {
            this.logError(resCommandResourceBundle.getString("IVJC0865__InteractionSpeci"));
            throw new CommandException(resCommandResourceBundle.getString("IVJC0865__InteractionSpeci"));
        }
        try {
            this.getInteraction().execute(this.getNewInteractionSpec(), (Record)this.getInput(), (Record)this.getOutput());
        }
        catch (ResourceException exn1) {
            block14: {
                if (currentTrace >= 1) {
                    this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: execute throws ResourceException]");
                }
                try {
                    this.getInteraction().close();
                    if (this.fieldConnection != null) {
                        this.fieldConnection.close();
                    }
                }
                catch (ResourceException resourceException) {
                    if (currentTrace < 1) break block14;
                    this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: close after exception in exectue failed]");
                }
            }
            throw new CommandException(String.valueOf(resCommandResourceBundle.getString("IVJC0872")) + " " + exn1.getMessage());
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute()]");
        }
    }

    private void oldAfterExecute(CommandEvent commandEvent) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent)]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (commandEvent.getPropertyNamed("__ComIbmIvjEabCommand_Exception") != null) {
            if (this.getCommunication() != null && !this.fieldIsExternalCommunication) {
                try {
                    this.getCommunication().disconnect();
                }
                catch (Throwable throwable) {}
                this.fieldCommunication = null;
            }
            return;
        }
        Communication communication = null;
        if (!this.getInternalBeforeAfter()) {
            if (!this.fieldIsExternalCommunication && this.getDisconnectCommunication() && this.getCommunication() != null) {
                try {
                    this.getCommunication().disconnect();
                    this.fieldCommunication = null;
                }
                catch (NotConnectedException notConnectedException) {
                }
                catch (CommunicationException communicationException) {
                    if (currentTrace >= 1) {
                        this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent) error: Unable to stop communication.]");
                    }
                    throw new RuntimeException(resCommandResourceBundle.getString("IVJC0855__Unable_to_stop_c"));
                }
            }
            if ((communication = this.getCommunication()) != null) {
                if (this.fieldIsExternalCommunication) {
                    commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Communication", communication);
                } else if (!this.getDisconnectCommunication()) {
                    commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Communication", communication);
                }
            }
        } else if (this.getCommunication() != null) {
            commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Communication", this.getCommunication());
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent)]");
        }
    }

    private void oldBeforeExecute(CommandEvent commandEvent) {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent)]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        Communication communication = (Communication)commandEvent.getPropertyNamed("__ComIbmIvjEabCommand_Communication");
        if (!this.getInternalBeforeAfter()) {
            if (communication != null) {
                this.fieldCommunication = communication;
                this.fieldIsExternalCommunication = true;
            }
            if (this.getCommunication() == null && this.getConnectionSpec() != null) {
                this.fieldCommunication = this.getConnectionSpec().createCommunication();
                try {
                    this.getCommunication().connect();
                }
                catch (LogonException ex1) {
                    if (currentTrace >= 1) {
                        this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws LogonException]");
                    }
                    throw ex1;
                }
                catch (NoConnectionAvailableException ex2) {
                    if (currentTrace >= 1) {
                        this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws NoConnectionAvailableException]");
                    }
                    throw ex2;
                }
                catch (AlreadyConnectedException ex3) {
                    if (currentTrace >= 1) {
                        this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws AlreadyConnectedException]");
                    }
                    throw ex3;
                }
                catch (CommunicationException ex4) {
                    if (currentTrace >= 1) {
                        this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws CommunicationException]");
                    }
                    throw ex4;
                }
            }
        } else if (communication != null) {
            this.fieldCommunication = communication;
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent)]");
        }
    }

    private void oldExecute() {
        int currentTrace = this.getCurrentTraceLevel();
        if (currentTrace >= 2) {
            this.logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute()]");
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (this.getCommunication() == null) {
            this.logError(resCommandResourceBundle.getString("IVJC0864__Communication_no"));
            if (currentTrace >= 1) {
                this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: Communication not provided]");
            }
            throw new ExecutionException(resCommandResourceBundle.getString("IVJC0864__Communication_no"));
        }
        if (this.getInteractionSpec() == null) {
            this.logError(resCommandResourceBundle.getString("IVJC0865__InteractionSpeci"));
            if (currentTrace >= 1) {
                this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: InteractionSpecification not provided]");
            }
            throw new ExecutionException(resCommandResourceBundle.getString("IVJC0865__InteractionSpeci"));
        }
        try {
            this.getCommunication().execute(this.getInteractionSpec(), this.getInput(), this.getOutput());
        }
        catch (ConnectorException exception) {
            block15: {
                if (currentTrace >= 1) {
                    this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: execute throws ConnectorException]");
                }
                try {
                    this.getCommunication().disconnect();
                }
                catch (Exception exception2) {
                    if (currentTrace < 1) break block15;
                    this.logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: disconnect after exception in exectue failed]");
                }
            }
            throw exception;
        }
        if (currentTrace >= 4) {
            this.logTraceInfo(this.toString());
        }
        if (currentTrace == 3) {
            this.logTraceInfo(this.toStringShort());
        }
        if (currentTrace >= 2) {
            this.logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute()]");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.removePropertyChangeListener(arg1);
    }

    public void setCommunication(Communication communication) {
        this.fieldIsExternalCommunication = true;
        Communication oldValue = this.fieldCommunication;
        this.fieldCommunication = communication;
        this.firePropertyChange("communication", oldValue, communication);
    }

    public void setConnectionFactoryConfiguration(IConnectionFactoryConfiguration connectionSpec) {
        IConnectionFactoryConfiguration oldValue = this.fieldConnectionFactoryConfiguration;
        this.fieldConnectionFactoryConfiguration = connectionSpec;
        this.firePropertyChange("connectionSpec", oldValue, connectionSpec);
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        ConnectionSpec oldValue = this.fieldConnectionSpec;
        this.fieldConnectionSpec = connectionSpec;
        this.firePropertyChange("connectionSpec", oldValue, connectionSpec);
    }

    public void setDisconnectCommunication(boolean disconnectCommunication) {
        boolean oldValue = this.fieldDisconnectCommunication;
        this.fieldDisconnectCommunication = disconnectCommunication;
        this.firePropertyChange("disconnectCommunication", new Boolean(oldValue), new Boolean(disconnectCommunication));
    }

    public void setDisconnectInteraction(boolean newDisconnectInteraction) {
        this.disconnectInteraction = newDisconnectInteraction;
    }

    public void setInput(Object input) {
        Object oldValue = this.fieldInput;
        this.fieldInput = input;
        this.firePropertyChange("input", oldValue, input);
    }

    public void setInteraction(Interaction interaction) {
        this.isExternalInteraction = true;
        Interaction oldValue = this.fieldInteraction;
        this.fieldInteraction = interaction;
        this.firePropertyChange("interaction", oldValue, interaction);
    }

    public void setInteractionSpec(com.ibm.connector.InteractionSpec interactionSpec) {
        com.ibm.connector.InteractionSpec oldValue = this.fieldInteractionSpec;
        this.fieldInteractionSpec = interactionSpec;
        this.firePropertyChange("interactionSpec", oldValue, interactionSpec);
    }

    public void setInternalBeforeAfter(boolean internalBeforeAfter) {
        boolean oldValue = this.fieldInternalBeforeAfter;
        this.fieldInternalBeforeAfter = internalBeforeAfter;
        this.firePropertyChange("internalBeforeAfter", new Boolean(oldValue), new Boolean(internalBeforeAfter));
    }

    protected void setLogWriter(PrintWriter newLogWriter) {
        this.logWriter = newLogWriter;
    }

    public void setNewInteractionSpec(InteractionSpec interactionSpec) {
        InteractionSpec oldValue = this.fieldNewInteractionSpec;
        this.fieldNewInteractionSpec = interactionSpec;
        this.firePropertyChange("interactionSpec", oldValue, interactionSpec);
    }

    public void setOutput(Object output) {
        if (this.fieldOutput == null) {
            Object oldValue = this.fieldOutput;
            this.fieldOutput = output;
            this.firePropertyChange("output", oldValue, output);
        } else {
            try {
                SelectorRecord cfr_ignored_0 = (SelectorRecord)this.fieldOutput;
                return;
            }
            catch (ClassCastException classCastException) {
                Object oldValue = this.fieldOutput;
                this.fieldOutput = output;
                this.firePropertyChange("output", oldValue, output);
            }
        }
    }

    public void setParentCommand(Command parentCommand) {
        Command oldValue = this.fieldParentCommand;
        this.fieldParentCommand = parentCommand;
        this.firePropertyChange("parentCommand", oldValue, parentCommand);
    }

    public String toString() {
        String dumpString = emptyString;
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive]");
            BeanDumper.setIndentation("        ");
            pwrtr.println("      fieldInput: ");
            if (this.fieldInput != null) {
                pwrtr.println("        [" + BeanDumper.toString(this.fieldInput) + "        ]");
            } else {
                pwrtr.println("        [null]");
            }
            pwrtr.println("      fieldOutput: ");
            if (this.fieldOutput != null) {
                pwrtr.println("        [" + BeanDumper.toString(this.fieldOutput) + "        ]");
            } else {
                pwrtr.println("        [null]");
            }
            pwrtr.println("      fieldInteractionSpec: ");
            if (this.fieldInteractionSpec != null) {
                pwrtr.println("        [" + BeanDumper.toString(this.fieldInteractionSpec) + "        ]");
            } else {
                pwrtr.println("        [null]");
            }
            BeanDumper.setIndentation("    ");
            pwrtr.println("      fieldDisconnectCommunication: ");
            pwrtr.println("        [" + new Boolean(this.disconnectInteraction).toString() + "        ]");
            pwrtr.println("      fieldInternalBeforeAfter: ");
            pwrtr.println("        [" + new Boolean(this.fieldInternalBeforeAfter).toString() + "        ]");
            pwrtr.println("      fieldIsExternalCommunication: ");
            pwrtr.println("        [" + new Boolean(this.isExternalInteraction).toString() + "        ]");
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }

    public String toStringShort() {
        String dumpString = emptyString;
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive]");
            BeanDumper.setIndentation("        ");
            pwrtr.println("      fieldInput: ");
            if (this.fieldInput != null) {
                pwrtr.println("        [" + this.fieldInput.getClass().getName() + "@" + this.fieldInput.hashCode() + "        ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            pwrtr.println("      fieldOutput: ");
            if (this.fieldOutput != null) {
                pwrtr.println("        [" + this.fieldOutput.getClass().getName() + "@" + this.fieldOutput.hashCode() + "        ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            pwrtr.println("      fieldConnectionSpec: ");
            if (this.fieldConnectionSpec != null) {
                pwrtr.println("        [" + this.fieldConnectionSpec.getClass().getName() + "@" + this.fieldConnectionSpec.hashCode() + "        ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            pwrtr.println("      fieldInteractionSpec: ");
            if (this.fieldInteractionSpec != null) {
                pwrtr.println("        [" + this.fieldInteractionSpec.getClass().getName() + "@" + this.fieldInteractionSpec.hashCode() + "        ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            pwrtr.println("      fieldCommunication: ");
            if (this.fieldCommunication != null) {
                pwrtr.println("        [" + this.fieldCommunication.getClass().getName() + "@" + this.fieldCommunication.hashCode() + "        ]");
            } else {
                pwrtr.println("        [ null ]");
            }
            BeanDumper.setIndentation("    ");
            pwrtr.println("      fieldDisconnectCommunication: ");
            pwrtr.println("        [" + new Boolean(this.fieldDisconnectCommunication).toString() + "        ]");
            pwrtr.println("      fieldInternalBeforeAfter: ");
            pwrtr.println("        [" + new Boolean(this.fieldInternalBeforeAfter).toString() + "        ]");
            pwrtr.println("      fieldIsExternalCommunication: ");
            pwrtr.println("        [" + new Boolean(this.fieldIsExternalCommunication).toString() + "        ]");
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }
}

