/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.businessobject;

import com.ibm.ivj.eab.businessobject.IInstanceSpace;
import com.ibm.ivj.eab.businessobject.SimpleInstanceSpace;
import com.ibm.ivj.eab.util.Set;
import java.util.Enumeration;
import java.util.Hashtable;

public class StructuredInstanceSpace
implements IInstanceSpace {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    private Hashtable instanceSpaces;

    public StructuredInstanceSpace() {
        this.removeAllInstances();
    }

    public Object addInstance(Object object) {
        try {
            return this.getInstanceSpace(object.getClass()).addInstance(object);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Object getInstance(Object object) {
        try {
            SimpleInstanceSpace instanceSpace = (SimpleInstanceSpace)this.instanceSpaces.get(object.getClass());
            return instanceSpace.getInstance(object);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Enumeration getInstances() {
        Set result = new Set();
        Enumeration instanceSpaceEnumeration = this.instanceSpaces.elements();
        while (instanceSpaceEnumeration.hasMoreElements()) {
            SimpleInstanceSpace instanceSpace = (SimpleInstanceSpace)instanceSpaceEnumeration.nextElement();
            Enumeration instanceEnumeration = instanceSpace.getInstances();
            while (instanceEnumeration.hasMoreElements()) {
                result.add(instanceEnumeration.nextElement());
            }
        }
        return result.elements();
    }

    private SimpleInstanceSpace getInstanceSpace(Class objectClass) {
        SimpleInstanceSpace result = (SimpleInstanceSpace)this.instanceSpaces.get(objectClass);
        if (result == null) {
            result = new SimpleInstanceSpace();
            this.instanceSpaces.put(objectClass, result);
        }
        return result;
    }

    public void removeAllInstances() {
        this.instanceSpaces = new Hashtable();
    }

    public Object removeInstance(Object object) {
        try {
            return this.getInstanceSpace(object.getClass()).removeInstance(object);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String toString() {
        String result = super.toString().concat("\n");
        Enumeration instanceSpaceEnumeration = this.instanceSpaces.elements();
        while (instanceSpaceEnumeration.hasMoreElements()) {
            result = result.concat(String.valueOf(instanceSpaceEnumeration.nextElement().toString()) + "\n");
        }
        return result;
    }
}

