/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.businessobject;

import com.ibm.ivj.eab.businessobject.BusinessObjectKey;
import com.ibm.ivj.eab.businessobject.IBusinessObject;
import com.ibm.ivj.eab.businessobject.IBusinessObjectKey;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class BusinessObject
implements IBusinessObject,
Serializable {
    static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = 4971184561897981725L;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private IBusinessObjectKey key;

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public final Object clone() {
        if (this.getKey() == null) {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return this;
            }
        }
        return this;
    }

    public final boolean equals(Object object) {
        try {
            BusinessObject businessObject = (BusinessObject)object;
            return this.getKey().equals(businessObject.getKey());
        }
        catch (Exception exception) {
            return super.equals(object);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChange.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final IBusinessObjectKey getKey() {
        return this.key;
    }

    public final Class getKeyClass() {
        try {
            String keyClassName = this.getClass().getName().concat("Key");
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> keyClass = null;
            if (loader != null) {
                keyClass = loader.loadClass(keyClassName);
            }
            if (keyClass == null) {
                keyClass = Class.forName(keyClassName);
            }
            return keyClass;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
    }

    public final int hashCode() {
        return this.getKey() == null ? super.hashCode() : this.getKey().hashCode();
    }

    public boolean isPropertyValid(String propertyName) {
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    protected final void setKey(IBusinessObjectKey key) throws IllegalArgumentException {
        if (key.getClass() != this.getKeyClass()) {
            throw new IllegalArgumentException();
        }
        this.key = key;
    }

    public String toString() {
        BusinessObjectKey key;
        try {
            key = (BusinessObjectKey)this.getKey();
        }
        catch (ClassCastException classCastException) {
            key = null;
        }
        if (key == null) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append(" [");
        buffer.append(key.getPropertyString());
        buffer.append("]");
        return buffer.toString();
    }
}

