/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.dwlm.client;

import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ProtocolMap
implements Externalizable {
    public static final ProtocolMap DIRECT = new ProtocolMap("direct", 0);
    public static final ProtocolMap SSL_OFFLOAD = new ProtocolMap("SSL-offload", 1);
    public static final ProtocolMap SSL_ONLOAD = new ProtocolMap("SSL-onload", 2);
    public static ProtocolMap[] ALL = new ProtocolMap[]{DIRECT, SSL_OFFLOAD, SSL_ONLOAD};
    private static final String HTTP = HttpConstants.SCHEME_HTTP.getName();
    private static final String HTTPS = HttpConstants.SCHEME_HTTPS.getName();
    private String name;
    private int index;

    public static ProtocolMap findByName(String string) {
        for (int i = 0; i < ALL.length; ++i) {
            if (!string.equalsIgnoreCase(ALL[i].getName())) continue;
            return ALL[i];
        }
        return null;
    }

    private ProtocolMap(String string, int n) {
        this.name = string;
        this.index = n;
    }

    public ProtocolMap() {
    }

    public String getName() {
        return this.name;
    }

    public String mapProtocol(String string) {
        switch (this.index) {
            case 0: {
                return string;
            }
            case 1: {
                if (string.equals(HTTP)) {
                    return HTTP;
                }
                if (string.equals(HTTPS)) {
                    return HTTP;
                }
                throw new IllegalArgumentException("invalid protocol: " + string);
            }
            case 2: {
                if (string.equals(HTTP)) {
                    return HTTPS;
                }
                if (string.equals(HTTPS)) {
                    return HTTPS;
                }
                throw new IllegalArgumentException("invalid protocol: " + string);
            }
        }
        throw new IllegalStateException("invalid index: " + this.index);
    }

    public String toString() {
        return this.name;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeInt(this.index);
        objectOutput.writeObject(this.name);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        objectInput.readInt();
        this.index = objectInput.readInt();
        this.name = (String)objectInput.readObject();
    }
}

