/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.List;

public class URIMatcher {
    private static final TraceComponent tc = Tr.register((Class)URIMatcher.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");
    private static final boolean DEBUG = Boolean.getBoolean(System.getProperty("com.ibm.ws.dwlm.client.debug", "false"));
    public static final int STAR = 0;
    protected final String name;
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    private static final Suffix[] EMPTY_SUFFIX_ARRAY = new Suffix[0];
    protected final Node root;

    public URIMatcher(String string) {
        this.name = string;
        this.root = new Node("", null, null);
    }

    public Object put(String string, Object object) throws Exception {
        boolean bl;
        String string2;
        String string3;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{string, object});
        }
        Object object2 = null;
        Object object3 = null;
        if (string.length() != 0 && !string.startsWith("/")) {
            string = "/" + string;
        }
        if ((n = string.indexOf("*")) < 0) {
            object2 = object;
            string3 = string;
            string2 = null;
        } else if (n == string.length() - 1) {
            if (string.endsWith("/*")) {
                this.put(string.substring(0, string.length() - 2), object);
            }
            string3 = string.substring(0, n);
            object3 = object;
            string2 = null;
        } else if (n == 1) {
            string3 = "/";
            string2 = string.substring(n + 1);
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        if (DEBUG) {
            System.out.println("prefix=" + string3);
        }
        Node node = this.root;
        int n2 = 0;
        do {
            bl = false;
            for (int i = 0; i < node.children.length; ++i) {
                Node node2 = node.children[i];
                int n3 = node2.getMatchLen(string3, n2);
                if (DEBUG) {
                    System.out.println(string3 + ":" + n2 + ",matchTo:" + node2.name + ",matchLen=" + n3);
                }
                if (n3 <= 0) continue;
                if (n3 < node2.chars.length) {
                    node.removeChild(node2);
                    String string4 = string.substring(n2, n2 + n3);
                    Node node3 = new Node(string4, node.exactTarget, node.prefixTarget);
                    node.addChild(node3);
                    node = node3;
                    String string5 = node2.name.substring(n3);
                    Node node4 = new Node(string5, node2.exactTarget, node2.prefixTarget);
                    node3.addChild(node4);
                    for (int j = 0; j < node2.children.length; ++j) {
                        node4.addChild(node2.children[j]);
                    }
                    if (DEBUG) {
                        System.out.println("newParent=" + string4 + ", newChild=" + string5);
                    }
                } else {
                    node = node2;
                    bl = true;
                    if (DEBUG) {
                        System.out.println("search deeper " + node);
                    }
                }
                n2 += n3;
            }
        } while (bl);
        if (DEBUG) {
            System.out.println("matched node = " + node);
        }
        if (n2 < string3.length()) {
            Node node5 = new Node(string3.substring(n2), object2, object3);
            node.addChild(node5);
            node = node5;
            if (DEBUG) {
                System.out.println("add new child = " + node5);
            }
        }
        if (string2 != null) {
            if (DEBUG) {
                System.out.println("add suffix");
            }
            node.addSuffix(string2, object);
        } else if (object2 != null) {
            if (DEBUG) {
                System.out.println("exact target=" + object + " for " + node);
            }
            this.putExactTarget(node, object);
        } else if (object3 != null) {
            if (DEBUG) {
                System.out.println("exact target=" + object + " for " + node);
            }
            this.putPrefixTarget(node, object);
        } else {
            throw new IllegalStateException("neither exact, prefix, nor suffix");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put", (Object)string);
        }
        return null;
    }

    public Object match(String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"match", (Object)string);
        }
        int n = 0;
        Node[] nodeArray = this.root.children;
        Object object = null;
        Object object2 = null;
        int n2 = string.length();
        block0: do {
            bl = false;
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node = nodeArray[i];
                int n3 = node.getMatchLen(string, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("child=" + node + ", len=" + n3));
                }
                if (n3 != node.chars.length) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("matched " + node));
                }
                bl = true;
                if (node.exactTarget != null && (n += n3) >= n2) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"match", (Object)("exact match of " + node.exactTarget));
                    }
                    return node.exactTarget;
                }
                Suffix[] suffixArray = node.suffixes;
                if (suffixArray != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"checking suffixes");
                    }
                    for (int j = 0; j < suffixArray.length; ++j) {
                        Suffix suffix = suffixArray[j];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("suffix=" + suffix));
                        }
                        if (!string.endsWith(suffix.suffix)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("suffix match for " + suffix.target));
                        }
                        object2 = suffix.target;
                        break;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"checking prefixes");
                }
                if (node.prefixTarget != null) {
                    object = node.prefixTarget;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("prefixTarget=" + object));
                    }
                }
                nodeArray = node.children;
                continue block0;
            }
        } while (bl);
        if (object2 != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"match", (Object)("suffix match of " + object2));
            }
            return object2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"match", (Object)("prefix match of " + object));
        }
        return object;
    }

    protected void putExactTarget(Node node, Object object) throws Exception {
        if (node.exactTarget != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("target clash between '" + node.exactTarget + "' and '" + object + "'"));
            }
        } else {
            node.exactTarget = object;
        }
    }

    protected void putPrefixTarget(Node node, Object object) throws Exception {
        if (node.prefixTarget != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("target clash between '" + node.prefixTarget + "' and '" + object + "'"));
            }
        } else {
            node.prefixTarget = object;
        }
    }

    protected void putSuffixTarget(Suffix suffix, Object object) throws Exception {
        if (suffix.target != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("target clash between '" + suffix.target + "' and '" + object + "'"));
            }
        } else {
            suffix.target = object;
        }
    }

    public String toString() {
        if (DEBUG) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("BEGIN URIMatcher: ").append(this.name).append("\n");
            this.toString(this.root, "", stringBuffer);
            stringBuffer.append("END URIMatcher: ").append(this.name);
            return stringBuffer.toString();
        }
        return this.name;
    }

    private void toString(Node node, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string).append(node.toString()).append("\n");
        string = string + "   ";
        for (int i = 0; i < node.children.length; ++i) {
            this.toString(node.children[i], string, stringBuffer);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        URIMatcher uRIMatcher = new URIMatcher("test");
        String[] stringArray2 = new String[]{"/*", "/trade/*", "/trade/*.jsp", "/trade/servlet/PingServlet", "/trade/servlet/PingServlet2Jsp", "/trade/servlet/SnoopServlet", "/trade/servlet/*"};
        for (int i = 0; i < stringArray2.length; ++i) {
            uRIMatcher.put(stringArray2[i], stringArray2[i]);
        }
        System.out.println(uRIMatcher);
        String[] stringArray3 = new String[]{"/", "/foo/bar", "/trade/servlet/PingServlet", "/trade/servlet/FooServlet", "/trade", "/trade/servlet/SnoopServlet", "/trade/foobar"};
        for (int i = 0; i < stringArray3.length; ++i) {
            System.out.println(stringArray3[i] + " matches " + uRIMatcher.match(stringArray3[i]));
        }
    }

    protected class Suffix {
        public final Node node;
        public final String suffix;
        public Object target = null;

        public Suffix(Node node, String string) {
            this.node = node;
            this.suffix = string;
        }

        public String toString() {
            return this.suffix;
        }
    }

    protected class Node {
        public final String name;
        public final char[] chars;
        public Object exactTarget = null;
        public Object prefixTarget = null;
        public Node[] children = URIMatcher.access$000();
        private final List childList = new ArrayList();
        public Suffix[] suffixes = null;
        private final List suffixList = new ArrayList();

        public Node(String string, Object object, Object object2) {
            this.name = string;
            this.chars = string.toCharArray();
            this.exactTarget = object;
            this.prefixTarget = object2;
        }

        public int getMatchLen(String string, int n) {
            int n2 = string.length();
            for (int i = 0; i < this.chars.length; ++i) {
                char c;
                if (n >= n2) {
                    return i;
                }
                if ((c = string.charAt(n++)) == this.chars[i]) continue;
                return i;
            }
            return this.chars.length;
        }

        public void addChild(Node node) {
            if (DEBUG) {
                System.out.println("add child " + node + " to " + this);
            }
            this.childList.add(node);
            this.children = this.childList.toArray(EMPTY_NODE_ARRAY);
        }

        public void removeChild(Node node) {
            this.childList.remove(node);
            this.children = this.childList.toArray(EMPTY_NODE_ARRAY);
        }

        public synchronized void addSuffix(String string, Object object) throws Exception {
            Suffix suffix = null;
            boolean bl = true;
            if (this.suffixes != null) {
                for (int i = 0; i < this.suffixes.length; ++i) {
                    if (!this.suffixes[i].equals(string)) continue;
                    suffix = this.suffixes[i];
                    bl = false;
                }
            }
            if (suffix == null) {
                suffix = new Suffix(this, string);
            }
            URIMatcher.this.putSuffixTarget(suffix, object);
            if (bl) {
                this.suffixList.add(suffix);
                this.suffixes = this.suffixList.toArray(EMPTY_SUFFIX_ARRAY);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append(",exact=").append(this.exactTarget).append(",prefix=").append(this.prefixTarget).append(")");
            return stringBuffer.toString();
        }
    }
}

