/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.ws.dwlm.client.TargetDescriptorImpl;
import com.ibm.ws.dwlm.client.TargetObjectImpl;
import com.ibm.ws.dwlm.client.TargetSelectorImpl;
import com.ibm.ws.dwlm.client.TargetServerApplicationImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TargetServerImpl
extends TargetObjectImpl
implements TargetServer {
    protected static final TraceComponent tc = Tr.register((Class)TargetServerImpl.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");
    protected static final TargetCluster[] NO_CLUSTER = new TargetCluster[0];
    protected static final TargetDescriptorImpl[] NO_DESCRIPTORS = new TargetDescriptorImpl[0];
    protected static final TargetServerApplicationImpl[] NO_APPLICATIONS = new TargetServerApplicationImpl[0];
    protected static final String[] NO_STRINGS = new String[0];
    protected final TargetSelectorImpl selector;
    protected final ODCHelper odc;
    protected ODCNode odcServer;
    protected ODCTree odcTree;
    protected final String cloneId;
    protected int weight;
    protected boolean reachable;
    protected final ChannelFramework channelFramework;
    protected final List chainNames = new ArrayList();
    protected final List channelNames = new ArrayList();
    protected final Map outboundSSLProps;
    protected boolean local;
    protected TargetDescriptorImpl[] descriptors = NO_DESCRIPTORS;
    protected TargetServerApplicationImpl[] serverApps = NO_APPLICATIONS;
    protected final ArrayList serverAppsList = new ArrayList();
    protected long nextWait = 50L;
    protected long nextRetry;
    ArrayList clusters = new ArrayList();
    protected static final long MIN_WAIT = 50L;
    protected static final long MAX_WAIT = 60000L;
    protected static final long MULTIPLIER = 10L;

    public TargetServerImpl(ODCNode oDCNode, Map map, ChannelFramework channelFramework, TargetSelectorImpl targetSelectorImpl) throws Exception {
        super(oDCNode.getLongName());
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TargetServerImpl", (Object)new Object[]{oDCNode, channelFramework});
        }
        this.selector = targetSelectorImpl;
        this.odc = ODCHelper.getInstance();
        this.odcServer = oDCNode;
        this.odcTree = oDCNode.getTree();
        this.cloneId = (String)oDCNode.getProperty(this.odc.serverCloneId);
        this.weight = oDCNode.getIntProperty(this.odc.serverWeight);
        this.reachable = true;
        this.outboundSSLProps = map;
        this.channelFramework = channelFramework;
        this.local = TargetTree.getMyServer().equals(oDCNode);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TargetServerImpl");
        }
    }

    public void init() throws Exception {
        this.buildTargetDescriptors();
    }

    public ODCNode getMyODCNode() {
        if (this.odcServer.getTree() == null) {
            this.odcServer = this.odcTree.refreshNode(this.odcServer);
        }
        return this.odcServer;
    }

    public TargetCluster[] getClusters() {
        return this.clusters.toArray(NO_CLUSTER);
    }

    public String getCloneId() {
        return this.cloneId;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
        if (n != 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("weight is " + n + " for " + this));
            }
            try {
                this.addToAllClusters();
            }
            catch (Throwable throwable) {
                TrUtil.warning((Throwable)throwable, (Object)this, (String)"setWeight", (TraceComponent)tc);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("weight is 0 for " + this));
            }
            this.removeFromAllClusters();
        }
    }

    public TargetServerApplicationImpl[] getServerApplications() {
        return this.serverApps;
    }

    public boolean hasNoDescriptors() {
        return this.descriptors.length == 0;
    }

    public synchronized TargetDescriptor getTargetDescriptor(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTargetDescriptor", (Object)string);
        }
        TargetDescriptorImpl targetDescriptorImpl = null;
        for (int i = 0; i < this.descriptors.length; ++i) {
            TargetDescriptorImpl targetDescriptorImpl2 = this.descriptors[i];
            if (!targetDescriptorImpl2.protocol.equals(string)) continue;
            if (!this.local || targetDescriptorImpl2.isLocal()) {
                targetDescriptorImpl2.obtainRefCount();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getTargetDescriptor", (Object)targetDescriptorImpl2);
                }
                return targetDescriptorImpl2;
            }
            targetDescriptorImpl = targetDescriptorImpl2;
        }
        if (targetDescriptorImpl != null) {
            targetDescriptorImpl.obtainRefCount();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTargetDescriptor", (Object)targetDescriptorImpl);
        }
        return targetDescriptorImpl;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isAvailable() {
        return this.isUp() && this.isReachable();
    }

    public boolean isUp() {
        return this.weight > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReachable() {
        if (this.reachable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("is reachable: " + this.getName()));
            }
            return true;
        }
        long l = System.currentTimeMillis();
        TargetServerImpl targetServerImpl = this;
        synchronized (targetServerImpl) {
            if (l >= this.nextRetry) {
                this.nextRetry = l + this.nextWait;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("try to reach: " + this.getName()));
                }
                return true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("is NOT reachable: " + this.getName()));
        }
        return false;
    }

    public void connectSuccess() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectSuccess", (Object)this.getName());
        }
        if (!this.reachable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"marking reachable: ", (Object)this.getName());
            }
            this.reachable = true;
            try {
                this.odcServer.setProperty(this.odc.serverReachable, (Object)Boolean.TRUE);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"136", (Object)throwable);
            }
            this.nextWait = 50L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectSuccess", (Object)this.getName());
        }
    }

    public void connectFailure() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectFailure", (Object)this.getName());
        }
        this.reachable = false;
        try {
            this.odcServer.setProperty(this.odc.serverReachable, (Object)Boolean.FALSE);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"243", (Object)throwable);
        }
        this.calculateNextRetry();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectFailure", (Object)this.getName());
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object)this);
        }
        this.removeFromAllClusters();
        this.releaseTargetDescriptors();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void addToAllClusters() throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToAllClusters", (Object)this);
        }
        if ((oDCNode = this.getMyODCNode()) != null) {
            ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.webModule);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                TargetCluster targetCluster = this.selector.getCluster(oDCNodeArray[i]);
                this.selector.addServerToCluster(this, targetCluster);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToAllClusters", (Object)this);
        }
    }

    public void removeFromAllClusters() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeFromAllClusters", (Object)this);
        }
        for (int i = 0; i < this.serverApps.length; ++i) {
            this.serverApps[i].removeFromAllClusters();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeFromAllClusters", (Object)this);
        }
    }

    public void buildTargetDescriptors() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"buildTargetDescriptors", (Object)this);
        }
        ArrayList<TargetDescriptorImpl> arrayList = new ArrayList<TargetDescriptorImpl>();
        ODCNode[] oDCNodeArray = this.odcServer.getNodes(this.odc.transport);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            ODCNode oDCNode = oDCNodeArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("transport=" + oDCNode));
            }
            if (oDCNode.getBooleanProperty(this.odc.transportODR)) continue;
            ODCNode[] oDCNodeArray2 = oDCNode.getNodes(this.odc.channelChain);
            for (int j = 0; j < oDCNodeArray2.length; ++j) {
                ODCNode oDCNode2 = oDCNodeArray2[j];
                try {
                    TargetDescriptorImpl targetDescriptorImpl = this.createTargetDescriptor(oDCNode2, oDCNode, this.outboundSSLProps, this.channelFramework);
                    arrayList.add(targetDescriptorImpl);
                    continue;
                }
                catch (Exception exception) {
                    Tr.warning((TraceComponent)tc, (String)"DWCT_Exception", (Object)exception);
                    FFDCFilter.processException((Throwable)exception, (String)"buildTargetDescriptors", (String)"283", (Object)this);
                }
            }
        }
        TargetDescriptorImpl[] targetDescriptorImplArray = arrayList.toArray(NO_DESCRIPTORS);
        if (this.descriptors.length == 0) {
            if (targetDescriptorImplArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"none-to-none");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"none-to-some");
                }
                this.setTargetDescriptors(targetDescriptorImplArray);
                this.addToAllClusters();
            }
        } else if (targetDescriptorImplArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"some-to-none");
            }
            this.removeFromAllClusters();
            this.setTargetDescriptors(targetDescriptorImplArray);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"some-to-some");
            }
            this.setTargetDescriptors(targetDescriptorImplArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildTargetDescriptors", (Object)this);
        }
    }

    protected synchronized void setTargetDescriptors(TargetDescriptorImpl[] targetDescriptorImplArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTargetDescriptors", (Object)new Object[]{targetDescriptorImplArray, this.descriptors});
        }
        this.releaseTargetDescriptors();
        this.descriptors = targetDescriptorImplArray;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTargetDescriptors");
        }
    }

    protected synchronized void releaseTargetDescriptors() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseTargetDescriptors", (Object)this);
        }
        for (int i = 0; i < this.descriptors.length; ++i) {
            try {
                this.descriptors[i].releaseRefCount();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"releaseTargetDescriptors", (String)"233", (Object)this);
            }
        }
        this.descriptors = NO_DESCRIPTORS;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseTargetDescriptors");
        }
    }

    public TargetServerApplicationImpl getServerApplication(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerApplication", (Object)string);
        }
        String string2 = string;
        string = EditionHelper.getAppAndEdition((String)string2)[0];
        for (int i = 0; i < this.serverApps.length; ++i) {
            if (!string.equals(this.serverApps[i].getApplicationName())) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerApplication", (Object)this.serverApps[i]);
            }
            return this.serverApps[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerApplication", (Object)"not found");
        }
        return null;
    }

    public synchronized void addServerApplication(TargetServerApplicationImpl targetServerApplicationImpl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("add serverapp " + targetServerApplicationImpl + " to " + this));
        }
        this.serverAppsList.add(targetServerApplicationImpl);
        this.serverApps = this.serverAppsList.toArray(NO_APPLICATIONS);
    }

    public synchronized void removeServerApplication(TargetServerApplicationImpl targetServerApplicationImpl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("remove serverapp " + targetServerApplicationImpl + " from " + this));
        }
        this.serverAppsList.remove(targetServerApplicationImpl);
        this.serverApps = this.serverAppsList.toArray(NO_APPLICATIONS);
    }

    public String toString() {
        return "name=" + this.getName() + ": weight=" + this.weight + " (" + super.toString() + ")";
    }

    protected TargetDescriptorImpl createTargetDescriptor(ODCNode oDCNode, ODCNode oDCNode2, Map map, ChannelFramework channelFramework) throws Exception {
        return new TargetDescriptorImpl(oDCNode, oDCNode2, map, channelFramework, this);
    }

    protected synchronized void calculateNextRetry() {
        this.nextWait = Math.min(60000L, this.nextWait * 10L);
        this.nextRetry = System.currentTimeMillis() + this.nextWait;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("nextWait=" + this.nextWait + "; nextRetry=" + this.nextRetry));
        }
    }
}

