/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.LoadBalancerModule;
import com.ibm.ws.dwlm.client.RoutingDebugRequestContextManager;
import com.ibm.ws.dwlm.client.TargetClusterImpl;
import com.ibm.ws.dwlm.client.TargetServerApplicationImpl;
import com.ibm.ws.dwlm.client.TargetServerImpl;
import com.ibm.ws.dwlm.client.Util;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.util.ApplicationQuiescer;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.dwlm.client.HttpTargetSelectorModule;
import com.ibm.wsspi.dwlm.client.ProtocolMap;
import com.ibm.wsspi.dwlm.client.RoutingDebugRequestContext;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetSelector;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.Properties;

public class TargetSelectorImpl
implements TargetSelector,
ODCListener {
    protected static final TraceComponent tc = Tr.register((Class)TargetSelectorImpl.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");
    protected static final String CLUSTER = "cluster";
    protected static final String SERVER = "server";
    protected static final String SERVER_APP = "serverApplication";
    protected final Properties outboundSSLProps;
    protected final ChannelFramework channelFramework;
    protected final ODCHelper odc;
    protected boolean started;
    protected ODCNode proxyContainer;
    protected ODCEdgeType server2WebModule;
    protected ODCEdgeType server2Transport;
    protected ODCEdgeType server2ServerApp;
    protected ODCTree targetTree = null;
    protected ODCEventType[] interestEvents;
    protected HttpTargetSelectorModule[] affinityModules = new HttpTargetSelectorModule[0];
    protected HttpTargetSelectorModule[] balancerModule = new HttpTargetSelectorModule[0];
    protected HttpTargetSelectorModule[] allModules = new HttpTargetSelectorModule[0];
    protected boolean sslOnload = false;
    protected boolean sslOffload = false;

    public TargetSelectorImpl(ODCTree oDCTree, Properties properties, ChannelFramework channelFramework) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor");
        }
        this.targetTree = oDCTree;
        this.outboundSSLProps = properties;
        this.channelFramework = channelFramework;
        this.odc = ODCHelper.getInstance();
        this.started = false;
        if (oDCTree == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"constructor", (Object)"disabled");
            }
            return;
        }
        this.proxyContainer = TargetTree.getMyProxyContainer();
        this.server2WebModule = this.odc.mgr.findEdgeType(this.odc.server, this.odc.webModule);
        this.server2Transport = this.odc.mgr.findEdgeType(this.odc.server, this.odc.transport);
        this.server2ServerApp = this.odc.mgr.findEdgeType(this.odc.server, this.odc.serverApplication);
        this.interestEvents = new ODCEventType[]{this.odc.serverWeight, this.odc.transportHost, this.odc.transportPort, this.odc.serverApplicationState, this.server2WebModule, this.server2Transport, this.server2ServerApp};
        ODCNode oDCNode = oDCTree.getRoot();
        Properties properties2 = oDCNode.getTransientProperties();
        Object object = properties2.get("ssl.offload");
        if (object != null) {
            this.sslOffload = (Boolean)object;
        }
        if ((object = properties2.get("ssl.onload")) != null) {
            this.sslOnload = (Boolean)object;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ssloffload=" + this.sslOffload + ", sslonload=" + this.sslOnload));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        if (this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start", (Object)"already started");
            }
            return;
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start", (Object)"disabled");
            }
            return;
        }
        this.loadHttpTargetSelectorModules(string);
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.targetTree.addListener((ODCListener)this);
            this.initWLM();
        }
        this.started = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public synchronized void stop() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        if (!this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stop", (Object)"not started");
            }
            return;
        }
        this.targetTree.removeListener((ODCListener)this);
        this.started = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public HttpTargetSelectorModule[] getAffinityModules() {
        return this.affinityModules;
    }

    public HttpTargetSelectorModule[] getLoadBalancerModule() {
        return this.balancerModule;
    }

    public HttpTargetSelectorModule[] getAllModules() {
        return this.allModules;
    }

    protected void loadHttpTargetSelectorModules(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadHttpTargetSelectorModules", (Object)string);
        }
        String[] stringArray = string.split(",");
        ArrayList<HttpTargetSelectorModule> arrayList = new ArrayList<HttpTargetSelectorModule>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loading " + stringArray[i]));
            }
            try {
                HttpTargetSelectorModule httpTargetSelectorModule = (HttpTargetSelectorModule)Class.forName(stringArray[i]).newInstance();
                httpTargetSelectorModule.registrationIndex = i;
                arrayList.add(httpTargetSelectorModule);
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("class load failure: " + throwable));
            }
        }
        this.affinityModules = arrayList.toArray(new HttpTargetSelectorModule[0]);
        HttpTargetSelectorModule httpTargetSelectorModule = this.createLoadBalancerModule();
        httpTargetSelectorModule.registrationIndex = stringArray.length;
        this.balancerModule = new HttpTargetSelectorModule[]{httpTargetSelectorModule};
        arrayList.add(httpTargetSelectorModule);
        this.allModules = arrayList.toArray(new HttpTargetSelectorModule[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadHttpTargetSelectorModules");
        }
    }

    protected HttpTargetSelectorModule createLoadBalancerModule() {
        return new LoadBalancerModule();
    }

    public boolean isEnabled() {
        return this.targetTree != null;
    }

    protected TargetDescriptor select(ODCNode oDCNode, HttpRequestMessage httpRequestMessage, HttpTargetSelectorModule[] httpTargetSelectorModuleArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"select", (Object)new Object[]{oDCNode, httpRequestMessage, httpTargetSelectorModuleArray});
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)"disabled");
            }
            return null;
        }
        ODCNode oDCNode2 = Util.uriToWebModule(this.targetTree, oDCNode);
        if (oDCNode2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)"no webModule");
            }
            return null;
        }
        RoutingDebugRequestContext routingDebugRequestContext = RoutingDebugRequestContextManager.getMatchRequestContext(httpRequestMessage);
        TargetCluster targetCluster = this.getCluster(oDCNode2);
        String string = this.getProtocolMap(oDCNode2).mapProtocol(httpRequestMessage.getScheme());
        for (int i = 0; i < httpTargetSelectorModuleArray.length; ++i) {
            TargetServer targetServer;
            HttpTargetSelectorModule httpTargetSelectorModule = httpTargetSelectorModuleArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("module: " + httpTargetSelectorModule.getName()));
            }
            if ((targetServer = httpTargetSelectorModule.select(targetCluster, httpRequestMessage)) == null) continue;
            TargetDescriptor targetDescriptor = targetServer.getTargetDescriptor(string);
            if (targetDescriptor == null) {
                Tr.warning((TraceComponent)tc, (String)"DWCT_NoProtocolFound", (Object)new Object[]{targetServer.getName(), string});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"select", (Object)"no endpoint for protocol");
                }
                if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                    routingDebugRequestContext.getMessage().append("no endpoint for protocol").append("\n");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)targetDescriptor);
            }
            if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                routingDebugRequestContext.getMessage().append(targetDescriptor.getDebugInfo());
            }
            return targetDescriptor;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"select", (Object)"no server selected");
        }
        if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
            routingDebugRequestContext.getMessage().append("no server selected").append("\n");
        }
        return null;
    }

    protected TargetDescriptor select(ODCNode oDCNode, HttpRequestMessage httpRequestMessage, HttpTargetSelectorModule[] httpTargetSelectorModuleArray, ODCNode oDCNode2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"select", (Object)new Object[]{oDCNode, httpRequestMessage, httpTargetSelectorModuleArray});
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)"disabled");
            }
            return null;
        }
        if (oDCNode2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)"no webModule");
            }
            return null;
        }
        RoutingDebugRequestContext routingDebugRequestContext = RoutingDebugRequestContextManager.getMatchRequestContext(httpRequestMessage);
        TargetCluster targetCluster = this.getCluster(oDCNode2);
        String string = this.getProtocolMap(oDCNode2).mapProtocol(httpRequestMessage.getScheme());
        for (int i = 0; i < httpTargetSelectorModuleArray.length; ++i) {
            TargetServer targetServer;
            HttpTargetSelectorModule httpTargetSelectorModule = httpTargetSelectorModuleArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("module: " + httpTargetSelectorModule.getName()));
            }
            if ((targetServer = httpTargetSelectorModule.select(targetCluster, httpRequestMessage)) == null) continue;
            TargetDescriptor targetDescriptor = targetServer.getTargetDescriptor(string);
            if (targetDescriptor == null) {
                Tr.warning((TraceComponent)tc, (String)"DWCT_NoProtocolFound", (Object)new Object[]{targetServer.getName(), string});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"select", (Object)"no endpoint for protocol");
                }
                if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                    routingDebugRequestContext.getMessage().append("no endpoint for protocol").append("\n");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)targetDescriptor);
            }
            if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                routingDebugRequestContext.getMessage().append(targetDescriptor.getDebugInfo());
            }
            return targetDescriptor;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"select", (Object)"no server selected");
        }
        if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
            routingDebugRequestContext.getMessage().append("no endpoint for protocol").append("\n");
        }
        return null;
    }

    public ODCEventType[] interestEventTypes() {
        return this.interestEvents;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(ODCEvent oDCEvent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleEvent", (Object)oDCEvent);
        }
        ODCEventType oDCEventType = oDCEvent.getEventType();
        if (oDCEvent instanceof ODCEventEdgeChange) {
            ODCEventEdgeChange oDCEventEdgeChange = (ODCEventEdgeChange)oDCEvent;
            if (oDCEventType == this.server2WebModule) {
                TargetServer targetServer = this.getServer(oDCEventEdgeChange.getSrcNode());
                TargetCluster targetCluster = this.getCluster(oDCEventEdgeChange.getDstNode());
                if (oDCEventEdgeChange.isAdd()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("webmodule " + targetCluster + " started running on server " + targetServer));
                    }
                    this.addServerToCluster(targetServer, targetCluster);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("webmodule " + targetCluster + " stopped running on server " + targetServer));
                    }
                    this.removeServerFromCluster(targetServer, targetCluster);
                }
            } else if (oDCEventType == this.server2Transport) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"server2Transport event");
                }
                this.rebuildTargetDescriptors(oDCEventEdgeChange.getSrcNode());
            } else {
                if (oDCEventType != this.server2ServerApp) throw new ODCException("unhandled edge change event: " + oDCEvent);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"server2ServerApp event");
                }
                ODCNode oDCNode = oDCEventEdgeChange.getSrcNode();
                ODCNode oDCNode2 = oDCEventEdgeChange.getDstNode();
                TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCNode);
                if (oDCEventEdgeChange.isAdd()) {
                    this.getServerApp(oDCNode2, true);
                    if (this.proxyContainer != null) {
                        this.proxyContainer.addNode(oDCNode2);
                    }
                } else {
                    TargetServerApplicationImpl targetServerApplicationImpl = this.getServerApp(oDCNode2, false);
                    if (targetServerApplicationImpl != null) {
                        targetServerImpl.removeServerApplication(targetServerApplicationImpl);
                    }
                }
            }
        } else {
            ODCEventSetProperty oDCEventSetProperty;
            ODCPropertyDescriptor oDCPropertyDescriptor;
            if (!(oDCEvent instanceof ODCEventSetProperty)) throw new ODCException("unknown type of event: " + oDCEvent);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setProperty event");
            }
            if ((oDCPropertyDescriptor = (oDCEventSetProperty = (ODCEventSetProperty)oDCEvent).getPropertyDescriptor()) == this.odc.serverWeight) {
                this.setServerWeight(oDCEventSetProperty);
            } else if (oDCPropertyDescriptor == this.odc.transportHost || oDCPropertyDescriptor == this.odc.transportPort) {
                this.rebuildTargetDescriptors(oDCEventSetProperty.getNode().getNode(this.odc.server));
            } else {
                if (oDCPropertyDescriptor != this.odc.serverApplicationState) throw new ODCException("unhandled property change event: " + oDCEvent);
                ODCNode oDCNode = oDCEventSetProperty.getNode();
                String string = (String)oDCEventSetProperty.getNewValue();
                TargetServerApplicationImpl targetServerApplicationImpl = this.getServerApp(oDCNode, true);
                if (ApplicationQuiescer.isQuiesceState((String)string)) {
                    targetServerApplicationImpl.beginQuiescing();
                } else {
                    targetServerApplicationImpl.endQuiescing();
                }
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"handleEvent");
    }

    public void addServerToCluster(TargetServer targetServer, TargetCluster targetCluster) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addServerToCluster", (Object)new Object[]{targetServer, targetCluster});
        }
        if (targetServer.getWeight() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addServerToCluster", (Object)"zero weight");
            }
            return;
        }
        if (this.serverHasNoTransports(targetServer)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addServerToCluster", (Object)"no transports");
            }
            return;
        }
        ODCNode oDCNode = this.getServerAppNode(targetServer, targetCluster);
        if (oDCNode == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addServerToCluster", (Object)("no server application found for cluster " + targetCluster + " on server " + targetServer));
            }
            return;
        }
        TargetServerApplicationImpl targetServerApplicationImpl = this.getServerApp(oDCNode, true);
        if (((TargetClusterImpl)targetCluster).getSappList().contains(targetServerApplicationImpl)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addServerToCluster", (Object)"already a member");
            }
            return;
        }
        targetCluster.addServer(targetServerApplicationImpl);
        for (int i = 0; i < this.allModules.length; ++i) {
            this.allModules[i].serverAddedToCluster(targetCluster, targetServerApplicationImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addServerToCluster", (Object)"ok");
        }
    }

    public void removeServerFromCluster(TargetServer targetServer, TargetCluster targetCluster) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeServerFromCluster", (Object)new Object[]{targetServer, targetCluster});
        }
        if (targetServer instanceof TargetServerImpl) {
            ODCNode oDCNode = this.getServerAppNode(targetServer, targetCluster);
            if (oDCNode == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"removeServerFromCluster", (Object)("no server application found for cluster " + targetCluster + " on server " + targetServer));
                }
                return;
            }
            targetServer = this.getServerApp(oDCNode, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("serverApp=" + targetServer));
            }
        }
        targetCluster.removeServer(targetServer);
        for (int i = 0; i < this.allModules.length; ++i) {
            this.allModules[i].serverRemovedFromCluster(targetCluster, targetServer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeServerFromCluster", (Object)new Object[]{targetServer, targetCluster});
        }
    }

    protected void initWLM() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initWLM");
        }
        ODCNode oDCNode = this.targetTree.getRoot();
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.cell);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checking cell " + oDCNodeArray[i]));
            }
            ODCNode[] oDCNodeArray2 = oDCNodeArray[i].getNodes(this.odc.application);
            for (int j = 0; j < oDCNodeArray2.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checking application " + oDCNodeArray2[j]));
                }
                ODCNode[] oDCNodeArray3 = oDCNodeArray2[j].getNodes(this.odc.webModule);
                for (int k = 0; k < oDCNodeArray3.length; ++k) {
                    this.initModule(oDCNodeArray3[k]);
                }
            }
            if (this.proxyContainer == null) continue;
            ODCNode[] oDCNodeArray4 = oDCNodeArray[i].getNodes(this.odc.node);
            for (int j = 0; j < oDCNodeArray4.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checking node " + oDCNodeArray4[j]));
                }
                ODCNode[] oDCNodeArray5 = oDCNodeArray4[j].getNodes(this.odc.server);
                for (int k = 0; k < oDCNodeArray5.length; ++k) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checking server " + oDCNodeArray5[k]));
                    }
                    ODCNode[] oDCNodeArray6 = oDCNodeArray5[k].getNodes(this.odc.serverApplication);
                    for (int i2 = 0; i2 < oDCNodeArray6.length; ++i2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("adding proxyContainer-to-serverApplication link from  " + this.proxyContainer + " to " + oDCNodeArray6[i2]));
                        }
                        this.proxyContainer.addNode(oDCNodeArray6[i2]);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initWLM");
        }
    }

    protected void initModule(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initModule", (Object)oDCNode);
        }
        TargetCluster targetCluster = this.getCluster(oDCNode);
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.server);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            this.getServer(oDCNodeArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initModule");
        }
    }

    protected void rebuildTargetDescriptors(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rebuildTargetDescriptors", (Object)oDCNode);
        }
        TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCNode);
        targetServerImpl.buildTargetDescriptors();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rebuildTargetDescriptors", (Object)oDCNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetServer getServer(ODCNode oDCNode) throws Exception {
        Properties properties;
        TargetServerImpl targetServerImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServer", (Object)oDCNode);
        }
        if ((targetServerImpl = (TargetServerImpl)(properties = oDCNode.getTransientProperties()).get(SERVER)) == null) {
            ODCTree oDCTree = this.targetTree;
            synchronized (oDCTree) {
                targetServerImpl = (TargetServerImpl)properties.get(SERVER);
                if (targetServerImpl == null) {
                    int n;
                    targetServerImpl = this.createTargetServer(oDCNode, this.outboundSSLProps, this.channelFramework);
                    properties.put(SERVER, targetServerImpl);
                    targetServerImpl.init();
                    ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.serverApplication);
                    for (n = 0; n < oDCNodeArray.length; ++n) {
                        this.getServerApp(oDCNodeArray[n], true);
                    }
                    for (n = 0; n < this.allModules.length; ++n) {
                        this.allModules[n].serverInitialize(targetServerImpl);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"target server created");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServer", (Object)targetServerImpl);
        }
        return targetServerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetServerApplicationImpl getServerApp(ODCNode oDCNode, boolean bl) throws Exception {
        Properties properties;
        TargetServerApplicationImpl targetServerApplicationImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerApp", (Object)new Object[]{oDCNode, new Boolean(bl)});
        }
        if ((targetServerApplicationImpl = (TargetServerApplicationImpl)(properties = oDCNode.getTransientProperties()).get(SERVER_APP)) == null && bl) {
            ODCTree oDCTree = this.targetTree;
            synchronized (oDCTree) {
                targetServerApplicationImpl = (TargetServerApplicationImpl)properties.get(SERVER_APP);
                if (targetServerApplicationImpl == null) {
                    ODCNode oDCNode2 = oDCNode.getNode(this.odc.server);
                    TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCNode2);
                    targetServerApplicationImpl = this.createTargetServerApplication(targetServerImpl, oDCNode);
                    properties.put(SERVER_APP, targetServerApplicationImpl);
                    targetServerImpl.addServerApplication(targetServerApplicationImpl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"target server application created");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerApp", (Object)targetServerApplicationImpl);
        }
        return targetServerApplicationImpl;
    }

    protected void setServerWeight(ODCEventSetProperty oDCEventSetProperty) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServerWeight", (Object)oDCEventSetProperty);
        }
        TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCEventSetProperty.getNode());
        int n = targetServerImpl.getWeight();
        int n2 = this.getWeight(oDCEventSetProperty.getNewValue());
        targetServerImpl.setWeight(n2);
        TargetServerApplicationImpl[] targetServerApplicationImplArray = targetServerImpl.getServerApplications();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"begin module notification");
        }
        for (int i = 0; i < targetServerApplicationImplArray.length; ++i) {
            TargetServerApplicationImpl targetServerApplicationImpl = targetServerApplicationImplArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting server weight for " + targetServerApplicationImpl));
            }
            for (int j = 0; j < this.allModules.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("notifying " + this.allModules[j]));
                }
                this.allModules[j].serverWeightChanged(targetServerApplicationImpl, n, n2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServerWeight");
        }
    }

    protected int getWeight(Object object) {
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    protected ProtocolMap getProtocolMap(ODCNode oDCNode) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProtocolMap", (Object)oDCNode);
        }
        ProtocolMap protocolMap = (object = oDCNode.getProperty(this.odc.webModuleProtocolMap)) != null ? (ProtocolMap)object : (this.sslOffload ? ProtocolMap.SSL_OFFLOAD : (this.sslOnload ? ProtocolMap.SSL_ONLOAD : ProtocolMap.DIRECT));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProtocolMap", (Object)protocolMap);
        }
        return protocolMap;
    }

    protected TargetClusterImpl createTargetCluster(ODCNode oDCNode) throws Exception {
        String string = oDCNode.getParent().getParent().getName();
        String string2 = oDCNode.getParent().getName();
        String string3 = oDCNode.getName();
        String string4 = string + "/" + string2 + "/" + string3;
        return this.createTargetCluster(string4, oDCNode);
    }

    protected TargetClusterImpl createTargetCluster(String string, ODCNode oDCNode) throws Exception {
        return new TargetClusterImpl(string, oDCNode, this);
    }

    protected TargetServerImpl createTargetServer(ODCNode oDCNode, Properties properties, ChannelFramework channelFramework) throws Exception {
        return new TargetServerImpl(oDCNode, properties, this.channelFramework, this);
    }

    protected TargetServerApplicationImpl createTargetServerApplication(TargetServerImpl targetServerImpl, ODCNode oDCNode) throws Exception {
        return new TargetServerApplicationImpl(targetServerImpl, oDCNode, this);
    }

    public TargetDescriptor select(ODCNode oDCNode, HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"select", (Object)new Object[]{oDCNode, httpRequestMessage});
        }
        ODCNode oDCNode2 = Util.uriToWebModule(this.targetTree, oDCNode);
        TargetClusterImpl targetClusterImpl = (TargetClusterImpl)this.getTargetCluster(oDCNode2);
        TargetDescriptor targetDescriptor = null;
        if (targetClusterImpl != null) {
            targetDescriptor = targetClusterImpl.selectTargetDescriptor(httpRequestMessage, this.getProtocolMap(oDCNode2).mapProtocol(httpRequestMessage.getScheme()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"select", targetDescriptor);
        }
        return targetDescriptor;
    }

    public TargetDescriptor affinitySelect(ODCNode oDCNode, HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"affinitySelect", (Object)new Object[]{oDCNode, httpRequestMessage});
        }
        TargetClusterImpl targetClusterImpl = (TargetClusterImpl)this.getTargetCluster(oDCNode);
        TargetDescriptor targetDescriptor = null;
        if (targetClusterImpl != null) {
            targetDescriptor = targetClusterImpl.affinitySelectTargetDescriptor(httpRequestMessage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"affinitySelect", (Object)targetDescriptor);
        }
        return targetDescriptor;
    }

    public TargetDescriptor balanceSelect(ODCNode oDCNode, HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"balanceSelect");
        }
        TargetClusterImpl targetClusterImpl = (TargetClusterImpl)this.getTargetCluster(oDCNode);
        TargetDescriptor targetDescriptor = null;
        if (targetClusterImpl != null) {
            targetDescriptor = targetClusterImpl.balanceSelectTargetDescriptor(httpRequestMessage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"balanceSelect");
        }
        return targetDescriptor;
    }

    public TargetCluster getTargetCluster(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTargetCluster", (Object)oDCNode);
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getTargetCluster", (Object)"disabled");
            }
            return null;
        }
        TargetCluster targetCluster = null;
        targetCluster = oDCNode.getType() == this.odc.uri ? this.getCluster(oDCNode.getParent()) : this.getCluster(oDCNode);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTargetCluster", (Object)targetCluster);
        }
        return targetCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetCluster getCluster(ODCNode oDCNode) throws Exception {
        Properties properties;
        TargetCluster targetCluster;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCluster", (Object)oDCNode);
        }
        if ((targetCluster = (TargetCluster)(properties = oDCNode.getTransientProperties()).get(CLUSTER)) == null) {
            ODCTree oDCTree = this.targetTree;
            synchronized (oDCTree) {
                targetCluster = (TargetCluster)properties.get(CLUSTER);
                if (targetCluster == null) {
                    ODCNode oDCNode2 = oDCNode.getParent();
                    ODCNode oDCNode3 = oDCNode2.getParent();
                    String string = oDCNode3.getName() + "/" + oDCNode2.getName() + "/" + oDCNode.getName();
                    targetCluster = this.createTargetCluster(oDCNode);
                    properties.put(CLUSTER, targetCluster);
                    for (int i = 0; i < this.allModules.length; ++i) {
                        this.allModules[i].clusterInitialize(targetCluster);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("cluster created for " + oDCNode));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCluster", (Object)targetCluster);
        }
        return targetCluster;
    }

    protected ODCNode getServerAppNode(TargetServer targetServer, TargetCluster targetCluster) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerAppNode", (Object)new Object[]{targetServer, targetCluster});
        }
        TargetServerImpl targetServerImpl = (TargetServerImpl)targetServer;
        ODCNode oDCNode = ((TargetClusterImpl)targetCluster).getODCNode();
        String string = oDCNode.getParent().getName();
        ODCNode oDCNode2 = targetServerImpl.getMyODCNode();
        ODCNode oDCNode3 = oDCNode2.getNode(this.odc.serverApplication, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerAppNode", (Object)oDCNode3);
        }
        return oDCNode3;
    }

    protected boolean serverHasNoTransports(TargetServer targetServer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverHasNoTransports", (Object)targetServer);
        }
        boolean bl = ((TargetServerImpl)targetServer).hasNoDescriptors();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverHasNoTransports", (Object)new Boolean(bl));
        }
        return bl;
    }
}

