/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.DWLMClientServiceContextImpl;
import com.ibm.ws.dwlm.client.RequestFlowInfoImpl;
import com.ibm.ws.dwlm.client.URIMatcher;
import com.ibm.ws.dwlm.client.VHostMatcher;
import com.ibm.wsspi.dwlm.client.DWLMClientServiceContext;
import com.ibm.wsspi.dwlm.client.RequestFlowInfo;
import com.ibm.wsspi.dwlm.client.RequestMapper;
import com.ibm.wsspi.dwlm.client.RequestMapperInvalidationListener;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCEventNodeChange;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTransactionListener;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class RequestMapperImpl
implements RequestMapper,
ODCTransactionListener {
    protected static final TraceComponent tc = Tr.register((Class)RequestMapperImpl.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");
    protected final ODCTree targetTree;
    protected ODCHelper odc;
    protected ODCEventType[] interestEvents;
    protected VHostMatcher vhostMatcher;
    protected Exception matcherException;
    protected Set invalidationListeners;

    public RequestMapperImpl(ODCTree oDCTree) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor");
        }
        this.targetTree = oDCTree;
        if (oDCTree == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"disabled");
            }
            return;
        }
        this.odc = ODCHelper.getInstance();
        this.interestEvents = this.createInterestEvents();
        this.invalidationListeners = new TreeSet();
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor", (Object)"initialized");
        }
    }

    protected ODCEventType[] createInterestEvents() throws Exception {
        return new ODCEventType[]{this.odc.mgr.findEdgeType(this.odc.application, this.odc.webModule), this.odc.mgr.findEdgeType(this.odc.webModule, this.odc.uri), this.odc.mgr.findEdgeType(this.odc.cell, this.odc.vhostGroup), this.odc.mgr.findEdgeType(this.odc.vhostGroup, this.odc.vhost), this.odc.vhostHost, this.odc.vhostPort, this.odc.webModuleRoutingEnabled};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.targetTree.addListener((ODCListener)this);
            this.makeMatchers();
        }
    }

    public boolean isEnabled() {
        return this.targetTree != null;
    }

    public ODCNode mapRequestToODCNode(HttpRequestMessage httpRequestMessage, int n) throws Exception {
        String string = httpRequestMessage.getVirtualHost();
        int n2 = httpRequestMessage.getVirtualPort();
        if (n2 == -1) {
            n2 = n;
        }
        String string2 = httpRequestMessage.getRequestURI();
        return this.mapRequestToODCNode(string, n2, string2);
    }

    public String mapRequestToClusterName(String string, int n, String string2) throws Exception {
        ODCNode oDCNode = this.mapRequestToODCNode(string, n, string2);
        if (oDCNode == null) {
            return null;
        }
        return this.mapODCNodeToClusterName(oDCNode);
    }

    public String[] mapRequestToClusterNames(String string, int n, String string2) throws Exception {
        ODCNode oDCNode = this.mapRequestToODCNode(string, n, string2);
        if (oDCNode == null) {
            return null;
        }
        return this.mapODCNodeToClusterNames(oDCNode);
    }

    public ODCNode mapRequestToODCNode(String string, int n, String string2) throws Exception {
        Object object;
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapRequestToODCNode", (Object)new Object[]{string, new Integer(n), string2});
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"mapRequestToODCNode", (Object)"disabled");
            }
            return null;
        }
        if (this.matcherException != null) {
            throw this.matcherException;
        }
        int n2 = string2.indexOf(59);
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        if ((oDCNode = this.convertTargetToODCNode(object = this.vhostMatcher.match(string, n, string2))) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"mapRequestToODCNode", (Object)("URL " + string + ":" + n + "/" + string2 + " not found"));
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapRequestToODCNode", (Object)oDCNode);
        }
        return oDCNode;
    }

    public ODCNode getWebModuleNode(ODCNode oDCNode) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getWebModuleNode " + oDCNode));
        }
        return oDCNode.getNode(this.odc.webModule);
    }

    public String mapODCNodeToClusterName(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapODCNodeToClusterName", (Object)oDCNode);
        }
        String[] stringArray = this.mapODCNodeToClusterNames(oDCNode);
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapODCNodeToClusterName", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapRequest(String string, int n, String string2, RequestFlowInfo requestFlowInfo) throws Exception {
        ODCNode oDCNode = this.mapRequestToODCNode(string, n, string2);
        RequestFlowInfoImpl requestFlowInfoImpl = (RequestFlowInfoImpl)requestFlowInfo;
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            oDCNode = this.targetTree.refreshNode(oDCNode);
            if (oDCNode != null) {
                ODCNode oDCNode2;
                requestFlowInfoImpl.setUriPattern(oDCNode.getName());
                ODCNode oDCNode3 = oDCNode.getParent();
                requestFlowInfoImpl.setWebModuleName(oDCNode3.getName());
                ODCNode[] oDCNodeArray = oDCNode3.getNodes(this.odc.cluster);
                if (oDCNodeArray.length > 0) {
                    requestFlowInfoImpl.setClusterName(oDCNodeArray[0].getName());
                }
                if ((oDCNode2 = oDCNode3.getNode(this.odc.vhostGroup)) != null) {
                    requestFlowInfoImpl.setVirtualHostName(oDCNode2.getName());
                }
            }
        }
    }

    public String[] mapODCNodeToClusterNames(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapODCNodeToClusterNames", (Object)oDCNode);
        }
        ODCNode[] oDCNodeArray = this.getWebModuleNode(oDCNode).getNodes(this.odc.cluster);
        String[] stringArray = new String[oDCNodeArray.length];
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            stringArray[i] = oDCNodeArray[i].getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapODCNodeToClusterNames", (Object)stringArray);
        }
        return stringArray;
    }

    public String mapODCNodeToServerName(ODCNode oDCNode) throws Exception {
        ODCNode[] oDCNodeArray = this.getWebModuleNode(oDCNode).getNodes(this.odc.server);
        if (oDCNodeArray.length != 1) {
            return null;
        }
        return oDCNodeArray[0].getName();
    }

    public ODCNode mapODCNodeToModule(ODCNode oDCNode) throws Exception {
        return oDCNode.getNode(this.odc.webModule);
    }

    public ODCEventType[] interestEventTypes() {
        return this.interestEvents;
    }

    public void handleEvents(ODCEvent[] oDCEventArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleEvent", (Object)oDCEventArray);
        }
        for (int i = 0; i < oDCEventArray.length; ++i) {
            for (int j = 0; j < this.interestEvents.length; ++j) {
                if (oDCEventArray[i].getEventType() != this.interestEvents[j]) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("remaking matchers due to event = " + oDCEventArray[i]));
                }
                this.makeMatchers();
                this.callListeners(oDCEventArray[i]);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleEvent", (Object)"remade matchers");
                }
                return;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleEvent", (Object)"did not remake matchers");
        }
    }

    public void handleEvent(ODCEvent oDCEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleEvent", (Object)oDCEvent);
        }
        this.makeMatchers();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleEvent");
        }
    }

    protected synchronized void makeMatchers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"makeMatchers");
        }
        HashSet hashSet = new HashSet();
        while (!this.makeMatchers(hashSet)) {
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"makeMatchers");
        }
    }

    protected synchronized boolean makeMatchers(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"makeMatchers", (Object)set);
        }
        try {
            VHostMatcher vHostMatcher = this.createVHostMatcher();
            ODCNode[] oDCNodeArray = this.targetTree.getRoot().getNodes(this.odc.cell);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cell=" + oDCNodeArray[i]));
                }
                ODCNode[] oDCNodeArray2 = oDCNodeArray[i].getNodes(this.odc.vhostGroup);
                for (int j = 0; j < oDCNodeArray2.length; ++j) {
                    String string;
                    ODCNode oDCNode = oDCNodeArray2[j];
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("vhostGroup=" + oDCNode));
                    }
                    ArrayList<URIMatcher> arrayList = new ArrayList<URIMatcher>();
                    ODCNode[] oDCNodeArray3 = oDCNode.getNodes(this.odc.vhost);
                    for (int k = 0; k < oDCNodeArray3.length; ++k) {
                        ODCNode oDCNode2 = oDCNodeArray3[k];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("vhost=" + oDCNode2));
                        }
                        string = (String)oDCNode2.getProperty(this.odc.vhostHost);
                        int n = oDCNode2.getIntProperty(this.odc.vhostPort);
                        arrayList.add(vHostMatcher.getURIMatcher(string, n));
                    }
                    ODCNode[] oDCNodeArray4 = oDCNode.getNodes(this.odc.webModule);
                    for (int k = 0; k < oDCNodeArray4.length; ++k) {
                        string = oDCNodeArray4[k];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("webModule=" + string));
                        }
                        if (set.contains(string.getPath())) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("skipping ... " + string.getPath() + " is disabled"));
                            continue;
                        }
                        Object object = string.getProperty(this.odc.webModuleRoutingEnabled);
                        if (object != null && !((Boolean)object).booleanValue()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("skip module " + string.getPath() + "; routing is disabled"));
                            continue;
                        }
                        String string2 = (String)string.getProperty(this.odc.webModuleContextRoot);
                        ODCNode[] oDCNodeArray5 = string.getChildren(this.odc.uri);
                        for (int i2 = 0; i2 < oDCNodeArray5.length; ++i2) {
                            ODCNode oDCNode3 = oDCNodeArray5[i2];
                            String string3 = string2 + oDCNode3.getName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("adding " + string3));
                            }
                            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                                URIMatcher uRIMatcher = (URIMatcher)arrayList.get(i3);
                                Object object2 = uRIMatcher.put(string3, oDCNode3);
                                if (object2 == null) continue;
                                set.add(string.getPath());
                                StringBuffer stringBuffer = new StringBuffer();
                                ODCNode oDCNode4 = string.getParent();
                                ODCNode oDCNode5 = oDCNode4.getParent();
                                ODCNode oDCNode6 = ((ODCNode)object2).getParent();
                                ODCNode oDCNode7 = oDCNode6.getParent();
                                ODCNode oDCNode8 = oDCNode7.getParent();
                                Tr.warning((TraceComponent)tc, (String)"DWCT0007E", (Object)new Object[]{string.getName(), oDCNode4.getName(), oDCNode5.getName(), oDCNode6.getName(), oDCNode7.getName(), oDCNode8.getName()});
                                return false;
                            }
                        }
                    }
                }
            }
            this.vhostMatcher = vHostMatcher;
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"DWCT_Exception", (Object)exception);
            this.matcherException = exception;
            this.vhostMatcher = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"makeMatchers", (Object)"true");
        }
        return true;
    }

    public void mapRequest(HttpRequestMessage httpRequestMessage, int n, DWLMClientServiceContext dWLMClientServiceContext) throws Exception {
        String string;
        ODCNode oDCNode;
        String string2 = httpRequestMessage.getVirtualHost();
        int n2 = httpRequestMessage.getVirtualPort();
        if (n2 == -1) {
            n2 = n;
        }
        if ((oDCNode = this.mapRequestToODCNode(string2, n2, string = httpRequestMessage.getRequestURI())) != null) {
            DWLMClientServiceContextImpl dWLMClientServiceContextImpl = (DWLMClientServiceContextImpl)dWLMClientServiceContext;
            dWLMClientServiceContextImpl.setODCNode(oDCNode);
        }
    }

    public synchronized boolean addInvalidationListener(RequestMapperInvalidationListener requestMapperInvalidationListener) throws IllegalArgumentException {
        if (requestMapperInvalidationListener == null) {
            throw new IllegalArgumentException("invalidationListener argument can not be null.");
        }
        return this.invalidationListeners.add(requestMapperInvalidationListener);
    }

    public synchronized boolean removeInvalidationListener(RequestMapperInvalidationListener requestMapperInvalidationListener) throws IllegalArgumentException {
        if (requestMapperInvalidationListener == null) {
            throw new IllegalArgumentException("invalidationListener argument can not be null.");
        }
        return this.invalidationListeners.remove(requestMapperInvalidationListener);
    }

    protected void notifyListeners(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyListeners", (Object)stringArray);
        }
        Set set = this.invalidationListeners;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                RequestMapperInvalidationListener requestMapperInvalidationListener = (RequestMapperInvalidationListener)iterator.next();
                if (stringArray[2] == null) continue;
                requestMapperInvalidationListener.invalidate(stringArray[2]);
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Caught exception invoking request mapper invalidation listener; listner=exception=" + throwable));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyListeners");
        }
    }

    protected void callListeners(ODCEvent oDCEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"callListeners", (Object)oDCEvent);
        }
        ODCEventType oDCEventType = oDCEvent.getEventType();
        if (oDCEvent instanceof ODCEventNodeChange) {
            ODCEventNodeChange oDCEventNodeChange = (ODCEventNodeChange)oDCEvent;
            ODCNode oDCNode = oDCEventNodeChange.getNode();
            if (oDCEventType == this.odc.vhostHost && !oDCEventNodeChange.isAdd()) {
                ODCNode oDCNode2 = null;
                try {
                    oDCNode2 = oDCNode.getParent();
                    ODCNode[] oDCNodeArray = oDCNode2.getNodes(this.odc.webModule);
                    String[] stringArray = null;
                    for (int i = 0; i < oDCNodeArray.length; ++i) {
                        stringArray = this.getDepIdsFromNode(oDCNodeArray[i]);
                        if (stringArray == null) continue;
                        this.notifyListeners(stringArray);
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ODCEventNodeChange failed for node =" + oDCNode.getLongName() + " with message " + exception.getMessage()));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"callListeners", (Object)"No dep ids sent to caller.");
                    }
                    return;
                }
            }
        } else if (oDCEvent instanceof ODCEventEdgeChange) {
            ODCEventEdgeChange oDCEventEdgeChange = (ODCEventEdgeChange)oDCEvent;
            ODCNode oDCNode = oDCEventEdgeChange.getDstNode();
            ODCNode oDCNode3 = null;
            String[] stringArray = null;
            if (oDCNode.getType() == this.odc.uri) {
                oDCNode3 = oDCEventEdgeChange.getSrcNode();
                stringArray = this.getDepIdsFromNode(oDCNode3);
                if (stringArray != null) {
                    this.notifyListeners(stringArray);
                }
            } else if (oDCNode.getType() == this.odc.webModule) {
                oDCNode3 = oDCNode;
                stringArray = this.getDepIdsFromNode(oDCNode3);
                if (stringArray != null) {
                    this.notifyListeners(stringArray);
                }
            } else if (oDCNode.getType() == this.odc.vhostGroup) {
                ODCNode[] oDCNodeArray = null;
                try {
                    oDCNodeArray = oDCNode.getNodes(this.odc.webModule);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ODCEventEdgeChange failed for node =" + oDCNode.getLongName() + " with message " + exception.getMessage()));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"callListeners", (Object)"No dep ids sent to caller.");
                    }
                    return;
                }
                for (int i = 0; i < oDCNodeArray.length; ++i) {
                    stringArray = this.getDepIdsFromNode(oDCNodeArray[i]);
                    if (stringArray == null) continue;
                    this.notifyListeners(stringArray);
                }
            }
        } else if (oDCEvent instanceof ODCEventSetProperty) {
            ODCEventSetProperty oDCEventSetProperty = (ODCEventSetProperty)oDCEvent;
            ODCNode oDCNode = null;
            String[] stringArray = null;
            try {
                oDCNode = oDCEventSetProperty.getNode();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ODCEventSetProperty failed for node =" + oDCNode.getLongName() + " with message " + exception.getMessage()));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"callListeners", (Object)"No dep ids sent to caller.");
                }
                return;
            }
            if (oDCNode.getType() == this.odc.webModule && (stringArray = this.getDepIdsFromNode(oDCNode)) != null) {
                this.notifyListeners(stringArray);
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callListeners", (Object)oDCEvent);
        }
    }

    protected String[] getDepIdsFromNode(ODCNode oDCNode) {
        String[] stringArray = new String[5];
        StringBuffer stringBuffer = new StringBuffer(64);
        ODCNode oDCNode2 = null;
        ODCNode oDCNode3 = null;
        try {
            oDCNode2 = oDCNode.getParent();
            oDCNode3 = oDCNode2.getParent();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("dependencyIds cannot be built for handle event:" + exception.getMessage()));
            }
            return null;
        }
        oDCNode.getTransientProperties().remove("dep_ids");
        String string = oDCNode.getName();
        String string2 = oDCNode2.getName();
        String string3 = oDCNode3.getName();
        stringBuffer.delete(0, stringBuffer.length());
        stringArray[0] = stringBuffer.append("cell=").append(string3).toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringArray[1] = stringBuffer.append("application=").append(string3).append("/").append(string2).toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringArray[2] = stringBuffer.append("webModule=").append(string3).append("/").append(string2).append("/").append(string).toString();
        stringArray[3] = "workClass=";
        stringArray[4] = "applicationEdition=";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dependencyIds=" + stringArray));
        }
        return stringArray;
    }

    protected VHostMatcher createVHostMatcher() {
        return new VHostMatcher();
    }

    protected ODCNode convertTargetToODCNode(Object object) {
        return (ODCNode)object;
    }
}

