/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.dwlm.client.HttpTargetSelectorModule;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import java.io.PrintStream;

public class LoadBalancerModule
extends HttpTargetSelectorModule {
    protected static final TraceComponent tc = Tr.register((Class)LoadBalancerModule.class, (String)"DWLMClient", (String)"com.ibm.ws.dwlm.client.nls.Messages");

    public String getName() {
        return "LoadBalancer";
    }

    public void clusterInitialize(TargetCluster targetCluster) {
        targetCluster.setAttachment(this, new ClusterInfo(targetCluster));
    }

    public void clusterCleanup(TargetCluster targetCluster) {
    }

    public void serverInitialize(TargetServer targetServer) {
    }

    public void serverCleanup(TargetServer targetServer) {
    }

    public void serverAddedToCluster(TargetCluster targetCluster, TargetServer targetServer) {
        this.clusterNeedsCompiling(targetCluster);
    }

    public void serverRemovedFromCluster(TargetCluster targetCluster, TargetServer targetServer) {
        this.clusterNeedsCompiling(targetCluster);
    }

    public void serverWeightChanged(TargetServer targetServer, int n, int n2) {
        TargetCluster[] targetClusterArray = targetServer.getClusters();
        for (int i = 0; i < targetClusterArray.length; ++i) {
            this.clusterNeedsCompiling(targetClusterArray[i]);
        }
    }

    protected void clusterNeedsCompiling(TargetCluster targetCluster) {
        ClusterInfo clusterInfo = (ClusterInfo)targetCluster.getAttachment(this);
        clusterInfo.needsCompiling = true;
    }

    public TargetServer select(TargetCluster targetCluster, HttpRequestMessage httpRequestMessage) {
        ClusterInfo clusterInfo = (ClusterInfo)targetCluster.getAttachment(this);
        return clusterInfo.select();
    }

    protected class ClusterInfo {
        protected final TargetCluster cluster;
        protected TargetServer[] states;
        protected int curState = 0;
        protected boolean needsCompiling = true;
        protected boolean selectFailureLogged = false;

        public ClusterInfo(TargetCluster targetCluster) {
            this.cluster = targetCluster;
        }

        public synchronized TargetServer select() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"select");
            }
            if (this.needsCompiling) {
                this.compile();
            }
            if (this.states.length == 0) {
                this.logSelectFailure();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"select", (Object)"none");
                }
                return null;
            }
            int n = this.curState;
            do {
                TargetServer targetServer;
                if (this.curState >= this.states.length) {
                    this.curState = 0;
                }
                if (!(targetServer = this.states[this.curState++]).isReachable()) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"select", (Object)targetServer);
                }
                return targetServer;
            } while (this.curState != n);
            this.logSelectFailure();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"select", (Object)"none available");
            }
            return null;
        }

        protected void logSelectFailure() {
            if (this.selectFailureLogged) {
                return;
            }
            Tr.warning((TraceComponent)tc, (String)"DWCT_NoTargetAvail", (Object)this.cluster.getName());
            this.selectFailureLogged = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void compile() {
            this.selectFailureLogged = false;
            TargetServer[] targetServerArray = this.cluster.getServers();
            Class<?> clazz = this.cluster.getClass();
            synchronized (clazz) {
                int n;
                if (!this.needsCompiling) {
                    return;
                }
                this.needsCompiling = false;
                int n2 = 0;
                int[] nArray = new int[targetServerArray.length];
                int[] nArray2 = new int[targetServerArray.length];
                for (n = 0; n < targetServerArray.length; ++n) {
                    TargetServer targetServer = targetServerArray[n];
                    if (targetServer.isLocal()) {
                        this.states = new TargetServer[]{targetServer};
                        if (tc.isDebugEnabled()) {
                            this.print(System.out);
                        }
                        return;
                    }
                    n2 += targetServer.getWeight();
                    nArray2[n] = 0;
                    nArray[n] = 0;
                    nArray2[n] = targetServer.getWeight() == 0 ? 100 : 0;
                }
                this.states = new TargetServer[n2];
                for (n = 0; n < n2; ++n) {
                    TargetServer targetServer;
                    int n3 = 0;
                    for (int i = 1; i < targetServerArray.length; ++i) {
                        if (nArray2[i] >= nArray2[n3]) continue;
                        n3 = i;
                    }
                    this.states[n] = targetServer = targetServerArray[n3];
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + 1;
                    nArray2[n3] = nArray[n3] * 100 / targetServer.getWeight();
                }
            }
            if (tc.isDebugEnabled()) {
                this.print(System.out);
            }
        }

        public void print(PrintStream printStream) {
            this.cluster.print(printStream);
            printStream.println("STATES:");
            for (int i = 0; i < this.states.length; ++i) {
                printStream.println("  " + i + ": " + this.states[i]);
            }
        }
    }
}

