/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.DWLMClientServiceContextImpl;
import com.ibm.ws.dwlm.client.RequestFlowInfoImpl;
import com.ibm.ws.dwlm.client.RequestMapperImpl;
import com.ibm.ws.dwlm.client.TargetSelectorImpl;
import com.ibm.ws.dwlm.client.mbean.RoutingDebugMBean;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.odc.ODCPluginCfgGenerator;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.ServiceHandle;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.dwlm.client.DWLMClient;
import com.ibm.wsspi.dwlm.client.DWLMClientServiceContext;
import com.ibm.wsspi.dwlm.client.RequestFlowInfo;
import com.ibm.wsspi.dwlm.client.RequestMapper;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetSelector;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTransaction;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DWLMClientImpl
implements DWLMClient,
ODCTransaction {
    public static final String[] PROPERTIES = new String[]{"client.register", "alias", "httpAffinityModules", "ODRPluginCfgAutoGenScope", "ODRPluginCfgChangeNotificationCommand"};
    public static final String DEFAULT_HTTP_AFFINITY_MODULES = "com.ibm.ws.http.wpf.HttpPartitionAffinityModule,com.ibm.ws.dwlm.client.HttpSessionAffinityModule";
    protected static final TraceComponent tc = Tr.register((Class)DWLMClientImpl.class, null, null);
    protected static DWLMClientImpl instance = null;
    protected Properties props = new Properties();
    protected ODCHelper odc = null;
    protected ODCTree targetTree = null;
    protected RequestMapperImpl requestMapper = null;
    protected TargetSelectorImpl targetSelector = null;
    protected ODCPluginCfgGenerator pluginCfgGenerator = null;
    protected String clientRegister = null;
    protected String sslAlias = null;
    protected String clientCell = null;
    protected String clientNode = null;
    protected String clientServer = null;
    protected String pluginCfgAutoGenScope = "none";
    protected String pluginCfgChangeNotificationCmd = null;
    protected final List dscList = new ArrayList();
    protected RoutingDebugMBean routingMBean = null;

    public void init(Properties properties) throws Exception {
        block12: {
            String string;
            String string2;
            int n;
            this.clientCell = DoPrivUtil.getMyCellName();
            this.clientNode = DoPrivUtil.getMyNodeName();
            this.clientServer = DoPrivUtil.getMyServerName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initializing properties");
            }
            for (n = 0; n < PROPERTIES.length; ++n) {
                string2 = PROPERTIES[n];
                string = System.getProperty(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string2 + "=" + string));
                }
                if (string != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("system property: " + string2 + "=" + string));
                    }
                    this.props.setProperty(string2, string);
                    continue;
                }
                if (properties == null || (string = properties.getProperty(string2)) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("parameter property: " + string2 + "=" + string));
                }
                this.props.setProperty(string2, string);
            }
            this.clientRegister = this.getProperty("client.register", "true");
            n = PlatformHelperFactory.getPlatformHelper().isZOS() ? 1 : 0;
            string2 = n != 0 ? "/RACFJSSESettings" : "/DefaultSSLSettings";
            this.sslAlias = this.getProperty("alias", this.clientNode + string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sslAlias=" + this.sslAlias));
            }
            this.pluginCfgAutoGenScope = this.getProperty("ODRPluginCfgAutoGenScope", "none");
            this.pluginCfgChangeNotificationCmd = this.getProperty("ODRPluginCfgChangeNotificationCommand", null);
            this.odc = ODCHelper.getInstance();
            this.targetTree = this.odc.mgr.getTree("target", this.odc.cellGroup);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("target tree = " + this.targetTree));
            }
            this.initPluginCfgAutoGen();
            if (this.clientRegister.equalsIgnoreCase("true")) {
                string = this.odc.mgr.getTree("proxy", this.odc.cellGroup);
                string.performTransaction((ODCTransaction)this, (Object)string);
            }
            if (this.routingMBean == null) {
                this.routingMBean = new RoutingDebugMBean();
                try {
                    this.routingMBean.initialize();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)tc, (String)"RoutingDebugMBean could not be registered due to failures.");
                }
            }
        }
    }

    public void performODCTransaction(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performODCTransaction");
        }
        ODCTree oDCTree = (ODCTree)object;
        String string = this.clientCell + "_" + this.clientNode + "_" + this.clientServer;
        ODCNode oDCNode = oDCTree.createNode(string, this.odc.proxy, oDCTree.getRoot());
        oDCNode.setProperty(this.odc.proxyCellName, (Object)this.clientCell);
        oDCNode.setProperty(this.odc.proxyNodeName, (Object)this.clientNode);
        oDCNode.setProperty(this.odc.proxyServerName, (Object)this.clientServer);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performODCTransaction");
        }
    }

    public TargetDescriptor mapRequestToTarget(HttpRequestMessage httpRequestMessage, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapRequestToTarget", (Object)httpRequestMessage);
        }
        ODCNode oDCNode = this.requestMapper.mapRequestToODCNode(httpRequestMessage, n);
        TargetDescriptor targetDescriptor = null;
        if (oDCNode != null) {
            targetDescriptor = this.targetSelector.select(oDCNode, httpRequestMessage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapRequestToTarget", (Object)targetDescriptor);
        }
        return targetDescriptor;
    }

    public synchronized RequestMapper getRequestMapper() throws Exception {
        if (this.requestMapper == null) {
            this.requestMapper = this.createRequestMapper(this.getTargetTree());
        }
        return this.requestMapper;
    }

    public synchronized TargetSelector getTargetSelector() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTargetSelector", (Object)this);
        }
        if (this.targetSelector == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"creating TargetSelector");
            }
            ChannelFramework channelFramework = ChannelFrameworkFactory.getChannelFramework();
            this.targetSelector = this.createTargetSelector(this.getTargetTree(), this.getMyOutboundSSLProps(), channelFramework);
            this.targetSelector.start(this.props.getProperty("httpAffinityModules", DEFAULT_HTTP_AFFINITY_MODULES));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTargetSelector", (Object)this.targetSelector);
        }
        return this.targetSelector;
    }

    public ODCTree getTargetTree() {
        return this.targetTree;
    }

    protected RequestMapperImpl createRequestMapper(ODCTree oDCTree) throws Exception {
        return new RequestMapperImpl(oDCTree);
    }

    protected TargetSelectorImpl createTargetSelector(ODCTree oDCTree, Properties properties, ChannelFramework channelFramework) throws Exception {
        return new TargetSelectorImpl(oDCTree, properties, channelFramework);
    }

    public RequestFlowInfo createRequestFlowInfo() {
        return new RequestFlowInfoImpl();
    }

    protected void initPluginCfgAutoGen() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initPluginCfgAutoGen");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ODRPluginCfgAutoGenScope=" + this.pluginCfgAutoGenScope));
            Tr.debug((TraceComponent)tc, (String)("ODRPluginCfgChangeNotificationCommand=" + this.pluginCfgChangeNotificationCmd));
        }
        if (this.pluginCfgAutoGenScope.equalsIgnoreCase("none")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initPluginCfgAutoGen", (Object)"disabled");
            }
            return;
        }
        if (this.pluginCfgGenerator != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initPluginCfgAutoGen", (Object)"already started");
            }
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (!this.pluginCfgAutoGenScope.equalsIgnoreCase("all")) {
            if (this.pluginCfgAutoGenScope.equalsIgnoreCase("cell")) {
                string = this.clientCell;
            } else if (this.pluginCfgAutoGenScope.equalsIgnoreCase("node")) {
                string = this.clientCell;
                string2 = this.clientNode;
            } else if (this.pluginCfgAutoGenScope.equalsIgnoreCase("server")) {
                string = this.clientCell;
                string2 = this.clientNode;
                string3 = this.clientServer;
            } else {
                throw new ComponentDisabledException("invalid value for ODRPluginCfgAutoGenScope: '" + this.pluginCfgAutoGenScope + "'; must be one of: all, cell, node, server, or none");
            }
        }
        this.pluginCfgGenerator = new ODCPluginCfgGenerator(this.getTargetTree(), string, string2, string3);
        this.pluginCfgGenerator.setNotificationCommand(this.pluginCfgChangeNotificationCmd);
        this.pluginCfgGenerator.start();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initPluginCfgAutoGen", (Object)"started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getMyOutboundSSLProps() {
        ServiceHandle serviceHandle;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMyOutboundSSLProps", (Object)("sslAlias=" + this.sslAlias));
        }
        if ((serviceHandle = ServiceHandle.obtain((Class)SecurityService.class)) != null) {
            try {
                SecurityService securityService = (SecurityService)serviceHandle.getService();
                Properties properties = securityService.getSecureSocketLayer(this.sslAlias);
                properties.put("alias", this.sslAlias);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getMyOutboundSSLProps", (Object)properties);
                }
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                serviceHandle.release();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMyOutboundSSLProps", (Object)"null");
        }
        return null;
    }

    protected String getProperty(String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProperty", (Object)new Object[]{string, string2});
        }
        if ((string3 = this.props.getProperty(string)) == null || string3.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"using default");
            }
            string3 = string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProperty", (Object)string3);
        }
        return string3;
    }

    public DWLMClientServiceContext createServiceContext() {
        return new DWLMClientServiceContextImpl(this);
    }

    public synchronized DWLMClientServiceContext obtainServiceContext() {
        int n = this.dscList.size();
        if (n > 0) {
            return (DWLMClientServiceContext)this.dscList.remove(n - 1);
        }
        return this.createServiceContext();
    }

    public synchronized void releaseDWLMClientServiceContext(DWLMClientServiceContext dWLMClientServiceContext) {
        if (this.dscList.size() < 100) {
            this.dscList.add(dWLMClientServiceContext);
        }
    }
}

