/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    public static final int RNG = 1;
    public static final int WRITE_PROTECTED = 2;
    public static final int LOGIN_REQUIRED = 4;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int TOKEN_INITIALIZED = 1024;
    public static final int SECONDARY_AUTHENTICATION = 2048;
    public static final int USER_PIN_COUNT_LOW = 65536;
    public static final int USER_PIN_FINAL_TRY = 131072;
    public static final int USER_PIN_LOCKED = 262144;
    public static final int USER_PIN_TO_BE_CHANGED = 524288;
    public static final int SO_PIN_COUNT_LOW = 0x100000;
    public static final int SO_PIN_FINAL_TRY = 0x200000;
    public static final int SO_PIN_LOCKED = 0x400000;
    public static final int SO_PIN_TO_BE_CHANGED = 0x800000;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int EFFECTIVELY_INFINITE = 0;
    static final int[] flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000};
    static final String[] flagNames = new String[]{PKCS11TokenInfo.a("\u0012I7"), PKCS11TokenInfo.a("\u0017U9_,\u001fW\"D=\u0005D$N-"), PKCS11TokenInfo.a("\fH7B'\u001fU5Z<\tU5O"), PKCS11TokenInfo.a("\u0015T5Y6\u0010N>T \u000eN$B(\fN*N-"), PKCS11TokenInfo.a("\u0005_3G<\u0013N&N6\u0005_9X=\u0013"), PKCS11TokenInfo.a("\u0012B#_&\u0012B/@,\u0019X>D=\u001fI5N-\u0005C"), PKCS11TokenInfo.a("\u0003K?H\"\u001fH>T=\u000fL5E"), PKCS11TokenInfo.a("\u0013R [&\u0012S#T9\u0001U1G%\u0005K"), PKCS11TokenInfo.a("\u0010U?_,\u0003S5O6\u0001R$C,\u000eS9H(\u0014N?E6\u0010F$C"), PKCS11TokenInfo.a("\u0004R1G6\u0003U)[=\u000fX?[,\u0012F$B&\u000eT"), PKCS11TokenInfo.a("\u0014H;N'\u001fN>B=\tF<B3\u0005C"), PKCS11TokenInfo.a("\u0013B3D'\u0004F\"R6\u0001R$C,\u000eS9H(\u0014N?E"), PKCS11TokenInfo.a("\u0015T5Y6\u0010N>T*\u000fR>_6\fH'"), PKCS11TokenInfo.a("\u0015T5Y6\u0010N>T/\tI1G6\u0014U)"), PKCS11TokenInfo.a("\u0015T5Y6\u0010N>T%\u000fD;N-"), PKCS11TokenInfo.a("\u0015T5Y6\u0010N>T=\u000fX2N6\u0003O1E.\u0005C"), PKCS11TokenInfo.a("\u0013H/[ \u000eX3D<\u000eS/G&\u0017"), PKCS11TokenInfo.a("\u0013H/[ \u000eX6B'\u0001K/_;\u0019"), PKCS11TokenInfo.a("\u0013H/[ \u000eX<D*\u000bB4"), PKCS11TokenInfo.a("\u0013H/[ \u000eX$D6\u0002B/H!\u0001I7N-")};
    private String label;
    private String manufacturer;
    private String model;
    private String serialNumber;
    private int flags;
    private int maxSessionCount;
    private int sessionCount;
    private int maxRwSessionCount;
    private int rwSessionCount;
    private int maxPinLen;
    private int minPinLen;
    private int totalPublicMemory;
    private int freePublicMemory;
    private int totalPrivateMemory;
    private int freePrivateMemory;
    private int hardwareVersion;
    private int firmwareVersion;
    private String utcTime;

    public PKCS11TokenInfo(String string, String string2, String string3, String string4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, String string5) {
        this.label = string;
        this.manufacturer = string2;
        this.model = string3;
        this.serialNumber = string4;
        this.flags = n2;
        this.maxSessionCount = n3;
        this.sessionCount = n4;
        this.maxRwSessionCount = n5;
        this.rwSessionCount = n6;
        this.maxPinLen = n7;
        this.minPinLen = n8;
        this.totalPublicMemory = n9;
        this.freePublicMemory = n10;
        this.totalPrivateMemory = n11;
        this.freePrivateMemory = n12;
        this.hardwareVersion = n13;
        this.firmwareVersion = n14;
        this.utcTime = string5;
    }

    public String label() {
        return this.label;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int flags() {
        return this.flags;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public String utcTime() {
        return this.utcTime;
    }

    public String toString() {
        return PKCS11TokenInfo.a("\u0010L3XXqS\u001f`\f.N\u001em\u0006z\rP+I`K\u0011i\f,=P+I`'P+I`'P+I") + this.label + PKCS11TokenInfo.a("J'P+I\rf\u001e~\u000f!d\u0004~\u001b%uJ+I`'P+") + this.manufacturer + PKCS11TokenInfo.a("J'P+I\rh\u0014n\u0005z'P+I`'P+I`'P+") + this.model + PKCS11TokenInfo.a("J'P+I\u0013b\u0002b\b,=P+I`'P+I`'P+") + this.serialNumber + PKCS11TokenInfo.a("J'P+I\u0006k\u0011l\u001az'P+I`'P+I`'P+") + this.flagsToString(PKCS11TokenInfo.a("`{P")) + PKCS11TokenInfo.a("J'P+I\rf\b+\u001a%t\u0003b\u0006.tJ+I`'P+") + this.infinite(this.maxSessionCount) + PKCS11TokenInfo.a("J'P+I\u0013b\u0003x\u0000/i\u00031I`'P+I`'P+") + this.unavailable(this.sessionCount) + PKCS11TokenInfo.a("J'P+I\rf\b+;\u0017'\u0003n\u001a3n\u001fe\u001az'P+") + this.infinite(this.maxRwSessionCount) + PKCS11TokenInfo.a("J'P+I\u0012PPx\f3t\u0019d\u00073=P+I`'P+") + this.unavailable(this.rwSessionCount) + PKCS11TokenInfo.a("J'P+I\rf\b+9\tIPg\f.=P+I`'P+") + this.maxPinLen + PKCS11TokenInfo.a("J'P+I\rn\u001e+9\tIPg\f.=P+I`'P+") + this.minPinLen + PKCS11TokenInfo.a("J'P+I\u0014h\u0004j\u0005`w\u0005i\u0005)dPf\f-=P+") + this.unavailable(this.totalPublicMemory) + PKCS11TokenInfo.a("J'P+I\u0006u\u0015nI0r\u0012g\u0000#'\u001dn\u0004z'P+") + this.unavailable(this.freePublicMemory) + PKCS11TokenInfo.a("J'P+I\u0014h\u0004j\u0005`w\u0002b\u001f!s\u0015+\u0004%jJ+") + this.unavailable(this.totalPrivateMemory) + PKCS11TokenInfo.a("J'P+I\u0006u\u0015nI0u\u0019}\b4bPf\f-=P+") + this.unavailable(this.freePrivateMemory) + PKCS11TokenInfo.a("J'P+I\bf\u0002o\u001e!u\u0015+\u001f%u\u0003b\u0006.=P+") + PKCS11.versionString(this.hardwareVersion) + PKCS11TokenInfo.a("J'P+I\u0006n\u0002f\u001e!u\u0015+\u001f%u\u0003b\u0006.=P+") + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? PKCS11TokenInfo.a("J'P+I\u0015S3+\u001d)j\u00151I`'P+I`'P+") + this.utcTime : "");
    }

    public String flagsToString(String string) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, string);
    }

    String infinite(int n2) {
        return n2 == 0 ? PKCS11TokenInfo.a("\u0005A6N*\u0014N&N%\u0019X9E/\tI9_,") : this.unavailable(n2);
    }

    String unavailable(int n2) {
        return n2 == -1 ? PKCS11TokenInfo.a("\u0015I1](\tK1I%\u0005X9E/\u000fU=J=\tH>") : Integer.toString(n2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 64;
                        break;
                    }
                    case 1: {
                        n5 = 7;
                        break;
                    }
                    case 2: {
                        n5 = 112;
                        break;
                    }
                    case 3: {
                        n5 = 11;
                        break;
                    }
                    default: {
                        n5 = 105;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

