/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.ReasonFlags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class IssuingDistributionPointExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.IssuingDistributionPoint";
    public static final String NAME = "IssuingDistributionPoint";
    public static final String DISTRIBUTION_PT = "distribution_pt";
    public static final String USER_CERTS_ONLY = "user_certs_only";
    public static final String CA_CERTS_ONLY = "ca_certs_only";
    public static final String LIMITED_REASONS = "limited_reasons";
    public static final String INDIRECT_CRL = "indirect_crl";
    public static final byte USER_ONLY = 1;
    public static final byte CA_ONLY = 16;
    public static final byte USER_AND_CA = 17;
    private static final byte TAG_DPOINT = 0;
    private static final byte TAG_USERCERTS = 1;
    private static final byte TAG_CACERTS = 2;
    private static final byte TAG_REASONS = 3;
    private static final byte TAG_INDIRECT = 4;
    private DistributionPointName dPoint = null;
    private boolean userCerts = false;
    private boolean caCerts = false;
    private ReasonFlags reasons = null;
    private boolean indirectCRL = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.IssuingDistributionPointExtension";

    public IssuingDistributionPointExtension(DistributionPointName distributionPointName, byte by, ReasonFlags reasonFlags, boolean bl) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{distributionPointName, new Byte(by), reasonFlags, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "IssuingDistributionPointExtension", objectArray);
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        if (distributionPointName != null) {
            this.dPoint = distributionPointName instanceof GeneralNames ? (GeneralNames)((GeneralNames)distributionPointName).clone() : distributionPointName;
        }
        if (by == 1) {
            this.userCerts = true;
        } else if (by == 16) {
            this.caCerts = true;
        } else if (by == 17) {
            this.userCerts = true;
            this.caCerts = true;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Invalid certificate type.");
            }
            throw new IOException("Invalid certificate type.");
        }
        if (reasonFlags != null) {
            objectArray = new DerOutputStream();
            reasonFlags.encode((DerOutputStream)objectArray);
            DerInputStream derInputStream = new DerInputStream(objectArray.toByteArray());
            this.reasons = new ReasonFlags(derInputStream);
        }
        if (bl) {
            this.indirectCRL = true;
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    public IssuingDistributionPointExtension(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuingDistributionPointExtension", (Object)byArray);
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        this.extensionValue = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.extensionValue, 0, byArray.length);
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    public IssuingDistributionPointExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "IssuingDistributionPointExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = bl;
        if (!this.critical) {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Illegal argument - criticality must be true.");
            }
            throw new IOException("Illegal argument - criticality must be true.");
        }
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Illegal argument type.");
            }
            throw new IOException("Illegal argument type.");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    public IssuingDistributionPointExtension(DerValue derValue) throws IOException {
        super(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IssuingDistributionPointExtension", derValue);
        }
        if (!this.critical) {
            if (debug != null) {
                debug.text(16384L, className, "IssuingDistributionPointExtension", "Invalid criticality value - must be true.");
            }
            throw new IOException("Invalid criticality value - must be true.");
        }
        this.decodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "IssuingDistributionPointExtension");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DISTRIBUTION_PT);
        attributeNameEnumeration.addElement(USER_CERTS_ONLY);
        attributeNameEnumeration.addElement(CA_CERTS_ONLY);
        attributeNameEnumeration.addElement(LIMITED_REASONS);
        attributeNameEnumeration.addElement(INDIRECT_CRL);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(String string, Object object) throws IOException {
        block24: {
            block25: {
                if (debug != null) {
                    debug.entry(16384L, className, "set", string, object);
                }
                if (!string.equalsIgnoreCase(DISTRIBUTION_PT)) break block25;
                if (object instanceof GeneralNames) {
                    this.dPoint = (GeneralNames)((GeneralNames)object).clone();
                    break block24;
                } else if (object instanceof RDN) {
                    this.dPoint = (RDN)object;
                    break block24;
                } else {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type DistributionPointName.");
                    }
                    throw new IOException("Attribute value should be of type DistributionPointName.");
                }
            }
            if (string.equalsIgnoreCase(USER_CERTS_ONLY)) {
                if (!(object instanceof Boolean)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                    }
                    throw new IOException("Attribute value should be of type Boolean.");
                }
                this.userCerts = (Boolean)object;
            } else if (string.equalsIgnoreCase(CA_CERTS_ONLY)) {
                if (!(object instanceof Boolean)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                    }
                    throw new IOException("Attribute value should be of type Boolean.");
                }
                this.caCerts = (Boolean)object;
            } else if (string.equalsIgnoreCase(LIMITED_REASONS)) {
                if (!(object instanceof ReasonFlags)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type ReasonFlags.");
                    }
                    throw new IOException("Attribute value should be of type ReasonFlags.");
                }
                DerOutputStream derOutputStream = new DerOutputStream();
                ((ReasonFlags)object).encode(derOutputStream);
                DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
                this.reasons = new ReasonFlags(derInputStream);
            } else if (string.equalsIgnoreCase(INDIRECT_CRL)) {
                if (!(object instanceof Boolean)) {
                    if (debug != null) {
                        debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                    }
                    throw new IOException("Attribute value should be of type Boolean.");
                }
                this.indirectCRL = (Boolean)object;
            } else {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
                }
                throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
            }
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(DISTRIBUTION_PT)) {
            if (this.dPoint instanceof GeneralNames) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", (GeneralNames)((GeneralNames)this.dPoint).clone());
                }
                return (GeneralNames)((GeneralNames)this.dPoint).clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.dPoint);
            }
            return this.dPoint;
        }
        if (string.equalsIgnoreCase(USER_CERTS_ONLY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_3", new Boolean(this.userCerts));
            }
            return new Boolean(this.userCerts);
        }
        if (string.equalsIgnoreCase(CA_CERTS_ONLY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", new Boolean(this.caCerts));
            }
            return new Boolean(this.caCerts);
        }
        if (string.equalsIgnoreCase(LIMITED_REASONS)) {
            if (this.reasons != null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.reasons.encode(derOutputStream);
                DerInputStream derInputStream = new DerInputStream(derOutputStream.toByteArray());
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_4", new ReasonFlags(derInputStream));
                }
                return new ReasonFlags(derInputStream);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_5", this.reasons);
            }
            return this.reasons;
        }
        if (string.equalsIgnoreCase(INDIRECT_CRL)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_6", new Boolean(this.indirectCRL));
            }
            return new Boolean(this.indirectCRL);
        }
        if (debug != null) {
            debug.text(16384L, className, "get_7", "Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(DISTRIBUTION_PT)) {
            this.dPoint = null;
        } else if (string.equalsIgnoreCase(USER_CERTS_ONLY)) {
            this.userCerts = false;
        } else if (string.equalsIgnoreCase(CA_CERTS_ONLY)) {
            this.caCerts = false;
        } else if (string.equalsIgnoreCase(LIMITED_REASONS)) {
            this.reasons = null;
        } else if (string.equalsIgnoreCase(INDIRECT_CRL)) {
            this.indirectCRL = false;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPoint.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString();
        string = string + this.getName() + " [\r\n";
        string = this.dPoint == null ? string + "Distribution Point: null\r\n" : string + this.dPoint.toString() + "\r\n";
        if (this.userCerts) {
            string = string + "Revokes end-entity certificates\r\n";
        }
        if (this.caCerts) {
            string = string + "Revokes CA certificates\r\n";
        }
        string = this.reasons == null ? string + "Reason Flags: null\r\n" : string + this.reasons.toString();
        if (this.indirectCRL) {
            string = string + "CRL distribution point name is indirect\r\n";
        }
        string = string + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public DistributionPointName getDistributionPoint() throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, className, "getDistributionPoint");
        }
        if (this.dPoint == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDistributionPoint_1", null);
            }
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DistributionPointName distributionPointName = null;
        this.dPoint.encode(byteArrayOutputStream);
        if (this.dPoint instanceof GeneralNames) {
            distributionPointName = new GeneralNames(new DerValue(byteArrayOutputStream.toByteArray()));
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDistributionPoint_2", distributionPointName);
            }
            return distributionPointName;
        }
        distributionPointName = new RDN(new DerValue(byteArrayOutputStream.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getDistributionPoint_3", distributionPointName);
        }
        return distributionPointName;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (!(this.dPoint != null || this.reasons != null || this.userCerts || this.caCerts || this.indirectCRL)) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        if (this.dPoint != null) {
            derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream4 = new DerOutputStream();
            this.dPoint.encode(derOutputStream);
            if (this.dPoint instanceof GeneralNames) {
                derOutputStream4.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
            } else {
                derOutputStream4.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream4);
        }
        if (this.userCerts) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBoolean(this.userCerts);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        if (this.caCerts) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBoolean(this.caCerts);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), derOutputStream);
        }
        if (this.reasons != null) {
            derOutputStream = new DerOutputStream();
            this.reasons.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)3), derOutputStream);
        }
        if (this.indirectCRL) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putBoolean(this.indirectCRL);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)4), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    private void decodeThis() throws IOException {
        DerValue derValue;
        if (debug != null) {
            debug.entry(8192L, className, "decodeThis");
        }
        if ((derValue = new DerValue(this.extensionValue)).getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "decodeThis", "IssuingDistributionPointExtension parsing error: not a SEQUENCE.");
            }
            throw new IOException("IssuingDistributionPointExtension parsing error: not a SEQUENCE.");
        }
        while (derValue.getData() != null && derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
                DerValue derValue3 = derValue2.getData().getDerValue();
                if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed()) {
                    derValue3.resetTag((byte)48);
                    try {
                        this.dPoint = new GeneralNames(derValue3);
                        continue;
                    }
                    catch (GeneralNamesException generalNamesException) {
                        if (debug != null) {
                            debug.exception(8192L, className, "decodeThis", generalNamesException);
                        }
                        throw new IOException("Error constructing distribution point name.");
                    }
                }
                if (derValue3.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                    derValue3.resetTag((byte)49);
                    this.dPoint = new RDN(derValue3);
                    continue;
                }
                if (debug != null) {
                    debug.text(8192L, className, "decodeThis", "IssuingDistributionPoint parsing error.");
                }
                throw new IOException("IssuingDistributionPoint parsing error.");
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)1);
                this.userCerts = derValue2.getBoolean();
                continue;
            }
            if (derValue2.isContextSpecific((byte)2) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)1);
                this.caCerts = derValue2.getBoolean();
                continue;
            }
            if (derValue2.isContextSpecific((byte)3) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)3);
                this.reasons = new ReasonFlags(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)4) && !derValue2.isConstructed()) {
                derValue2.resetTag((byte)1);
                this.indirectCRL = derValue2.getBoolean();
                continue;
            }
            if (debug != null) {
                debug.text(8192L, className, "decodeThis", "IssuingDistributionPoint parsing error.");
            }
            throw new IOException("IssuingDistributionPoint parsing error.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "decodeThis");
        }
    }
}

