/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Enumeration;

public final class InvalidityDateExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.InvalidityDate";
    public static final String NAME = "InvalidityDate";
    public static final String NUMBER = "value";
    private Date invalidityDate;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.InvalidityDateExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.invalidityDate == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putGeneralizedTime(this.invalidityDate);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public InvalidityDateExtension(Date date) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "InvalidityDateExtension", date);
        }
        this.setInvalidityDate(date);
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "InvalidityDateExtension");
        }
    }

    public InvalidityDateExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "InvalidityDateExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.setInvalidityDate(derValue.getGeneralizedTime());
        if (debug != null) {
            debug.exit(16384L, className, "InvalidityDateExtension");
        }
    }

    private void setInvalidityDate(Date date) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setInvalidityDate", date);
        }
        if (date == null) {
            if (debug != null) {
                debug.text(8192L, className, "setInvalidityDate", "invalidityDate not specified.");
            }
            throw new IllegalArgumentException("invalidityDate not specified.");
        }
        this.invalidityDate = date;
        if (debug != null) {
            debug.exit(8192L, className, "setInvalidityDate");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (!(object instanceof Date)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute must be of type Date.");
                }
                throw new IOException("Attribute must be of type Date.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:InvalidityDate.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        this.setInvalidityDate((Date)object);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (this.invalidityDate == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Date(this.invalidityDate.getTime()));
            }
            return new Date(this.invalidityDate.getTime());
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "get", "delete", string);
        }
        if (!string.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "get", "delete", "Attribute name not recognized by CertAttrSet:InvalidityDate.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:InvalidityDate.");
        }
        this.invalidityDate = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", "delete");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString() + "Invalidity Date: ";
        string = this.invalidityDate == null ? string + "null" : string + this.invalidityDate.toString();
        string = string + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InvalidityDate_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

