/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.ReasonFlags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class DistributionPoint {
    private DistributionPointName dpName = null;
    private ReasonFlags reasons = null;
    private GeneralNames issuer = null;
    private byte TAG_DPNAME = 0;
    private byte TAG_REASONS = 1;
    private byte TAG_ISSUER = (byte)2;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.DistributionPoint";

    public DistributionPoint(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DistributionPoint", (Object)byArray);
        }
        this.decode(new DerValue(byArray));
        if (debug != null) {
            debug.exit(16384L, className, "DistributionPoint");
        }
    }

    public DistributionPoint(DistributionPointName distributionPointName, ReasonFlags reasonFlags, GeneralNames generalNames) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{distributionPointName, reasonFlags, generalNames};
            debug.entry(16384L, (Object)className, "DistributionPoint", objectArray);
        }
        if (distributionPointName != null) {
            this.dpName = distributionPointName instanceof GeneralNames ? (GeneralNames)((GeneralNames)distributionPointName).clone() : distributionPointName;
        }
        if (reasonFlags != null) {
            objectArray = new DerOutputStream();
            reasonFlags.encode((DerOutputStream)objectArray);
            DerInputStream derInputStream = new DerInputStream(objectArray.toByteArray());
            this.reasons = new ReasonFlags(derInputStream);
        }
        if (generalNames != null) {
            this.issuer = (GeneralNames)generalNames.clone();
        }
        if (debug != null) {
            debug.exit(16384L, className, "DistributionPoint");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.dpName != null) {
            this.dpName.encode(byteArrayOutputStream);
            derOutputStream.write(byteArrayOutputStream.toByteArray());
            if (this.dpName instanceof GeneralNames) {
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
            } else {
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
            derOutputStream3.write(DerValue.createTag((byte)-128, true, this.TAG_DPNAME), derOutputStream2);
        }
        if (this.reasons != null) {
            derOutputStream = new DerOutputStream();
            this.reasons.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, this.TAG_REASONS), derOutputStream);
        }
        if (this.issuer != null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            derOutputStream = new DerOutputStream();
            this.issuer.encode(byteArrayOutputStream);
            derOutputStream.write(byteArrayOutputStream.toByteArray());
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, this.TAG_ISSUER), derOutputStream);
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream3);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof DistributionPoint)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((DistributionPoint)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "";
        string = string + "\nDistribution Point: [";
        string = this.dpName == null ? string + "\r\n\tDistribution Point Name: null" : string + "\r\n\tDistribution Point Name: " + this.dpName.toString();
        string = this.reasons == null ? string + "\r\n\tReason Flags: null" : string + "\r\n\t" + this.reasons.toString();
        string = this.issuer == null ? string + "\r\n\tIssuer: null" : string + "\r\n\tIssuer: " + this.issuer.toString() + "\n";
        string = string + "\n]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public DistributionPointName getName() throws IOException, GeneralNamesException {
        DistributionPointName distributionPointName = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        if (this.dpName == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getName_1", null);
            }
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.dpName.encode(byteArrayOutputStream);
        if (this.dpName instanceof GeneralNames) {
            distributionPointName = new GeneralNames(new DerValue(byteArrayOutputStream.toByteArray()));
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getName_2", distributionPointName);
            }
            return distributionPointName;
        }
        distributionPointName = new RDN(new DerValue(byteArrayOutputStream.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName_3", distributionPointName);
        }
        return distributionPointName;
    }

    public ReasonFlags getReasons() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getReasons");
        }
        if (this.reasons == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getReasons_1", null);
            }
            return null;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.reasons.encode(derOutputStream);
        ReasonFlags reasonFlags = new ReasonFlags(new DerValue(derOutputStream.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getReasons_2", reasonFlags);
        }
        return reasonFlags;
    }

    public GeneralNames getIssuer() throws IOException, GeneralNamesException {
        if (debug != null) {
            debug.entry(16384L, className, "getIssuer");
        }
        if (this.issuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getIssuer_1", null);
            }
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.issuer.encode(byteArrayOutputStream);
        GeneralNames generalNames = new GeneralNames(new DerValue(byteArrayOutputStream.toByteArray()));
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getIssuer_2", generalNames);
        }
        return generalNames;
    }

    void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DistributionPoint parsing error: not a SEQUENCE.");
            }
            throw new IOException("DistributionPoint parsing error: not a SEQUENCE.");
        }
        if (derValue.getData().available() == 0) {
            return;
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.isContextSpecific(this.TAG_DPNAME) && derValue2.isConstructed()) {
            DerValue derValue3 = derValue2.getData().getDerValue();
            if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed()) {
                derValue3.resetTag((byte)48);
                try {
                    this.dpName = new GeneralNames(derValue3);
                }
                catch (GeneralNamesException generalNamesException) {
                    if (debug != null) {
                        debug.text(16384L, className, "decode", "Error constructing distribution point name.");
                    }
                    throw new IOException("Error constructing distribution point name.");
                }
            } else if (derValue3.isContextSpecific((byte)1) && derValue3.isConstructed()) {
                derValue3.resetTag((byte)49);
                this.dpName = new RDN(derValue3);
            } else {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "DistributionPoint parsing error.");
                }
                throw new IOException("DistributionPoint parsing error.");
            }
            if (derValue.getData().available() == 0) {
                if (debug != null) {
                    debug.exit(16384L, className, "decode_1");
                }
                return;
            }
            derValue2 = derValue.getData().getDerValue();
        }
        if (derValue2.isContextSpecific(this.TAG_REASONS) && !derValue2.isConstructed()) {
            derValue2.resetTag((byte)3);
            this.reasons = new ReasonFlags(derValue2);
            if (derValue.getData().available() == 0) {
                if (debug != null) {
                    debug.exit(16384L, className, "decode_2");
                }
                return;
            }
            derValue2 = derValue.getData().getDerValue();
        }
        if (derValue2.isContextSpecific(this.TAG_ISSUER) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            try {
                this.issuer = new GeneralNames(derValue2);
            }
            catch (GeneralNamesException generalNamesException) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", generalNamesException);
                }
                throw new IOException("Error constructing issuer name.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DistributionPoint parsing error.");
            }
            throw new IOException("DistributionPoint parsing error.");
        }
        if (derValue.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "DistributionPoint parsing error: data overrun.");
            }
            throw new IOException("DistributionPoint parsing error: data overrun.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode_3");
        }
    }
}

