/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.Enumeration;

public final class CertificateValidity
implements CertAttrSet {
    public static final String IDENT = "x509.info.validity";
    public static final String NAME = "validity";
    public static final String NOT_BEFORE = "notBefore";
    public static final String NOT_AFTER = "notAfter";
    private static final long YR_2050 = 2524636800000L;
    private Date notBefore;
    private Date notAfter;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateValidity";

    private Date getNotBefore() {
        if (debug != null) {
            debug.entry(8192L, className, "getNotBefore");
            debug.exit(8192L, (Object)className, "getNotBefore", new Date(this.notBefore.getTime()));
        }
        return new Date(this.notBefore.getTime());
    }

    private Date getNotAfter() {
        if (debug != null) {
            debug.entry(8192L, className, "getNotAfter");
            debug.exit(8192L, (Object)className, "getNotAfter", new Date(this.notAfter.getTime()));
        }
        return new Date(this.notAfter.getTime());
    }

    private void construct(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "construct", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoded CertificateValidity, starting sequence tag missing.");
            }
            throw new IOException("Invalid encoded CertificateValidity, starting sequence tag missing.");
        }
        if (derValue.getData().available() == 0) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "No data encoded for CertificateValidity");
            }
            throw new IOException("No data encoded for CertificateValidity");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoding for CertificateValidity");
            }
            throw new IOException("Invalid encoding for CertificateValidity");
        }
        if (derValueArray[0].getTag() == 23) {
            this.notBefore = derValue.getData().getUTCTime();
        } else if (derValueArray[0].getTag() == 24) {
            this.notBefore = derValue.getData().getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoding for CertificateValidity");
            }
            throw new IOException("Invalid encoding for CertificateValidity");
        }
        if (derValueArray[1].getTag() == 23) {
            this.notAfter = derValue.getData().getUTCTime();
        } else if (derValueArray[1].getTag() == 24) {
            this.notAfter = derValue.getData().getGeneralizedTime();
        } else {
            if (debug != null) {
                debug.text(8192L, className, "construct", "Invalid encoding for CertificateValidity");
            }
            throw new IOException("Invalid encoding for CertificateValidity");
        }
        if (debug != null) {
            debug.exit(8192L, className, "construct");
        }
    }

    public CertificateValidity() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateValidity");
            debug.exit(16384L, className, "CertificateValidity");
        }
    }

    public CertificateValidity(Date date, Date date2) {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateValidity", date, date2);
        }
        this.notBefore = date != null ? new Date(date.getTime()) : date;
        this.notAfter = date2 != null ? new Date(date2.getTime()) : date2;
        if (debug != null) {
            debug.exit(16384L, className, "CertificateValidity");
        }
    }

    public CertificateValidity(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateValidity", derInputStream);
        }
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateValidity");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.notBefore == null || this.notAfter == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", "Validity: [From: " + this.notBefore.toString() + ",\n               To: " + this.notAfter.toString() + "]");
        }
        return "Validity: [From: " + this.notBefore.toString() + ",\n               To: " + this.notAfter.toString() + "]";
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.notBefore == null || this.notAfter == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "CertAttrSet:CertificateValidity: null values to encode.\n");
            }
            throw new IOException("CertAttrSet:CertificateValidity: null values to encode.\n");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.notBefore.getTime() < 2524636800000L) {
            derOutputStream.putUTCTime(this.notBefore);
        } else {
            derOutputStream.putGeneralizedTime(this.notBefore);
        }
        if (this.notAfter.getTime() < 2524636800000L) {
            derOutputStream.putUTCTime(this.notAfter);
        } else {
            derOutputStream.putGeneralizedTime(this.notAfter);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Date)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type Date.");
            }
            throw new IOException("Attribute must be of type Date.");
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = object != null ? new Date(((Date)object).getTime()) : (Date)object;
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = object != null ? new Date(((Date)object).getTime()) : (Date)object;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.getNotBefore());
            }
            return this.getNotBefore();
        }
        if (string.equalsIgnoreCase(NOT_AFTER)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.getNotAfter());
            }
            return this.getNotAfter();
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = null;
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "delete", "Attribute name not recognized by CertAttrSet: CertificateValidity.");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NOT_BEFORE);
        attributeNameEnumeration.addElement(NOT_AFTER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public void valid() throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, className, "valid");
        }
        Date date = new Date();
        this.valid(date);
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }

    public void valid(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "valid", date);
        }
        if (this.notBefore.after(date)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotBefore: " + this.notBefore.toString());
            }
            throw new CertificateNotYetValidException("NotBefore: " + this.notBefore.toString());
        }
        if (this.notAfter.before(date)) {
            if (debug != null) {
                debug.text(16384L, className, "valid", "NotAfter: " + this.notAfter.toString());
            }
            throw new CertificateExpiredException("NotAfter: " + this.notAfter.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "valid");
        }
    }
}

