/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public final class CertificateSubjectName
implements CertAttrSet {
    public static final String IDENT = "x509.info.subject";
    public static final String NAME = "subject";
    public static final String DN_NAME = "dname";
    private X500Name dnName;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateSubjectName";

    public CertificateSubjectName(X500Name x500Name) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateSubjectName", x500Name);
            debug.exit(16384L, className, "CertificateSubjectName");
        }
        this.dnName = x500Name;
    }

    public CertificateSubjectName(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateSubjectName", derInputStream);
        }
        this.dnName = new X500Name(derInputStream);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateSubjectName");
        }
    }

    public CertificateSubjectName(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateSubjectName", inputStream);
        }
        DerValue derValue = new DerValue(inputStream);
        this.dnName = new X500Name(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateSubjectName");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.dnName == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", this.dnName.toString());
        }
        return this.dnName.toString();
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        this.dnName.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof X500Name)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute must be of type X500Name.");
            }
            throw new IOException("Attribute must be of type X500Name.");
        }
        if (!string.equalsIgnoreCase(DN_NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = (X500Name)object;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(DN_NAME)) {
            return this.dnName;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(DN_NAME)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = null;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DN_NAME);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

