/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertificatePolicyId;
import java.io.IOException;
import java.util.Vector;

public final class CertificatePolicySet {
    private Vector ids;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificatePolicySet";

    public CertificatePolicySet(Vector vector) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificatePolicySet", vector);
            debug.exit(16384L, className, "CertificatePolicySet");
        }
        this.ids = vector;
    }

    public CertificatePolicySet(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificatePolicySet", derInputStream);
        }
        this.ids = new Vector(1, 1);
        DerValue[] derValueArray = derInputStream.getSequence(5);
        for (int i = 0; i < derValueArray.length; ++i) {
            CertificatePolicyId certificatePolicyId = new CertificatePolicyId(derValueArray[i]);
            this.ids.addElement(certificatePolicyId);
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificatePolicySet");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "CertificatePolicySet:[\n" + this.ids.toString() + "]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", derOutputStream);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.ids.size(); ++i) {
            ((CertificatePolicyId)this.ids.elementAt(i)).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }
}

