/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X509AttributeName;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public final class CRLExtensions {
    private Hashtable map = new Hashtable(11);
    private boolean unsupportedCritExt = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CRLExtensions";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public CRLExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "CRLExtensions");
            debug.exit(16384L, className, "CRLExtensions");
        }
    }

    public CRLExtensions(DerInputStream derInputStream) throws CRLException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CRLExtensions", derInputStream);
        }
        this.init(derInputStream);
        if (debug != null) {
            debug.exit(16384L, className, "CRLExtensions");
        }
    }

    private void init(DerInputStream derInputStream) throws CRLException {
        try {
            Object object;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "init", derInputStream);
            }
            DerInputStream derInputStream2 = derInputStream;
            byte by = (byte)derInputStream.peekByte();
            if ((by & 0xC0) == 128 && (by & 0x1F) == 0) {
                object = derInputStream2.getDerValue();
                derInputStream2 = ((DerValue)object).getData();
            }
            object = derInputStream2.getSequence(5);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Extension extension = new Extension((DerValue)object[i]);
                this.parseExtension(extension);
            }
            if (debug != null) {
                debug.exit(8192L, className, "init");
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(8192L, className, "init", iOException);
            }
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    private Object copyExtension(Extension extension) {
        try {
            Class clazz;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "copyExtension", extension);
            }
            if ((clazz = OIDMap.getClass(extension.getExtensionId())) == null) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "copyExtension_1", new Extension(extension));
                }
                return new Extension(extension);
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CRLExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CRLExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n);
            for (int i = 0; i < n; ++i) {
                Array.setByte(object, i, byArray[i]);
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            if (debug != null) {
                debug.exit(8192L, (Object)className, "copyExtension_2", (CertAttrSet)constructor.newInstance(objectArray));
            }
            return (CertAttrSet)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "copyExtension", exception);
                debug.exit(8192L, (Object)className, "copyExtension_3", null);
            }
            return null;
        }
    }

    private void parseExtension(Extension extension) throws CRLException {
        try {
            Class clazz;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "parseExtension", extension);
            }
            if ((clazz = OIDMap.getClass(extension.getExtensionId())) == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) != null) {
                    if (debug != null) {
                        debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                    }
                    throw new CRLException("Duplicate extensions not allowed");
                }
                if (debug != null) {
                    debug.exit(8192L, className, "parseExtension_1");
                }
                return;
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CRLExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CRLExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n);
            for (int i = 0; i < n; ++i) {
                Array.setByte(object, i, byArray[i]);
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), certAttrSet) != null) {
                if (debug != null) {
                    debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                }
                throw new CRLException("Duplicate extensions not allowed");
            }
            if (debug != null) {
                debug.exit(8192L, className, "parseExtension_2");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (debug != null) {
                debug.exception(8192L, className, "parseExtension", invocationTargetException);
            }
            throw new CRLException(invocationTargetException.getTargetException().getMessage());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "parseExtension", exception);
            }
            throw new CRLException(exception.toString());
        }
    }

    public void encode(OutputStream outputStream, boolean bl) throws CRLException {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "encode", outputStream, new Boolean(bl));
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            Collection collection = this.map.values();
            Object[] objectArray = collection.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof CertAttrSet) {
                    ((CertAttrSet)objectArray[i]).encode(derOutputStream);
                    continue;
                }
                if (objectArray[i] instanceof Extension) {
                    ((Extension)objectArray[i]).encode(derOutputStream);
                    continue;
                }
                if (debug != null) {
                    debug.text(16384L, className, "encode", "Illegal extension object");
                }
                throw new CRLException("Illegal extension object");
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (bl) {
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
            } else {
                derOutputStream3 = derOutputStream2;
            }
            outputStream.write(derOutputStream3.toByteArray());
            if (debug != null) {
                debug.exit(16384L, className, "encode");
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", iOException);
            }
            throw new CRLException("Encoding error: " + iOException.toString());
        }
        catch (CertificateException certificateException) {
            if (debug != null) {
                debug.exception(16384L, className, "encode", certificateException);
            }
            throw new CRLException("Encoding error: " + certificateException.toString());
        }
    }

    public Extension get(String string) {
        String string2;
        X509AttributeName x509AttributeName;
        String string3;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if ((string3 = (x509AttributeName = new X509AttributeName(string)).getPrefix()).equalsIgnoreCase("x509")) {
            int n = string.lastIndexOf(".");
            string2 = string.substring(n + 1);
        } else {
            string2 = string;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", (Extension)this.copyExtension((Extension)this.map.get(string2)));
        }
        return (Extension)this.copyExtension((Extension)this.map.get(string2));
    }

    public void set(String string, Object object) {
        this.map.put(string, object);
    }

    public void delete(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        this.map.remove(string);
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        Enumeration enumeration = this.map.elements();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(11);
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            hashtable.put(extension.getExtensionId().toString(), this.copyExtension(extension));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", hashtable.elements());
        }
        return hashtable.elements();
    }

    public Collection getAllExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "getAllExtensions");
        }
        Enumeration enumeration = this.map.elements();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(11);
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            hashtable.put(extension.getExtensionId().toString(), this.copyExtension(extension));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAllExtensions", hashtable.values());
        }
        return hashtable.values();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", this.unsupportedCritExt);
        }
        return this.unsupportedCritExt;
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (this == object) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(object instanceof CRLExtensions)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        Collection collection = ((CRLExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        if (n != this.map.size()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            Extension extension;
            if (objectArray[i] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[i]).getName();
            }
            Extension extension2 = (Extension)objectArray[i];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = (Extension)this.map.get(string)) == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_4", false);
                }
                return false;
            }
            if (extension.equals(extension2)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_5", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_6", true);
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", this.map.hashCode());
        }
        return this.map.hashCode();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.map.toString());
        }
        return this.map.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

