/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.validator.Validator;
import com.ibm.security.validator.ValidatorException;
import com.ibm.security.x509.NetscapeCertTypeExtension;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class SimpleValidator
extends Validator {
    static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    static final String OID_KEY_USAGE = "2.5.29.15";
    static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    static final ObjectIdentifier OBJID_NETSCAPE_CERT_TYPE = NetscapeCertTypeExtension.NetscapeCertType_Id;
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_CODE_SIGNING_CA = "object_signing_ca";
    private Map trustedX500Principals;
    private Collection trustedCerts;

    SimpleValidator(String string, Collection collection) {
        super("Simple", string);
        this.trustedCerts = collection;
        this.trustedX500Principals = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)this.trustedX500Principals.get(x500Principal);
            if (arrayList == null) {
                arrayList = new ArrayList<X509Certificate>(2);
                this.trustedX500Principals.put(x500Principal, arrayList);
            }
            arrayList.add(x509Certificate);
        }
    }

    public Collection getTrustedCertificates() {
        return this.trustedCerts;
    }

    X509Certificate[] engineValidate(X509Certificate[] x509CertificateArray, Collection collection, Object object) throws CertificateException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        x509CertificateArray = this.buildTrustedChain(x509CertificateArray);
        Date date = this.validationDate;
        if (date == null) {
            date = new Date();
        }
        for (int i = x509CertificateArray.length - 2; i >= 0; --i) {
            X509Certificate x509Certificate = x509CertificateArray[i + 1];
            X509Certificate x509Certificate2 = x509CertificateArray[i];
            if (!this.variant.equals("code signing") && !this.variant.equals("jce signing")) {
                x509Certificate2.checkValidity(date);
            }
            if (!x509Certificate2.getIssuerX500Principal().equals(x509Certificate.getSubjectX500Principal())) {
                throw new ValidatorException(ValidatorException.T_NAME_CHAINING, x509Certificate2);
            }
            try {
                x509Certificate2.verify(x509Certificate.getPublicKey());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ValidatorException(ValidatorException.T_SIGNATURE_ERROR, x509Certificate2, generalSecurityException);
            }
            if (i == 0) continue;
            this.checkExtensions(x509Certificate2, i);
        }
        return x509CertificateArray;
    }

    private void checkExtensions(X509Certificate x509Certificate, int n) throws CertificateException {
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        this.checkBasicConstraints(x509Certificate, set, n);
        this.checkKeyUsage(x509Certificate, set);
        this.checkNetscapeCertType(x509Certificate, set);
        if (!set.isEmpty()) {
            throw new ValidatorException("Certificate contains unknown critical extensions: " + set, ValidatorException.T_CA_EXTENSIONS, x509Certificate);
        }
    }

    private void checkNetscapeCertType(X509Certificate x509Certificate, Set set) throws CertificateException {
        if (!this.variant.equals("generic")) {
            if (this.variant.equals("tls client") || this.variant.equals("tls server")) {
                if (!SimpleValidator.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA)) {
                    throw new ValidatorException("Invalid Netscape CertType extension for SSL CA certificate", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
                }
                set.remove(OID_NETSCAPE_CERT_TYPE);
            } else if (this.variant.equals("code signing") || this.variant.equals("jce signing")) {
                if (!SimpleValidator.getNetscapeCertTypeBit(x509Certificate, NSCT_CODE_SIGNING_CA)) {
                    throw new ValidatorException("Invalid Netscape CertType extension for code signing CA certificate", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
                }
                set.remove(OID_NETSCAPE_CERT_TYPE);
            } else {
                throw new CertificateException("Unknown variant " + this.variant);
            }
        }
    }

    static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) {
        try {
            NetscapeCertTypeExtension netscapeCertTypeExtension;
            Object object;
            if (x509Certificate instanceof X509CertImpl) {
                object = (X509CertImpl)x509Certificate;
                ObjectIdentifier objectIdentifier = OBJID_NETSCAPE_CERT_TYPE;
                netscapeCertTypeExtension = (NetscapeCertTypeExtension)((X509CertImpl)object).getExtension(objectIdentifier);
                if (netscapeCertTypeExtension == null) {
                    return true;
                }
            } else {
                object = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
                if (object == null) {
                    return true;
                }
                DerInputStream derInputStream = new DerInputStream((byte[])object);
                byte[] byArray = derInputStream.getOctetString();
                byArray = new DerValue(byArray).getUnalignedBitString().toByteArray();
                netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray);
            }
            object = (Boolean)netscapeCertTypeExtension.get(string);
            return (Boolean)object;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws CertificateException {
        set.remove(OID_BASIC_CONSTRAINTS);
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 < 0) {
            throw new ValidatorException("End user tried to act as a CA", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
        }
        if (n - 1 > n2) {
            throw new ValidatorException("Violated path length constraints", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
        }
    }

    private void checkKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException {
        set.remove(OID_KEY_USAGE);
        set.remove(OID_EXTENDED_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            throw new ValidatorException("Wrong key usage: expected keyCertSign", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
        }
    }

    private X509Certificate[] buildTrustedChain(X509Certificate[] x509CertificateArray) throws CertificateException {
        List list;
        Serializable serializable;
        Serializable serializable2;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(x509CertificateArray.length);
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            serializable2 = x509CertificateArray[i];
            serializable = this.getTrustedCertificate((X509Certificate)serializable2);
            if (serializable != null) {
                arrayList.add(serializable);
                return arrayList.toArray(CHAIN0);
            }
            arrayList.add(serializable2);
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        serializable2 = x509Certificate.getSubjectX500Principal();
        if (!((X500Principal)serializable2).equals(serializable = x509Certificate.getIssuerX500Principal()) && (list = (List)this.trustedX500Principals.get(serializable)) != null) {
            X509Certificate x509Certificate2 = (X509Certificate)list.iterator().next();
            arrayList.add(x509Certificate2);
            return arrayList.toArray(CHAIN0);
        }
        throw new ValidatorException(ValidatorException.T_NO_TRUST_ANCHOR);
    }

    private X509Certificate getTrustedCertificate(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        List list = (List)this.trustedX500Principals.get(x500Principal);
        if (list == null) {
            return null;
        }
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate)) {
                return x509Certificate;
            }
            if (!x509Certificate2.getIssuerX500Principal().equals(x500Principal2) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            return x509Certificate2;
        }
        return null;
    }
}

