/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;

public class parseCerts {
    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length < 1) {
            System.out.println("usage: parseCerts CertFile [CertFile CertFile ...]");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Certificate certificate = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
                certificate = new X509CertImpl(fileInputStream);
                fileInputStream.close();
                System.out.println(certificate);
                parseCerts.verifyCert(certificate);
                continue;
            }
            catch (CertificateException certificateException) {
                Content content;
                SignedData signedData;
                Certificate[] certificateArray;
                certificateException.printStackTrace();
                ContentInfo contentInfo = new ContentInfo(stringArray[i], false);
                if (!contentInfo.isSignedData()) {
                    System.out.println("Not pkcs#7 signed data");
                    System.exit(1);
                }
                if ((certificateArray = (signedData = (SignedData)(content = contentInfo.getContent())).getCertificates()) != null || certificateArray.length != 0) {
                    for (int j = 0; j < certificateArray.length; ++j) {
                        certificate = certificateArray[j];
                        System.out.println(certificate);
                        parseCerts.verifyCert(certificate);
                    }
                    continue;
                }
                System.out.println("No certificates in object");
            }
        }
    }

    static void verifyCert(Certificate certificate) throws Exception {
        X509CertImpl x509CertImpl = (X509CertImpl)certificate;
        try {
            x509CertImpl.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            System.out.println("Warning: Certificate expired!");
            System.out.println(certificateExpiredException.getMessage());
        }
        PublicKey publicKey = x509CertImpl.getPublicKey();
        if (((Object)x509CertImpl.getSubjectDN()).equals(x509CertImpl.getIssuerDN())) {
            System.out.println("It is self signed, verifying signature ...");
            try {
                x509CertImpl.verify(publicKey);
                System.out.println("The signature is verified.");
            }
            catch (Exception exception) {
                System.out.println("\tThe signature can't be verified.");
                exception.printStackTrace();
            }
        }
    }
}

