/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.BASE64Decoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class parseCert {
    public static void main(String[] stringArray) {
        block15: {
            Object object;
            if (stringArray.length < 1) {
                System.out.println("Usage: parseCert -file=certificateFileName [-base64] [-publickey=extractedPublicKeyfile]");
                System.exit(1);
            }
            String string = null;
            String string2 = null;
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i].toLowerCase();
                boolean bl2 = false;
                if (((String)object).startsWith("-file=")) {
                    string = stringArray[i].substring(6);
                    bl2 = true;
                }
                if (((String)object).startsWith("-publickey=")) {
                    string2 = stringArray[i].substring(11);
                    bl2 = true;
                }
                if (((String)object).startsWith("-base64")) {
                    bl = true;
                    bl2 = true;
                }
                if (bl2) continue;
                System.out.println("ERROR:  Unknown parameter " + stringArray[i] + ".");
                System.exit(1);
            }
            if (string == null) {
                System.out.println("ERROR:  input file must be specified.");
                System.exit(1);
            }
            System.out.println("parseCert invoked with:");
            System.out.println("\tInput file = " + string);
            System.out.println("\tInput file in Base64 format = " + bl);
            System.out.println("\tPublic key store file name = " + string2);
            try {
                Certificate certificate = null;
                try {
                    object = new FileInputStream(string);
                    if (bl) {
                        BASE64Decoder bASE64Decoder = new BASE64Decoder();
                        byte[] byArray = bASE64Decoder.decodeBuffer((InputStream)object);
                        certificate = new X509CertImpl(byArray);
                    } else {
                        certificate = new X509CertImpl((InputStream)object);
                    }
                    ((FileInputStream)object).close();
                    System.out.println("*** Input Certificate =\r\n" + certificate);
                    parseCert.verifyCert(certificate);
                    parseCert.storePublicKey(string2, certificate);
                }
                catch (CertificateException certificateException) {
                    Content content;
                    SignedData signedData;
                    Certificate[] certificateArray;
                    certificateException.printStackTrace();
                    ContentInfo contentInfo = new ContentInfo(string, false);
                    if (!contentInfo.isSignedData()) {
                        System.out.println("Not pkcs#7 signed data");
                        System.exit(1);
                    }
                    if ((certificateArray = (signedData = (SignedData)(content = contentInfo.getContent())).getCertificates()) != null || certificateArray.length != 0) {
                        int n = 0;
                        for (int i = 0; i < certificateArray.length; ++i) {
                            certificate = certificateArray[i];
                            System.out.println(certificate);
                            parseCert.verifyCert(certificate);
                            if (string2 == null) continue;
                            String string3 = string2 + n++;
                            parseCert.storePublicKey(string3, certificate);
                        }
                        break block15;
                    }
                    System.out.println("No certificates in object");
                }
            }
            catch (Exception exception) {
                System.out.println("\r\nERROR:  Exception");
                exception.printStackTrace();
            }
        }
    }

    static void verifyCert(Certificate certificate) throws CertificateNotYetValidException {
        X509CertImpl x509CertImpl = (X509CertImpl)certificate;
        try {
            x509CertImpl.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            System.out.println("Warning: Certificate expired!");
            System.out.println(certificateExpiredException.getMessage());
        }
        PublicKey publicKey = x509CertImpl.getPublicKey();
        if (((Object)x509CertImpl.getSubjectDN()).equals(x509CertImpl.getIssuerDN())) {
            System.out.println("It is self signed, verifying signature ...");
            try {
                x509CertImpl.verify(publicKey);
                System.out.println("The signature is verified.");
            }
            catch (Exception exception) {
                System.out.println("\tThe signature can't be verified.");
                exception.printStackTrace();
            }
        }
    }

    static void storePublicKey(String string, Certificate certificate) throws IOException, FileNotFoundException {
        if (string == null) {
            return;
        }
        X509CertImpl x509CertImpl = (X509CertImpl)certificate;
        PublicKey publicKey = x509CertImpl.getPublicKey();
        System.out.println("*** Public key = " + publicKey);
        FileOutputStream fileOutputStream = null;
        System.out.println("*** Writing the PublicKey object to " + string);
        byte[] byArray = publicKey.getEncoded();
        fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }
}

