/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class ContentType
extends PKCS9DerObject
implements Cloneable {
    private ObjectIdentifier oid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.ContentType";

    public ContentType(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentType", (Object)byArray);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", byArray, string);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentType", string);
        }
        this.oid = new ObjectIdentifier(string);
        if (debug != null) {
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String string, String string2) throws IOException {
        super(string2);
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", string, string2);
        }
        this.oid = new ObjectIdentifier(string);
        if (debug != null) {
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(ObjectIdentifier objectIdentifier) {
        this.oid = objectIdentifier;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentType", objectIdentifier);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(ObjectIdentifier objectIdentifier, String string) {
        super(string);
        this.oid = objectIdentifier;
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", objectIdentifier, string);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "ContentType", string, new Boolean(bl));
            debug.exit(16384L, className, "ContentType");
        }
    }

    public ContentType(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "ContentType", objectArray);
            debug.exit(16384L, className, "ContentType");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            ContentType contentType = new ContentType(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", contentType);
            }
            return contentType;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof ContentType) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((ContentType)object)));
            }
            return this.equals((ContentType)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.CONTENT_TYPE_OID);
        }
        return PKCSOID.CONTENT_TYPE_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.oid == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "ObjectIdentifier not specified.");
            }
            throw new IOException("ObjectIdentifier not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        derOutputStream2.putOID(this.oid);
        derOutputStream.write((byte)49, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
        }
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception exception) {
            objectIdentifier = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getOID", objectIdentifier);
        }
        return objectIdentifier;
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getOID());
        }
        return this.getOID();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 6) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "ContentType");
        }
        return "ContentType";
    }

    public String toString() {
        String string = "PKCS9 ContentType: " + this.oid + "\r\n";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.oid = new DerInputStream(derValueArray[0].toByteArray()).getOID();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(ContentType contentType) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", contentType);
        }
        if (contentType == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            contentType.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

