/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public final class CertBag
extends PKCSDerObject
implements Bag,
Cloneable {
    private ObjectIdentifier oid;
    private Object value;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.CertBag";

    public CertBag(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertBag", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "CertBag", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(Certificate certificate) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertBag", certificate);
        }
        this.oid = certificate instanceof X509Certificate ? PKCSOID.X509_CERT_OID : PKCSOID.SDSI_CERT_OID;
        this.value = certificate;
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(Certificate certificate, String string) throws PKCSException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "CertBag", certificate, string);
        }
        this.oid = certificate instanceof X509Certificate ? PKCSOID.X509_CERT_OID : PKCSOID.SDSI_CERT_OID;
        this.value = certificate;
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(ObjectIdentifier objectIdentifier, byte[] byArray) {
        this(objectIdentifier, byArray, null);
        if (debug != null) {
            debug.entry(16384L, className, "CertBag", objectIdentifier, byArray);
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(ObjectIdentifier objectIdentifier, byte[] byArray, String string) {
        super(string);
        Object object;
        if (debug != null) {
            object = new Object[]{objectIdentifier, byArray, string};
            debug.entry(16384L, (Object)className, "CertBag", (Object[])object);
        }
        if (!(objectIdentifier.equals(PKCSOID.X509CERTBAG_OID) || objectIdentifier.equals(PKCSOID.SDSICERTBAG_OID) || objectIdentifier.equals(PKCSOID.X509_CERT_OID) || objectIdentifier.equals(PKCSOID.SDSI_CERT_OID))) {
            if (debug != null) {
                debug.text(16384L, className, "CertBag", "Invalid input object identifier.");
            }
            throw new IllegalArgumentException("Invalid input object identifier.");
        }
        this.oid = objectIdentifier;
        try {
            if (objectIdentifier.equals(PKCSOID.X509CERTBAG_OID) || objectIdentifier.equals(PKCSOID.X509_CERT_OID)) {
                this.value = new X509CertImpl(byArray);
            } else if (objectIdentifier.equals(PKCSOID.SDSICERTBAG_OID) || objectIdentifier.equals(PKCSOID.SDSI_CERT_OID)) {
                object = new DerValue(byArray);
                this.value = ((DerValue)object).getIA5String();
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "CertBag", exception);
            }
            throw new IllegalArgumentException("Invalid certificate encoding.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "CertBag", objectArray);
            debug.exit(16384L, className, "CertBag");
        }
    }

    public CertBag(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "CertBag", objectArray);
            debug.exit(16384L, className, "CertBag");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        derOutputStream.putOID(this.oid);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
            X509Certificate x509Certificate = (X509Certificate)this.value;
            try {
                byte[] byArray = x509Certificate.getEncoded();
                derOutputStream4.putOctetString(byArray);
                derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream4);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "encode", certificateEncodingException);
                }
                throw new IOException("Error encoding X.509 CRL.");
            }
        } else {
            derOutputStream3.putIA5String((String)this.value);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
        }
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.oid.toString());
        }
        catch (Exception exception) {
            objectIdentifier = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getObjectIdentifier", objectIdentifier);
        }
        return objectIdentifier;
    }

    public Object getValue() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getValue");
            }
            if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
                X509CertImpl x509CertImpl = new X509CertImpl(this.getEncodedValue());
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getValue_1", x509CertImpl);
                }
                return x509CertImpl;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getValue_2", new String((String)this.value));
            }
            return new String((String)this.value);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getValue", exception);
                debug.exit(16384L, (Object)className, "getValue_3", null);
            }
            return null;
        }
    }

    public byte[] getEncodedValue() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "getEncodedValue");
            }
            if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
                X509Certificate x509Certificate = (X509Certificate)this.value;
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getEncodedValue_1", x509Certificate.getEncoded());
                }
                return x509Certificate.getEncoded();
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putIA5String((String)this.value);
            byte[] byArray = derOutputStream.toByteArray();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedValue_2", byArray);
            }
            return byArray;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedValue", exception);
                debug.exit(16384L, (Object)className, "getEncodedValue_3", null);
            }
            return null;
        }
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", "CertBag");
        }
        return "CertBag";
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof CertBag) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((CertBag)object));
            }
            return this.equals((CertBag)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            CertBag certBag = new CertBag(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", certBag);
            }
            return certBag;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        Object object = this.getValue();
        String string = "CertBag:";
        string = string + "\r\nobject identifier: " + this.oid;
        string = string + "\r\ncertificate:\r\n";
        string = string + object.toString();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertBag parsing error, not a SEQUENCE.");
            }
            throw new IOException("CertBag parsing error, not a SEQUENCE.");
        }
        this.oid = derValue.getData().getOID();
        if (!(this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.SDSICERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID) || this.oid.equals(PKCSOID.SDSI_CERT_OID))) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid CertBag object identifier in encoding.");
            }
            throw new IllegalArgumentException("Invalid CertBag object identifier in encoding.");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        DerValue derValue3 = derValue2.isContextSpecific((byte)0) ? derValue2.getData().getDerValue() : derValue2;
        if (this.oid.equals(PKCSOID.X509CERTBAG_OID) || this.oid.equals(PKCSOID.X509_CERT_OID)) {
            try {
                byte[] byArray = derValue3.getOctetString();
                this.value = new X509CertImpl(byArray);
            }
            catch (CertificateException certificateException) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", certificateException);
                }
                throw new IOException("Error decoding X.509 CRL from encoding.");
            }
        } else if (this.oid.equals(PKCSOID.SDSICERTBAG_OID) || this.oid.equals(PKCSOID.SDSI_CERT_OID)) {
            this.value = derValue3.getIA5String();
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Invalid encoded OID");
            }
            throw new IllegalArgumentException("Invalid encoded OID");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(CertBag certBag) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", certBag);
        }
        if (certBag == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            certBag.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

