/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Message;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.base.WSIFDefaultMessage;

public class WSIFMessageImpl
extends AbstractMap
implements WSIFMessage {
    private static final String copyright = "(c) Copyright IBM Corporation 2003.";
    private static final long serialVersionUID = 1L;
    private WSIFMessage message = null;
    private Set fieldSet;

    public WSIFMessageImpl() {
        this((WSIFMessage)new WSIFDefaultMessage());
    }

    public WSIFMessageImpl(WSIFMessage wSIFMessage) {
        this.message = wSIFMessage == null ? new WSIFDefaultMessage() : wSIFMessage;
        this.fieldSet = new WSIFSet();
    }

    public String getName() {
        return this.message.getName();
    }

    public void setName(String string) {
        this.message.setName(string);
    }

    public Iterator getPartNames() {
        return this.message.getPartNames();
    }

    public Iterator getParts() {
        return this.message.getParts();
    }

    public void setParts(Map map) {
        this.message.setParts(map);
    }

    public String getRepresentationStyle() {
        return this.message.getRepresentationStyle();
    }

    public void setRepresentationStyle(String string) {
        this.message.setRepresentationStyle(string);
    }

    public Object getObjectPart(String string) throws WSIFException {
        return this.message.getObjectPart(string);
    }

    public Object getObjectPart(String string, Class clazz) throws WSIFException {
        return this.message.getObjectPart(string, clazz);
    }

    public void setObjectPart(String string, Object object) throws WSIFException {
        this.message.setObjectPart(string, object);
    }

    public char getCharPart(String string) throws WSIFException {
        return this.message.getCharPart(string);
    }

    public byte getBytePart(String string) throws WSIFException {
        return this.message.getBytePart(string);
    }

    public short getShortPart(String string) throws WSIFException {
        return this.message.getShortPart(string);
    }

    public int getIntPart(String string) throws WSIFException {
        return this.message.getIntPart(string);
    }

    public long getLongPart(String string) throws WSIFException {
        return this.message.getLongPart(string);
    }

    public float getFloatPart(String string) throws WSIFException {
        return this.message.getFloatPart(string);
    }

    public double getDoublePart(String string) throws WSIFException {
        return this.message.getDoublePart(string);
    }

    public boolean getBooleanPart(String string) throws WSIFException {
        return this.message.getBooleanPart(string);
    }

    public void setCharPart(String string, char c) {
        this.message.setCharPart(string, c);
    }

    public void setBytePart(String string, byte by) {
        this.message.setBytePart(string, by);
    }

    public void setShortPart(String string, short s) {
        this.message.setShortPart(string, s);
    }

    public void setIntPart(String string, int n) {
        this.message.setIntPart(string, n);
    }

    public void setLongPart(String string, long l) {
        this.message.setLongPart(string, l);
    }

    public void setFloatPart(String string, float f) {
        this.message.setFloatPart(string, f);
    }

    public void setDoublePart(String string, double d) {
        this.message.setDoublePart(string, d);
    }

    public void setBooleanPart(String string, boolean bl) {
        this.message.setBooleanPart(string, bl);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            WSIFMessageImpl wSIFMessageImpl = (WSIFMessageImpl)super.clone();
            wSIFMessageImpl.message = (WSIFMessage)this.message.clone();
            return wSIFMessageImpl;
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException(this.getClass().getName());
        }
    }

    public Message getMessageDefinition() {
        return this.message.getMessageDefinition();
    }

    public void setMessageDefinition(Message message) {
        this.message.setMessageDefinition(message);
    }

    public static final String getMessageDefinitionAsString(Message message) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n................................................................................");
        stringBuffer.append("\nQName = " + message.getQName().getNamespaceURI() + "/" + message.getQName().getLocalPart());
        Map map = message.getParts();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        Object object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append("\n[" + n + "] key = " + object.toString() + " value = " + map.get(object));
            ++n;
        }
        if (n == 0) {
            stringBuffer.append("\nNo part definitions set!");
        }
        stringBuffer.append("\n................................................................................");
        return stringBuffer.toString();
    }

    public WSIFMessage message() {
        return this.message;
    }

    public Set entrySet() {
        return this.fieldSet;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        try {
            object3 = this.message.getObjectPart((String)object);
        }
        catch (WSIFException wSIFException) {
            object3 = null;
        }
        try {
            this.message.setObjectPart((String)object, object2);
        }
        catch (WSIFException wSIFException) {
            // empty catch block
        }
        return object3;
    }

    public class WSIFEntry
    implements Map.Entry,
    Serializable {
        Object key;

        public WSIFEntry(Object object, Object object2) {
            this.key = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            try {
                return WSIFMessageImpl.this.message.getObjectPart((String)this.key);
            }
            catch (WSIFException wSIFException) {
                return null;
            }
        }

        public Object setValue(Object object) {
            Object object2 = this.getValue();
            try {
                WSIFMessageImpl.this.message.setObjectPart((String)this.key, object);
            }
            catch (WSIFException wSIFException) {
                // empty catch block
            }
            return object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) return false;
                bl = true;
            } else {
                bl = this.key.equals(entry.getKey());
            }
            if (!bl) return false;
            if (this.getValue() == null) {
                if (entry.getValue() != null) return false;
                return true;
            }
            boolean bl2 = this.getValue().equals(entry.getValue());
            if (!bl2) return false;
            return true;
        }

        public int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.getValue();
        }
    }

    public class WSIFSet
    extends AbstractSet
    implements Serializable {
        protected WSIFSet() {
        }

        public Iterator iterator() {
            return new WSIFIterator();
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }

        public class WSIFIterator
        implements Iterator,
        Serializable {
            Iterator fieldNames;

            public WSIFIterator() {
                this.fieldNames = WSIFMessageImpl.this.message.getPartNames();
            }

            public boolean hasNext() {
                return this.fieldNames.hasNext();
            }

            public Object next() {
                String string = (String)this.fieldNames.next();
                return new WSIFEntry(string, null);
            }

            public void remove() {
                this.fieldNames.remove();
            }
        }
    }
}

